/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.datastore.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.datastore.Gs2DatastoreRestClient;
import io.gs2.datastore.domain.model.DataObjectDomain;
import io.gs2.datastore.model.DataObjectHistory;
import io.gs2.datastore.request.GetDataObjectHistoryByUserIdRequest;
import io.gs2.datastore.result.GetDataObjectHistoryByUserIdResult;

public class DataObjectHistoryDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2DatastoreRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String dataObjectName;
    private final String generation;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDataObjectName() {
        return this.dataObjectName;
    }

    public String getGeneration() {
        return this.generation;
    }

    public DataObjectHistoryDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String dataObjectName, String generation) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2DatastoreRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.dataObjectName = dataObjectName;
        this.generation = generation;
        this.parentKey = DataObjectDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, this.dataObjectName != null ? this.dataObjectName.toString() : null, "DataObjectHistory");
    }

    private DataObjectHistory get(GetDataObjectHistoryByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withDataObjectName(this.dataObjectName).withGeneration(this.generation);
        GetDataObjectHistoryByUserIdResult result = this.client.getDataObjectHistoryByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, DataObjectHistoryDomain.createCacheKey(request.getGeneration() != null ? request.getGeneration().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String userId, String dataObjectName, String generation, String childType) {
        return String.join((CharSequence)":", "datastore", namespaceName, userId, dataObjectName, generation, childType);
    }

    public static String createCacheKey(String generation) {
        return String.join((CharSequence)":", generation);
    }

    public DataObjectHistory model() {
        DataObjectHistory value = this.cache.get(this.parentKey, DataObjectHistoryDomain.createCacheKey(this.getGeneration() != null ? this.getGeneration().toString() : null), DataObjectHistory.class);
        if (value == null) {
            try {
                this.get(new GetDataObjectHistoryByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, DataObjectHistoryDomain.createCacheKey(this.getGeneration() != null ? this.getGeneration().toString() : null), DataObjectHistory.class);
            }
            value = this.cache.get(this.parentKey, DataObjectHistoryDomain.createCacheKey(this.getGeneration() != null ? this.getGeneration().toString() : null), DataObjectHistory.class);
        }
        return value;
    }
}

