/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.datastore.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.datastore.Gs2DatastoreRestClient;
import io.gs2.datastore.domain.model.DataObjectDomain;
import io.gs2.datastore.domain.model.UserDomain;
import io.gs2.datastore.model.DataObject;
import io.gs2.datastore.request.DescribeDataObjectsByUserIdRequest;
import io.gs2.datastore.result.DescribeDataObjectsByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeDataObjectsByUserIdIterator
implements Iterator<DataObject>,
Iterable<DataObject> {
    CacheDatabase cache;
    Gs2DatastoreRestClient client;
    String namespaceName;
    String userId;
    String status;
    String pageToken;
    boolean last;
    List<DataObject> result;
    Integer fetchSize;

    public DescribeDataObjectsByUserIdIterator(CacheDatabase cache, Gs2DatastoreRestClient client, String namespaceName, String userId, String status) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.status = status;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<DataObject>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "DataObject");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, DataObject.class)) {
            this.result = this.cache.list(parentKey, DataObject.class).stream().filter(item -> this.status == null || item.getStatus().equals(this.status)).collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeDataObjectsByUserIdResult r = this.client.describeDataObjectsByUserId(new DescribeDataObjectsByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withStatus(this.status).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (DataObject item2 : this.result) {
                this.cache.put(parentKey, DataObjectDomain.createCacheKey(item2.getName() != null ? item2.getName().toString() : null), item2, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, DataObject.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public DataObject next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        DataObject ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<DataObject> iterator() {
        return this;
    }
}

