/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.core.domain;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.ExecuteStampSheetEvent;
import io.gs2.core.domain.ExecuteStampTaskEvent;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.model.IResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.distributor.Gs2DistributorRestClient;
import io.gs2.distributor.request.RunStampSheetRequest;
import io.gs2.distributor.request.RunStampSheetWithoutNamespaceRequest;
import io.gs2.distributor.request.RunStampTaskRequest;
import io.gs2.distributor.request.RunStampTaskWithoutNamespaceRequest;
import io.gs2.distributor.result.RunStampSheetResult;
import io.gs2.distributor.result.RunStampSheetWithoutNamespaceResult;
import io.gs2.distributor.result.RunStampTaskResult;
import io.gs2.distributor.result.RunStampTaskWithoutNamespaceResult;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;

public class StampSheetDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final Gs2RestSession session;
    private final String stampSheet;
    private final String stampSheetEncryptionKeyId;
    private final String namespaceName;
    private final ExecuteStampTaskEvent stampTaskEvent;
    private final ExecuteStampSheetEvent stampSheetEvent;

    public StampSheetDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, Gs2RestSession session, String stampSheet, String stampSheetEncryptionKeyId, String namespaceName, ExecuteStampTaskEvent stampTaskEvent, ExecuteStampSheetEvent stampSheetEvent) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.session = session;
        this.stampSheet = stampSheet;
        this.stampSheetEncryptionKeyId = stampSheetEncryptionKeyId;
        this.namespaceName = namespaceName;
        this.stampTaskEvent = stampTaskEvent;
        this.stampSheetEvent = stampSheetEvent;
    }

    public void run() {
        IResult result;
        Gs2DistributorRestClient client = new Gs2DistributorRestClient(this.session);
        JSONObject stampSheetJson = new JSONObject(this.stampSheet);
        String stampSheetPayload = stampSheetJson.getString("body");
        JSONObject stampSheetPayloadJson = new JSONObject(stampSheetPayload);
        JSONArray stampTasks = stampSheetPayloadJson.getJSONArray("tasks");
        String contextStack = null;
        for (int i = 0; i < stampTasks.length(); ++i) {
            IResult result2;
            String stampTask = stampTasks.getString(i);
            JSONObject stampTaskJson = new JSONObject(stampTasks.getString(i));
            String stampTaskPayload = stampTaskJson.getString("body");
            JSONObject stampTaskPayloadJson = new JSONObject(stampTaskPayload);
            if (this.namespaceName == null) {
                result2 = client.runStampTaskWithoutNamespace(((RunStampTaskWithoutNamespaceRequest)new RunStampTaskWithoutNamespaceRequest().withContextStack(contextStack)).withStampTask(stampTasks.getString(i)).withKeyId(this.stampSheetEncryptionKeyId));
                contextStack = ((RunStampTaskWithoutNamespaceResult)result2).getContextStack();
                this.stampTaskEvent.onEvent(this.cache, stampTaskPayloadJson.getString("action"), stampTaskPayloadJson.getString("args"), ((RunStampTaskWithoutNamespaceResult)result2).getResult());
                continue;
            }
            result2 = client.runStampTask(((RunStampTaskRequest)new RunStampTaskRequest().withContextStack(contextStack)).withNamespaceName(this.namespaceName).withStampTask(stampTasks.getString(i)).withKeyId(this.stampSheetEncryptionKeyId));
            contextStack = ((RunStampTaskResult)result2).getContextStack();
            this.stampTaskEvent.onEvent(this.cache, stampTaskPayloadJson.getString("action"), stampTaskPayloadJson.getString("args"), ((RunStampTaskResult)result2).getResult());
        }
        String action = null;
        JSONObject requestJson = null;
        JSONObject resultJson = null;
        if (this.namespaceName == null) {
            result = client.runStampSheetWithoutNamespace(((RunStampSheetWithoutNamespaceRequest)new RunStampSheetWithoutNamespaceRequest().withContextStack(contextStack)).withStampSheet(this.stampSheet).withKeyId(this.stampSheetEncryptionKeyId));
            this.stampSheetEvent.onEvent(this.cache, stampSheetPayloadJson.getString("action"), stampSheetPayloadJson.getString("args"), ((RunStampSheetWithoutNamespaceResult)result).getResult());
            action = stampSheetPayloadJson.getString("action");
            requestJson = new JSONObject(stampSheetPayloadJson.getString("args"));
            resultJson = new JSONObject(((RunStampSheetWithoutNamespaceResult)result).getResult().length() != 0 ? ((RunStampSheetWithoutNamespaceResult)result).getResult() : "{}");
        } else {
            result = client.runStampSheet(((RunStampSheetRequest)new RunStampSheetRequest().withContextStack(contextStack)).withNamespaceName(this.namespaceName).withStampSheet(this.stampSheet).withKeyId(this.stampSheetEncryptionKeyId));
            this.stampSheetEvent.onEvent(this.cache, stampSheetPayloadJson.getString("action"), stampSheetPayloadJson.getString("args"), ((RunStampSheetResult)result).getResult());
            action = stampSheetPayloadJson.getString("action");
            requestJson = new JSONObject(stampSheetPayloadJson.getString("args"));
            resultJson = new JSONObject(((RunStampSheetResult)result).getResult().length() != 0 ? ((RunStampSheetResult)result).getResult() : "{}");
        }
        if (resultJson.has("stampSheet")) {
            StampSheetDomain newStampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, resultJson.getString("stampSheet"), resultJson.getString("stampSheetEncryptionKeyId"), this.namespaceName, this.stampTaskEvent, this.stampSheetEvent);
            newStampSheet.run();
        }
        if (Objects.equals(action, "Gs2JobQueue:PushByUserId")) {
            Gs2.pushJobQueue(this.jobQueueDomain, requestJson.getString("namespaceName"));
        }
    }
}

