/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.core.domain;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.Gs2;
import io.gs2.jobQueue.domain.model.JobAccessTokenDomain;
import io.gs2.jobQueue.domain.model.JobDomain;
import io.gs2.jobQueue.request.RunByUserIdRequest;
import io.gs2.jobQueue.request.RunRequest;
import java.util.ArrayList;
import java.util.List;

public class JobQueueDomain {
    private final Object lock = new Object();
    private Gs2 gs2;
    private final List<String> tasks = new ArrayList<String>();

    public JobQueueDomain(Gs2 gs2) {
        this.gs2 = gs2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(String namespaceName) {
        Object object = this.lock;
        synchronized (object) {
            this.tasks.add(namespaceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(AccessToken accessToken) {
        JobAccessTokenDomain job;
        String namespaceName = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.tasks.size() > 0) {
                namespaceName = this.tasks.get(0);
            }
        }
        if (namespaceName != null && (job = this.gs2.jobQueue.namespace(namespaceName).accessToken(accessToken).run(new RunRequest())).getIsLastJob().booleanValue()) {
            Object object2 = this.lock;
            synchronized (object2) {
                this.tasks.remove(namespaceName);
            }
        }
        return this.tasks.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runByUserId(String userId) {
        JobDomain job;
        String namespaceName = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.tasks.size() > 0) {
                namespaceName = this.tasks.get(0);
            }
        }
        if (namespaceName != null && (job = this.gs2.jobQueue.namespace(namespaceName).user(userId).run(new RunByUserIdRequest())).getIsLastJob().booleanValue()) {
            Object object2 = this.lock;
            synchronized (object2) {
                this.tasks.remove(namespaceName);
            }
        }
        return this.tasks.size() == 0;
    }
}

