/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.chat.domain.model;

import io.gs2.chat.Gs2ChatRestClient;
import io.gs2.chat.domain.model.UserDomain;
import io.gs2.chat.model.Subscribe;
import io.gs2.chat.request.GetSubscribeByUserIdRequest;
import io.gs2.chat.request.SubscribeByUserIdRequest;
import io.gs2.chat.request.UnsubscribeByUserIdRequest;
import io.gs2.chat.request.UpdateNotificationTypeByUserIdRequest;
import io.gs2.chat.result.GetSubscribeByUserIdResult;
import io.gs2.chat.result.SubscribeByUserIdResult;
import io.gs2.chat.result.UnsubscribeByUserIdResult;
import io.gs2.chat.result.UpdateNotificationTypeByUserIdResult;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;

public class SubscribeDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ChatRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String roomName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getRoomName() {
        return this.roomName;
    }

    public SubscribeDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String roomName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ChatRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.roomName = roomName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Subscribe");
    }

    public SubscribeDomain subscribe(SubscribeByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withRoomName(this.roomName);
        SubscribeByUserIdResult result = this.client.subscribeByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, SubscribeDomain.createCacheKey(request.getRoomName() != null ? request.getRoomName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        SubscribeDomain domain = this;
        return domain;
    }

    private Subscribe get(GetSubscribeByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withRoomName(this.roomName);
        GetSubscribeByUserIdResult result = this.client.getSubscribeByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, SubscribeDomain.createCacheKey(request.getRoomName() != null ? request.getRoomName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public SubscribeDomain updateNotificationType(UpdateNotificationTypeByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withRoomName(this.roomName);
        UpdateNotificationTypeByUserIdResult result = this.client.updateNotificationTypeByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, SubscribeDomain.createCacheKey(request.getRoomName() != null ? request.getRoomName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        SubscribeDomain domain = this;
        return domain;
    }

    public SubscribeDomain unsubscribe(UnsubscribeByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withRoomName(this.roomName);
        UnsubscribeByUserIdResult result = this.client.unsubscribeByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, SubscribeDomain.createCacheKey(request.getRoomName() != null ? request.getRoomName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        SubscribeDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String roomName, String childType) {
        return String.join((CharSequence)":", "chat", namespaceName, userId, roomName, childType);
    }

    public static String createCacheKey(String roomName) {
        return String.join((CharSequence)":", roomName);
    }

    public Subscribe model() {
        Subscribe value = this.cache.get(this.parentKey, SubscribeDomain.createCacheKey(this.getRoomName() != null ? this.getRoomName().toString() : null), Subscribe.class);
        if (value == null) {
            try {
                this.get(new GetSubscribeByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, SubscribeDomain.createCacheKey(this.getRoomName() != null ? this.getRoomName().toString() : null), Subscribe.class);
            }
            value = this.cache.get(this.parentKey, SubscribeDomain.createCacheKey(this.getRoomName() != null ? this.getRoomName().toString() : null), Subscribe.class);
        }
        return value;
    }
}

