/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.chat.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.chat.Gs2ChatRestClient;
import io.gs2.chat.domain.model.MessageDomain;
import io.gs2.chat.domain.model.RoomDomain;
import io.gs2.chat.model.Message;
import io.gs2.chat.request.GetMessageRequest;
import io.gs2.chat.result.GetMessageResult;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;

public class MessageAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ChatRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String roomName;
    private final String password;
    private final String messageName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getRoomName() {
        return this.roomName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public MessageAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String roomName, String password, String messageName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ChatRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.roomName = roomName;
        this.password = password;
        this.messageName = messageName;
        this.parentKey = RoomDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Singleton", this.roomName != null ? this.roomName.toString() : null, "Message");
    }

    private Message get(GetMessageRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withRoomName(this.roomName).withPassword(this.password).withMessageName(this.messageName);
        GetMessageResult result = this.client.getMessage(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MessageDomain.createCacheKey(request.getMessageName() != null ? request.getMessageName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String userId, String roomName, String messageName, String childType) {
        return String.join((CharSequence)":", "chat", namespaceName, userId, roomName, messageName, childType);
    }

    public static String createCacheKey(String messageName) {
        return String.join((CharSequence)":", messageName);
    }

    public Message model() {
        Message value = this.cache.get(this.parentKey, MessageDomain.createCacheKey(this.getMessageName() != null ? this.getMessageName().toString() : null), Message.class);
        if (value == null) {
            try {
                this.get(new GetMessageRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, MessageDomain.createCacheKey(this.getMessageName() != null ? this.getMessageName().toString() : null), Message.class);
            }
            value = this.cache.get(this.parentKey, MessageDomain.createCacheKey(this.getMessageName() != null ? this.getMessageName().toString() : null), Message.class);
        }
        return value;
    }
}

