/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.chat.domain.iterator;

import io.gs2.chat.Gs2ChatRestClient;
import io.gs2.chat.domain.model.SubscribeDomain;
import io.gs2.chat.domain.model.UserDomain;
import io.gs2.chat.model.Subscribe;
import io.gs2.chat.request.DescribeSubscribesByUserIdRequest;
import io.gs2.chat.result.DescribeSubscribesByUserIdResult;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeSubscribesByUserIdIterator
implements Iterator<Subscribe>,
Iterable<Subscribe> {
    CacheDatabase cache;
    Gs2ChatRestClient client;
    String namespaceName;
    String userId;
    String pageToken;
    boolean last;
    List<Subscribe> result;
    Integer fetchSize;

    public DescribeSubscribesByUserIdIterator(CacheDatabase cache, Gs2ChatRestClient client, String namespaceName, String userId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Subscribe>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Subscribe");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Subscribe.class)) {
            this.result = this.cache.list(parentKey, Subscribe.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeSubscribesByUserIdResult r = this.client.describeSubscribesByUserId(new DescribeSubscribesByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Subscribe item : this.result) {
                this.cache.put(parentKey, SubscribeDomain.createCacheKey(item.getRoomName() != null ? item.getRoomName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Subscribe.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Subscribe next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Subscribe ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Subscribe> iterator() {
        return this;
    }
}

