/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.chat.domain.iterator;

import io.gs2.chat.Gs2ChatRestClient;
import io.gs2.chat.domain.model.RoomDomain;
import io.gs2.chat.domain.model.UserDomain;
import io.gs2.chat.model.Room;
import io.gs2.chat.request.DescribeRoomsRequest;
import io.gs2.chat.result.DescribeRoomsResult;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeRoomsIterator
implements Iterator<Room>,
Iterable<Room> {
    CacheDatabase cache;
    Gs2ChatRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<Room> result;
    Integer fetchSize;

    public DescribeRoomsIterator(CacheDatabase cache, Gs2ChatRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Room>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Singleton", "Room");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Room.class)) {
            this.result = this.cache.list(parentKey, Room.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeRoomsResult r = this.client.describeRooms(new DescribeRoomsRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Room item : this.result) {
                this.cache.put(parentKey, RoomDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Room.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Room next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Room ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Room> iterator() {
        return this;
    }
}

