/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.auth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.auth.request.LoginBySignatureRequest;
import io.gs2.auth.request.LoginRequest;
import io.gs2.auth.result.LoginBySignatureResult;
import io.gs2.auth.result.LoginResult;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import java.util.HashMap;

public class Gs2AuthRestClient
extends AbstractGs2Client<Gs2AuthRestClient> {
    public Gs2AuthRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void loginAsync(LoginRequest request, AsyncAction<AsyncResult<LoginResult>> callback) {
        LoginTask task = new LoginTask(request, callback);
        this.session.execute(task);
    }

    public LoginResult login(LoginRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.loginAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (LoginResult)resultAsyncResult[0].getResult();
    }

    public void loginBySignatureAsync(LoginBySignatureRequest request, AsyncAction<AsyncResult<LoginBySignatureResult>> callback) {
        LoginBySignatureTask task = new LoginBySignatureTask(request, callback);
        this.session.execute(task);
    }

    public LoginBySignatureResult loginBySignature(LoginBySignatureRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.loginBySignatureAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (LoginBySignatureResult)resultAsyncResult[0].getResult();
    }

    class LoginBySignatureTask
    extends Gs2RestSessionTask<LoginBySignatureResult> {
        private LoginBySignatureRequest request;

        public LoginBySignatureTask(LoginBySignatureRequest request, AsyncAction<AsyncResult<LoginBySignatureResult>> userCallback) {
            super((Gs2RestSession)Gs2AuthRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public LoginBySignatureResult parse(JsonNode data) {
            return LoginBySignatureResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "auth").replace("{region}", Gs2AuthRestClient.this.session.getRegion().getName()) + "/login/signed";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("userId", LoginBySignatureTask.this.request.getUserId());
                    this.put("keyId", LoginBySignatureTask.this.request.getKeyId());
                    this.put("body", LoginBySignatureTask.this.request.getBody());
                    this.put("signature", LoginBySignatureTask.this.request.getSignature());
                    this.put("contextStack", LoginBySignatureTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class LoginTask
    extends Gs2RestSessionTask<LoginResult> {
        private LoginRequest request;

        public LoginTask(LoginRequest request, AsyncAction<AsyncResult<LoginResult>> userCallback) {
            super((Gs2RestSession)Gs2AuthRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public LoginResult parse(JsonNode data) {
            return LoginResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "auth").replace("{region}", Gs2AuthRestClient.this.session.getRegion().getName()) + "/login";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("userId", LoginTask.this.request.getUserId());
                    this.put("timeOffset", LoginTask.this.request.getTimeOffset());
                    this.put("contextStack", LoginTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

