/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.account.domain.model;

import io.gs2.account.Gs2AccountRestClient;
import io.gs2.account.domain.model.AccountDomain;
import io.gs2.account.model.TakeOver;
import io.gs2.account.request.CreateTakeOverByUserIdRequest;
import io.gs2.account.request.GetTakeOverByUserIdRequest;
import io.gs2.account.request.UpdateTakeOverByUserIdRequest;
import io.gs2.account.result.CreateTakeOverByUserIdResult;
import io.gs2.account.result.GetTakeOverByUserIdResult;
import io.gs2.account.result.UpdateTakeOverByUserIdResult;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;

public class TakeOverDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2AccountRestClient client;
    private final String namespaceName;
    private final String userId;
    private final Integer type;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public Integer getType() {
        return this.type;
    }

    public TakeOverDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, Integer type) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2AccountRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.type = type;
        this.parentKey = AccountDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "TakeOver");
    }

    public TakeOverDomain create(CreateTakeOverByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withType(this.type);
        CreateTakeOverByUserIdResult result = this.client.createTakeOverByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, TakeOverDomain.createCacheKey(request.getType() != null ? request.getType().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        TakeOverDomain domain = this;
        return domain;
    }

    private TakeOver get(GetTakeOverByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withType(this.type);
        GetTakeOverByUserIdResult result = this.client.getTakeOverByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, TakeOverDomain.createCacheKey(request.getType() != null ? request.getType().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public TakeOverDomain update(UpdateTakeOverByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withType(this.type);
        UpdateTakeOverByUserIdResult result = this.client.updateTakeOverByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, TakeOverDomain.createCacheKey(request.getType() != null ? request.getType().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        TakeOverDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String type, String childType) {
        return String.join((CharSequence)":", "account", namespaceName, userId, type, childType);
    }

    public static String createCacheKey(String type) {
        return String.join((CharSequence)":", type);
    }

    public TakeOver model() {
        TakeOver value = this.cache.get(this.parentKey, TakeOverDomain.createCacheKey(this.getType() != null ? this.getType().toString() : null), TakeOver.class);
        if (value == null) {
            try {
                this.get(new GetTakeOverByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, TakeOverDomain.createCacheKey(this.getType() != null ? this.getType().toString() : null), TakeOver.class);
            }
            value = this.cache.get(this.parentKey, TakeOverDomain.createCacheKey(this.getType() != null ? this.getType().toString() : null), TakeOver.class);
        }
        return value;
    }
}

