/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.account.domain.model;

import io.gs2.account.Gs2AccountRestClient;
import io.gs2.account.domain.model.AccountDomain;
import io.gs2.account.domain.model.TakeOverDomain;
import io.gs2.account.model.TakeOver;
import io.gs2.account.request.CreateTakeOverRequest;
import io.gs2.account.request.DeleteTakeOverRequest;
import io.gs2.account.request.GetTakeOverRequest;
import io.gs2.account.request.UpdateTakeOverRequest;
import io.gs2.account.result.CreateTakeOverResult;
import io.gs2.account.result.DeleteTakeOverResult;
import io.gs2.account.result.GetTakeOverResult;
import io.gs2.account.result.UpdateTakeOverResult;
import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;

public class TakeOverAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2AccountRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final Integer type;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public Integer getType() {
        return this.type;
    }

    public TakeOverAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, Integer type) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2AccountRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.type = type;
        this.parentKey = AccountDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "TakeOver");
    }

    public TakeOverAccessTokenDomain create(CreateTakeOverRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withType(this.type);
        CreateTakeOverResult result = this.client.createTakeOver(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, TakeOverDomain.createCacheKey(request.getType() != null ? request.getType().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        TakeOverAccessTokenDomain domain = this;
        return domain;
    }

    private TakeOver get(GetTakeOverRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withType(this.type);
        GetTakeOverResult result = this.client.getTakeOver(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, TakeOverDomain.createCacheKey(request.getType() != null ? request.getType().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public TakeOverAccessTokenDomain update(UpdateTakeOverRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withType(this.type);
        UpdateTakeOverResult result = this.client.updateTakeOver(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, TakeOverDomain.createCacheKey(request.getType() != null ? request.getType().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        TakeOverAccessTokenDomain domain = this;
        return domain;
    }

    public TakeOverAccessTokenDomain delete(DeleteTakeOverRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withType(this.type);
        DeleteTakeOverResult result = null;
        try {
            result = this.client.deleteTakeOver(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, TakeOverDomain.createCacheKey(request.getType() != null ? request.getType().toString() : null), TakeOver.class);
        TakeOverAccessTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String type, String childType) {
        return String.join((CharSequence)":", "account", namespaceName, userId, type, childType);
    }

    public static String createCacheKey(String type) {
        return String.join((CharSequence)":", type);
    }

    public TakeOver model() {
        TakeOver value = this.cache.get(this.parentKey, TakeOverDomain.createCacheKey(this.getType() != null ? this.getType().toString() : null), TakeOver.class);
        if (value == null) {
            try {
                this.get(new GetTakeOverRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, TakeOverDomain.createCacheKey(this.getType() != null ? this.getType().toString() : null), TakeOver.class);
            }
            value = this.cache.get(this.parentKey, TakeOverDomain.createCacheKey(this.getType() != null ? this.getType().toString() : null), TakeOver.class);
        }
        return value;
    }
}

