/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.guild.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.model.IModel;
import io.gs2.guild.model.RoleModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GuildModel
implements IModel,
Serializable,
Comparable<GuildModel> {
    private String guildModelId;
    private String name;
    private String metadata;
    private Integer defaultMaximumMemberCount;
    private Integer maximumMemberCount;
    private List<RoleModel> roles;
    private String guildMasterRole;
    private String guildMemberDefaultRole;
    private Integer rejoinCoolTimeMinutes;

    public String getGuildModelId() {
        return this.guildModelId;
    }

    public void setGuildModelId(String guildModelId) {
        this.guildModelId = guildModelId;
    }

    public GuildModel withGuildModelId(String guildModelId) {
        this.guildModelId = guildModelId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GuildModel withName(String name) {
        this.name = name;
        return this;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public GuildModel withMetadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public Integer getDefaultMaximumMemberCount() {
        return this.defaultMaximumMemberCount;
    }

    public void setDefaultMaximumMemberCount(Integer defaultMaximumMemberCount) {
        this.defaultMaximumMemberCount = defaultMaximumMemberCount;
    }

    public GuildModel withDefaultMaximumMemberCount(Integer defaultMaximumMemberCount) {
        this.defaultMaximumMemberCount = defaultMaximumMemberCount;
        return this;
    }

    public Integer getMaximumMemberCount() {
        return this.maximumMemberCount;
    }

    public void setMaximumMemberCount(Integer maximumMemberCount) {
        this.maximumMemberCount = maximumMemberCount;
    }

    public GuildModel withMaximumMemberCount(Integer maximumMemberCount) {
        this.maximumMemberCount = maximumMemberCount;
        return this;
    }

    public List<RoleModel> getRoles() {
        return this.roles;
    }

    public void setRoles(List<RoleModel> roles) {
        this.roles = roles;
    }

    public GuildModel withRoles(List<RoleModel> roles) {
        this.roles = roles;
        return this;
    }

    public String getGuildMasterRole() {
        return this.guildMasterRole;
    }

    public void setGuildMasterRole(String guildMasterRole) {
        this.guildMasterRole = guildMasterRole;
    }

    public GuildModel withGuildMasterRole(String guildMasterRole) {
        this.guildMasterRole = guildMasterRole;
        return this;
    }

    public String getGuildMemberDefaultRole() {
        return this.guildMemberDefaultRole;
    }

    public void setGuildMemberDefaultRole(String guildMemberDefaultRole) {
        this.guildMemberDefaultRole = guildMemberDefaultRole;
    }

    public GuildModel withGuildMemberDefaultRole(String guildMemberDefaultRole) {
        this.guildMemberDefaultRole = guildMemberDefaultRole;
        return this;
    }

    public Integer getRejoinCoolTimeMinutes() {
        return this.rejoinCoolTimeMinutes;
    }

    public void setRejoinCoolTimeMinutes(Integer rejoinCoolTimeMinutes) {
        this.rejoinCoolTimeMinutes = rejoinCoolTimeMinutes;
    }

    public GuildModel withRejoinCoolTimeMinutes(Integer rejoinCoolTimeMinutes) {
        this.rejoinCoolTimeMinutes = rejoinCoolTimeMinutes;
        return this;
    }

    public static GuildModel fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new GuildModel().withGuildModelId(data.get("guildModelId") == null || data.get("guildModelId").isNull() ? null : data.get("guildModelId").asText()).withName(data.get("name") == null || data.get("name").isNull() ? null : data.get("name").asText()).withMetadata(data.get("metadata") == null || data.get("metadata").isNull() ? null : data.get("metadata").asText()).withDefaultMaximumMemberCount(data.get("defaultMaximumMemberCount") == null || data.get("defaultMaximumMemberCount").isNull() ? null : Integer.valueOf(data.get("defaultMaximumMemberCount").intValue())).withMaximumMemberCount(data.get("maximumMemberCount") == null || data.get("maximumMemberCount").isNull() ? null : Integer.valueOf(data.get("maximumMemberCount").intValue())).withRoles(data.get("roles") == null || data.get("roles").isNull() ? new ArrayList<RoleModel>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("roles").elements(), 256), false).map(item -> RoleModel.fromJson(item)).collect(Collectors.toList())).withGuildMasterRole(data.get("guildMasterRole") == null || data.get("guildMasterRole").isNull() ? null : data.get("guildMasterRole").asText()).withGuildMemberDefaultRole(data.get("guildMemberDefaultRole") == null || data.get("guildMemberDefaultRole").isNull() ? null : data.get("guildMemberDefaultRole").asText()).withRejoinCoolTimeMinutes(data.get("rejoinCoolTimeMinutes") == null || data.get("rejoinCoolTimeMinutes").isNull() ? null : Integer.valueOf(data.get("rejoinCoolTimeMinutes").intValue()));
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
            {
                this.put("guildModelId", GuildModel.this.getGuildModelId());
                this.put("name", GuildModel.this.getName());
                this.put("metadata", GuildModel.this.getMetadata());
                this.put("defaultMaximumMemberCount", GuildModel.this.getDefaultMaximumMemberCount());
                this.put("maximumMemberCount", GuildModel.this.getMaximumMemberCount());
                this.put("roles", GuildModel.this.getRoles() == null ? new ArrayList() : GuildModel.this.getRoles().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                this.put("guildMasterRole", GuildModel.this.getGuildMasterRole());
                this.put("guildMemberDefaultRole", GuildModel.this.getGuildMemberDefaultRole());
                this.put("rejoinCoolTimeMinutes", GuildModel.this.getRejoinCoolTimeMinutes());
            }
        });
    }

    @Override
    public int compareTo(GuildModel o) {
        return this.guildModelId.compareTo(o.guildModelId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.guildModelId == null ? 0 : this.guildModelId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.defaultMaximumMemberCount == null ? 0 : this.defaultMaximumMemberCount.hashCode());
        result = 31 * result + (this.maximumMemberCount == null ? 0 : this.maximumMemberCount.hashCode());
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        result = 31 * result + (this.guildMasterRole == null ? 0 : this.guildMasterRole.hashCode());
        result = 31 * result + (this.guildMemberDefaultRole == null ? 0 : this.guildMemberDefaultRole.hashCode());
        result = 31 * result + (this.rejoinCoolTimeMinutes == null ? 0 : this.rejoinCoolTimeMinutes.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        GuildModel other = (GuildModel)o;
        if (this.guildModelId == null) {
            return other.guildModelId == null;
        }
        if (!this.guildModelId.equals(other.guildModelId)) {
            return false;
        }
        if (this.name == null) {
            return other.name == null;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.metadata == null) {
            return other.metadata == null;
        }
        if (!this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.defaultMaximumMemberCount == null) {
            return other.defaultMaximumMemberCount == null;
        }
        if (!this.defaultMaximumMemberCount.equals(other.defaultMaximumMemberCount)) {
            return false;
        }
        if (this.maximumMemberCount == null) {
            return other.maximumMemberCount == null;
        }
        if (!this.maximumMemberCount.equals(other.maximumMemberCount)) {
            return false;
        }
        if (this.roles == null) {
            return other.roles == null;
        }
        if (!this.roles.equals(other.roles)) {
            return false;
        }
        if (this.guildMasterRole == null) {
            return other.guildMasterRole == null;
        }
        if (!this.guildMasterRole.equals(other.guildMasterRole)) {
            return false;
        }
        if (this.guildMemberDefaultRole == null) {
            return other.guildMemberDefaultRole == null;
        }
        if (!this.guildMemberDefaultRole.equals(other.guildMemberDefaultRole)) {
            return false;
        }
        if (this.rejoinCoolTimeMinutes == null) {
            return other.rejoinCoolTimeMinutes == null;
        }
        return this.rejoinCoolTimeMinutes.equals(other.rejoinCoolTimeMinutes);
    }
}

