/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.core.exception;

import io.gs2.core.model.RequestError;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Gs2Exception
extends RuntimeException {
    List<RequestError> errors = new ArrayList<RequestError>();

    public Gs2Exception(String message) {
        super(message);
        try {
            JSONArray errors = new JSONArray(this.getMessage());
            for (int i = 0; i < errors.length(); ++i) {
                RequestError e = new RequestError();
                JSONObject error = errors.getJSONObject(i);
                e.setComponent(error.getString("component"));
                e.setMessage(error.getString("message"));
                e.setCode(error.getString("code"));
                this.errors.add(e);
            }
        }
        catch (JSONException e) {
            this.errors.add(new RequestError("unknown", this.getMessage(), null));
        }
    }

    public Gs2Exception(List<RequestError> errors) {
        this.errors = errors;
    }

    public List<RequestError> getErrors() {
        return this.errors;
    }
}

