/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.adReward.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.adReward.model.AdMob;
import io.gs2.adReward.model.AppLovinMax;
import io.gs2.adReward.model.LogSetting;
import io.gs2.adReward.model.NotificationSetting;
import io.gs2.adReward.model.UnityAd;
import io.gs2.core.control.Gs2BasicRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CreateNamespaceRequest
extends Gs2BasicRequest<CreateNamespaceRequest> {
    private String name;
    private AdMob admob;
    private UnityAd unityAd;
    private List<AppLovinMax> appLovinMaxes;
    private String description;
    private NotificationSetting changePointNotification;
    private LogSetting logSetting;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateNamespaceRequest withName(String name) {
        this.name = name;
        return this;
    }

    public AdMob getAdmob() {
        return this.admob;
    }

    public void setAdmob(AdMob admob) {
        this.admob = admob;
    }

    public CreateNamespaceRequest withAdmob(AdMob admob) {
        this.admob = admob;
        return this;
    }

    public UnityAd getUnityAd() {
        return this.unityAd;
    }

    public void setUnityAd(UnityAd unityAd) {
        this.unityAd = unityAd;
    }

    public CreateNamespaceRequest withUnityAd(UnityAd unityAd) {
        this.unityAd = unityAd;
        return this;
    }

    public List<AppLovinMax> getAppLovinMaxes() {
        return this.appLovinMaxes;
    }

    public void setAppLovinMaxes(List<AppLovinMax> appLovinMaxes) {
        this.appLovinMaxes = appLovinMaxes;
    }

    public CreateNamespaceRequest withAppLovinMaxes(List<AppLovinMax> appLovinMaxes) {
        this.appLovinMaxes = appLovinMaxes;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateNamespaceRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public NotificationSetting getChangePointNotification() {
        return this.changePointNotification;
    }

    public void setChangePointNotification(NotificationSetting changePointNotification) {
        this.changePointNotification = changePointNotification;
    }

    public CreateNamespaceRequest withChangePointNotification(NotificationSetting changePointNotification) {
        this.changePointNotification = changePointNotification;
        return this;
    }

    public LogSetting getLogSetting() {
        return this.logSetting;
    }

    public void setLogSetting(LogSetting logSetting) {
        this.logSetting = logSetting;
    }

    public CreateNamespaceRequest withLogSetting(LogSetting logSetting) {
        this.logSetting = logSetting;
        return this;
    }

    public static CreateNamespaceRequest fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new CreateNamespaceRequest().withName(data.get("name") == null || data.get("name").isNull() ? null : data.get("name").asText()).withAdmob(data.get("admob") == null || data.get("admob").isNull() ? null : AdMob.fromJson(data.get("admob"))).withUnityAd(data.get("unityAd") == null || data.get("unityAd").isNull() ? null : UnityAd.fromJson(data.get("unityAd"))).withAppLovinMaxes(data.get("appLovinMaxes") == null || data.get("appLovinMaxes").isNull() ? new ArrayList<AppLovinMax>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("appLovinMaxes").elements(), 256), false).map(item -> AppLovinMax.fromJson(item)).collect(Collectors.toList())).withDescription(data.get("description") == null || data.get("description").isNull() ? null : data.get("description").asText()).withChangePointNotification(data.get("changePointNotification") == null || data.get("changePointNotification").isNull() ? null : NotificationSetting.fromJson(data.get("changePointNotification"))).withLogSetting(data.get("logSetting") == null || data.get("logSetting").isNull() ? null : LogSetting.fromJson(data.get("logSetting")));
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
            {
                this.put("name", CreateNamespaceRequest.this.getName());
                this.put("admob", CreateNamespaceRequest.this.getAdmob() != null ? CreateNamespaceRequest.this.getAdmob().toJson() : null);
                this.put("unityAd", CreateNamespaceRequest.this.getUnityAd() != null ? CreateNamespaceRequest.this.getUnityAd().toJson() : null);
                this.put("appLovinMaxes", CreateNamespaceRequest.this.getAppLovinMaxes() == null ? new ArrayList() : CreateNamespaceRequest.this.getAppLovinMaxes().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                this.put("description", CreateNamespaceRequest.this.getDescription());
                this.put("changePointNotification", CreateNamespaceRequest.this.getChangePointNotification() != null ? CreateNamespaceRequest.this.getChangePointNotification().toJson() : null);
                this.put("logSetting", CreateNamespaceRequest.this.getLogSetting() != null ? CreateNamespaceRequest.this.getLogSetting().toJson() : null);
            }
        });
    }
}

