/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.skillTree;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.skillTree.request.CheckCleanUserDataByUserIdRequest;
import io.gs2.skillTree.request.CheckDumpUserDataByUserIdRequest;
import io.gs2.skillTree.request.CheckImportUserDataByUserIdRequest;
import io.gs2.skillTree.request.CleanUserDataByUserIdRequest;
import io.gs2.skillTree.request.CreateNamespaceRequest;
import io.gs2.skillTree.request.CreateNodeModelMasterRequest;
import io.gs2.skillTree.request.DeleteNamespaceRequest;
import io.gs2.skillTree.request.DeleteNodeModelMasterRequest;
import io.gs2.skillTree.request.DescribeNamespacesRequest;
import io.gs2.skillTree.request.DescribeNodeModelMastersRequest;
import io.gs2.skillTree.request.DescribeNodeModelsRequest;
import io.gs2.skillTree.request.DescribeStatusesByUserIdRequest;
import io.gs2.skillTree.request.DescribeStatusesRequest;
import io.gs2.skillTree.request.DumpUserDataByUserIdRequest;
import io.gs2.skillTree.request.ExportMasterRequest;
import io.gs2.skillTree.request.GetCurrentTreeMasterRequest;
import io.gs2.skillTree.request.GetNamespaceRequest;
import io.gs2.skillTree.request.GetNamespaceStatusRequest;
import io.gs2.skillTree.request.GetNodeModelMasterRequest;
import io.gs2.skillTree.request.GetNodeModelRequest;
import io.gs2.skillTree.request.GetStatusByUserIdRequest;
import io.gs2.skillTree.request.GetStatusRequest;
import io.gs2.skillTree.request.ImportUserDataByUserIdRequest;
import io.gs2.skillTree.request.MarkReleaseByStampSheetRequest;
import io.gs2.skillTree.request.MarkReleaseByUserIdRequest;
import io.gs2.skillTree.request.MarkRestrainByStampTaskRequest;
import io.gs2.skillTree.request.MarkRestrainByUserIdRequest;
import io.gs2.skillTree.request.PrepareImportUserDataByUserIdRequest;
import io.gs2.skillTree.request.ReleaseByUserIdRequest;
import io.gs2.skillTree.request.ReleaseRequest;
import io.gs2.skillTree.request.ResetByUserIdRequest;
import io.gs2.skillTree.request.ResetRequest;
import io.gs2.skillTree.request.RestrainByUserIdRequest;
import io.gs2.skillTree.request.RestrainRequest;
import io.gs2.skillTree.request.UpdateCurrentTreeMasterFromGitHubRequest;
import io.gs2.skillTree.request.UpdateCurrentTreeMasterRequest;
import io.gs2.skillTree.request.UpdateNamespaceRequest;
import io.gs2.skillTree.request.UpdateNodeModelMasterRequest;
import io.gs2.skillTree.result.CheckCleanUserDataByUserIdResult;
import io.gs2.skillTree.result.CheckDumpUserDataByUserIdResult;
import io.gs2.skillTree.result.CheckImportUserDataByUserIdResult;
import io.gs2.skillTree.result.CleanUserDataByUserIdResult;
import io.gs2.skillTree.result.CreateNamespaceResult;
import io.gs2.skillTree.result.CreateNodeModelMasterResult;
import io.gs2.skillTree.result.DeleteNamespaceResult;
import io.gs2.skillTree.result.DeleteNodeModelMasterResult;
import io.gs2.skillTree.result.DescribeNamespacesResult;
import io.gs2.skillTree.result.DescribeNodeModelMastersResult;
import io.gs2.skillTree.result.DescribeNodeModelsResult;
import io.gs2.skillTree.result.DescribeStatusesByUserIdResult;
import io.gs2.skillTree.result.DescribeStatusesResult;
import io.gs2.skillTree.result.DumpUserDataByUserIdResult;
import io.gs2.skillTree.result.ExportMasterResult;
import io.gs2.skillTree.result.GetCurrentTreeMasterResult;
import io.gs2.skillTree.result.GetNamespaceResult;
import io.gs2.skillTree.result.GetNamespaceStatusResult;
import io.gs2.skillTree.result.GetNodeModelMasterResult;
import io.gs2.skillTree.result.GetNodeModelResult;
import io.gs2.skillTree.result.GetStatusByUserIdResult;
import io.gs2.skillTree.result.GetStatusResult;
import io.gs2.skillTree.result.ImportUserDataByUserIdResult;
import io.gs2.skillTree.result.MarkReleaseByStampSheetResult;
import io.gs2.skillTree.result.MarkReleaseByUserIdResult;
import io.gs2.skillTree.result.MarkRestrainByStampTaskResult;
import io.gs2.skillTree.result.MarkRestrainByUserIdResult;
import io.gs2.skillTree.result.PrepareImportUserDataByUserIdResult;
import io.gs2.skillTree.result.ReleaseByUserIdResult;
import io.gs2.skillTree.result.ReleaseResult;
import io.gs2.skillTree.result.ResetByUserIdResult;
import io.gs2.skillTree.result.ResetResult;
import io.gs2.skillTree.result.RestrainByUserIdResult;
import io.gs2.skillTree.result.RestrainResult;
import io.gs2.skillTree.result.UpdateCurrentTreeMasterFromGitHubResult;
import io.gs2.skillTree.result.UpdateCurrentTreeMasterResult;
import io.gs2.skillTree.result.UpdateNamespaceResult;
import io.gs2.skillTree.result.UpdateNodeModelMasterResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Gs2SkillTreeRestClient
extends AbstractGs2Client<Gs2SkillTreeRestClient> {
    public Gs2SkillTreeRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void dumpUserDataByUserIdAsync(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> callback) {
        DumpUserDataByUserIdTask task = new DumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DumpUserDataByUserIdResult dumpUserDataByUserId(DumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.dumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkDumpUserDataByUserIdAsync(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> callback) {
        CheckDumpUserDataByUserIdTask task = new CheckDumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckDumpUserDataByUserIdResult checkDumpUserDataByUserId(CheckDumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkDumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckDumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void cleanUserDataByUserIdAsync(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> callback) {
        CleanUserDataByUserIdTask task = new CleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CleanUserDataByUserIdResult cleanUserDataByUserId(CleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.cleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkCleanUserDataByUserIdAsync(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> callback) {
        CheckCleanUserDataByUserIdTask task = new CheckCleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckCleanUserDataByUserIdResult checkCleanUserDataByUserId(CheckCleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkCleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckCleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void prepareImportUserDataByUserIdAsync(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> callback) {
        PrepareImportUserDataByUserIdTask task = new PrepareImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PrepareImportUserDataByUserIdResult prepareImportUserDataByUserId(PrepareImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void importUserDataByUserIdAsync(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> callback) {
        ImportUserDataByUserIdTask task = new ImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ImportUserDataByUserIdResult importUserDataByUserId(ImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.importUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkImportUserDataByUserIdAsync(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> callback) {
        CheckImportUserDataByUserIdTask task = new CheckImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckImportUserDataByUserIdResult checkImportUserDataByUserId(CheckImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeNodeModelsAsync(DescribeNodeModelsRequest request, AsyncAction<AsyncResult<DescribeNodeModelsResult>> callback) {
        DescribeNodeModelsTask task = new DescribeNodeModelsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNodeModelsResult describeNodeModels(DescribeNodeModelsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNodeModelsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNodeModelsResult)resultAsyncResult[0].getResult();
    }

    public void getNodeModelAsync(GetNodeModelRequest request, AsyncAction<AsyncResult<GetNodeModelResult>> callback) {
        GetNodeModelTask task = new GetNodeModelTask(request, callback);
        this.session.execute(task);
    }

    public GetNodeModelResult getNodeModel(GetNodeModelRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNodeModelAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNodeModelResult)resultAsyncResult[0].getResult();
    }

    public void describeNodeModelMastersAsync(DescribeNodeModelMastersRequest request, AsyncAction<AsyncResult<DescribeNodeModelMastersResult>> callback) {
        DescribeNodeModelMastersTask task = new DescribeNodeModelMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNodeModelMastersResult describeNodeModelMasters(DescribeNodeModelMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNodeModelMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNodeModelMastersResult)resultAsyncResult[0].getResult();
    }

    public void createNodeModelMasterAsync(CreateNodeModelMasterRequest request, AsyncAction<AsyncResult<CreateNodeModelMasterResult>> callback) {
        CreateNodeModelMasterTask task = new CreateNodeModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateNodeModelMasterResult createNodeModelMaster(CreateNodeModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNodeModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNodeModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void getNodeModelMasterAsync(GetNodeModelMasterRequest request, AsyncAction<AsyncResult<GetNodeModelMasterResult>> callback) {
        GetNodeModelMasterTask task = new GetNodeModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetNodeModelMasterResult getNodeModelMaster(GetNodeModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNodeModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNodeModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateNodeModelMasterAsync(UpdateNodeModelMasterRequest request, AsyncAction<AsyncResult<UpdateNodeModelMasterResult>> callback) {
        UpdateNodeModelMasterTask task = new UpdateNodeModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNodeModelMasterResult updateNodeModelMaster(UpdateNodeModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNodeModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNodeModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteNodeModelMasterAsync(DeleteNodeModelMasterRequest request, AsyncAction<AsyncResult<DeleteNodeModelMasterResult>> callback) {
        DeleteNodeModelMasterTask task = new DeleteNodeModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNodeModelMasterResult deleteNodeModelMaster(DeleteNodeModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNodeModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNodeModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void markReleaseByUserIdAsync(MarkReleaseByUserIdRequest request, AsyncAction<AsyncResult<MarkReleaseByUserIdResult>> callback) {
        MarkReleaseByUserIdTask task = new MarkReleaseByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public MarkReleaseByUserIdResult markReleaseByUserId(MarkReleaseByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.markReleaseByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (MarkReleaseByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void releaseAsync(ReleaseRequest request, AsyncAction<AsyncResult<ReleaseResult>> callback) {
        ReleaseTask task = new ReleaseTask(request, callback);
        this.session.execute(task);
    }

    public ReleaseResult release(ReleaseRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.releaseAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ReleaseResult)resultAsyncResult[0].getResult();
    }

    public void releaseByUserIdAsync(ReleaseByUserIdRequest request, AsyncAction<AsyncResult<ReleaseByUserIdResult>> callback) {
        ReleaseByUserIdTask task = new ReleaseByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ReleaseByUserIdResult releaseByUserId(ReleaseByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.releaseByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ReleaseByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void markRestrainByUserIdAsync(MarkRestrainByUserIdRequest request, AsyncAction<AsyncResult<MarkRestrainByUserIdResult>> callback) {
        MarkRestrainByUserIdTask task = new MarkRestrainByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public MarkRestrainByUserIdResult markRestrainByUserId(MarkRestrainByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.markRestrainByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (MarkRestrainByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void restrainAsync(RestrainRequest request, AsyncAction<AsyncResult<RestrainResult>> callback) {
        RestrainTask task = new RestrainTask(request, callback);
        this.session.execute(task);
    }

    public RestrainResult restrain(RestrainRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.restrainAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RestrainResult)resultAsyncResult[0].getResult();
    }

    public void restrainByUserIdAsync(RestrainByUserIdRequest request, AsyncAction<AsyncResult<RestrainByUserIdResult>> callback) {
        RestrainByUserIdTask task = new RestrainByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public RestrainByUserIdResult restrainByUserId(RestrainByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.restrainByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RestrainByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeStatusesAsync(DescribeStatusesRequest request, AsyncAction<AsyncResult<DescribeStatusesResult>> callback) {
        DescribeStatusesTask task = new DescribeStatusesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeStatusesResult describeStatuses(DescribeStatusesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeStatusesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeStatusesResult)resultAsyncResult[0].getResult();
    }

    public void describeStatusesByUserIdAsync(DescribeStatusesByUserIdRequest request, AsyncAction<AsyncResult<DescribeStatusesByUserIdResult>> callback) {
        DescribeStatusesByUserIdTask task = new DescribeStatusesByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeStatusesByUserIdResult describeStatusesByUserId(DescribeStatusesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeStatusesByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeStatusesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getStatusAsync(GetStatusRequest request, AsyncAction<AsyncResult<GetStatusResult>> callback) {
        GetStatusTask task = new GetStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetStatusResult getStatus(GetStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetStatusResult)resultAsyncResult[0].getResult();
    }

    public void getStatusByUserIdAsync(GetStatusByUserIdRequest request, AsyncAction<AsyncResult<GetStatusByUserIdResult>> callback) {
        GetStatusByUserIdTask task = new GetStatusByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetStatusByUserIdResult getStatusByUserId(GetStatusByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getStatusByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetStatusByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void resetAsync(ResetRequest request, AsyncAction<AsyncResult<ResetResult>> callback) {
        ResetTask task = new ResetTask(request, callback);
        this.session.execute(task);
    }

    public ResetResult reset(ResetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.resetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ResetResult)resultAsyncResult[0].getResult();
    }

    public void resetByUserIdAsync(ResetByUserIdRequest request, AsyncAction<AsyncResult<ResetByUserIdResult>> callback) {
        ResetByUserIdTask task = new ResetByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ResetByUserIdResult resetByUserId(ResetByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.resetByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ResetByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void markReleaseByStampSheetAsync(MarkReleaseByStampSheetRequest request, AsyncAction<AsyncResult<MarkReleaseByStampSheetResult>> callback) {
        MarkReleaseByStampSheetTask task = new MarkReleaseByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public MarkReleaseByStampSheetResult markReleaseByStampSheet(MarkReleaseByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.markReleaseByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (MarkReleaseByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void markRestrainByStampTaskAsync(MarkRestrainByStampTaskRequest request, AsyncAction<AsyncResult<MarkRestrainByStampTaskResult>> callback) {
        MarkRestrainByStampTaskTask task = new MarkRestrainByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public MarkRestrainByStampTaskResult markRestrainByStampTask(MarkRestrainByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.markRestrainByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (MarkRestrainByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentTreeMasterAsync(GetCurrentTreeMasterRequest request, AsyncAction<AsyncResult<GetCurrentTreeMasterResult>> callback) {
        GetCurrentTreeMasterTask task = new GetCurrentTreeMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentTreeMasterResult getCurrentTreeMaster(GetCurrentTreeMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentTreeMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentTreeMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentTreeMasterAsync(UpdateCurrentTreeMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentTreeMasterResult>> callback) {
        UpdateCurrentTreeMasterTask task = new UpdateCurrentTreeMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentTreeMasterResult updateCurrentTreeMaster(UpdateCurrentTreeMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentTreeMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentTreeMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentTreeMasterFromGitHubAsync(UpdateCurrentTreeMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentTreeMasterFromGitHubResult>> callback) {
        UpdateCurrentTreeMasterFromGitHubTask task = new UpdateCurrentTreeMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentTreeMasterFromGitHubResult updateCurrentTreeMasterFromGitHub(UpdateCurrentTreeMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentTreeMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentTreeMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("transactionSetting", CreateNamespaceTask.this.request.getTransactionSetting() != null ? CreateNamespaceTask.this.request.getTransactionSetting().toJson() : null);
                    this.put("releaseScript", CreateNamespaceTask.this.request.getReleaseScript() != null ? CreateNamespaceTask.this.request.getReleaseScript().toJson() : null);
                    this.put("restrainScript", CreateNamespaceTask.this.request.getRestrainScript() != null ? CreateNamespaceTask.this.request.getRestrainScript().toJson() : null);
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("transactionSetting", UpdateNamespaceTask.this.request.getTransactionSetting() != null ? UpdateNamespaceTask.this.request.getTransactionSetting().toJson() : null);
                    this.put("releaseScript", UpdateNamespaceTask.this.request.getReleaseScript() != null ? UpdateNamespaceTask.this.request.getReleaseScript().toJson() : null);
                    this.put("restrainScript", UpdateNamespaceTask.this.request.getRestrainScript() != null ? UpdateNamespaceTask.this.request.getRestrainScript().toJson() : null);
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DumpUserDataByUserIdTask
    extends Gs2RestSessionTask<DumpUserDataByUserIdResult> {
        private DumpUserDataByUserIdRequest request;

        public DumpUserDataByUserIdTask(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DumpUserDataByUserIdResult parse(JsonNode data) {
            return DumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", DumpUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckDumpUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckDumpUserDataByUserIdResult> {
        private CheckDumpUserDataByUserIdRequest request;

        public CheckDumpUserDataByUserIdTask(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckDumpUserDataByUserIdResult parse(JsonNode data) {
            return CheckDumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CleanUserDataByUserIdResult> {
        private CleanUserDataByUserIdRequest request;

        public CleanUserDataByUserIdTask(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CleanUserDataByUserIdResult parse(JsonNode data) {
            return CleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", CleanUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckCleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckCleanUserDataByUserIdResult> {
        private CheckCleanUserDataByUserIdRequest request;

        public CheckCleanUserDataByUserIdTask(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckCleanUserDataByUserIdResult parse(JsonNode data) {
            return CheckCleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareImportUserDataByUserIdTask
    extends Gs2RestSessionTask<PrepareImportUserDataByUserIdResult> {
        private PrepareImportUserDataByUserIdRequest request;

        public PrepareImportUserDataByUserIdTask(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareImportUserDataByUserIdResult parse(JsonNode data) {
            return PrepareImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/prepare";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", PrepareImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ImportUserDataByUserIdTask
    extends Gs2RestSessionTask<ImportUserDataByUserIdResult> {
        private ImportUserDataByUserIdRequest request;

        public ImportUserDataByUserIdTask(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ImportUserDataByUserIdResult parse(JsonNode data) {
            return ImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("uploadToken", ImportUserDataByUserIdTask.this.request.getUploadToken());
                    this.put("contextStack", ImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckImportUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckImportUserDataByUserIdResult> {
        private CheckImportUserDataByUserIdRequest request;

        public CheckImportUserDataByUserIdTask(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckImportUserDataByUserIdResult parse(JsonNode data) {
            return CheckImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/{uploadToken}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{uploadToken}", this.request.getUploadToken() == null || this.request.getUploadToken().length() == 0 ? "null" : String.valueOf(this.request.getUploadToken()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeNodeModelsTask
    extends Gs2RestSessionTask<DescribeNodeModelsResult> {
        private DescribeNodeModelsRequest request;

        public DescribeNodeModelsTask(DescribeNodeModelsRequest request, AsyncAction<AsyncResult<DescribeNodeModelsResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNodeModelsResult parse(JsonNode data) {
            return DescribeNodeModelsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/model";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNodeModelTask
    extends Gs2RestSessionTask<GetNodeModelResult> {
        private GetNodeModelRequest request;

        public GetNodeModelTask(GetNodeModelRequest request, AsyncAction<AsyncResult<GetNodeModelResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNodeModelResult parse(JsonNode data) {
            return GetNodeModelResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/model/{nodeModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{nodeModelName}", this.request.getNodeModelName() == null || this.request.getNodeModelName().length() == 0 ? "null" : String.valueOf(this.request.getNodeModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeNodeModelMastersTask
    extends Gs2RestSessionTask<DescribeNodeModelMastersResult> {
        private DescribeNodeModelMastersRequest request;

        public DescribeNodeModelMastersTask(DescribeNodeModelMastersRequest request, AsyncAction<AsyncResult<DescribeNodeModelMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNodeModelMastersResult parse(JsonNode data) {
            return DescribeNodeModelMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNodeModelMasterTask
    extends Gs2RestSessionTask<CreateNodeModelMasterResult> {
        private CreateNodeModelMasterRequest request;

        public CreateNodeModelMasterTask(CreateNodeModelMasterRequest request, AsyncAction<AsyncResult<CreateNodeModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNodeModelMasterResult parse(JsonNode data) {
            return CreateNodeModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNodeModelMasterTask.this.request.getName());
                    this.put("description", CreateNodeModelMasterTask.this.request.getDescription());
                    this.put("metadata", CreateNodeModelMasterTask.this.request.getMetadata());
                    this.put("releaseConsumeActions", CreateNodeModelMasterTask.this.request.getReleaseConsumeActions() == null ? new ArrayList() : CreateNodeModelMasterTask.this.request.getReleaseConsumeActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("restrainReturnRate", CreateNodeModelMasterTask.this.request.getRestrainReturnRate());
                    this.put("premiseNodeNames", CreateNodeModelMasterTask.this.request.getPremiseNodeNames() == null ? new ArrayList() : CreateNodeModelMasterTask.this.request.getPremiseNodeNames().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", CreateNodeModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNodeModelMasterTask
    extends Gs2RestSessionTask<GetNodeModelMasterResult> {
        private GetNodeModelMasterRequest request;

        public GetNodeModelMasterTask(GetNodeModelMasterRequest request, AsyncAction<AsyncResult<GetNodeModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNodeModelMasterResult parse(JsonNode data) {
            return GetNodeModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model/{nodeModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{nodeModelName}", this.request.getNodeModelName() == null || this.request.getNodeModelName().length() == 0 ? "null" : String.valueOf(this.request.getNodeModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNodeModelMasterTask
    extends Gs2RestSessionTask<UpdateNodeModelMasterResult> {
        private UpdateNodeModelMasterRequest request;

        public UpdateNodeModelMasterTask(UpdateNodeModelMasterRequest request, AsyncAction<AsyncResult<UpdateNodeModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNodeModelMasterResult parse(JsonNode data) {
            return UpdateNodeModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model/{nodeModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{nodeModelName}", this.request.getNodeModelName() == null || this.request.getNodeModelName().length() == 0 ? "null" : String.valueOf(this.request.getNodeModelName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNodeModelMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateNodeModelMasterTask.this.request.getMetadata());
                    this.put("releaseConsumeActions", UpdateNodeModelMasterTask.this.request.getReleaseConsumeActions() == null ? new ArrayList() : UpdateNodeModelMasterTask.this.request.getReleaseConsumeActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("restrainReturnRate", UpdateNodeModelMasterTask.this.request.getRestrainReturnRate());
                    this.put("premiseNodeNames", UpdateNodeModelMasterTask.this.request.getPremiseNodeNames() == null ? new ArrayList() : UpdateNodeModelMasterTask.this.request.getPremiseNodeNames().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", UpdateNodeModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNodeModelMasterTask
    extends Gs2RestSessionTask<DeleteNodeModelMasterResult> {
        private DeleteNodeModelMasterRequest request;

        public DeleteNodeModelMasterTask(DeleteNodeModelMasterRequest request, AsyncAction<AsyncResult<DeleteNodeModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNodeModelMasterResult parse(JsonNode data) {
            return DeleteNodeModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model/{nodeModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{nodeModelName}", this.request.getNodeModelName() == null || this.request.getNodeModelName().length() == 0 ? "null" : String.valueOf(this.request.getNodeModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class MarkReleaseByUserIdTask
    extends Gs2RestSessionTask<MarkReleaseByUserIdResult> {
        private MarkReleaseByUserIdRequest request;

        public MarkReleaseByUserIdTask(MarkReleaseByUserIdRequest request, AsyncAction<AsyncResult<MarkReleaseByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public MarkReleaseByUserIdResult parse(JsonNode data) {
            return MarkReleaseByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/{propertyId}/node/release/mark";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("nodeModelNames", MarkReleaseByUserIdTask.this.request.getNodeModelNames() == null ? new ArrayList() : MarkReleaseByUserIdTask.this.request.getNodeModelNames().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", MarkReleaseByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ReleaseTask
    extends Gs2RestSessionTask<ReleaseResult> {
        private ReleaseRequest request;

        public ReleaseTask(ReleaseRequest request, AsyncAction<AsyncResult<ReleaseResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ReleaseResult parse(JsonNode data) {
            return ReleaseResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/status/{propertyId}/node/release";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("nodeModelNames", ReleaseTask.this.request.getNodeModelNames() == null ? new ArrayList() : ReleaseTask.this.request.getNodeModelNames().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("config", ReleaseTask.this.request.getConfig() == null ? new ArrayList() : ReleaseTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", ReleaseTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ReleaseByUserIdTask
    extends Gs2RestSessionTask<ReleaseByUserIdResult> {
        private ReleaseByUserIdRequest request;

        public ReleaseByUserIdTask(ReleaseByUserIdRequest request, AsyncAction<AsyncResult<ReleaseByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ReleaseByUserIdResult parse(JsonNode data) {
            return ReleaseByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/{propertyId}/node/release";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("nodeModelNames", ReleaseByUserIdTask.this.request.getNodeModelNames() == null ? new ArrayList() : ReleaseByUserIdTask.this.request.getNodeModelNames().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("config", ReleaseByUserIdTask.this.request.getConfig() == null ? new ArrayList() : ReleaseByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", ReleaseByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class MarkRestrainByUserIdTask
    extends Gs2RestSessionTask<MarkRestrainByUserIdResult> {
        private MarkRestrainByUserIdRequest request;

        public MarkRestrainByUserIdTask(MarkRestrainByUserIdRequest request, AsyncAction<AsyncResult<MarkRestrainByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public MarkRestrainByUserIdResult parse(JsonNode data) {
            return MarkRestrainByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/{propertyId}/node/restrain/mark";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("nodeModelNames", MarkRestrainByUserIdTask.this.request.getNodeModelNames() == null ? new ArrayList() : MarkRestrainByUserIdTask.this.request.getNodeModelNames().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", MarkRestrainByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class RestrainTask
    extends Gs2RestSessionTask<RestrainResult> {
        private RestrainRequest request;

        public RestrainTask(RestrainRequest request, AsyncAction<AsyncResult<RestrainResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RestrainResult parse(JsonNode data) {
            return RestrainResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/status/{propertyId}/node/restrain";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("nodeModelNames", RestrainTask.this.request.getNodeModelNames() == null ? new ArrayList() : RestrainTask.this.request.getNodeModelNames().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("config", RestrainTask.this.request.getConfig() == null ? new ArrayList() : RestrainTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", RestrainTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class RestrainByUserIdTask
    extends Gs2RestSessionTask<RestrainByUserIdResult> {
        private RestrainByUserIdRequest request;

        public RestrainByUserIdTask(RestrainByUserIdRequest request, AsyncAction<AsyncResult<RestrainByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RestrainByUserIdResult parse(JsonNode data) {
            return RestrainByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/{propertyId}/node/restrain";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("nodeModelNames", RestrainByUserIdTask.this.request.getNodeModelNames() == null ? new ArrayList() : RestrainByUserIdTask.this.request.getNodeModelNames().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("config", RestrainByUserIdTask.this.request.getConfig() == null ? new ArrayList() : RestrainByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", RestrainByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeStatusesTask
    extends Gs2RestSessionTask<DescribeStatusesResult> {
        private DescribeStatusesRequest request;

        public DescribeStatusesTask(DescribeStatusesRequest request, AsyncAction<AsyncResult<DescribeStatusesResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeStatusesResult parse(JsonNode data) {
            return DescribeStatusesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeStatusesByUserIdTask
    extends Gs2RestSessionTask<DescribeStatusesByUserIdResult> {
        private DescribeStatusesByUserIdRequest request;

        public DescribeStatusesByUserIdTask(DescribeStatusesByUserIdRequest request, AsyncAction<AsyncResult<DescribeStatusesByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeStatusesByUserIdResult parse(JsonNode data) {
            return DescribeStatusesByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetStatusTask
    extends Gs2RestSessionTask<GetStatusResult> {
        private GetStatusRequest request;

        public GetStatusTask(GetStatusRequest request, AsyncAction<AsyncResult<GetStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetStatusResult parse(JsonNode data) {
            return GetStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/status/{propertyId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetStatusByUserIdTask
    extends Gs2RestSessionTask<GetStatusByUserIdResult> {
        private GetStatusByUserIdRequest request;

        public GetStatusByUserIdTask(GetStatusByUserIdRequest request, AsyncAction<AsyncResult<GetStatusByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetStatusByUserIdResult parse(JsonNode data) {
            return GetStatusByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/{propertyId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ResetTask
    extends Gs2RestSessionTask<ResetResult> {
        private ResetRequest request;

        public ResetTask(ResetRequest request, AsyncAction<AsyncResult<ResetResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ResetResult parse(JsonNode data) {
            return ResetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/status/{propertyId}/reset";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("config", ResetTask.this.request.getConfig() == null ? new ArrayList() : ResetTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", ResetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ResetByUserIdTask
    extends Gs2RestSessionTask<ResetByUserIdResult> {
        private ResetByUserIdRequest request;

        public ResetByUserIdTask(ResetByUserIdRequest request, AsyncAction<AsyncResult<ResetByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ResetByUserIdResult parse(JsonNode data) {
            return ResetByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/{propertyId}/reset";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class MarkReleaseByStampSheetTask
    extends Gs2RestSessionTask<MarkReleaseByStampSheetResult> {
        private MarkReleaseByStampSheetRequest request;

        public MarkReleaseByStampSheetTask(MarkReleaseByStampSheetRequest request, AsyncAction<AsyncResult<MarkReleaseByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public MarkReleaseByStampSheetResult parse(JsonNode data) {
            return MarkReleaseByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/stamp/status/release";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", MarkReleaseByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", MarkReleaseByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", MarkReleaseByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class MarkRestrainByStampTaskTask
    extends Gs2RestSessionTask<MarkRestrainByStampTaskResult> {
        private MarkRestrainByStampTaskRequest request;

        public MarkRestrainByStampTaskTask(MarkRestrainByStampTaskRequest request, AsyncAction<AsyncResult<MarkRestrainByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public MarkRestrainByStampTaskResult parse(JsonNode data) {
            return MarkRestrainByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/stamp/status/restrain";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", MarkRestrainByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", MarkRestrainByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", MarkRestrainByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentTreeMasterTask
    extends Gs2RestSessionTask<GetCurrentTreeMasterResult> {
        private GetCurrentTreeMasterRequest request;

        public GetCurrentTreeMasterTask(GetCurrentTreeMasterRequest request, AsyncAction<AsyncResult<GetCurrentTreeMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentTreeMasterResult parse(JsonNode data) {
            return GetCurrentTreeMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentTreeMasterTask
    extends Gs2RestSessionTask<UpdateCurrentTreeMasterResult> {
        private UpdateCurrentTreeMasterRequest request;

        public UpdateCurrentTreeMasterTask(UpdateCurrentTreeMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentTreeMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentTreeMasterResult parse(JsonNode data) {
            return UpdateCurrentTreeMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentTreeMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentTreeMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentTreeMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentTreeMasterFromGitHubResult> {
        private UpdateCurrentTreeMasterFromGitHubRequest request;

        public UpdateCurrentTreeMasterFromGitHubTask(UpdateCurrentTreeMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentTreeMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2SkillTreeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentTreeMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentTreeMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "skill-tree").replace("{region}", Gs2SkillTreeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentTreeMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentTreeMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentTreeMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

