/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.schedule;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.schedule.request.CheckCleanUserDataByUserIdRequest;
import io.gs2.schedule.request.CheckDumpUserDataByUserIdRequest;
import io.gs2.schedule.request.CheckImportUserDataByUserIdRequest;
import io.gs2.schedule.request.CleanUserDataByUserIdRequest;
import io.gs2.schedule.request.CreateEventMasterRequest;
import io.gs2.schedule.request.CreateNamespaceRequest;
import io.gs2.schedule.request.DeleteEventMasterRequest;
import io.gs2.schedule.request.DeleteNamespaceRequest;
import io.gs2.schedule.request.DeleteTriggerByStampTaskRequest;
import io.gs2.schedule.request.DeleteTriggerByUserIdRequest;
import io.gs2.schedule.request.DeleteTriggerRequest;
import io.gs2.schedule.request.DescribeEventMastersRequest;
import io.gs2.schedule.request.DescribeEventsByUserIdRequest;
import io.gs2.schedule.request.DescribeEventsRequest;
import io.gs2.schedule.request.DescribeNamespacesRequest;
import io.gs2.schedule.request.DescribeRawEventsRequest;
import io.gs2.schedule.request.DescribeTriggersByUserIdRequest;
import io.gs2.schedule.request.DescribeTriggersRequest;
import io.gs2.schedule.request.DumpUserDataByUserIdRequest;
import io.gs2.schedule.request.ExportMasterRequest;
import io.gs2.schedule.request.GetCurrentEventMasterRequest;
import io.gs2.schedule.request.GetEventByUserIdRequest;
import io.gs2.schedule.request.GetEventMasterRequest;
import io.gs2.schedule.request.GetEventRequest;
import io.gs2.schedule.request.GetNamespaceRequest;
import io.gs2.schedule.request.GetNamespaceStatusRequest;
import io.gs2.schedule.request.GetRawEventRequest;
import io.gs2.schedule.request.GetTriggerByUserIdRequest;
import io.gs2.schedule.request.GetTriggerRequest;
import io.gs2.schedule.request.ImportUserDataByUserIdRequest;
import io.gs2.schedule.request.PrepareImportUserDataByUserIdRequest;
import io.gs2.schedule.request.TriggerByStampSheetRequest;
import io.gs2.schedule.request.TriggerByUserIdRequest;
import io.gs2.schedule.request.UpdateCurrentEventMasterFromGitHubRequest;
import io.gs2.schedule.request.UpdateCurrentEventMasterRequest;
import io.gs2.schedule.request.UpdateEventMasterRequest;
import io.gs2.schedule.request.UpdateNamespaceRequest;
import io.gs2.schedule.request.VerifyEventByStampTaskRequest;
import io.gs2.schedule.request.VerifyEventByUserIdRequest;
import io.gs2.schedule.request.VerifyEventRequest;
import io.gs2.schedule.result.CheckCleanUserDataByUserIdResult;
import io.gs2.schedule.result.CheckDumpUserDataByUserIdResult;
import io.gs2.schedule.result.CheckImportUserDataByUserIdResult;
import io.gs2.schedule.result.CleanUserDataByUserIdResult;
import io.gs2.schedule.result.CreateEventMasterResult;
import io.gs2.schedule.result.CreateNamespaceResult;
import io.gs2.schedule.result.DeleteEventMasterResult;
import io.gs2.schedule.result.DeleteNamespaceResult;
import io.gs2.schedule.result.DeleteTriggerByStampTaskResult;
import io.gs2.schedule.result.DeleteTriggerByUserIdResult;
import io.gs2.schedule.result.DeleteTriggerResult;
import io.gs2.schedule.result.DescribeEventMastersResult;
import io.gs2.schedule.result.DescribeEventsByUserIdResult;
import io.gs2.schedule.result.DescribeEventsResult;
import io.gs2.schedule.result.DescribeNamespacesResult;
import io.gs2.schedule.result.DescribeRawEventsResult;
import io.gs2.schedule.result.DescribeTriggersByUserIdResult;
import io.gs2.schedule.result.DescribeTriggersResult;
import io.gs2.schedule.result.DumpUserDataByUserIdResult;
import io.gs2.schedule.result.ExportMasterResult;
import io.gs2.schedule.result.GetCurrentEventMasterResult;
import io.gs2.schedule.result.GetEventByUserIdResult;
import io.gs2.schedule.result.GetEventMasterResult;
import io.gs2.schedule.result.GetEventResult;
import io.gs2.schedule.result.GetNamespaceResult;
import io.gs2.schedule.result.GetNamespaceStatusResult;
import io.gs2.schedule.result.GetRawEventResult;
import io.gs2.schedule.result.GetTriggerByUserIdResult;
import io.gs2.schedule.result.GetTriggerResult;
import io.gs2.schedule.result.ImportUserDataByUserIdResult;
import io.gs2.schedule.result.PrepareImportUserDataByUserIdResult;
import io.gs2.schedule.result.TriggerByStampSheetResult;
import io.gs2.schedule.result.TriggerByUserIdResult;
import io.gs2.schedule.result.UpdateCurrentEventMasterFromGitHubResult;
import io.gs2.schedule.result.UpdateCurrentEventMasterResult;
import io.gs2.schedule.result.UpdateEventMasterResult;
import io.gs2.schedule.result.UpdateNamespaceResult;
import io.gs2.schedule.result.VerifyEventByStampTaskResult;
import io.gs2.schedule.result.VerifyEventByUserIdResult;
import io.gs2.schedule.result.VerifyEventResult;
import java.util.ArrayList;
import java.util.HashMap;

public class Gs2ScheduleRestClient
extends AbstractGs2Client<Gs2ScheduleRestClient> {
    public Gs2ScheduleRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void dumpUserDataByUserIdAsync(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> callback) {
        DumpUserDataByUserIdTask task = new DumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DumpUserDataByUserIdResult dumpUserDataByUserId(DumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.dumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkDumpUserDataByUserIdAsync(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> callback) {
        CheckDumpUserDataByUserIdTask task = new CheckDumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckDumpUserDataByUserIdResult checkDumpUserDataByUserId(CheckDumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkDumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckDumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void cleanUserDataByUserIdAsync(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> callback) {
        CleanUserDataByUserIdTask task = new CleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CleanUserDataByUserIdResult cleanUserDataByUserId(CleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.cleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkCleanUserDataByUserIdAsync(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> callback) {
        CheckCleanUserDataByUserIdTask task = new CheckCleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckCleanUserDataByUserIdResult checkCleanUserDataByUserId(CheckCleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkCleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckCleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void prepareImportUserDataByUserIdAsync(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> callback) {
        PrepareImportUserDataByUserIdTask task = new PrepareImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PrepareImportUserDataByUserIdResult prepareImportUserDataByUserId(PrepareImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void importUserDataByUserIdAsync(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> callback) {
        ImportUserDataByUserIdTask task = new ImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ImportUserDataByUserIdResult importUserDataByUserId(ImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.importUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkImportUserDataByUserIdAsync(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> callback) {
        CheckImportUserDataByUserIdTask task = new CheckImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckImportUserDataByUserIdResult checkImportUserDataByUserId(CheckImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeEventMastersAsync(DescribeEventMastersRequest request, AsyncAction<AsyncResult<DescribeEventMastersResult>> callback) {
        DescribeEventMastersTask task = new DescribeEventMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeEventMastersResult describeEventMasters(DescribeEventMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeEventMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeEventMastersResult)resultAsyncResult[0].getResult();
    }

    public void createEventMasterAsync(CreateEventMasterRequest request, AsyncAction<AsyncResult<CreateEventMasterResult>> callback) {
        CreateEventMasterTask task = new CreateEventMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateEventMasterResult createEventMaster(CreateEventMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createEventMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateEventMasterResult)resultAsyncResult[0].getResult();
    }

    public void getEventMasterAsync(GetEventMasterRequest request, AsyncAction<AsyncResult<GetEventMasterResult>> callback) {
        GetEventMasterTask task = new GetEventMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetEventMasterResult getEventMaster(GetEventMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getEventMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetEventMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateEventMasterAsync(UpdateEventMasterRequest request, AsyncAction<AsyncResult<UpdateEventMasterResult>> callback) {
        UpdateEventMasterTask task = new UpdateEventMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateEventMasterResult updateEventMaster(UpdateEventMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateEventMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateEventMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteEventMasterAsync(DeleteEventMasterRequest request, AsyncAction<AsyncResult<DeleteEventMasterResult>> callback) {
        DeleteEventMasterTask task = new DeleteEventMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteEventMasterResult deleteEventMaster(DeleteEventMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteEventMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteEventMasterResult)resultAsyncResult[0].getResult();
    }

    public void describeTriggersAsync(DescribeTriggersRequest request, AsyncAction<AsyncResult<DescribeTriggersResult>> callback) {
        DescribeTriggersTask task = new DescribeTriggersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeTriggersResult describeTriggers(DescribeTriggersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeTriggersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeTriggersResult)resultAsyncResult[0].getResult();
    }

    public void describeTriggersByUserIdAsync(DescribeTriggersByUserIdRequest request, AsyncAction<AsyncResult<DescribeTriggersByUserIdResult>> callback) {
        DescribeTriggersByUserIdTask task = new DescribeTriggersByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeTriggersByUserIdResult describeTriggersByUserId(DescribeTriggersByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeTriggersByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeTriggersByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getTriggerAsync(GetTriggerRequest request, AsyncAction<AsyncResult<GetTriggerResult>> callback) {
        GetTriggerTask task = new GetTriggerTask(request, callback);
        this.session.execute(task);
    }

    public GetTriggerResult getTrigger(GetTriggerRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getTriggerAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetTriggerResult)resultAsyncResult[0].getResult();
    }

    public void getTriggerByUserIdAsync(GetTriggerByUserIdRequest request, AsyncAction<AsyncResult<GetTriggerByUserIdResult>> callback) {
        GetTriggerByUserIdTask task = new GetTriggerByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetTriggerByUserIdResult getTriggerByUserId(GetTriggerByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getTriggerByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetTriggerByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void triggerByUserIdAsync(TriggerByUserIdRequest request, AsyncAction<AsyncResult<TriggerByUserIdResult>> callback) {
        TriggerByUserIdTask task = new TriggerByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public TriggerByUserIdResult triggerByUserId(TriggerByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.triggerByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (TriggerByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void triggerByStampSheetAsync(TriggerByStampSheetRequest request, AsyncAction<AsyncResult<TriggerByStampSheetResult>> callback) {
        TriggerByStampSheetTask task = new TriggerByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public TriggerByStampSheetResult triggerByStampSheet(TriggerByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.triggerByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (TriggerByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void deleteTriggerAsync(DeleteTriggerRequest request, AsyncAction<AsyncResult<DeleteTriggerResult>> callback) {
        DeleteTriggerTask task = new DeleteTriggerTask(request, callback);
        this.session.execute(task);
    }

    public DeleteTriggerResult deleteTrigger(DeleteTriggerRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteTriggerAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteTriggerResult)resultAsyncResult[0].getResult();
    }

    public void deleteTriggerByUserIdAsync(DeleteTriggerByUserIdRequest request, AsyncAction<AsyncResult<DeleteTriggerByUserIdResult>> callback) {
        DeleteTriggerByUserIdTask task = new DeleteTriggerByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteTriggerByUserIdResult deleteTriggerByUserId(DeleteTriggerByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteTriggerByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteTriggerByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteTriggerByStampTaskAsync(DeleteTriggerByStampTaskRequest request, AsyncAction<AsyncResult<DeleteTriggerByStampTaskResult>> callback) {
        DeleteTriggerByStampTaskTask task = new DeleteTriggerByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public DeleteTriggerByStampTaskResult deleteTriggerByStampTask(DeleteTriggerByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteTriggerByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteTriggerByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void describeEventsAsync(DescribeEventsRequest request, AsyncAction<AsyncResult<DescribeEventsResult>> callback) {
        DescribeEventsTask task = new DescribeEventsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeEventsResult describeEvents(DescribeEventsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeEventsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeEventsResult)resultAsyncResult[0].getResult();
    }

    public void describeEventsByUserIdAsync(DescribeEventsByUserIdRequest request, AsyncAction<AsyncResult<DescribeEventsByUserIdResult>> callback) {
        DescribeEventsByUserIdTask task = new DescribeEventsByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeEventsByUserIdResult describeEventsByUserId(DescribeEventsByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeEventsByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeEventsByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeRawEventsAsync(DescribeRawEventsRequest request, AsyncAction<AsyncResult<DescribeRawEventsResult>> callback) {
        DescribeRawEventsTask task = new DescribeRawEventsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeRawEventsResult describeRawEvents(DescribeRawEventsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeRawEventsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeRawEventsResult)resultAsyncResult[0].getResult();
    }

    public void getEventAsync(GetEventRequest request, AsyncAction<AsyncResult<GetEventResult>> callback) {
        GetEventTask task = new GetEventTask(request, callback);
        this.session.execute(task);
    }

    public GetEventResult getEvent(GetEventRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getEventAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetEventResult)resultAsyncResult[0].getResult();
    }

    public void getEventByUserIdAsync(GetEventByUserIdRequest request, AsyncAction<AsyncResult<GetEventByUserIdResult>> callback) {
        GetEventByUserIdTask task = new GetEventByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetEventByUserIdResult getEventByUserId(GetEventByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getEventByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetEventByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getRawEventAsync(GetRawEventRequest request, AsyncAction<AsyncResult<GetRawEventResult>> callback) {
        GetRawEventTask task = new GetRawEventTask(request, callback);
        this.session.execute(task);
    }

    public GetRawEventResult getRawEvent(GetRawEventRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getRawEventAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetRawEventResult)resultAsyncResult[0].getResult();
    }

    public void verifyEventAsync(VerifyEventRequest request, AsyncAction<AsyncResult<VerifyEventResult>> callback) {
        VerifyEventTask task = new VerifyEventTask(request, callback);
        this.session.execute(task);
    }

    public VerifyEventResult verifyEvent(VerifyEventRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.verifyEventAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (VerifyEventResult)resultAsyncResult[0].getResult();
    }

    public void verifyEventByUserIdAsync(VerifyEventByUserIdRequest request, AsyncAction<AsyncResult<VerifyEventByUserIdResult>> callback) {
        VerifyEventByUserIdTask task = new VerifyEventByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public VerifyEventByUserIdResult verifyEventByUserId(VerifyEventByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.verifyEventByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (VerifyEventByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void verifyEventByStampTaskAsync(VerifyEventByStampTaskRequest request, AsyncAction<AsyncResult<VerifyEventByStampTaskResult>> callback) {
        VerifyEventByStampTaskTask task = new VerifyEventByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public VerifyEventByStampTaskResult verifyEventByStampTask(VerifyEventByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.verifyEventByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (VerifyEventByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentEventMasterAsync(GetCurrentEventMasterRequest request, AsyncAction<AsyncResult<GetCurrentEventMasterResult>> callback) {
        GetCurrentEventMasterTask task = new GetCurrentEventMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentEventMasterResult getCurrentEventMaster(GetCurrentEventMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentEventMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentEventMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentEventMasterAsync(UpdateCurrentEventMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentEventMasterResult>> callback) {
        UpdateCurrentEventMasterTask task = new UpdateCurrentEventMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentEventMasterResult updateCurrentEventMaster(UpdateCurrentEventMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentEventMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentEventMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentEventMasterFromGitHubAsync(UpdateCurrentEventMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentEventMasterFromGitHubResult>> callback) {
        UpdateCurrentEventMasterFromGitHubTask task = new UpdateCurrentEventMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentEventMasterFromGitHubResult updateCurrentEventMasterFromGitHub(UpdateCurrentEventMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentEventMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentEventMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DumpUserDataByUserIdTask
    extends Gs2RestSessionTask<DumpUserDataByUserIdResult> {
        private DumpUserDataByUserIdRequest request;

        public DumpUserDataByUserIdTask(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DumpUserDataByUserIdResult parse(JsonNode data) {
            return DumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", DumpUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckDumpUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckDumpUserDataByUserIdResult> {
        private CheckDumpUserDataByUserIdRequest request;

        public CheckDumpUserDataByUserIdTask(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckDumpUserDataByUserIdResult parse(JsonNode data) {
            return CheckDumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CleanUserDataByUserIdResult> {
        private CleanUserDataByUserIdRequest request;

        public CleanUserDataByUserIdTask(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CleanUserDataByUserIdResult parse(JsonNode data) {
            return CleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", CleanUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckCleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckCleanUserDataByUserIdResult> {
        private CheckCleanUserDataByUserIdRequest request;

        public CheckCleanUserDataByUserIdTask(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckCleanUserDataByUserIdResult parse(JsonNode data) {
            return CheckCleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareImportUserDataByUserIdTask
    extends Gs2RestSessionTask<PrepareImportUserDataByUserIdResult> {
        private PrepareImportUserDataByUserIdRequest request;

        public PrepareImportUserDataByUserIdTask(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareImportUserDataByUserIdResult parse(JsonNode data) {
            return PrepareImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/prepare";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", PrepareImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ImportUserDataByUserIdTask
    extends Gs2RestSessionTask<ImportUserDataByUserIdResult> {
        private ImportUserDataByUserIdRequest request;

        public ImportUserDataByUserIdTask(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ImportUserDataByUserIdResult parse(JsonNode data) {
            return ImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("uploadToken", ImportUserDataByUserIdTask.this.request.getUploadToken());
                    this.put("contextStack", ImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckImportUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckImportUserDataByUserIdResult> {
        private CheckImportUserDataByUserIdRequest request;

        public CheckImportUserDataByUserIdTask(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckImportUserDataByUserIdResult parse(JsonNode data) {
            return CheckImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/{uploadToken}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{uploadToken}", this.request.getUploadToken() == null || this.request.getUploadToken().length() == 0 ? "null" : String.valueOf(this.request.getUploadToken()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeEventMastersTask
    extends Gs2RestSessionTask<DescribeEventMastersResult> {
        private DescribeEventMastersRequest request;

        public DescribeEventMastersTask(DescribeEventMastersRequest request, AsyncAction<AsyncResult<DescribeEventMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeEventMastersResult parse(JsonNode data) {
            return DescribeEventMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/event";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateEventMasterTask
    extends Gs2RestSessionTask<CreateEventMasterResult> {
        private CreateEventMasterRequest request;

        public CreateEventMasterTask(CreateEventMasterRequest request, AsyncAction<AsyncResult<CreateEventMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateEventMasterResult parse(JsonNode data) {
            return CreateEventMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/event";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateEventMasterTask.this.request.getName());
                    this.put("description", CreateEventMasterTask.this.request.getDescription());
                    this.put("metadata", CreateEventMasterTask.this.request.getMetadata());
                    this.put("scheduleType", CreateEventMasterTask.this.request.getScheduleType());
                    this.put("absoluteBegin", CreateEventMasterTask.this.request.getAbsoluteBegin());
                    this.put("absoluteEnd", CreateEventMasterTask.this.request.getAbsoluteEnd());
                    this.put("repeatType", CreateEventMasterTask.this.request.getRepeatType());
                    this.put("repeatBeginDayOfMonth", CreateEventMasterTask.this.request.getRepeatBeginDayOfMonth());
                    this.put("repeatEndDayOfMonth", CreateEventMasterTask.this.request.getRepeatEndDayOfMonth());
                    this.put("repeatBeginDayOfWeek", CreateEventMasterTask.this.request.getRepeatBeginDayOfWeek());
                    this.put("repeatEndDayOfWeek", CreateEventMasterTask.this.request.getRepeatEndDayOfWeek());
                    this.put("repeatBeginHour", CreateEventMasterTask.this.request.getRepeatBeginHour());
                    this.put("repeatEndHour", CreateEventMasterTask.this.request.getRepeatEndHour());
                    this.put("relativeTriggerName", CreateEventMasterTask.this.request.getRelativeTriggerName());
                    this.put("contextStack", CreateEventMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetEventMasterTask
    extends Gs2RestSessionTask<GetEventMasterResult> {
        private GetEventMasterRequest request;

        public GetEventMasterTask(GetEventMasterRequest request, AsyncAction<AsyncResult<GetEventMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetEventMasterResult parse(JsonNode data) {
            return GetEventMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/event/{eventName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateEventMasterTask
    extends Gs2RestSessionTask<UpdateEventMasterResult> {
        private UpdateEventMasterRequest request;

        public UpdateEventMasterTask(UpdateEventMasterRequest request, AsyncAction<AsyncResult<UpdateEventMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateEventMasterResult parse(JsonNode data) {
            return UpdateEventMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/event/{eventName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateEventMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateEventMasterTask.this.request.getMetadata());
                    this.put("scheduleType", UpdateEventMasterTask.this.request.getScheduleType());
                    this.put("absoluteBegin", UpdateEventMasterTask.this.request.getAbsoluteBegin());
                    this.put("absoluteEnd", UpdateEventMasterTask.this.request.getAbsoluteEnd());
                    this.put("repeatType", UpdateEventMasterTask.this.request.getRepeatType());
                    this.put("repeatBeginDayOfMonth", UpdateEventMasterTask.this.request.getRepeatBeginDayOfMonth());
                    this.put("repeatEndDayOfMonth", UpdateEventMasterTask.this.request.getRepeatEndDayOfMonth());
                    this.put("repeatBeginDayOfWeek", UpdateEventMasterTask.this.request.getRepeatBeginDayOfWeek());
                    this.put("repeatEndDayOfWeek", UpdateEventMasterTask.this.request.getRepeatEndDayOfWeek());
                    this.put("repeatBeginHour", UpdateEventMasterTask.this.request.getRepeatBeginHour());
                    this.put("repeatEndHour", UpdateEventMasterTask.this.request.getRepeatEndHour());
                    this.put("relativeTriggerName", UpdateEventMasterTask.this.request.getRelativeTriggerName());
                    this.put("contextStack", UpdateEventMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteEventMasterTask
    extends Gs2RestSessionTask<DeleteEventMasterResult> {
        private DeleteEventMasterRequest request;

        public DeleteEventMasterTask(DeleteEventMasterRequest request, AsyncAction<AsyncResult<DeleteEventMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteEventMasterResult parse(JsonNode data) {
            return DeleteEventMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/event/{eventName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeTriggersTask
    extends Gs2RestSessionTask<DescribeTriggersResult> {
        private DescribeTriggersRequest request;

        public DescribeTriggersTask(DescribeTriggersRequest request, AsyncAction<AsyncResult<DescribeTriggersResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeTriggersResult parse(JsonNode data) {
            return DescribeTriggersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/trigger";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeTriggersByUserIdTask
    extends Gs2RestSessionTask<DescribeTriggersByUserIdResult> {
        private DescribeTriggersByUserIdRequest request;

        public DescribeTriggersByUserIdTask(DescribeTriggersByUserIdRequest request, AsyncAction<AsyncResult<DescribeTriggersByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeTriggersByUserIdResult parse(JsonNode data) {
            return DescribeTriggersByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/trigger";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetTriggerTask
    extends Gs2RestSessionTask<GetTriggerResult> {
        private GetTriggerRequest request;

        public GetTriggerTask(GetTriggerRequest request, AsyncAction<AsyncResult<GetTriggerResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetTriggerResult parse(JsonNode data) {
            return GetTriggerResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/trigger/{triggerName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{triggerName}", this.request.getTriggerName() == null || this.request.getTriggerName().length() == 0 ? "null" : String.valueOf(this.request.getTriggerName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetTriggerByUserIdTask
    extends Gs2RestSessionTask<GetTriggerByUserIdResult> {
        private GetTriggerByUserIdRequest request;

        public GetTriggerByUserIdTask(GetTriggerByUserIdRequest request, AsyncAction<AsyncResult<GetTriggerByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetTriggerByUserIdResult parse(JsonNode data) {
            return GetTriggerByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/trigger/{triggerName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{triggerName}", this.request.getTriggerName() == null || this.request.getTriggerName().length() == 0 ? "null" : String.valueOf(this.request.getTriggerName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class TriggerByUserIdTask
    extends Gs2RestSessionTask<TriggerByUserIdResult> {
        private TriggerByUserIdRequest request;

        public TriggerByUserIdTask(TriggerByUserIdRequest request, AsyncAction<AsyncResult<TriggerByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public TriggerByUserIdResult parse(JsonNode data) {
            return TriggerByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/trigger/{triggerName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{triggerName}", this.request.getTriggerName() == null || this.request.getTriggerName().length() == 0 ? "null" : String.valueOf(this.request.getTriggerName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("triggerStrategy", TriggerByUserIdTask.this.request.getTriggerStrategy());
                    this.put("ttl", TriggerByUserIdTask.this.request.getTtl());
                    this.put("contextStack", TriggerByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class TriggerByStampSheetTask
    extends Gs2RestSessionTask<TriggerByStampSheetResult> {
        private TriggerByStampSheetRequest request;

        public TriggerByStampSheetTask(TriggerByStampSheetRequest request, AsyncAction<AsyncResult<TriggerByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public TriggerByStampSheetResult parse(JsonNode data) {
            return TriggerByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/stamp/trigger";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", TriggerByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", TriggerByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", TriggerByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteTriggerTask
    extends Gs2RestSessionTask<DeleteTriggerResult> {
        private DeleteTriggerRequest request;

        public DeleteTriggerTask(DeleteTriggerRequest request, AsyncAction<AsyncResult<DeleteTriggerResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteTriggerResult parse(JsonNode data) {
            return DeleteTriggerResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/trigger/{triggerName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{triggerName}", this.request.getTriggerName() == null || this.request.getTriggerName().length() == 0 ? "null" : String.valueOf(this.request.getTriggerName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteTriggerByUserIdTask
    extends Gs2RestSessionTask<DeleteTriggerByUserIdResult> {
        private DeleteTriggerByUserIdRequest request;

        public DeleteTriggerByUserIdTask(DeleteTriggerByUserIdRequest request, AsyncAction<AsyncResult<DeleteTriggerByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteTriggerByUserIdResult parse(JsonNode data) {
            return DeleteTriggerByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/trigger/{triggerName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{triggerName}", this.request.getTriggerName() == null || this.request.getTriggerName().length() == 0 ? "null" : String.valueOf(this.request.getTriggerName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteTriggerByStampTaskTask
    extends Gs2RestSessionTask<DeleteTriggerByStampTaskResult> {
        private DeleteTriggerByStampTaskRequest request;

        public DeleteTriggerByStampTaskTask(DeleteTriggerByStampTaskRequest request, AsyncAction<AsyncResult<DeleteTriggerByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteTriggerByStampTaskResult parse(JsonNode data) {
            return DeleteTriggerByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/stamp/trigger/delete";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", DeleteTriggerByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", DeleteTriggerByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", DeleteTriggerByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeEventsTask
    extends Gs2RestSessionTask<DescribeEventsResult> {
        private DescribeEventsRequest request;

        public DescribeEventsTask(DescribeEventsRequest request, AsyncAction<AsyncResult<DescribeEventsResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeEventsResult parse(JsonNode data) {
            return DescribeEventsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/event";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeEventsByUserIdTask
    extends Gs2RestSessionTask<DescribeEventsByUserIdResult> {
        private DescribeEventsByUserIdRequest request;

        public DescribeEventsByUserIdTask(DescribeEventsByUserIdRequest request, AsyncAction<AsyncResult<DescribeEventsByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeEventsByUserIdResult parse(JsonNode data) {
            return DescribeEventsByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/event";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeRawEventsTask
    extends Gs2RestSessionTask<DescribeRawEventsResult> {
        private DescribeRawEventsRequest request;

        public DescribeRawEventsTask(DescribeRawEventsRequest request, AsyncAction<AsyncResult<DescribeRawEventsResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeRawEventsResult parse(JsonNode data) {
            return DescribeRawEventsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/event";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetEventTask
    extends Gs2RestSessionTask<GetEventResult> {
        private GetEventRequest request;

        public GetEventTask(GetEventRequest request, AsyncAction<AsyncResult<GetEventResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetEventResult parse(JsonNode data) {
            return GetEventResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/event/{eventName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetEventByUserIdTask
    extends Gs2RestSessionTask<GetEventByUserIdResult> {
        private GetEventByUserIdRequest request;

        public GetEventByUserIdTask(GetEventByUserIdRequest request, AsyncAction<AsyncResult<GetEventByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetEventByUserIdResult parse(JsonNode data) {
            return GetEventByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/event/{eventName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetRawEventTask
    extends Gs2RestSessionTask<GetRawEventResult> {
        private GetRawEventRequest request;

        public GetRawEventTask(GetRawEventRequest request, AsyncAction<AsyncResult<GetRawEventResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetRawEventResult parse(JsonNode data) {
            return GetRawEventResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/event/{eventName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class VerifyEventTask
    extends Gs2RestSessionTask<VerifyEventResult> {
        private VerifyEventRequest request;

        public VerifyEventTask(VerifyEventRequest request, AsyncAction<AsyncResult<VerifyEventResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public VerifyEventResult parse(JsonNode data) {
            return VerifyEventResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/event/{eventName}/verify/{verifyType}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            url = url.replace("{verifyType}", this.request.getVerifyType() == null || this.request.getVerifyType().length() == 0 ? "null" : String.valueOf(this.request.getVerifyType()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", VerifyEventTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class VerifyEventByUserIdTask
    extends Gs2RestSessionTask<VerifyEventByUserIdResult> {
        private VerifyEventByUserIdRequest request;

        public VerifyEventByUserIdTask(VerifyEventByUserIdRequest request, AsyncAction<AsyncResult<VerifyEventByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public VerifyEventByUserIdResult parse(JsonNode data) {
            return VerifyEventByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/event/{eventName}/verify/{verifyType}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            url = url.replace("{verifyType}", this.request.getVerifyType() == null || this.request.getVerifyType().length() == 0 ? "null" : String.valueOf(this.request.getVerifyType()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", VerifyEventByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class VerifyEventByStampTaskTask
    extends Gs2RestSessionTask<VerifyEventByStampTaskResult> {
        private VerifyEventByStampTaskRequest request;

        public VerifyEventByStampTaskTask(VerifyEventByStampTaskRequest request, AsyncAction<AsyncResult<VerifyEventByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public VerifyEventByStampTaskResult parse(JsonNode data) {
            return VerifyEventByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/stamp/event/verify";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", VerifyEventByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", VerifyEventByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", VerifyEventByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentEventMasterTask
    extends Gs2RestSessionTask<GetCurrentEventMasterResult> {
        private GetCurrentEventMasterRequest request;

        public GetCurrentEventMasterTask(GetCurrentEventMasterRequest request, AsyncAction<AsyncResult<GetCurrentEventMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentEventMasterResult parse(JsonNode data) {
            return GetCurrentEventMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentEventMasterTask
    extends Gs2RestSessionTask<UpdateCurrentEventMasterResult> {
        private UpdateCurrentEventMasterRequest request;

        public UpdateCurrentEventMasterTask(UpdateCurrentEventMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentEventMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentEventMasterResult parse(JsonNode data) {
            return UpdateCurrentEventMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentEventMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentEventMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentEventMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentEventMasterFromGitHubResult> {
        private UpdateCurrentEventMasterFromGitHubRequest request;

        public UpdateCurrentEventMasterFromGitHubTask(UpdateCurrentEventMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentEventMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentEventMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentEventMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentEventMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentEventMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentEventMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

