/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.log;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.log.request.CountAccessLogRequest;
import io.gs2.log.request.CountExecuteStampSheetLogRequest;
import io.gs2.log.request.CountExecuteStampTaskLogRequest;
import io.gs2.log.request.CountIssueStampSheetLogRequest;
import io.gs2.log.request.CreateInsightRequest;
import io.gs2.log.request.CreateNamespaceRequest;
import io.gs2.log.request.DeleteInsightRequest;
import io.gs2.log.request.DeleteNamespaceRequest;
import io.gs2.log.request.DescribeInsightsRequest;
import io.gs2.log.request.DescribeNamespacesRequest;
import io.gs2.log.request.GetInsightRequest;
import io.gs2.log.request.GetNamespaceRequest;
import io.gs2.log.request.GetNamespaceStatusRequest;
import io.gs2.log.request.PutLogRequest;
import io.gs2.log.request.QueryAccessLogRequest;
import io.gs2.log.request.QueryAccessLogWithTelemetryRequest;
import io.gs2.log.request.QueryExecuteStampSheetLogRequest;
import io.gs2.log.request.QueryExecuteStampTaskLogRequest;
import io.gs2.log.request.QueryIssueStampSheetLogRequest;
import io.gs2.log.request.UpdateNamespaceRequest;
import io.gs2.log.result.CountAccessLogResult;
import io.gs2.log.result.CountExecuteStampSheetLogResult;
import io.gs2.log.result.CountExecuteStampTaskLogResult;
import io.gs2.log.result.CountIssueStampSheetLogResult;
import io.gs2.log.result.CreateInsightResult;
import io.gs2.log.result.CreateNamespaceResult;
import io.gs2.log.result.DeleteInsightResult;
import io.gs2.log.result.DeleteNamespaceResult;
import io.gs2.log.result.DescribeInsightsResult;
import io.gs2.log.result.DescribeNamespacesResult;
import io.gs2.log.result.GetInsightResult;
import io.gs2.log.result.GetNamespaceResult;
import io.gs2.log.result.GetNamespaceStatusResult;
import io.gs2.log.result.PutLogResult;
import io.gs2.log.result.QueryAccessLogResult;
import io.gs2.log.result.QueryAccessLogWithTelemetryResult;
import io.gs2.log.result.QueryExecuteStampSheetLogResult;
import io.gs2.log.result.QueryExecuteStampTaskLogResult;
import io.gs2.log.result.QueryIssueStampSheetLogResult;
import io.gs2.log.result.UpdateNamespaceResult;
import java.util.ArrayList;
import java.util.HashMap;

public class Gs2LogRestClient
extends AbstractGs2Client<Gs2LogRestClient> {
    public Gs2LogRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void queryAccessLogAsync(QueryAccessLogRequest request, AsyncAction<AsyncResult<QueryAccessLogResult>> callback) {
        QueryAccessLogTask task = new QueryAccessLogTask(request, callback);
        this.session.execute(task);
    }

    public QueryAccessLogResult queryAccessLog(QueryAccessLogRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.queryAccessLogAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (QueryAccessLogResult)resultAsyncResult[0].getResult();
    }

    public void countAccessLogAsync(CountAccessLogRequest request, AsyncAction<AsyncResult<CountAccessLogResult>> callback) {
        CountAccessLogTask task = new CountAccessLogTask(request, callback);
        this.session.execute(task);
    }

    public CountAccessLogResult countAccessLog(CountAccessLogRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.countAccessLogAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CountAccessLogResult)resultAsyncResult[0].getResult();
    }

    public void queryIssueStampSheetLogAsync(QueryIssueStampSheetLogRequest request, AsyncAction<AsyncResult<QueryIssueStampSheetLogResult>> callback) {
        QueryIssueStampSheetLogTask task = new QueryIssueStampSheetLogTask(request, callback);
        this.session.execute(task);
    }

    public QueryIssueStampSheetLogResult queryIssueStampSheetLog(QueryIssueStampSheetLogRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.queryIssueStampSheetLogAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (QueryIssueStampSheetLogResult)resultAsyncResult[0].getResult();
    }

    public void countIssueStampSheetLogAsync(CountIssueStampSheetLogRequest request, AsyncAction<AsyncResult<CountIssueStampSheetLogResult>> callback) {
        CountIssueStampSheetLogTask task = new CountIssueStampSheetLogTask(request, callback);
        this.session.execute(task);
    }

    public CountIssueStampSheetLogResult countIssueStampSheetLog(CountIssueStampSheetLogRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.countIssueStampSheetLogAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CountIssueStampSheetLogResult)resultAsyncResult[0].getResult();
    }

    public void queryExecuteStampSheetLogAsync(QueryExecuteStampSheetLogRequest request, AsyncAction<AsyncResult<QueryExecuteStampSheetLogResult>> callback) {
        QueryExecuteStampSheetLogTask task = new QueryExecuteStampSheetLogTask(request, callback);
        this.session.execute(task);
    }

    public QueryExecuteStampSheetLogResult queryExecuteStampSheetLog(QueryExecuteStampSheetLogRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.queryExecuteStampSheetLogAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (QueryExecuteStampSheetLogResult)resultAsyncResult[0].getResult();
    }

    public void countExecuteStampSheetLogAsync(CountExecuteStampSheetLogRequest request, AsyncAction<AsyncResult<CountExecuteStampSheetLogResult>> callback) {
        CountExecuteStampSheetLogTask task = new CountExecuteStampSheetLogTask(request, callback);
        this.session.execute(task);
    }

    public CountExecuteStampSheetLogResult countExecuteStampSheetLog(CountExecuteStampSheetLogRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.countExecuteStampSheetLogAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CountExecuteStampSheetLogResult)resultAsyncResult[0].getResult();
    }

    public void queryExecuteStampTaskLogAsync(QueryExecuteStampTaskLogRequest request, AsyncAction<AsyncResult<QueryExecuteStampTaskLogResult>> callback) {
        QueryExecuteStampTaskLogTask task = new QueryExecuteStampTaskLogTask(request, callback);
        this.session.execute(task);
    }

    public QueryExecuteStampTaskLogResult queryExecuteStampTaskLog(QueryExecuteStampTaskLogRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.queryExecuteStampTaskLogAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (QueryExecuteStampTaskLogResult)resultAsyncResult[0].getResult();
    }

    public void countExecuteStampTaskLogAsync(CountExecuteStampTaskLogRequest request, AsyncAction<AsyncResult<CountExecuteStampTaskLogResult>> callback) {
        CountExecuteStampTaskLogTask task = new CountExecuteStampTaskLogTask(request, callback);
        this.session.execute(task);
    }

    public CountExecuteStampTaskLogResult countExecuteStampTaskLog(CountExecuteStampTaskLogRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.countExecuteStampTaskLogAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CountExecuteStampTaskLogResult)resultAsyncResult[0].getResult();
    }

    public void queryAccessLogWithTelemetryAsync(QueryAccessLogWithTelemetryRequest request, AsyncAction<AsyncResult<QueryAccessLogWithTelemetryResult>> callback) {
        QueryAccessLogWithTelemetryTask task = new QueryAccessLogWithTelemetryTask(request, callback);
        this.session.execute(task);
    }

    public QueryAccessLogWithTelemetryResult queryAccessLogWithTelemetry(QueryAccessLogWithTelemetryRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.queryAccessLogWithTelemetryAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (QueryAccessLogWithTelemetryResult)resultAsyncResult[0].getResult();
    }

    public void putLogAsync(PutLogRequest request, AsyncAction<AsyncResult<PutLogResult>> callback) {
        PutLogTask task = new PutLogTask(request, callback);
        this.session.execute(task);
    }

    public PutLogResult putLog(PutLogRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.putLogAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PutLogResult)resultAsyncResult[0].getResult();
    }

    public void describeInsightsAsync(DescribeInsightsRequest request, AsyncAction<AsyncResult<DescribeInsightsResult>> callback) {
        DescribeInsightsTask task = new DescribeInsightsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeInsightsResult describeInsights(DescribeInsightsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeInsightsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeInsightsResult)resultAsyncResult[0].getResult();
    }

    public void createInsightAsync(CreateInsightRequest request, AsyncAction<AsyncResult<CreateInsightResult>> callback) {
        CreateInsightTask task = new CreateInsightTask(request, callback);
        this.session.execute(task);
    }

    public CreateInsightResult createInsight(CreateInsightRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createInsightAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateInsightResult)resultAsyncResult[0].getResult();
    }

    public void getInsightAsync(GetInsightRequest request, AsyncAction<AsyncResult<GetInsightResult>> callback) {
        GetInsightTask task = new GetInsightTask(request, callback);
        this.session.execute(task);
    }

    public GetInsightResult getInsight(GetInsightRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getInsightAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetInsightResult)resultAsyncResult[0].getResult();
    }

    public void deleteInsightAsync(DeleteInsightRequest request, AsyncAction<AsyncResult<DeleteInsightResult>> callback) {
        DeleteInsightTask task = new DeleteInsightTask(request, callback);
        this.session.execute(task);
    }

    public DeleteInsightResult deleteInsight(DeleteInsightRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteInsightAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteInsightResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("type", CreateNamespaceTask.this.request.getType());
                    this.put("gcpCredentialJson", CreateNamespaceTask.this.request.getGcpCredentialJson());
                    this.put("bigQueryDatasetName", CreateNamespaceTask.this.request.getBigQueryDatasetName());
                    this.put("logExpireDays", CreateNamespaceTask.this.request.getLogExpireDays());
                    this.put("awsRegion", CreateNamespaceTask.this.request.getAwsRegion());
                    this.put("awsAccessKeyId", CreateNamespaceTask.this.request.getAwsAccessKeyId());
                    this.put("awsSecretAccessKey", CreateNamespaceTask.this.request.getAwsSecretAccessKey());
                    this.put("firehoseStreamName", CreateNamespaceTask.this.request.getFirehoseStreamName());
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("type", UpdateNamespaceTask.this.request.getType());
                    this.put("gcpCredentialJson", UpdateNamespaceTask.this.request.getGcpCredentialJson());
                    this.put("bigQueryDatasetName", UpdateNamespaceTask.this.request.getBigQueryDatasetName());
                    this.put("logExpireDays", UpdateNamespaceTask.this.request.getLogExpireDays());
                    this.put("awsRegion", UpdateNamespaceTask.this.request.getAwsRegion());
                    this.put("awsAccessKeyId", UpdateNamespaceTask.this.request.getAwsAccessKeyId());
                    this.put("awsSecretAccessKey", UpdateNamespaceTask.this.request.getAwsSecretAccessKey());
                    this.put("firehoseStreamName", UpdateNamespaceTask.this.request.getFirehoseStreamName());
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class QueryAccessLogTask
    extends Gs2RestSessionTask<QueryAccessLogResult> {
        private QueryAccessLogRequest request;

        public QueryAccessLogTask(QueryAccessLogRequest request, AsyncAction<AsyncResult<QueryAccessLogResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public QueryAccessLogResult parse(JsonNode data) {
            return QueryAccessLogResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/{namespaceName}/log/access";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getService() != null) {
                queryStrings.add("service=" + EncodingUtil.urlEncode(String.valueOf(this.request.getService())));
            }
            if (this.request.getMethod() != null) {
                queryStrings.add("method=" + EncodingUtil.urlEncode(String.valueOf(this.request.getMethod())));
            }
            if (this.request.getUserId() != null) {
                queryStrings.add("userId=" + EncodingUtil.urlEncode(String.valueOf(this.request.getUserId())));
            }
            if (this.request.getBegin() != null) {
                queryStrings.add("begin=" + String.valueOf(this.request.getBegin()));
            }
            if (this.request.getEnd() != null) {
                queryStrings.add("end=" + String.valueOf(this.request.getEnd()));
            }
            if (this.request.getLongTerm() != null) {
                queryStrings.add("longTerm=" + String.valueOf(this.request.getLongTerm()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CountAccessLogTask
    extends Gs2RestSessionTask<CountAccessLogResult> {
        private CountAccessLogRequest request;

        public CountAccessLogTask(CountAccessLogRequest request, AsyncAction<AsyncResult<CountAccessLogResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CountAccessLogResult parse(JsonNode data) {
            return CountAccessLogResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/{namespaceName}/log/access/count";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getService() != null) {
                queryStrings.add("service=" + String.valueOf(this.request.getService()));
            }
            if (this.request.getMethod() != null) {
                queryStrings.add("method=" + String.valueOf(this.request.getMethod()));
            }
            if (this.request.getUserId() != null) {
                queryStrings.add("userId=" + String.valueOf(this.request.getUserId()));
            }
            if (this.request.getBegin() != null) {
                queryStrings.add("begin=" + String.valueOf(this.request.getBegin()));
            }
            if (this.request.getEnd() != null) {
                queryStrings.add("end=" + String.valueOf(this.request.getEnd()));
            }
            if (this.request.getLongTerm() != null) {
                queryStrings.add("longTerm=" + String.valueOf(this.request.getLongTerm()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class QueryIssueStampSheetLogTask
    extends Gs2RestSessionTask<QueryIssueStampSheetLogResult> {
        private QueryIssueStampSheetLogRequest request;

        public QueryIssueStampSheetLogTask(QueryIssueStampSheetLogRequest request, AsyncAction<AsyncResult<QueryIssueStampSheetLogResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public QueryIssueStampSheetLogResult parse(JsonNode data) {
            return QueryIssueStampSheetLogResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/{namespaceName}/log/issue/stamp/sheet";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getService() != null) {
                queryStrings.add("service=" + EncodingUtil.urlEncode(String.valueOf(this.request.getService())));
            }
            if (this.request.getMethod() != null) {
                queryStrings.add("method=" + EncodingUtil.urlEncode(String.valueOf(this.request.getMethod())));
            }
            if (this.request.getUserId() != null) {
                queryStrings.add("userId=" + EncodingUtil.urlEncode(String.valueOf(this.request.getUserId())));
            }
            if (this.request.getAction() != null) {
                queryStrings.add("action=" + EncodingUtil.urlEncode(String.valueOf(this.request.getAction())));
            }
            if (this.request.getBegin() != null) {
                queryStrings.add("begin=" + String.valueOf(this.request.getBegin()));
            }
            if (this.request.getEnd() != null) {
                queryStrings.add("end=" + String.valueOf(this.request.getEnd()));
            }
            if (this.request.getLongTerm() != null) {
                queryStrings.add("longTerm=" + String.valueOf(this.request.getLongTerm()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CountIssueStampSheetLogTask
    extends Gs2RestSessionTask<CountIssueStampSheetLogResult> {
        private CountIssueStampSheetLogRequest request;

        public CountIssueStampSheetLogTask(CountIssueStampSheetLogRequest request, AsyncAction<AsyncResult<CountIssueStampSheetLogResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CountIssueStampSheetLogResult parse(JsonNode data) {
            return CountIssueStampSheetLogResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/{namespaceName}/log/issue/stamp/sheet/count";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getService() != null) {
                queryStrings.add("service=" + String.valueOf(this.request.getService()));
            }
            if (this.request.getMethod() != null) {
                queryStrings.add("method=" + String.valueOf(this.request.getMethod()));
            }
            if (this.request.getUserId() != null) {
                queryStrings.add("userId=" + String.valueOf(this.request.getUserId()));
            }
            if (this.request.getAction() != null) {
                queryStrings.add("action=" + String.valueOf(this.request.getAction()));
            }
            if (this.request.getBegin() != null) {
                queryStrings.add("begin=" + String.valueOf(this.request.getBegin()));
            }
            if (this.request.getEnd() != null) {
                queryStrings.add("end=" + String.valueOf(this.request.getEnd()));
            }
            if (this.request.getLongTerm() != null) {
                queryStrings.add("longTerm=" + String.valueOf(this.request.getLongTerm()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class QueryExecuteStampSheetLogTask
    extends Gs2RestSessionTask<QueryExecuteStampSheetLogResult> {
        private QueryExecuteStampSheetLogRequest request;

        public QueryExecuteStampSheetLogTask(QueryExecuteStampSheetLogRequest request, AsyncAction<AsyncResult<QueryExecuteStampSheetLogResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public QueryExecuteStampSheetLogResult parse(JsonNode data) {
            return QueryExecuteStampSheetLogResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/{namespaceName}/log/execute/stamp/sheet";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getService() != null) {
                queryStrings.add("service=" + EncodingUtil.urlEncode(String.valueOf(this.request.getService())));
            }
            if (this.request.getMethod() != null) {
                queryStrings.add("method=" + EncodingUtil.urlEncode(String.valueOf(this.request.getMethod())));
            }
            if (this.request.getUserId() != null) {
                queryStrings.add("userId=" + EncodingUtil.urlEncode(String.valueOf(this.request.getUserId())));
            }
            if (this.request.getAction() != null) {
                queryStrings.add("action=" + EncodingUtil.urlEncode(String.valueOf(this.request.getAction())));
            }
            if (this.request.getBegin() != null) {
                queryStrings.add("begin=" + String.valueOf(this.request.getBegin()));
            }
            if (this.request.getEnd() != null) {
                queryStrings.add("end=" + String.valueOf(this.request.getEnd()));
            }
            if (this.request.getLongTerm() != null) {
                queryStrings.add("longTerm=" + String.valueOf(this.request.getLongTerm()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CountExecuteStampSheetLogTask
    extends Gs2RestSessionTask<CountExecuteStampSheetLogResult> {
        private CountExecuteStampSheetLogRequest request;

        public CountExecuteStampSheetLogTask(CountExecuteStampSheetLogRequest request, AsyncAction<AsyncResult<CountExecuteStampSheetLogResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CountExecuteStampSheetLogResult parse(JsonNode data) {
            return CountExecuteStampSheetLogResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/{namespaceName}/log/execute/stamp/sheet/count";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getService() != null) {
                queryStrings.add("service=" + String.valueOf(this.request.getService()));
            }
            if (this.request.getMethod() != null) {
                queryStrings.add("method=" + String.valueOf(this.request.getMethod()));
            }
            if (this.request.getUserId() != null) {
                queryStrings.add("userId=" + String.valueOf(this.request.getUserId()));
            }
            if (this.request.getAction() != null) {
                queryStrings.add("action=" + String.valueOf(this.request.getAction()));
            }
            if (this.request.getBegin() != null) {
                queryStrings.add("begin=" + String.valueOf(this.request.getBegin()));
            }
            if (this.request.getEnd() != null) {
                queryStrings.add("end=" + String.valueOf(this.request.getEnd()));
            }
            if (this.request.getLongTerm() != null) {
                queryStrings.add("longTerm=" + String.valueOf(this.request.getLongTerm()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class QueryExecuteStampTaskLogTask
    extends Gs2RestSessionTask<QueryExecuteStampTaskLogResult> {
        private QueryExecuteStampTaskLogRequest request;

        public QueryExecuteStampTaskLogTask(QueryExecuteStampTaskLogRequest request, AsyncAction<AsyncResult<QueryExecuteStampTaskLogResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public QueryExecuteStampTaskLogResult parse(JsonNode data) {
            return QueryExecuteStampTaskLogResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/{namespaceName}/log/execute/stamp/task";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getService() != null) {
                queryStrings.add("service=" + EncodingUtil.urlEncode(String.valueOf(this.request.getService())));
            }
            if (this.request.getMethod() != null) {
                queryStrings.add("method=" + EncodingUtil.urlEncode(String.valueOf(this.request.getMethod())));
            }
            if (this.request.getUserId() != null) {
                queryStrings.add("userId=" + EncodingUtil.urlEncode(String.valueOf(this.request.getUserId())));
            }
            if (this.request.getAction() != null) {
                queryStrings.add("action=" + EncodingUtil.urlEncode(String.valueOf(this.request.getAction())));
            }
            if (this.request.getBegin() != null) {
                queryStrings.add("begin=" + String.valueOf(this.request.getBegin()));
            }
            if (this.request.getEnd() != null) {
                queryStrings.add("end=" + String.valueOf(this.request.getEnd()));
            }
            if (this.request.getLongTerm() != null) {
                queryStrings.add("longTerm=" + String.valueOf(this.request.getLongTerm()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CountExecuteStampTaskLogTask
    extends Gs2RestSessionTask<CountExecuteStampTaskLogResult> {
        private CountExecuteStampTaskLogRequest request;

        public CountExecuteStampTaskLogTask(CountExecuteStampTaskLogRequest request, AsyncAction<AsyncResult<CountExecuteStampTaskLogResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CountExecuteStampTaskLogResult parse(JsonNode data) {
            return CountExecuteStampTaskLogResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/{namespaceName}/log/execute/stamp/task/count";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getService() != null) {
                queryStrings.add("service=" + String.valueOf(this.request.getService()));
            }
            if (this.request.getMethod() != null) {
                queryStrings.add("method=" + String.valueOf(this.request.getMethod()));
            }
            if (this.request.getUserId() != null) {
                queryStrings.add("userId=" + String.valueOf(this.request.getUserId()));
            }
            if (this.request.getAction() != null) {
                queryStrings.add("action=" + String.valueOf(this.request.getAction()));
            }
            if (this.request.getBegin() != null) {
                queryStrings.add("begin=" + String.valueOf(this.request.getBegin()));
            }
            if (this.request.getEnd() != null) {
                queryStrings.add("end=" + String.valueOf(this.request.getEnd()));
            }
            if (this.request.getLongTerm() != null) {
                queryStrings.add("longTerm=" + String.valueOf(this.request.getLongTerm()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class QueryAccessLogWithTelemetryTask
    extends Gs2RestSessionTask<QueryAccessLogWithTelemetryResult> {
        private QueryAccessLogWithTelemetryRequest request;

        public QueryAccessLogWithTelemetryTask(QueryAccessLogWithTelemetryRequest request, AsyncAction<AsyncResult<QueryAccessLogWithTelemetryResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public QueryAccessLogWithTelemetryResult parse(JsonNode data) {
            return QueryAccessLogWithTelemetryResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/{namespaceName}/log/access/telemetry";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getUserId() != null) {
                queryStrings.add("userId=" + EncodingUtil.urlEncode(String.valueOf(this.request.getUserId())));
            }
            if (this.request.getBegin() != null) {
                queryStrings.add("begin=" + String.valueOf(this.request.getBegin()));
            }
            if (this.request.getEnd() != null) {
                queryStrings.add("end=" + String.valueOf(this.request.getEnd()));
            }
            if (this.request.getLongTerm() != null) {
                queryStrings.add("longTerm=" + String.valueOf(this.request.getLongTerm()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PutLogTask
    extends Gs2RestSessionTask<PutLogResult> {
        private PutLogRequest request;

        public PutLogTask(PutLogRequest request, AsyncAction<AsyncResult<PutLogResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PutLogResult parse(JsonNode data) {
            return PutLogResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/log/put";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("loggingNamespaceId", PutLogTask.this.request.getLoggingNamespaceId());
                    this.put("logCategory", PutLogTask.this.request.getLogCategory());
                    this.put("payload", PutLogTask.this.request.getPayload());
                    this.put("contextStack", PutLogTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeInsightsTask
    extends Gs2RestSessionTask<DescribeInsightsResult> {
        private DescribeInsightsRequest request;

        public DescribeInsightsTask(DescribeInsightsRequest request, AsyncAction<AsyncResult<DescribeInsightsResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeInsightsResult parse(JsonNode data) {
            return DescribeInsightsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/{namespaceName}/insight";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateInsightTask
    extends Gs2RestSessionTask<CreateInsightResult> {
        private CreateInsightRequest request;

        public CreateInsightTask(CreateInsightRequest request, AsyncAction<AsyncResult<CreateInsightResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateInsightResult parse(JsonNode data) {
            return CreateInsightResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/{namespaceName}/insight";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", CreateInsightTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetInsightTask
    extends Gs2RestSessionTask<GetInsightResult> {
        private GetInsightRequest request;

        public GetInsightTask(GetInsightRequest request, AsyncAction<AsyncResult<GetInsightResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetInsightResult parse(JsonNode data) {
            return GetInsightResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/{namespaceName}/insight/{insightName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{insightName}", this.request.getInsightName() == null || this.request.getInsightName().length() == 0 ? "null" : String.valueOf(this.request.getInsightName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteInsightTask
    extends Gs2RestSessionTask<DeleteInsightResult> {
        private DeleteInsightRequest request;

        public DeleteInsightTask(DeleteInsightRequest request, AsyncAction<AsyncResult<DeleteInsightResult>> userCallback) {
            super((Gs2RestSession)Gs2LogRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteInsightResult parse(JsonNode data) {
            return DeleteInsightResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "log").replace("{region}", Gs2LogRestClient.this.session.getRegion().getName()) + "/{namespaceName}/insight/{insightName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{insightName}", this.request.getInsightName() == null || this.request.getInsightName().length() == 0 ? "null" : String.valueOf(this.request.getInsightName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

