/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.key;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.key.request.CreateGitHubApiKeyRequest;
import io.gs2.key.request.CreateKeyRequest;
import io.gs2.key.request.CreateNamespaceRequest;
import io.gs2.key.request.DecryptRequest;
import io.gs2.key.request.DeleteGitHubApiKeyRequest;
import io.gs2.key.request.DeleteKeyRequest;
import io.gs2.key.request.DeleteNamespaceRequest;
import io.gs2.key.request.DescribeGitHubApiKeysRequest;
import io.gs2.key.request.DescribeKeysRequest;
import io.gs2.key.request.DescribeNamespacesRequest;
import io.gs2.key.request.EncryptRequest;
import io.gs2.key.request.GetGitHubApiKeyRequest;
import io.gs2.key.request.GetKeyRequest;
import io.gs2.key.request.GetNamespaceRequest;
import io.gs2.key.request.GetNamespaceStatusRequest;
import io.gs2.key.request.UpdateGitHubApiKeyRequest;
import io.gs2.key.request.UpdateKeyRequest;
import io.gs2.key.request.UpdateNamespaceRequest;
import io.gs2.key.result.CreateGitHubApiKeyResult;
import io.gs2.key.result.CreateKeyResult;
import io.gs2.key.result.CreateNamespaceResult;
import io.gs2.key.result.DecryptResult;
import io.gs2.key.result.DeleteGitHubApiKeyResult;
import io.gs2.key.result.DeleteKeyResult;
import io.gs2.key.result.DeleteNamespaceResult;
import io.gs2.key.result.DescribeGitHubApiKeysResult;
import io.gs2.key.result.DescribeKeysResult;
import io.gs2.key.result.DescribeNamespacesResult;
import io.gs2.key.result.EncryptResult;
import io.gs2.key.result.GetGitHubApiKeyResult;
import io.gs2.key.result.GetKeyResult;
import io.gs2.key.result.GetNamespaceResult;
import io.gs2.key.result.GetNamespaceStatusResult;
import io.gs2.key.result.UpdateGitHubApiKeyResult;
import io.gs2.key.result.UpdateKeyResult;
import io.gs2.key.result.UpdateNamespaceResult;
import java.util.ArrayList;
import java.util.HashMap;

public class Gs2KeyRestClient
extends AbstractGs2Client<Gs2KeyRestClient> {
    public Gs2KeyRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void describeKeysAsync(DescribeKeysRequest request, AsyncAction<AsyncResult<DescribeKeysResult>> callback) {
        DescribeKeysTask task = new DescribeKeysTask(request, callback);
        this.session.execute(task);
    }

    public DescribeKeysResult describeKeys(DescribeKeysRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeKeysAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeKeysResult)resultAsyncResult[0].getResult();
    }

    public void createKeyAsync(CreateKeyRequest request, AsyncAction<AsyncResult<CreateKeyResult>> callback) {
        CreateKeyTask task = new CreateKeyTask(request, callback);
        this.session.execute(task);
    }

    public CreateKeyResult createKey(CreateKeyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createKeyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateKeyResult)resultAsyncResult[0].getResult();
    }

    public void updateKeyAsync(UpdateKeyRequest request, AsyncAction<AsyncResult<UpdateKeyResult>> callback) {
        UpdateKeyTask task = new UpdateKeyTask(request, callback);
        this.session.execute(task);
    }

    public UpdateKeyResult updateKey(UpdateKeyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateKeyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateKeyResult)resultAsyncResult[0].getResult();
    }

    public void getKeyAsync(GetKeyRequest request, AsyncAction<AsyncResult<GetKeyResult>> callback) {
        GetKeyTask task = new GetKeyTask(request, callback);
        this.session.execute(task);
    }

    public GetKeyResult getKey(GetKeyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getKeyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetKeyResult)resultAsyncResult[0].getResult();
    }

    public void deleteKeyAsync(DeleteKeyRequest request, AsyncAction<AsyncResult<DeleteKeyResult>> callback) {
        DeleteKeyTask task = new DeleteKeyTask(request, callback);
        this.session.execute(task);
    }

    public DeleteKeyResult deleteKey(DeleteKeyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteKeyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteKeyResult)resultAsyncResult[0].getResult();
    }

    public void encryptAsync(EncryptRequest request, AsyncAction<AsyncResult<EncryptResult>> callback) {
        EncryptTask task = new EncryptTask(request, callback);
        this.session.execute(task);
    }

    public EncryptResult encrypt(EncryptRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.encryptAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (EncryptResult)resultAsyncResult[0].getResult();
    }

    public void decryptAsync(DecryptRequest request, AsyncAction<AsyncResult<DecryptResult>> callback) {
        DecryptTask task = new DecryptTask(request, callback);
        this.session.execute(task);
    }

    public DecryptResult decrypt(DecryptRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.decryptAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DecryptResult)resultAsyncResult[0].getResult();
    }

    public void describeGitHubApiKeysAsync(DescribeGitHubApiKeysRequest request, AsyncAction<AsyncResult<DescribeGitHubApiKeysResult>> callback) {
        DescribeGitHubApiKeysTask task = new DescribeGitHubApiKeysTask(request, callback);
        this.session.execute(task);
    }

    public DescribeGitHubApiKeysResult describeGitHubApiKeys(DescribeGitHubApiKeysRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeGitHubApiKeysAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeGitHubApiKeysResult)resultAsyncResult[0].getResult();
    }

    public void createGitHubApiKeyAsync(CreateGitHubApiKeyRequest request, AsyncAction<AsyncResult<CreateGitHubApiKeyResult>> callback) {
        CreateGitHubApiKeyTask task = new CreateGitHubApiKeyTask(request, callback);
        this.session.execute(task);
    }

    public CreateGitHubApiKeyResult createGitHubApiKey(CreateGitHubApiKeyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createGitHubApiKeyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateGitHubApiKeyResult)resultAsyncResult[0].getResult();
    }

    public void updateGitHubApiKeyAsync(UpdateGitHubApiKeyRequest request, AsyncAction<AsyncResult<UpdateGitHubApiKeyResult>> callback) {
        UpdateGitHubApiKeyTask task = new UpdateGitHubApiKeyTask(request, callback);
        this.session.execute(task);
    }

    public UpdateGitHubApiKeyResult updateGitHubApiKey(UpdateGitHubApiKeyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateGitHubApiKeyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateGitHubApiKeyResult)resultAsyncResult[0].getResult();
    }

    public void getGitHubApiKeyAsync(GetGitHubApiKeyRequest request, AsyncAction<AsyncResult<GetGitHubApiKeyResult>> callback) {
        GetGitHubApiKeyTask task = new GetGitHubApiKeyTask(request, callback);
        this.session.execute(task);
    }

    public GetGitHubApiKeyResult getGitHubApiKey(GetGitHubApiKeyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getGitHubApiKeyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetGitHubApiKeyResult)resultAsyncResult[0].getResult();
    }

    public void deleteGitHubApiKeyAsync(DeleteGitHubApiKeyRequest request, AsyncAction<AsyncResult<DeleteGitHubApiKeyResult>> callback) {
        DeleteGitHubApiKeyTask task = new DeleteGitHubApiKeyTask(request, callback);
        this.session.execute(task);
    }

    public DeleteGitHubApiKeyResult deleteGitHubApiKey(DeleteGitHubApiKeyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteGitHubApiKeyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteGitHubApiKeyResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2KeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "key").replace("{region}", Gs2KeyRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2KeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "key").replace("{region}", Gs2KeyRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2KeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "key").replace("{region}", Gs2KeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2KeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "key").replace("{region}", Gs2KeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2KeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "key").replace("{region}", Gs2KeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2KeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "key").replace("{region}", Gs2KeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeKeysTask
    extends Gs2RestSessionTask<DescribeKeysResult> {
        private DescribeKeysRequest request;

        public DescribeKeysTask(DescribeKeysRequest request, AsyncAction<AsyncResult<DescribeKeysResult>> userCallback) {
            super((Gs2RestSession)Gs2KeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeKeysResult parse(JsonNode data) {
            return DescribeKeysResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "key").replace("{region}", Gs2KeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/key";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateKeyTask
    extends Gs2RestSessionTask<CreateKeyResult> {
        private CreateKeyRequest request;

        public CreateKeyTask(CreateKeyRequest request, AsyncAction<AsyncResult<CreateKeyResult>> userCallback) {
            super((Gs2RestSession)Gs2KeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateKeyResult parse(JsonNode data) {
            return CreateKeyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "key").replace("{region}", Gs2KeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/key";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateKeyTask.this.request.getName());
                    this.put("description", CreateKeyTask.this.request.getDescription());
                    this.put("contextStack", CreateKeyTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateKeyTask
    extends Gs2RestSessionTask<UpdateKeyResult> {
        private UpdateKeyRequest request;

        public UpdateKeyTask(UpdateKeyRequest request, AsyncAction<AsyncResult<UpdateKeyResult>> userCallback) {
            super((Gs2RestSession)Gs2KeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateKeyResult parse(JsonNode data) {
            return UpdateKeyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "key").replace("{region}", Gs2KeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/key/{keyName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{keyName}", this.request.getKeyName() == null || this.request.getKeyName().length() == 0 ? "null" : String.valueOf(this.request.getKeyName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateKeyTask.this.request.getDescription());
                    this.put("contextStack", UpdateKeyTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetKeyTask
    extends Gs2RestSessionTask<GetKeyResult> {
        private GetKeyRequest request;

        public GetKeyTask(GetKeyRequest request, AsyncAction<AsyncResult<GetKeyResult>> userCallback) {
            super((Gs2RestSession)Gs2KeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetKeyResult parse(JsonNode data) {
            return GetKeyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "key").replace("{region}", Gs2KeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/key/{keyName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{keyName}", this.request.getKeyName() == null || this.request.getKeyName().length() == 0 ? "null" : String.valueOf(this.request.getKeyName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteKeyTask
    extends Gs2RestSessionTask<DeleteKeyResult> {
        private DeleteKeyRequest request;

        public DeleteKeyTask(DeleteKeyRequest request, AsyncAction<AsyncResult<DeleteKeyResult>> userCallback) {
            super((Gs2RestSession)Gs2KeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteKeyResult parse(JsonNode data) {
            return DeleteKeyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "key").replace("{region}", Gs2KeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/key/{keyName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{keyName}", this.request.getKeyName() == null || this.request.getKeyName().length() == 0 ? "null" : String.valueOf(this.request.getKeyName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class EncryptTask
    extends Gs2RestSessionTask<EncryptResult> {
        private EncryptRequest request;

        public EncryptTask(EncryptRequest request, AsyncAction<AsyncResult<EncryptResult>> userCallback) {
            super((Gs2RestSession)Gs2KeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public EncryptResult parse(JsonNode data) {
            return EncryptResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "key").replace("{region}", Gs2KeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/key/{keyName}/encrypt";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{keyName}", this.request.getKeyName() == null || this.request.getKeyName().length() == 0 ? "null" : String.valueOf(this.request.getKeyName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("data", EncryptTask.this.request.getData());
                    this.put("contextStack", EncryptTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DecryptTask
    extends Gs2RestSessionTask<DecryptResult> {
        private DecryptRequest request;

        public DecryptTask(DecryptRequest request, AsyncAction<AsyncResult<DecryptResult>> userCallback) {
            super((Gs2RestSession)Gs2KeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DecryptResult parse(JsonNode data) {
            return DecryptResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "key").replace("{region}", Gs2KeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/key/{keyName}/decrypt";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{keyName}", this.request.getKeyName() == null || this.request.getKeyName().length() == 0 ? "null" : String.valueOf(this.request.getKeyName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("data", DecryptTask.this.request.getData());
                    this.put("contextStack", DecryptTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeGitHubApiKeysTask
    extends Gs2RestSessionTask<DescribeGitHubApiKeysResult> {
        private DescribeGitHubApiKeysRequest request;

        public DescribeGitHubApiKeysTask(DescribeGitHubApiKeysRequest request, AsyncAction<AsyncResult<DescribeGitHubApiKeysResult>> userCallback) {
            super((Gs2RestSession)Gs2KeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeGitHubApiKeysResult parse(JsonNode data) {
            return DescribeGitHubApiKeysResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "key").replace("{region}", Gs2KeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/github";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateGitHubApiKeyTask
    extends Gs2RestSessionTask<CreateGitHubApiKeyResult> {
        private CreateGitHubApiKeyRequest request;

        public CreateGitHubApiKeyTask(CreateGitHubApiKeyRequest request, AsyncAction<AsyncResult<CreateGitHubApiKeyResult>> userCallback) {
            super((Gs2RestSession)Gs2KeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateGitHubApiKeyResult parse(JsonNode data) {
            return CreateGitHubApiKeyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "key").replace("{region}", Gs2KeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/github";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateGitHubApiKeyTask.this.request.getName());
                    this.put("description", CreateGitHubApiKeyTask.this.request.getDescription());
                    this.put("apiKey", CreateGitHubApiKeyTask.this.request.getApiKey());
                    this.put("encryptionKeyName", CreateGitHubApiKeyTask.this.request.getEncryptionKeyName());
                    this.put("contextStack", CreateGitHubApiKeyTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateGitHubApiKeyTask
    extends Gs2RestSessionTask<UpdateGitHubApiKeyResult> {
        private UpdateGitHubApiKeyRequest request;

        public UpdateGitHubApiKeyTask(UpdateGitHubApiKeyRequest request, AsyncAction<AsyncResult<UpdateGitHubApiKeyResult>> userCallback) {
            super((Gs2RestSession)Gs2KeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateGitHubApiKeyResult parse(JsonNode data) {
            return UpdateGitHubApiKeyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "key").replace("{region}", Gs2KeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/github/{apiKeyName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{apiKeyName}", this.request.getApiKeyName() == null || this.request.getApiKeyName().length() == 0 ? "null" : String.valueOf(this.request.getApiKeyName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateGitHubApiKeyTask.this.request.getDescription());
                    this.put("apiKey", UpdateGitHubApiKeyTask.this.request.getApiKey());
                    this.put("encryptionKeyName", UpdateGitHubApiKeyTask.this.request.getEncryptionKeyName());
                    this.put("contextStack", UpdateGitHubApiKeyTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetGitHubApiKeyTask
    extends Gs2RestSessionTask<GetGitHubApiKeyResult> {
        private GetGitHubApiKeyRequest request;

        public GetGitHubApiKeyTask(GetGitHubApiKeyRequest request, AsyncAction<AsyncResult<GetGitHubApiKeyResult>> userCallback) {
            super((Gs2RestSession)Gs2KeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetGitHubApiKeyResult parse(JsonNode data) {
            return GetGitHubApiKeyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "key").replace("{region}", Gs2KeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/github/{apiKeyName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{apiKeyName}", this.request.getApiKeyName() == null || this.request.getApiKeyName().length() == 0 ? "null" : String.valueOf(this.request.getApiKeyName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteGitHubApiKeyTask
    extends Gs2RestSessionTask<DeleteGitHubApiKeyResult> {
        private DeleteGitHubApiKeyRequest request;

        public DeleteGitHubApiKeyTask(DeleteGitHubApiKeyRequest request, AsyncAction<AsyncResult<DeleteGitHubApiKeyResult>> userCallback) {
            super((Gs2RestSession)Gs2KeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteGitHubApiKeyResult parse(JsonNode data) {
            return DeleteGitHubApiKeyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "key").replace("{region}", Gs2KeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/github/{apiKeyName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{apiKeyName}", this.request.getApiKeyName() == null || this.request.getApiKeyName().length() == 0 ? "null" : String.valueOf(this.request.getApiKeyName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

