/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inventory.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.model.IModel;
import java.io.Serializable;
import java.util.HashMap;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ItemModel
implements IModel,
Serializable,
Comparable<ItemModel> {
    private String itemModelId;
    private String name;
    private String metadata;
    private Long stackingLimit;
    private Boolean allowMultipleStacks;
    private Integer sortValue;

    public String getItemModelId() {
        return this.itemModelId;
    }

    public void setItemModelId(String itemModelId) {
        this.itemModelId = itemModelId;
    }

    public ItemModel withItemModelId(String itemModelId) {
        this.itemModelId = itemModelId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ItemModel withName(String name) {
        this.name = name;
        return this;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public ItemModel withMetadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public Long getStackingLimit() {
        return this.stackingLimit;
    }

    public void setStackingLimit(Long stackingLimit) {
        this.stackingLimit = stackingLimit;
    }

    public ItemModel withStackingLimit(Long stackingLimit) {
        this.stackingLimit = stackingLimit;
        return this;
    }

    public Boolean getAllowMultipleStacks() {
        return this.allowMultipleStacks;
    }

    public void setAllowMultipleStacks(Boolean allowMultipleStacks) {
        this.allowMultipleStacks = allowMultipleStacks;
    }

    public ItemModel withAllowMultipleStacks(Boolean allowMultipleStacks) {
        this.allowMultipleStacks = allowMultipleStacks;
        return this;
    }

    public Integer getSortValue() {
        return this.sortValue;
    }

    public void setSortValue(Integer sortValue) {
        this.sortValue = sortValue;
    }

    public ItemModel withSortValue(Integer sortValue) {
        this.sortValue = sortValue;
        return this;
    }

    public static ItemModel fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new ItemModel().withItemModelId(data.get("itemModelId") == null || data.get("itemModelId").isNull() ? null : data.get("itemModelId").asText()).withName(data.get("name") == null || data.get("name").isNull() ? null : data.get("name").asText()).withMetadata(data.get("metadata") == null || data.get("metadata").isNull() ? null : data.get("metadata").asText()).withStackingLimit(data.get("stackingLimit") == null || data.get("stackingLimit").isNull() ? null : Long.valueOf(data.get("stackingLimit").longValue())).withAllowMultipleStacks(data.get("allowMultipleStacks") == null || data.get("allowMultipleStacks").isNull() ? null : Boolean.valueOf(data.get("allowMultipleStacks").booleanValue())).withSortValue(data.get("sortValue") == null || data.get("sortValue").isNull() ? null : Integer.valueOf(data.get("sortValue").intValue()));
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
            {
                this.put("itemModelId", ItemModel.this.getItemModelId());
                this.put("name", ItemModel.this.getName());
                this.put("metadata", ItemModel.this.getMetadata());
                this.put("stackingLimit", ItemModel.this.getStackingLimit());
                this.put("allowMultipleStacks", ItemModel.this.getAllowMultipleStacks());
                this.put("sortValue", ItemModel.this.getSortValue());
            }
        });
    }

    @Override
    public int compareTo(ItemModel o) {
        return this.itemModelId.compareTo(o.itemModelId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.itemModelId == null ? 0 : this.itemModelId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.stackingLimit == null ? 0 : this.stackingLimit.hashCode());
        result = 31 * result + (this.allowMultipleStacks == null ? 0 : this.allowMultipleStacks.hashCode());
        result = 31 * result + (this.sortValue == null ? 0 : this.sortValue.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ItemModel other = (ItemModel)o;
        if (this.itemModelId == null) {
            return other.itemModelId == null;
        }
        if (!this.itemModelId.equals(other.itemModelId)) {
            return false;
        }
        if (this.name == null) {
            return other.name == null;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.metadata == null) {
            return other.metadata == null;
        }
        if (!this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.stackingLimit == null) {
            return other.stackingLimit == null;
        }
        if (!this.stackingLimit.equals(other.stackingLimit)) {
            return false;
        }
        if (this.allowMultipleStacks == null) {
            return other.allowMultipleStacks == null;
        }
        if (!this.allowMultipleStacks.equals(other.allowMultipleStacks)) {
            return false;
        }
        if (this.sortValue == null) {
            return other.sortValue == null;
        }
        return this.sortValue.equals(other.sortValue);
    }
}

