/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.core.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.model.IResult;
import io.gs2.core.net.Gs2Response;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2SessionTask;
import io.gs2.core.net.HttpTaskBuilder;
import java.io.IOException;

public abstract class Gs2RestSessionTask<T extends IResult>
extends Gs2SessionTask {
    protected HttpTaskBuilder builder = HttpTaskBuilder.create();
    private AsyncAction<AsyncResult<T>> callback;

    public Gs2RestSessionTask(Gs2RestSession gs2RestSession, AsyncAction<AsyncResult<T>> callback) {
        super(gs2RestSession);
        this.callback = callback;
    }

    public abstract T parse(JsonNode var1);

    @Override
    protected void prepareImpl() {
        this.builder.setHeader("X-GS2-CLIENT-ID", this.getGs2Session().getGs2Credential().getClientId());
        this.builder.setHeader("Authorization", "Bearer " + this.getProjectToken());
    }

    @Override
    protected void executeImpl() {
        this.builder.build().send();
    }

    @Override
    protected void triggerUserCallback(Gs2Response gs2Response) {
        try {
            if (gs2Response.getGs2Exception() == null) {
                T result = this.parse(new ObjectMapper().readTree(gs2Response.message));
                AsyncResult<T> asyncResult = new AsyncResult<T>(result, gs2Response.getGs2Exception());
                this.callback.callback(asyncResult);
            } else {
                AsyncResult<Object> asyncResult = new AsyncResult<Object>(null, gs2Response.getGs2Exception());
                this.callback.callback(asyncResult);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

