/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.chat;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.chat.request.CheckCleanUserDataByUserIdRequest;
import io.gs2.chat.request.CheckDumpUserDataByUserIdRequest;
import io.gs2.chat.request.CheckImportUserDataByUserIdRequest;
import io.gs2.chat.request.CleanUserDataByUserIdRequest;
import io.gs2.chat.request.CreateNamespaceRequest;
import io.gs2.chat.request.CreateRoomFromBackendRequest;
import io.gs2.chat.request.CreateRoomRequest;
import io.gs2.chat.request.DeleteMessageRequest;
import io.gs2.chat.request.DeleteNamespaceRequest;
import io.gs2.chat.request.DeleteRoomFromBackendRequest;
import io.gs2.chat.request.DeleteRoomRequest;
import io.gs2.chat.request.DescribeMessagesByUserIdRequest;
import io.gs2.chat.request.DescribeMessagesRequest;
import io.gs2.chat.request.DescribeNamespacesRequest;
import io.gs2.chat.request.DescribeRoomsRequest;
import io.gs2.chat.request.DescribeSubscribesByRoomNameRequest;
import io.gs2.chat.request.DescribeSubscribesByUserIdRequest;
import io.gs2.chat.request.DescribeSubscribesRequest;
import io.gs2.chat.request.DumpUserDataByUserIdRequest;
import io.gs2.chat.request.GetMessageByUserIdRequest;
import io.gs2.chat.request.GetMessageRequest;
import io.gs2.chat.request.GetNamespaceRequest;
import io.gs2.chat.request.GetNamespaceStatusRequest;
import io.gs2.chat.request.GetRoomRequest;
import io.gs2.chat.request.GetSubscribeByUserIdRequest;
import io.gs2.chat.request.GetSubscribeRequest;
import io.gs2.chat.request.ImportUserDataByUserIdRequest;
import io.gs2.chat.request.PostByUserIdRequest;
import io.gs2.chat.request.PostRequest;
import io.gs2.chat.request.PrepareImportUserDataByUserIdRequest;
import io.gs2.chat.request.SubscribeByUserIdRequest;
import io.gs2.chat.request.SubscribeRequest;
import io.gs2.chat.request.UnsubscribeByUserIdRequest;
import io.gs2.chat.request.UnsubscribeRequest;
import io.gs2.chat.request.UpdateNamespaceRequest;
import io.gs2.chat.request.UpdateNotificationTypeByUserIdRequest;
import io.gs2.chat.request.UpdateNotificationTypeRequest;
import io.gs2.chat.request.UpdateRoomFromBackendRequest;
import io.gs2.chat.request.UpdateRoomRequest;
import io.gs2.chat.result.CheckCleanUserDataByUserIdResult;
import io.gs2.chat.result.CheckDumpUserDataByUserIdResult;
import io.gs2.chat.result.CheckImportUserDataByUserIdResult;
import io.gs2.chat.result.CleanUserDataByUserIdResult;
import io.gs2.chat.result.CreateNamespaceResult;
import io.gs2.chat.result.CreateRoomFromBackendResult;
import io.gs2.chat.result.CreateRoomResult;
import io.gs2.chat.result.DeleteMessageResult;
import io.gs2.chat.result.DeleteNamespaceResult;
import io.gs2.chat.result.DeleteRoomFromBackendResult;
import io.gs2.chat.result.DeleteRoomResult;
import io.gs2.chat.result.DescribeMessagesByUserIdResult;
import io.gs2.chat.result.DescribeMessagesResult;
import io.gs2.chat.result.DescribeNamespacesResult;
import io.gs2.chat.result.DescribeRoomsResult;
import io.gs2.chat.result.DescribeSubscribesByRoomNameResult;
import io.gs2.chat.result.DescribeSubscribesByUserIdResult;
import io.gs2.chat.result.DescribeSubscribesResult;
import io.gs2.chat.result.DumpUserDataByUserIdResult;
import io.gs2.chat.result.GetMessageByUserIdResult;
import io.gs2.chat.result.GetMessageResult;
import io.gs2.chat.result.GetNamespaceResult;
import io.gs2.chat.result.GetNamespaceStatusResult;
import io.gs2.chat.result.GetRoomResult;
import io.gs2.chat.result.GetSubscribeByUserIdResult;
import io.gs2.chat.result.GetSubscribeResult;
import io.gs2.chat.result.ImportUserDataByUserIdResult;
import io.gs2.chat.result.PostByUserIdResult;
import io.gs2.chat.result.PostResult;
import io.gs2.chat.result.PrepareImportUserDataByUserIdResult;
import io.gs2.chat.result.SubscribeByUserIdResult;
import io.gs2.chat.result.SubscribeResult;
import io.gs2.chat.result.UnsubscribeByUserIdResult;
import io.gs2.chat.result.UnsubscribeResult;
import io.gs2.chat.result.UpdateNamespaceResult;
import io.gs2.chat.result.UpdateNotificationTypeByUserIdResult;
import io.gs2.chat.result.UpdateNotificationTypeResult;
import io.gs2.chat.result.UpdateRoomFromBackendResult;
import io.gs2.chat.result.UpdateRoomResult;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Gs2ChatRestClient
extends AbstractGs2Client<Gs2ChatRestClient> {
    public Gs2ChatRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void dumpUserDataByUserIdAsync(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> callback) {
        DumpUserDataByUserIdTask task = new DumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DumpUserDataByUserIdResult dumpUserDataByUserId(DumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.dumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkDumpUserDataByUserIdAsync(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> callback) {
        CheckDumpUserDataByUserIdTask task = new CheckDumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckDumpUserDataByUserIdResult checkDumpUserDataByUserId(CheckDumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkDumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckDumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void cleanUserDataByUserIdAsync(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> callback) {
        CleanUserDataByUserIdTask task = new CleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CleanUserDataByUserIdResult cleanUserDataByUserId(CleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.cleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkCleanUserDataByUserIdAsync(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> callback) {
        CheckCleanUserDataByUserIdTask task = new CheckCleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckCleanUserDataByUserIdResult checkCleanUserDataByUserId(CheckCleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkCleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckCleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void prepareImportUserDataByUserIdAsync(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> callback) {
        PrepareImportUserDataByUserIdTask task = new PrepareImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PrepareImportUserDataByUserIdResult prepareImportUserDataByUserId(PrepareImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void importUserDataByUserIdAsync(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> callback) {
        ImportUserDataByUserIdTask task = new ImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ImportUserDataByUserIdResult importUserDataByUserId(ImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.importUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkImportUserDataByUserIdAsync(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> callback) {
        CheckImportUserDataByUserIdTask task = new CheckImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckImportUserDataByUserIdResult checkImportUserDataByUserId(CheckImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeRoomsAsync(DescribeRoomsRequest request, AsyncAction<AsyncResult<DescribeRoomsResult>> callback) {
        DescribeRoomsTask task = new DescribeRoomsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeRoomsResult describeRooms(DescribeRoomsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeRoomsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeRoomsResult)resultAsyncResult[0].getResult();
    }

    public void createRoomAsync(CreateRoomRequest request, AsyncAction<AsyncResult<CreateRoomResult>> callback) {
        CreateRoomTask task = new CreateRoomTask(request, callback);
        this.session.execute(task);
    }

    public CreateRoomResult createRoom(CreateRoomRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createRoomAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateRoomResult)resultAsyncResult[0].getResult();
    }

    public void createRoomFromBackendAsync(CreateRoomFromBackendRequest request, AsyncAction<AsyncResult<CreateRoomFromBackendResult>> callback) {
        CreateRoomFromBackendTask task = new CreateRoomFromBackendTask(request, callback);
        this.session.execute(task);
    }

    public CreateRoomFromBackendResult createRoomFromBackend(CreateRoomFromBackendRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createRoomFromBackendAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateRoomFromBackendResult)resultAsyncResult[0].getResult();
    }

    public void getRoomAsync(GetRoomRequest request, AsyncAction<AsyncResult<GetRoomResult>> callback) {
        GetRoomTask task = new GetRoomTask(request, callback);
        this.session.execute(task);
    }

    public GetRoomResult getRoom(GetRoomRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getRoomAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetRoomResult)resultAsyncResult[0].getResult();
    }

    public void updateRoomAsync(UpdateRoomRequest request, AsyncAction<AsyncResult<UpdateRoomResult>> callback) {
        UpdateRoomTask task = new UpdateRoomTask(request, callback);
        this.session.execute(task);
    }

    public UpdateRoomResult updateRoom(UpdateRoomRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateRoomAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateRoomResult)resultAsyncResult[0].getResult();
    }

    public void updateRoomFromBackendAsync(UpdateRoomFromBackendRequest request, AsyncAction<AsyncResult<UpdateRoomFromBackendResult>> callback) {
        UpdateRoomFromBackendTask task = new UpdateRoomFromBackendTask(request, callback);
        this.session.execute(task);
    }

    public UpdateRoomFromBackendResult updateRoomFromBackend(UpdateRoomFromBackendRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateRoomFromBackendAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateRoomFromBackendResult)resultAsyncResult[0].getResult();
    }

    public void deleteRoomAsync(DeleteRoomRequest request, AsyncAction<AsyncResult<DeleteRoomResult>> callback) {
        DeleteRoomTask task = new DeleteRoomTask(request, callback);
        this.session.execute(task);
    }

    public DeleteRoomResult deleteRoom(DeleteRoomRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteRoomAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteRoomResult)resultAsyncResult[0].getResult();
    }

    public void deleteRoomFromBackendAsync(DeleteRoomFromBackendRequest request, AsyncAction<AsyncResult<DeleteRoomFromBackendResult>> callback) {
        DeleteRoomFromBackendTask task = new DeleteRoomFromBackendTask(request, callback);
        this.session.execute(task);
    }

    public DeleteRoomFromBackendResult deleteRoomFromBackend(DeleteRoomFromBackendRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteRoomFromBackendAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteRoomFromBackendResult)resultAsyncResult[0].getResult();
    }

    public void describeMessagesAsync(DescribeMessagesRequest request, AsyncAction<AsyncResult<DescribeMessagesResult>> callback) {
        DescribeMessagesTask task = new DescribeMessagesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeMessagesResult describeMessages(DescribeMessagesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeMessagesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeMessagesResult)resultAsyncResult[0].getResult();
    }

    public void describeMessagesByUserIdAsync(DescribeMessagesByUserIdRequest request, AsyncAction<AsyncResult<DescribeMessagesByUserIdResult>> callback) {
        DescribeMessagesByUserIdTask task = new DescribeMessagesByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeMessagesByUserIdResult describeMessagesByUserId(DescribeMessagesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeMessagesByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeMessagesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void postAsync(PostRequest request, AsyncAction<AsyncResult<PostResult>> callback) {
        PostTask task = new PostTask(request, callback);
        this.session.execute(task);
    }

    public PostResult post(PostRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.postAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PostResult)resultAsyncResult[0].getResult();
    }

    public void postByUserIdAsync(PostByUserIdRequest request, AsyncAction<AsyncResult<PostByUserIdResult>> callback) {
        PostByUserIdTask task = new PostByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PostByUserIdResult postByUserId(PostByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.postByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PostByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getMessageAsync(GetMessageRequest request, AsyncAction<AsyncResult<GetMessageResult>> callback) {
        GetMessageTask task = new GetMessageTask(request, callback);
        this.session.execute(task);
    }

    public GetMessageResult getMessage(GetMessageRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getMessageAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetMessageResult)resultAsyncResult[0].getResult();
    }

    public void getMessageByUserIdAsync(GetMessageByUserIdRequest request, AsyncAction<AsyncResult<GetMessageByUserIdResult>> callback) {
        GetMessageByUserIdTask task = new GetMessageByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetMessageByUserIdResult getMessageByUserId(GetMessageByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getMessageByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetMessageByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteMessageAsync(DeleteMessageRequest request, AsyncAction<AsyncResult<DeleteMessageResult>> callback) {
        DeleteMessageTask task = new DeleteMessageTask(request, callback);
        this.session.execute(task);
    }

    public DeleteMessageResult deleteMessage(DeleteMessageRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteMessageAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteMessageResult)resultAsyncResult[0].getResult();
    }

    public void describeSubscribesAsync(DescribeSubscribesRequest request, AsyncAction<AsyncResult<DescribeSubscribesResult>> callback) {
        DescribeSubscribesTask task = new DescribeSubscribesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeSubscribesResult describeSubscribes(DescribeSubscribesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeSubscribesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeSubscribesResult)resultAsyncResult[0].getResult();
    }

    public void describeSubscribesByUserIdAsync(DescribeSubscribesByUserIdRequest request, AsyncAction<AsyncResult<DescribeSubscribesByUserIdResult>> callback) {
        DescribeSubscribesByUserIdTask task = new DescribeSubscribesByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeSubscribesByUserIdResult describeSubscribesByUserId(DescribeSubscribesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeSubscribesByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeSubscribesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeSubscribesByRoomNameAsync(DescribeSubscribesByRoomNameRequest request, AsyncAction<AsyncResult<DescribeSubscribesByRoomNameResult>> callback) {
        DescribeSubscribesByRoomNameTask task = new DescribeSubscribesByRoomNameTask(request, callback);
        this.session.execute(task);
    }

    public DescribeSubscribesByRoomNameResult describeSubscribesByRoomName(DescribeSubscribesByRoomNameRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeSubscribesByRoomNameAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeSubscribesByRoomNameResult)resultAsyncResult[0].getResult();
    }

    public void subscribeAsync(SubscribeRequest request, AsyncAction<AsyncResult<SubscribeResult>> callback) {
        SubscribeTask task = new SubscribeTask(request, callback);
        this.session.execute(task);
    }

    public SubscribeResult subscribe(SubscribeRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.subscribeAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SubscribeResult)resultAsyncResult[0].getResult();
    }

    public void subscribeByUserIdAsync(SubscribeByUserIdRequest request, AsyncAction<AsyncResult<SubscribeByUserIdResult>> callback) {
        SubscribeByUserIdTask task = new SubscribeByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public SubscribeByUserIdResult subscribeByUserId(SubscribeByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.subscribeByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SubscribeByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getSubscribeAsync(GetSubscribeRequest request, AsyncAction<AsyncResult<GetSubscribeResult>> callback) {
        GetSubscribeTask task = new GetSubscribeTask(request, callback);
        this.session.execute(task);
    }

    public GetSubscribeResult getSubscribe(GetSubscribeRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getSubscribeAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetSubscribeResult)resultAsyncResult[0].getResult();
    }

    public void getSubscribeByUserIdAsync(GetSubscribeByUserIdRequest request, AsyncAction<AsyncResult<GetSubscribeByUserIdResult>> callback) {
        GetSubscribeByUserIdTask task = new GetSubscribeByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetSubscribeByUserIdResult getSubscribeByUserId(GetSubscribeByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getSubscribeByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetSubscribeByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void updateNotificationTypeAsync(UpdateNotificationTypeRequest request, AsyncAction<AsyncResult<UpdateNotificationTypeResult>> callback) {
        UpdateNotificationTypeTask task = new UpdateNotificationTypeTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNotificationTypeResult updateNotificationType(UpdateNotificationTypeRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNotificationTypeAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNotificationTypeResult)resultAsyncResult[0].getResult();
    }

    public void updateNotificationTypeByUserIdAsync(UpdateNotificationTypeByUserIdRequest request, AsyncAction<AsyncResult<UpdateNotificationTypeByUserIdResult>> callback) {
        UpdateNotificationTypeByUserIdTask task = new UpdateNotificationTypeByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNotificationTypeByUserIdResult updateNotificationTypeByUserId(UpdateNotificationTypeByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNotificationTypeByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNotificationTypeByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void unsubscribeAsync(UnsubscribeRequest request, AsyncAction<AsyncResult<UnsubscribeResult>> callback) {
        UnsubscribeTask task = new UnsubscribeTask(request, callback);
        this.session.execute(task);
    }

    public UnsubscribeResult unsubscribe(UnsubscribeRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.unsubscribeAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UnsubscribeResult)resultAsyncResult[0].getResult();
    }

    public void unsubscribeByUserIdAsync(UnsubscribeByUserIdRequest request, AsyncAction<AsyncResult<UnsubscribeByUserIdResult>> callback) {
        UnsubscribeByUserIdTask task = new UnsubscribeByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public UnsubscribeByUserIdResult unsubscribeByUserId(UnsubscribeByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.unsubscribeByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UnsubscribeByUserIdResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("allowCreateRoom", CreateNamespaceTask.this.request.getAllowCreateRoom());
                    this.put("postMessageScript", CreateNamespaceTask.this.request.getPostMessageScript() != null ? CreateNamespaceTask.this.request.getPostMessageScript().toJson() : null);
                    this.put("createRoomScript", CreateNamespaceTask.this.request.getCreateRoomScript() != null ? CreateNamespaceTask.this.request.getCreateRoomScript().toJson() : null);
                    this.put("deleteRoomScript", CreateNamespaceTask.this.request.getDeleteRoomScript() != null ? CreateNamespaceTask.this.request.getDeleteRoomScript().toJson() : null);
                    this.put("subscribeRoomScript", CreateNamespaceTask.this.request.getSubscribeRoomScript() != null ? CreateNamespaceTask.this.request.getSubscribeRoomScript().toJson() : null);
                    this.put("unsubscribeRoomScript", CreateNamespaceTask.this.request.getUnsubscribeRoomScript() != null ? CreateNamespaceTask.this.request.getUnsubscribeRoomScript().toJson() : null);
                    this.put("postNotification", CreateNamespaceTask.this.request.getPostNotification() != null ? CreateNamespaceTask.this.request.getPostNotification().toJson() : null);
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("allowCreateRoom", UpdateNamespaceTask.this.request.getAllowCreateRoom());
                    this.put("postMessageScript", UpdateNamespaceTask.this.request.getPostMessageScript() != null ? UpdateNamespaceTask.this.request.getPostMessageScript().toJson() : null);
                    this.put("createRoomScript", UpdateNamespaceTask.this.request.getCreateRoomScript() != null ? UpdateNamespaceTask.this.request.getCreateRoomScript().toJson() : null);
                    this.put("deleteRoomScript", UpdateNamespaceTask.this.request.getDeleteRoomScript() != null ? UpdateNamespaceTask.this.request.getDeleteRoomScript().toJson() : null);
                    this.put("subscribeRoomScript", UpdateNamespaceTask.this.request.getSubscribeRoomScript() != null ? UpdateNamespaceTask.this.request.getSubscribeRoomScript().toJson() : null);
                    this.put("unsubscribeRoomScript", UpdateNamespaceTask.this.request.getUnsubscribeRoomScript() != null ? UpdateNamespaceTask.this.request.getUnsubscribeRoomScript().toJson() : null);
                    this.put("postNotification", UpdateNamespaceTask.this.request.getPostNotification() != null ? UpdateNamespaceTask.this.request.getPostNotification().toJson() : null);
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DumpUserDataByUserIdTask
    extends Gs2RestSessionTask<DumpUserDataByUserIdResult> {
        private DumpUserDataByUserIdRequest request;

        public DumpUserDataByUserIdTask(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DumpUserDataByUserIdResult parse(JsonNode data) {
            return DumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", DumpUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckDumpUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckDumpUserDataByUserIdResult> {
        private CheckDumpUserDataByUserIdRequest request;

        public CheckDumpUserDataByUserIdTask(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckDumpUserDataByUserIdResult parse(JsonNode data) {
            return CheckDumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CleanUserDataByUserIdResult> {
        private CleanUserDataByUserIdRequest request;

        public CleanUserDataByUserIdTask(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CleanUserDataByUserIdResult parse(JsonNode data) {
            return CleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", CleanUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckCleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckCleanUserDataByUserIdResult> {
        private CheckCleanUserDataByUserIdRequest request;

        public CheckCleanUserDataByUserIdTask(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckCleanUserDataByUserIdResult parse(JsonNode data) {
            return CheckCleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareImportUserDataByUserIdTask
    extends Gs2RestSessionTask<PrepareImportUserDataByUserIdResult> {
        private PrepareImportUserDataByUserIdRequest request;

        public PrepareImportUserDataByUserIdTask(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareImportUserDataByUserIdResult parse(JsonNode data) {
            return PrepareImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/prepare";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", PrepareImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ImportUserDataByUserIdTask
    extends Gs2RestSessionTask<ImportUserDataByUserIdResult> {
        private ImportUserDataByUserIdRequest request;

        public ImportUserDataByUserIdTask(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ImportUserDataByUserIdResult parse(JsonNode data) {
            return ImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("uploadToken", ImportUserDataByUserIdTask.this.request.getUploadToken());
                    this.put("contextStack", ImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckImportUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckImportUserDataByUserIdResult> {
        private CheckImportUserDataByUserIdRequest request;

        public CheckImportUserDataByUserIdTask(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckImportUserDataByUserIdResult parse(JsonNode data) {
            return CheckImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/{uploadToken}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{uploadToken}", this.request.getUploadToken() == null || this.request.getUploadToken().length() == 0 ? "null" : String.valueOf(this.request.getUploadToken()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeRoomsTask
    extends Gs2RestSessionTask<DescribeRoomsResult> {
        private DescribeRoomsRequest request;

        public DescribeRoomsTask(DescribeRoomsRequest request, AsyncAction<AsyncResult<DescribeRoomsResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeRoomsResult parse(JsonNode data) {
            return DescribeRoomsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/room";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateRoomTask
    extends Gs2RestSessionTask<CreateRoomResult> {
        private CreateRoomRequest request;

        public CreateRoomTask(CreateRoomRequest request, AsyncAction<AsyncResult<CreateRoomResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateRoomResult parse(JsonNode data) {
            return CreateRoomResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/room/user";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateRoomTask.this.request.getName());
                    this.put("metadata", CreateRoomTask.this.request.getMetadata());
                    this.put("password", CreateRoomTask.this.request.getPassword());
                    this.put("whiteListUserIds", CreateRoomTask.this.request.getWhiteListUserIds() == null ? new ArrayList() : CreateRoomTask.this.request.getWhiteListUserIds().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", CreateRoomTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CreateRoomFromBackendTask
    extends Gs2RestSessionTask<CreateRoomFromBackendResult> {
        private CreateRoomFromBackendRequest request;

        public CreateRoomFromBackendTask(CreateRoomFromBackendRequest request, AsyncAction<AsyncResult<CreateRoomFromBackendResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateRoomFromBackendResult parse(JsonNode data) {
            return CreateRoomFromBackendResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/room";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateRoomFromBackendTask.this.request.getName());
                    this.put("userId", CreateRoomFromBackendTask.this.request.getUserId());
                    this.put("metadata", CreateRoomFromBackendTask.this.request.getMetadata());
                    this.put("password", CreateRoomFromBackendTask.this.request.getPassword());
                    this.put("whiteListUserIds", CreateRoomFromBackendTask.this.request.getWhiteListUserIds() == null ? new ArrayList() : CreateRoomFromBackendTask.this.request.getWhiteListUserIds().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", CreateRoomFromBackendTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class GetRoomTask
    extends Gs2RestSessionTask<GetRoomResult> {
        private GetRoomRequest request;

        public GetRoomTask(GetRoomRequest request, AsyncAction<AsyncResult<GetRoomResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetRoomResult parse(JsonNode data) {
            return GetRoomResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/room/{roomName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateRoomTask
    extends Gs2RestSessionTask<UpdateRoomResult> {
        private UpdateRoomRequest request;

        public UpdateRoomTask(UpdateRoomRequest request, AsyncAction<AsyncResult<UpdateRoomResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateRoomResult parse(JsonNode data) {
            return UpdateRoomResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/room/{roomName}/user";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("metadata", UpdateRoomTask.this.request.getMetadata());
                    this.put("password", UpdateRoomTask.this.request.getPassword());
                    this.put("whiteListUserIds", UpdateRoomTask.this.request.getWhiteListUserIds() == null ? new ArrayList() : UpdateRoomTask.this.request.getWhiteListUserIds().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", UpdateRoomTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class UpdateRoomFromBackendTask
    extends Gs2RestSessionTask<UpdateRoomFromBackendResult> {
        private UpdateRoomFromBackendRequest request;

        public UpdateRoomFromBackendTask(UpdateRoomFromBackendRequest request, AsyncAction<AsyncResult<UpdateRoomFromBackendResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateRoomFromBackendResult parse(JsonNode data) {
            return UpdateRoomFromBackendResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/room/{roomName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("metadata", UpdateRoomFromBackendTask.this.request.getMetadata());
                    this.put("password", UpdateRoomFromBackendTask.this.request.getPassword());
                    this.put("whiteListUserIds", UpdateRoomFromBackendTask.this.request.getWhiteListUserIds() == null ? new ArrayList() : UpdateRoomFromBackendTask.this.request.getWhiteListUserIds().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("userId", UpdateRoomFromBackendTask.this.request.getUserId());
                    this.put("contextStack", UpdateRoomFromBackendTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteRoomTask
    extends Gs2RestSessionTask<DeleteRoomResult> {
        private DeleteRoomRequest request;

        public DeleteRoomTask(DeleteRoomRequest request, AsyncAction<AsyncResult<DeleteRoomResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteRoomResult parse(JsonNode data) {
            return DeleteRoomResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/room/{roomName}/user";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteRoomFromBackendTask
    extends Gs2RestSessionTask<DeleteRoomFromBackendResult> {
        private DeleteRoomFromBackendRequest request;

        public DeleteRoomFromBackendTask(DeleteRoomFromBackendRequest request, AsyncAction<AsyncResult<DeleteRoomFromBackendResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteRoomFromBackendResult parse(JsonNode data) {
            return DeleteRoomFromBackendResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/room/{roomName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getUserId() != null) {
                queryStrings.add("userId=" + EncodingUtil.urlEncode(String.valueOf(this.request.getUserId())));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeMessagesTask
    extends Gs2RestSessionTask<DescribeMessagesResult> {
        private DescribeMessagesRequest request;

        public DescribeMessagesTask(DescribeMessagesRequest request, AsyncAction<AsyncResult<DescribeMessagesResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeMessagesResult parse(JsonNode data) {
            return DescribeMessagesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/room/{roomName}/message";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPassword() != null) {
                queryStrings.add("password=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPassword())));
            }
            if (this.request.getStartAt() != null) {
                queryStrings.add("startAt=" + String.valueOf(this.request.getStartAt()));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeMessagesByUserIdTask
    extends Gs2RestSessionTask<DescribeMessagesByUserIdResult> {
        private DescribeMessagesByUserIdRequest request;

        public DescribeMessagesByUserIdTask(DescribeMessagesByUserIdRequest request, AsyncAction<AsyncResult<DescribeMessagesByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeMessagesByUserIdResult parse(JsonNode data) {
            return DescribeMessagesByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/room/{roomName}/message/get";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPassword() != null) {
                queryStrings.add("password=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPassword())));
            }
            if (this.request.getUserId() != null) {
                queryStrings.add("userId=" + EncodingUtil.urlEncode(String.valueOf(this.request.getUserId())));
            }
            if (this.request.getStartAt() != null) {
                queryStrings.add("startAt=" + String.valueOf(this.request.getStartAt()));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class PostTask
    extends Gs2RestSessionTask<PostResult> {
        private PostRequest request;

        public PostTask(PostRequest request, AsyncAction<AsyncResult<PostResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PostResult parse(JsonNode data) {
            return PostResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/room/{roomName}/message";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("category", PostTask.this.request.getCategory());
                    this.put("metadata", PostTask.this.request.getMetadata());
                    this.put("password", PostTask.this.request.getPassword());
                    this.put("contextStack", PostTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PostByUserIdTask
    extends Gs2RestSessionTask<PostByUserIdResult> {
        private PostByUserIdRequest request;

        public PostByUserIdTask(PostByUserIdRequest request, AsyncAction<AsyncResult<PostByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PostByUserIdResult parse(JsonNode data) {
            return PostByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/room/{roomName}/message/user/{userId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("category", PostByUserIdTask.this.request.getCategory());
                    this.put("metadata", PostByUserIdTask.this.request.getMetadata());
                    this.put("password", PostByUserIdTask.this.request.getPassword());
                    this.put("contextStack", PostByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class GetMessageTask
    extends Gs2RestSessionTask<GetMessageResult> {
        private GetMessageRequest request;

        public GetMessageTask(GetMessageRequest request, AsyncAction<AsyncResult<GetMessageResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetMessageResult parse(JsonNode data) {
            return GetMessageResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/room/{roomName}/message/{messageName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            url = url.replace("{messageName}", this.request.getMessageName() == null || this.request.getMessageName().length() == 0 ? "null" : String.valueOf(this.request.getMessageName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPassword() != null) {
                queryStrings.add("password=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPassword())));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetMessageByUserIdTask
    extends Gs2RestSessionTask<GetMessageByUserIdResult> {
        private GetMessageByUserIdRequest request;

        public GetMessageByUserIdTask(GetMessageByUserIdRequest request, AsyncAction<AsyncResult<GetMessageByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetMessageByUserIdResult parse(JsonNode data) {
            return GetMessageByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/room/{roomName}/message/{messageName}/get";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            url = url.replace("{messageName}", this.request.getMessageName() == null || this.request.getMessageName().length() == 0 ? "null" : String.valueOf(this.request.getMessageName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPassword() != null) {
                queryStrings.add("password=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPassword())));
            }
            if (this.request.getUserId() != null) {
                queryStrings.add("userId=" + EncodingUtil.urlEncode(String.valueOf(this.request.getUserId())));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteMessageTask
    extends Gs2RestSessionTask<DeleteMessageResult> {
        private DeleteMessageRequest request;

        public DeleteMessageTask(DeleteMessageRequest request, AsyncAction<AsyncResult<DeleteMessageResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteMessageResult parse(JsonNode data) {
            return DeleteMessageResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/room/{roomName}/message/{messageName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            url = url.replace("{messageName}", this.request.getMessageName() == null || this.request.getMessageName().length() == 0 ? "null" : String.valueOf(this.request.getMessageName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getUserId() != null) {
                queryStrings.add("userId=" + EncodingUtil.urlEncode(String.valueOf(this.request.getUserId())));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeSubscribesTask
    extends Gs2RestSessionTask<DescribeSubscribesResult> {
        private DescribeSubscribesRequest request;

        public DescribeSubscribesTask(DescribeSubscribesRequest request, AsyncAction<AsyncResult<DescribeSubscribesResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeSubscribesResult parse(JsonNode data) {
            return DescribeSubscribesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/room/subscribe";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeSubscribesByUserIdTask
    extends Gs2RestSessionTask<DescribeSubscribesByUserIdResult> {
        private DescribeSubscribesByUserIdRequest request;

        public DescribeSubscribesByUserIdTask(DescribeSubscribesByUserIdRequest request, AsyncAction<AsyncResult<DescribeSubscribesByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeSubscribesByUserIdResult parse(JsonNode data) {
            return DescribeSubscribesByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/room/subscribe";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeSubscribesByRoomNameTask
    extends Gs2RestSessionTask<DescribeSubscribesByRoomNameResult> {
        private DescribeSubscribesByRoomNameRequest request;

        public DescribeSubscribesByRoomNameTask(DescribeSubscribesByRoomNameRequest request, AsyncAction<AsyncResult<DescribeSubscribesByRoomNameResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeSubscribesByRoomNameResult parse(JsonNode data) {
            return DescribeSubscribesByRoomNameResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/room/{roomName}/subscribe";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class SubscribeTask
    extends Gs2RestSessionTask<SubscribeResult> {
        private SubscribeRequest request;

        public SubscribeTask(SubscribeRequest request, AsyncAction<AsyncResult<SubscribeResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SubscribeResult parse(JsonNode data) {
            return SubscribeResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/room/{roomName}/subscribe";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("notificationTypes", SubscribeTask.this.request.getNotificationTypes() == null ? new ArrayList() : SubscribeTask.this.request.getNotificationTypes().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", SubscribeTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class SubscribeByUserIdTask
    extends Gs2RestSessionTask<SubscribeByUserIdResult> {
        private SubscribeByUserIdRequest request;

        public SubscribeByUserIdTask(SubscribeByUserIdRequest request, AsyncAction<AsyncResult<SubscribeByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SubscribeByUserIdResult parse(JsonNode data) {
            return SubscribeByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/room/{roomName}/subscribe";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("notificationTypes", SubscribeByUserIdTask.this.request.getNotificationTypes() == null ? new ArrayList() : SubscribeByUserIdTask.this.request.getNotificationTypes().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", SubscribeByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class GetSubscribeTask
    extends Gs2RestSessionTask<GetSubscribeResult> {
        private GetSubscribeRequest request;

        public GetSubscribeTask(GetSubscribeRequest request, AsyncAction<AsyncResult<GetSubscribeResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetSubscribeResult parse(JsonNode data) {
            return GetSubscribeResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/room/{roomName}/subscribe";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetSubscribeByUserIdTask
    extends Gs2RestSessionTask<GetSubscribeByUserIdResult> {
        private GetSubscribeByUserIdRequest request;

        public GetSubscribeByUserIdTask(GetSubscribeByUserIdRequest request, AsyncAction<AsyncResult<GetSubscribeByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetSubscribeByUserIdResult parse(JsonNode data) {
            return GetSubscribeByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/room/{roomName}/subscribe";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNotificationTypeTask
    extends Gs2RestSessionTask<UpdateNotificationTypeResult> {
        private UpdateNotificationTypeRequest request;

        public UpdateNotificationTypeTask(UpdateNotificationTypeRequest request, AsyncAction<AsyncResult<UpdateNotificationTypeResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNotificationTypeResult parse(JsonNode data) {
            return UpdateNotificationTypeResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/room/{roomName}/subscribe/notification";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("notificationTypes", UpdateNotificationTypeTask.this.request.getNotificationTypes() == null ? new ArrayList() : UpdateNotificationTypeTask.this.request.getNotificationTypes().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", UpdateNotificationTypeTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class UpdateNotificationTypeByUserIdTask
    extends Gs2RestSessionTask<UpdateNotificationTypeByUserIdResult> {
        private UpdateNotificationTypeByUserIdRequest request;

        public UpdateNotificationTypeByUserIdTask(UpdateNotificationTypeByUserIdRequest request, AsyncAction<AsyncResult<UpdateNotificationTypeByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNotificationTypeByUserIdResult parse(JsonNode data) {
            return UpdateNotificationTypeByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/room/{roomName}/subscribe/notification";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("notificationTypes", UpdateNotificationTypeByUserIdTask.this.request.getNotificationTypes() == null ? new ArrayList() : UpdateNotificationTypeByUserIdTask.this.request.getNotificationTypes().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", UpdateNotificationTypeByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class UnsubscribeTask
    extends Gs2RestSessionTask<UnsubscribeResult> {
        private UnsubscribeRequest request;

        public UnsubscribeTask(UnsubscribeRequest request, AsyncAction<AsyncResult<UnsubscribeResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UnsubscribeResult parse(JsonNode data) {
            return UnsubscribeResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/room/{roomName}/subscribe";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class UnsubscribeByUserIdTask
    extends Gs2RestSessionTask<UnsubscribeByUserIdResult> {
        private UnsubscribeByUserIdRequest request;

        public UnsubscribeByUserIdTask(UnsubscribeByUserIdRequest request, AsyncAction<AsyncResult<UnsubscribeByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ChatRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UnsubscribeByUserIdResult parse(JsonNode data) {
            return UnsubscribeByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "chat").replace("{region}", Gs2ChatRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/room/{roomName}/subscribe";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{roomName}", this.request.getRoomName() == null || this.request.getRoomName().length() == 0 ? "null" : String.valueOf(this.request.getRoomName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }
}

