/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.script;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.script.request.CreateNamespaceRequest;
import io.gs2.script.request.CreateScriptFromGitHubRequest;
import io.gs2.script.request.CreateScriptRequest;
import io.gs2.script.request.DebugInvokeRequest;
import io.gs2.script.request.DeleteNamespaceRequest;
import io.gs2.script.request.DeleteScriptRequest;
import io.gs2.script.request.DescribeNamespacesRequest;
import io.gs2.script.request.DescribeScriptsRequest;
import io.gs2.script.request.GetNamespaceRequest;
import io.gs2.script.request.GetNamespaceStatusRequest;
import io.gs2.script.request.GetScriptRequest;
import io.gs2.script.request.InvokeScriptRequest;
import io.gs2.script.request.UpdateNamespaceRequest;
import io.gs2.script.request.UpdateScriptFromGitHubRequest;
import io.gs2.script.request.UpdateScriptRequest;
import io.gs2.script.result.CreateNamespaceResult;
import io.gs2.script.result.CreateScriptFromGitHubResult;
import io.gs2.script.result.CreateScriptResult;
import io.gs2.script.result.DebugInvokeResult;
import io.gs2.script.result.DeleteNamespaceResult;
import io.gs2.script.result.DeleteScriptResult;
import io.gs2.script.result.DescribeNamespacesResult;
import io.gs2.script.result.DescribeScriptsResult;
import io.gs2.script.result.GetNamespaceResult;
import io.gs2.script.result.GetNamespaceStatusResult;
import io.gs2.script.result.GetScriptResult;
import io.gs2.script.result.InvokeScriptResult;
import io.gs2.script.result.UpdateNamespaceResult;
import io.gs2.script.result.UpdateScriptFromGitHubResult;
import io.gs2.script.result.UpdateScriptResult;
import java.util.ArrayList;
import java.util.HashMap;

public class Gs2ScriptRestClient
extends AbstractGs2Client<Gs2ScriptRestClient> {
    public Gs2ScriptRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void describeScriptsAsync(DescribeScriptsRequest request, AsyncAction<AsyncResult<DescribeScriptsResult>> callback) {
        DescribeScriptsTask task = new DescribeScriptsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeScriptsResult describeScripts(DescribeScriptsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeScriptsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeScriptsResult)resultAsyncResult[0].getResult();
    }

    public void createScriptAsync(CreateScriptRequest request, AsyncAction<AsyncResult<CreateScriptResult>> callback) {
        CreateScriptTask task = new CreateScriptTask(request, callback);
        this.session.execute(task);
    }

    public CreateScriptResult createScript(CreateScriptRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createScriptAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateScriptResult)resultAsyncResult[0].getResult();
    }

    public void createScriptFromGitHubAsync(CreateScriptFromGitHubRequest request, AsyncAction<AsyncResult<CreateScriptFromGitHubResult>> callback) {
        CreateScriptFromGitHubTask task = new CreateScriptFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public CreateScriptFromGitHubResult createScriptFromGitHub(CreateScriptFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createScriptFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateScriptFromGitHubResult)resultAsyncResult[0].getResult();
    }

    public void getScriptAsync(GetScriptRequest request, AsyncAction<AsyncResult<GetScriptResult>> callback) {
        GetScriptTask task = new GetScriptTask(request, callback);
        this.session.execute(task);
    }

    public GetScriptResult getScript(GetScriptRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getScriptAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetScriptResult)resultAsyncResult[0].getResult();
    }

    public void updateScriptAsync(UpdateScriptRequest request, AsyncAction<AsyncResult<UpdateScriptResult>> callback) {
        UpdateScriptTask task = new UpdateScriptTask(request, callback);
        this.session.execute(task);
    }

    public UpdateScriptResult updateScript(UpdateScriptRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateScriptAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateScriptResult)resultAsyncResult[0].getResult();
    }

    public void updateScriptFromGitHubAsync(UpdateScriptFromGitHubRequest request, AsyncAction<AsyncResult<UpdateScriptFromGitHubResult>> callback) {
        UpdateScriptFromGitHubTask task = new UpdateScriptFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateScriptFromGitHubResult updateScriptFromGitHub(UpdateScriptFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateScriptFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateScriptFromGitHubResult)resultAsyncResult[0].getResult();
    }

    public void deleteScriptAsync(DeleteScriptRequest request, AsyncAction<AsyncResult<DeleteScriptResult>> callback) {
        DeleteScriptTask task = new DeleteScriptTask(request, callback);
        this.session.execute(task);
    }

    public DeleteScriptResult deleteScript(DeleteScriptRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteScriptAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteScriptResult)resultAsyncResult[0].getResult();
    }

    public void invokeScriptAsync(InvokeScriptRequest request, AsyncAction<AsyncResult<InvokeScriptResult>> callback) {
        InvokeScriptTask task = new InvokeScriptTask(request, callback);
        this.session.execute(task);
    }

    public InvokeScriptResult invokeScript(InvokeScriptRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.invokeScriptAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (InvokeScriptResult)resultAsyncResult[0].getResult();
    }

    public void debugInvokeAsync(DebugInvokeRequest request, AsyncAction<AsyncResult<DebugInvokeResult>> callback) {
        DebugInvokeTask task = new DebugInvokeTask(request, callback);
        this.session.execute(task);
    }

    public DebugInvokeResult debugInvoke(DebugInvokeRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.debugInvokeAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DebugInvokeResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2ScriptRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "script").replace("{region}", Gs2ScriptRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ScriptRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "script").replace("{region}", Gs2ScriptRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2ScriptRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "script").replace("{region}", Gs2ScriptRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ScriptRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "script").replace("{region}", Gs2ScriptRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ScriptRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "script").replace("{region}", Gs2ScriptRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ScriptRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "script").replace("{region}", Gs2ScriptRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeScriptsTask
    extends Gs2RestSessionTask<DescribeScriptsResult> {
        private DescribeScriptsRequest request;

        public DescribeScriptsTask(DescribeScriptsRequest request, AsyncAction<AsyncResult<DescribeScriptsResult>> userCallback) {
            super((Gs2RestSession)Gs2ScriptRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeScriptsResult parse(JsonNode data) {
            return DescribeScriptsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "script").replace("{region}", Gs2ScriptRestClient.this.session.getRegion().getName()) + "/{namespaceName}/script";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateScriptTask
    extends Gs2RestSessionTask<CreateScriptResult> {
        private CreateScriptRequest request;

        public CreateScriptTask(CreateScriptRequest request, AsyncAction<AsyncResult<CreateScriptResult>> userCallback) {
            super((Gs2RestSession)Gs2ScriptRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateScriptResult parse(JsonNode data) {
            return CreateScriptResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "script").replace("{region}", Gs2ScriptRestClient.this.session.getRegion().getName()) + "/{namespaceName}/script";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateScriptTask.this.request.getName());
                    this.put("description", CreateScriptTask.this.request.getDescription());
                    this.put("script", CreateScriptTask.this.request.getScript());
                    this.put("contextStack", CreateScriptTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateScriptFromGitHubTask
    extends Gs2RestSessionTask<CreateScriptFromGitHubResult> {
        private CreateScriptFromGitHubRequest request;

        public CreateScriptFromGitHubTask(CreateScriptFromGitHubRequest request, AsyncAction<AsyncResult<CreateScriptFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2ScriptRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateScriptFromGitHubResult parse(JsonNode data) {
            return CreateScriptFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "script").replace("{region}", Gs2ScriptRestClient.this.session.getRegion().getName()) + "/{namespaceName}/script/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateScriptFromGitHubTask.this.request.getName());
                    this.put("description", CreateScriptFromGitHubTask.this.request.getDescription());
                    this.put("checkoutSetting", CreateScriptFromGitHubTask.this.request.getCheckoutSetting() != null ? CreateScriptFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", CreateScriptFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetScriptTask
    extends Gs2RestSessionTask<GetScriptResult> {
        private GetScriptRequest request;

        public GetScriptTask(GetScriptRequest request, AsyncAction<AsyncResult<GetScriptResult>> userCallback) {
            super((Gs2RestSession)Gs2ScriptRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetScriptResult parse(JsonNode data) {
            return GetScriptResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "script").replace("{region}", Gs2ScriptRestClient.this.session.getRegion().getName()) + "/{namespaceName}/script/{scriptName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{scriptName}", this.request.getScriptName() == null || this.request.getScriptName().length() == 0 ? "null" : String.valueOf(this.request.getScriptName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateScriptTask
    extends Gs2RestSessionTask<UpdateScriptResult> {
        private UpdateScriptRequest request;

        public UpdateScriptTask(UpdateScriptRequest request, AsyncAction<AsyncResult<UpdateScriptResult>> userCallback) {
            super((Gs2RestSession)Gs2ScriptRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateScriptResult parse(JsonNode data) {
            return UpdateScriptResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "script").replace("{region}", Gs2ScriptRestClient.this.session.getRegion().getName()) + "/{namespaceName}/script/{scriptName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{scriptName}", this.request.getScriptName() == null || this.request.getScriptName().length() == 0 ? "null" : String.valueOf(this.request.getScriptName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateScriptTask.this.request.getDescription());
                    this.put("script", UpdateScriptTask.this.request.getScript());
                    this.put("contextStack", UpdateScriptTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateScriptFromGitHubTask
    extends Gs2RestSessionTask<UpdateScriptFromGitHubResult> {
        private UpdateScriptFromGitHubRequest request;

        public UpdateScriptFromGitHubTask(UpdateScriptFromGitHubRequest request, AsyncAction<AsyncResult<UpdateScriptFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2ScriptRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateScriptFromGitHubResult parse(JsonNode data) {
            return UpdateScriptFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "script").replace("{region}", Gs2ScriptRestClient.this.session.getRegion().getName()) + "/{namespaceName}/script/{scriptName}/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{scriptName}", this.request.getScriptName() == null || this.request.getScriptName().length() == 0 ? "null" : String.valueOf(this.request.getScriptName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateScriptFromGitHubTask.this.request.getDescription());
                    this.put("checkoutSetting", UpdateScriptFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateScriptFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateScriptFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteScriptTask
    extends Gs2RestSessionTask<DeleteScriptResult> {
        private DeleteScriptRequest request;

        public DeleteScriptTask(DeleteScriptRequest request, AsyncAction<AsyncResult<DeleteScriptResult>> userCallback) {
            super((Gs2RestSession)Gs2ScriptRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteScriptResult parse(JsonNode data) {
            return DeleteScriptResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "script").replace("{region}", Gs2ScriptRestClient.this.session.getRegion().getName()) + "/{namespaceName}/script/{scriptName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{scriptName}", this.request.getScriptName() == null || this.request.getScriptName().length() == 0 ? "null" : String.valueOf(this.request.getScriptName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class InvokeScriptTask
    extends Gs2RestSessionTask<InvokeScriptResult> {
        private InvokeScriptRequest request;

        public InvokeScriptTask(InvokeScriptRequest request, AsyncAction<AsyncResult<InvokeScriptResult>> userCallback) {
            super((Gs2RestSession)Gs2ScriptRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public InvokeScriptResult parse(JsonNode data) {
            return InvokeScriptResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "script").replace("{region}", Gs2ScriptRestClient.this.session.getRegion().getName()) + "/invoke";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("scriptId", InvokeScriptTask.this.request.getScriptId());
                    this.put("userId", InvokeScriptTask.this.request.getUserId());
                    this.put("args", InvokeScriptTask.this.request.getArgs());
                    this.put("randomStatus", InvokeScriptTask.this.request.getRandomStatus() != null ? InvokeScriptTask.this.request.getRandomStatus().toJson() : null);
                    this.put("contextStack", InvokeScriptTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DebugInvokeTask
    extends Gs2RestSessionTask<DebugInvokeResult> {
        private DebugInvokeRequest request;

        public DebugInvokeTask(DebugInvokeRequest request, AsyncAction<AsyncResult<DebugInvokeResult>> userCallback) {
            super((Gs2RestSession)Gs2ScriptRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DebugInvokeResult parse(JsonNode data) {
            return DebugInvokeResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "script").replace("{region}", Gs2ScriptRestClient.this.session.getRegion().getName()) + "/debug/invoke";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("script", DebugInvokeTask.this.request.getScript());
                    this.put("args", DebugInvokeTask.this.request.getArgs());
                    this.put("randomStatus", DebugInvokeTask.this.request.getRandomStatus() != null ? DebugInvokeTask.this.request.getRandomStatus().toJson() : null);
                    this.put("contextStack", DebugInvokeTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

