/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.project;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.project.request.CreateAccountRequest;
import io.gs2.project.request.CreateBillingMethodRequest;
import io.gs2.project.request.CreateProjectRequest;
import io.gs2.project.request.DeleteAccountRequest;
import io.gs2.project.request.DeleteBillingMethodRequest;
import io.gs2.project.request.DeleteProjectRequest;
import io.gs2.project.request.DescribeBillingMethodsRequest;
import io.gs2.project.request.DescribeBillingsRequest;
import io.gs2.project.request.DescribeProjectsRequest;
import io.gs2.project.request.DescribeReceiptsRequest;
import io.gs2.project.request.ForgetRequest;
import io.gs2.project.request.GetBillingMethodRequest;
import io.gs2.project.request.GetProjectRequest;
import io.gs2.project.request.GetProjectTokenByIdentifierRequest;
import io.gs2.project.request.GetProjectTokenRequest;
import io.gs2.project.request.IssueAccountTokenRequest;
import io.gs2.project.request.IssuePasswordRequest;
import io.gs2.project.request.SignInRequest;
import io.gs2.project.request.UpdateAccountRequest;
import io.gs2.project.request.UpdateBillingMethodRequest;
import io.gs2.project.request.UpdateProjectRequest;
import io.gs2.project.request.VerifyRequest;
import io.gs2.project.result.CreateAccountResult;
import io.gs2.project.result.CreateBillingMethodResult;
import io.gs2.project.result.CreateProjectResult;
import io.gs2.project.result.DeleteAccountResult;
import io.gs2.project.result.DeleteBillingMethodResult;
import io.gs2.project.result.DeleteProjectResult;
import io.gs2.project.result.DescribeBillingMethodsResult;
import io.gs2.project.result.DescribeBillingsResult;
import io.gs2.project.result.DescribeProjectsResult;
import io.gs2.project.result.DescribeReceiptsResult;
import io.gs2.project.result.ForgetResult;
import io.gs2.project.result.GetBillingMethodResult;
import io.gs2.project.result.GetProjectResult;
import io.gs2.project.result.GetProjectTokenByIdentifierResult;
import io.gs2.project.result.GetProjectTokenResult;
import io.gs2.project.result.IssueAccountTokenResult;
import io.gs2.project.result.IssuePasswordResult;
import io.gs2.project.result.SignInResult;
import io.gs2.project.result.UpdateAccountResult;
import io.gs2.project.result.UpdateBillingMethodResult;
import io.gs2.project.result.UpdateProjectResult;
import io.gs2.project.result.VerifyResult;
import java.util.ArrayList;
import java.util.HashMap;

public class Gs2ProjectRestClient
extends AbstractGs2Client<Gs2ProjectRestClient> {
    public Gs2ProjectRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void createAccountAsync(CreateAccountRequest request, AsyncAction<AsyncResult<CreateAccountResult>> callback) {
        CreateAccountTask task = new CreateAccountTask(request, callback);
        this.session.execute(task);
    }

    public CreateAccountResult createAccount(CreateAccountRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createAccountAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateAccountResult)resultAsyncResult[0].getResult();
    }

    public void verifyAsync(VerifyRequest request, AsyncAction<AsyncResult<VerifyResult>> callback) {
        VerifyTask task = new VerifyTask(request, callback);
        this.session.execute(task);
    }

    public VerifyResult verify(VerifyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.verifyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (VerifyResult)resultAsyncResult[0].getResult();
    }

    public void signInAsync(SignInRequest request, AsyncAction<AsyncResult<SignInResult>> callback) {
        SignInTask task = new SignInTask(request, callback);
        this.session.execute(task);
    }

    public SignInResult signIn(SignInRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.signInAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SignInResult)resultAsyncResult[0].getResult();
    }

    public void issueAccountTokenAsync(IssueAccountTokenRequest request, AsyncAction<AsyncResult<IssueAccountTokenResult>> callback) {
        IssueAccountTokenTask task = new IssueAccountTokenTask(request, callback);
        this.session.execute(task);
    }

    public IssueAccountTokenResult issueAccountToken(IssueAccountTokenRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.issueAccountTokenAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (IssueAccountTokenResult)resultAsyncResult[0].getResult();
    }

    public void forgetAsync(ForgetRequest request, AsyncAction<AsyncResult<ForgetResult>> callback) {
        ForgetTask task = new ForgetTask(request, callback);
        this.session.execute(task);
    }

    public ForgetResult forget(ForgetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.forgetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ForgetResult)resultAsyncResult[0].getResult();
    }

    public void issuePasswordAsync(IssuePasswordRequest request, AsyncAction<AsyncResult<IssuePasswordResult>> callback) {
        IssuePasswordTask task = new IssuePasswordTask(request, callback);
        this.session.execute(task);
    }

    public IssuePasswordResult issuePassword(IssuePasswordRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.issuePasswordAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (IssuePasswordResult)resultAsyncResult[0].getResult();
    }

    public void updateAccountAsync(UpdateAccountRequest request, AsyncAction<AsyncResult<UpdateAccountResult>> callback) {
        UpdateAccountTask task = new UpdateAccountTask(request, callback);
        this.session.execute(task);
    }

    public UpdateAccountResult updateAccount(UpdateAccountRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateAccountAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateAccountResult)resultAsyncResult[0].getResult();
    }

    public void deleteAccountAsync(DeleteAccountRequest request, AsyncAction<AsyncResult<DeleteAccountResult>> callback) {
        DeleteAccountTask task = new DeleteAccountTask(request, callback);
        this.session.execute(task);
    }

    public DeleteAccountResult deleteAccount(DeleteAccountRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteAccountAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteAccountResult)resultAsyncResult[0].getResult();
    }

    public void describeProjectsAsync(DescribeProjectsRequest request, AsyncAction<AsyncResult<DescribeProjectsResult>> callback) {
        DescribeProjectsTask task = new DescribeProjectsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeProjectsResult describeProjects(DescribeProjectsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeProjectsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeProjectsResult)resultAsyncResult[0].getResult();
    }

    public void createProjectAsync(CreateProjectRequest request, AsyncAction<AsyncResult<CreateProjectResult>> callback) {
        CreateProjectTask task = new CreateProjectTask(request, callback);
        this.session.execute(task);
    }

    public CreateProjectResult createProject(CreateProjectRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createProjectAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateProjectResult)resultAsyncResult[0].getResult();
    }

    public void getProjectAsync(GetProjectRequest request, AsyncAction<AsyncResult<GetProjectResult>> callback) {
        GetProjectTask task = new GetProjectTask(request, callback);
        this.session.execute(task);
    }

    public GetProjectResult getProject(GetProjectRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getProjectAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetProjectResult)resultAsyncResult[0].getResult();
    }

    public void getProjectTokenAsync(GetProjectTokenRequest request, AsyncAction<AsyncResult<GetProjectTokenResult>> callback) {
        GetProjectTokenTask task = new GetProjectTokenTask(request, callback);
        this.session.execute(task);
    }

    public GetProjectTokenResult getProjectToken(GetProjectTokenRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getProjectTokenAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetProjectTokenResult)resultAsyncResult[0].getResult();
    }

    public void getProjectTokenByIdentifierAsync(GetProjectTokenByIdentifierRequest request, AsyncAction<AsyncResult<GetProjectTokenByIdentifierResult>> callback) {
        GetProjectTokenByIdentifierTask task = new GetProjectTokenByIdentifierTask(request, callback);
        this.session.execute(task);
    }

    public GetProjectTokenByIdentifierResult getProjectTokenByIdentifier(GetProjectTokenByIdentifierRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getProjectTokenByIdentifierAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetProjectTokenByIdentifierResult)resultAsyncResult[0].getResult();
    }

    public void updateProjectAsync(UpdateProjectRequest request, AsyncAction<AsyncResult<UpdateProjectResult>> callback) {
        UpdateProjectTask task = new UpdateProjectTask(request, callback);
        this.session.execute(task);
    }

    public UpdateProjectResult updateProject(UpdateProjectRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateProjectAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateProjectResult)resultAsyncResult[0].getResult();
    }

    public void deleteProjectAsync(DeleteProjectRequest request, AsyncAction<AsyncResult<DeleteProjectResult>> callback) {
        DeleteProjectTask task = new DeleteProjectTask(request, callback);
        this.session.execute(task);
    }

    public DeleteProjectResult deleteProject(DeleteProjectRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteProjectAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteProjectResult)resultAsyncResult[0].getResult();
    }

    public void describeBillingMethodsAsync(DescribeBillingMethodsRequest request, AsyncAction<AsyncResult<DescribeBillingMethodsResult>> callback) {
        DescribeBillingMethodsTask task = new DescribeBillingMethodsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeBillingMethodsResult describeBillingMethods(DescribeBillingMethodsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeBillingMethodsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeBillingMethodsResult)resultAsyncResult[0].getResult();
    }

    public void createBillingMethodAsync(CreateBillingMethodRequest request, AsyncAction<AsyncResult<CreateBillingMethodResult>> callback) {
        CreateBillingMethodTask task = new CreateBillingMethodTask(request, callback);
        this.session.execute(task);
    }

    public CreateBillingMethodResult createBillingMethod(CreateBillingMethodRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createBillingMethodAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateBillingMethodResult)resultAsyncResult[0].getResult();
    }

    public void getBillingMethodAsync(GetBillingMethodRequest request, AsyncAction<AsyncResult<GetBillingMethodResult>> callback) {
        GetBillingMethodTask task = new GetBillingMethodTask(request, callback);
        this.session.execute(task);
    }

    public GetBillingMethodResult getBillingMethod(GetBillingMethodRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getBillingMethodAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetBillingMethodResult)resultAsyncResult[0].getResult();
    }

    public void updateBillingMethodAsync(UpdateBillingMethodRequest request, AsyncAction<AsyncResult<UpdateBillingMethodResult>> callback) {
        UpdateBillingMethodTask task = new UpdateBillingMethodTask(request, callback);
        this.session.execute(task);
    }

    public UpdateBillingMethodResult updateBillingMethod(UpdateBillingMethodRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateBillingMethodAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateBillingMethodResult)resultAsyncResult[0].getResult();
    }

    public void deleteBillingMethodAsync(DeleteBillingMethodRequest request, AsyncAction<AsyncResult<DeleteBillingMethodResult>> callback) {
        DeleteBillingMethodTask task = new DeleteBillingMethodTask(request, callback);
        this.session.execute(task);
    }

    public DeleteBillingMethodResult deleteBillingMethod(DeleteBillingMethodRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteBillingMethodAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteBillingMethodResult)resultAsyncResult[0].getResult();
    }

    public void describeReceiptsAsync(DescribeReceiptsRequest request, AsyncAction<AsyncResult<DescribeReceiptsResult>> callback) {
        DescribeReceiptsTask task = new DescribeReceiptsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeReceiptsResult describeReceipts(DescribeReceiptsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeReceiptsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeReceiptsResult)resultAsyncResult[0].getResult();
    }

    public void describeBillingsAsync(DescribeBillingsRequest request, AsyncAction<AsyncResult<DescribeBillingsResult>> callback) {
        DescribeBillingsTask task = new DescribeBillingsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeBillingsResult describeBillings(DescribeBillingsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeBillingsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeBillingsResult)resultAsyncResult[0].getResult();
    }

    class CreateAccountTask
    extends Gs2RestSessionTask<CreateAccountResult> {
        private CreateAccountRequest request;

        public CreateAccountTask(CreateAccountRequest request, AsyncAction<AsyncResult<CreateAccountResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateAccountResult parse(JsonNode data) {
            return CreateAccountResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("email", CreateAccountTask.this.request.getEmail());
                    this.put("fullName", CreateAccountTask.this.request.getFullName());
                    this.put("companyName", CreateAccountTask.this.request.getCompanyName());
                    this.put("password", CreateAccountTask.this.request.getPassword());
                    this.put("lang", CreateAccountTask.this.request.getLang());
                    this.put("contextStack", CreateAccountTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class VerifyTask
    extends Gs2RestSessionTask<VerifyResult> {
        private VerifyRequest request;

        public VerifyTask(VerifyRequest request, AsyncAction<AsyncResult<VerifyResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public VerifyResult parse(JsonNode data) {
            return VerifyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account/verify";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("verifyToken", VerifyTask.this.request.getVerifyToken());
                    this.put("contextStack", VerifyTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class SignInTask
    extends Gs2RestSessionTask<SignInResult> {
        private SignInRequest request;

        public SignInTask(SignInRequest request, AsyncAction<AsyncResult<SignInResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SignInResult parse(JsonNode data) {
            return SignInResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account/signIn";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("email", SignInTask.this.request.getEmail());
                    this.put("password", SignInTask.this.request.getPassword());
                    this.put("contextStack", SignInTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class IssueAccountTokenTask
    extends Gs2RestSessionTask<IssueAccountTokenResult> {
        private IssueAccountTokenRequest request;

        public IssueAccountTokenTask(IssueAccountTokenRequest request, AsyncAction<AsyncResult<IssueAccountTokenResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public IssueAccountTokenResult parse(JsonNode data) {
            return IssueAccountTokenResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account/accountToken";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("accountName", IssueAccountTokenTask.this.request.getAccountName());
                    this.put("contextStack", IssueAccountTokenTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ForgetTask
    extends Gs2RestSessionTask<ForgetResult> {
        private ForgetRequest request;

        public ForgetTask(ForgetRequest request, AsyncAction<AsyncResult<ForgetResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ForgetResult parse(JsonNode data) {
            return ForgetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account/forget";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("email", ForgetTask.this.request.getEmail());
                    this.put("lang", ForgetTask.this.request.getLang());
                    this.put("contextStack", ForgetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class IssuePasswordTask
    extends Gs2RestSessionTask<IssuePasswordResult> {
        private IssuePasswordRequest request;

        public IssuePasswordTask(IssuePasswordRequest request, AsyncAction<AsyncResult<IssuePasswordResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public IssuePasswordResult parse(JsonNode data) {
            return IssuePasswordResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account/password/issue";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("issuePasswordToken", IssuePasswordTask.this.request.getIssuePasswordToken());
                    this.put("contextStack", IssuePasswordTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateAccountTask
    extends Gs2RestSessionTask<UpdateAccountResult> {
        private UpdateAccountRequest request;

        public UpdateAccountTask(UpdateAccountRequest request, AsyncAction<AsyncResult<UpdateAccountResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateAccountResult parse(JsonNode data) {
            return UpdateAccountResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("email", UpdateAccountTask.this.request.getEmail());
                    this.put("fullName", UpdateAccountTask.this.request.getFullName());
                    this.put("companyName", UpdateAccountTask.this.request.getCompanyName());
                    this.put("password", UpdateAccountTask.this.request.getPassword());
                    this.put("accountToken", UpdateAccountTask.this.request.getAccountToken());
                    this.put("contextStack", UpdateAccountTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteAccountTask
    extends Gs2RestSessionTask<DeleteAccountResult> {
        private DeleteAccountRequest request;

        public DeleteAccountTask(DeleteAccountRequest request, AsyncAction<AsyncResult<DeleteAccountResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteAccountResult parse(JsonNode data) {
            return DeleteAccountResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeProjectsTask
    extends Gs2RestSessionTask<DescribeProjectsResult> {
        private DescribeProjectsRequest request;

        public DescribeProjectsTask(DescribeProjectsRequest request, AsyncAction<AsyncResult<DescribeProjectsResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeProjectsResult parse(JsonNode data) {
            return DescribeProjectsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account/me/project";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getAccountToken() != null) {
                queryStrings.add("accountToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getAccountToken())));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateProjectTask
    extends Gs2RestSessionTask<CreateProjectResult> {
        private CreateProjectRequest request;

        public CreateProjectTask(CreateProjectRequest request, AsyncAction<AsyncResult<CreateProjectResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateProjectResult parse(JsonNode data) {
            return CreateProjectResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account/me/project";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("accountToken", CreateProjectTask.this.request.getAccountToken());
                    this.put("name", CreateProjectTask.this.request.getName());
                    this.put("description", CreateProjectTask.this.request.getDescription());
                    this.put("plan", CreateProjectTask.this.request.getPlan());
                    this.put("billingMethodName", CreateProjectTask.this.request.getBillingMethodName());
                    this.put("enableEventBridge", CreateProjectTask.this.request.getEnableEventBridge());
                    this.put("eventBridgeAwsAccountId", CreateProjectTask.this.request.getEventBridgeAwsAccountId());
                    this.put("eventBridgeAwsRegion", CreateProjectTask.this.request.getEventBridgeAwsRegion());
                    this.put("contextStack", CreateProjectTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetProjectTask
    extends Gs2RestSessionTask<GetProjectResult> {
        private GetProjectRequest request;

        public GetProjectTask(GetProjectRequest request, AsyncAction<AsyncResult<GetProjectResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetProjectResult parse(JsonNode data) {
            return GetProjectResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account/me/project/{projectName}";
            url = url.replace("{projectName}", this.request.getProjectName() == null || this.request.getProjectName().length() == 0 ? "null" : String.valueOf(this.request.getProjectName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getAccountToken() != null) {
                queryStrings.add("accountToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getAccountToken())));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetProjectTokenTask
    extends Gs2RestSessionTask<GetProjectTokenResult> {
        private GetProjectTokenRequest request;

        public GetProjectTokenTask(GetProjectTokenRequest request, AsyncAction<AsyncResult<GetProjectTokenResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetProjectTokenResult parse(JsonNode data) {
            return GetProjectTokenResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/project/{projectName}/projectToken";
            url = url.replace("{projectName}", this.request.getProjectName() == null || this.request.getProjectName().length() == 0 ? "null" : String.valueOf(this.request.getProjectName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("accountToken", GetProjectTokenTask.this.request.getAccountToken());
                    this.put("contextStack", GetProjectTokenTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetProjectTokenByIdentifierTask
    extends Gs2RestSessionTask<GetProjectTokenByIdentifierResult> {
        private GetProjectTokenByIdentifierRequest request;

        public GetProjectTokenByIdentifierTask(GetProjectTokenByIdentifierRequest request, AsyncAction<AsyncResult<GetProjectTokenByIdentifierResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetProjectTokenByIdentifierResult parse(JsonNode data) {
            return GetProjectTokenByIdentifierResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account/{accountName}/project/{projectName}/user/{userName}/projectToken";
            url = url.replace("{accountName}", this.request.getAccountName() == null || this.request.getAccountName().length() == 0 ? "null" : String.valueOf(this.request.getAccountName()));
            url = url.replace("{projectName}", this.request.getProjectName() == null || this.request.getProjectName().length() == 0 ? "null" : String.valueOf(this.request.getProjectName()));
            url = url.replace("{userName}", this.request.getUserName() == null || this.request.getUserName().length() == 0 ? "null" : String.valueOf(this.request.getUserName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("password", GetProjectTokenByIdentifierTask.this.request.getPassword());
                    this.put("contextStack", GetProjectTokenByIdentifierTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateProjectTask
    extends Gs2RestSessionTask<UpdateProjectResult> {
        private UpdateProjectRequest request;

        public UpdateProjectTask(UpdateProjectRequest request, AsyncAction<AsyncResult<UpdateProjectResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateProjectResult parse(JsonNode data) {
            return UpdateProjectResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account/me/project/{projectName}";
            url = url.replace("{projectName}", this.request.getProjectName() == null || this.request.getProjectName().length() == 0 ? "null" : String.valueOf(this.request.getProjectName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("accountToken", UpdateProjectTask.this.request.getAccountToken());
                    this.put("description", UpdateProjectTask.this.request.getDescription());
                    this.put("plan", UpdateProjectTask.this.request.getPlan());
                    this.put("billingMethodName", UpdateProjectTask.this.request.getBillingMethodName());
                    this.put("enableEventBridge", UpdateProjectTask.this.request.getEnableEventBridge());
                    this.put("eventBridgeAwsAccountId", UpdateProjectTask.this.request.getEventBridgeAwsAccountId());
                    this.put("eventBridgeAwsRegion", UpdateProjectTask.this.request.getEventBridgeAwsRegion());
                    this.put("contextStack", UpdateProjectTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteProjectTask
    extends Gs2RestSessionTask<DeleteProjectResult> {
        private DeleteProjectRequest request;

        public DeleteProjectTask(DeleteProjectRequest request, AsyncAction<AsyncResult<DeleteProjectResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteProjectResult parse(JsonNode data) {
            return DeleteProjectResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account/me/project/{projectName}";
            url = url.replace("{projectName}", this.request.getProjectName() == null || this.request.getProjectName().length() == 0 ? "null" : String.valueOf(this.request.getProjectName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getAccountToken() != null) {
                queryStrings.add("accountToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getAccountToken())));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeBillingMethodsTask
    extends Gs2RestSessionTask<DescribeBillingMethodsResult> {
        private DescribeBillingMethodsRequest request;

        public DescribeBillingMethodsTask(DescribeBillingMethodsRequest request, AsyncAction<AsyncResult<DescribeBillingMethodsResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeBillingMethodsResult parse(JsonNode data) {
            return DescribeBillingMethodsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account/me/billingMethod";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getAccountToken() != null) {
                queryStrings.add("accountToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getAccountToken())));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateBillingMethodTask
    extends Gs2RestSessionTask<CreateBillingMethodResult> {
        private CreateBillingMethodRequest request;

        public CreateBillingMethodTask(CreateBillingMethodRequest request, AsyncAction<AsyncResult<CreateBillingMethodResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateBillingMethodResult parse(JsonNode data) {
            return CreateBillingMethodResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account/me/billingMethod";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("accountToken", CreateBillingMethodTask.this.request.getAccountToken());
                    this.put("description", CreateBillingMethodTask.this.request.getDescription());
                    this.put("methodType", CreateBillingMethodTask.this.request.getMethodType());
                    this.put("cardCustomerId", CreateBillingMethodTask.this.request.getCardCustomerId());
                    this.put("partnerId", CreateBillingMethodTask.this.request.getPartnerId());
                    this.put("contextStack", CreateBillingMethodTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetBillingMethodTask
    extends Gs2RestSessionTask<GetBillingMethodResult> {
        private GetBillingMethodRequest request;

        public GetBillingMethodTask(GetBillingMethodRequest request, AsyncAction<AsyncResult<GetBillingMethodResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetBillingMethodResult parse(JsonNode data) {
            return GetBillingMethodResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account/me/billingMethod/{billingMethodName}";
            url = url.replace("{billingMethodName}", this.request.getBillingMethodName() == null || this.request.getBillingMethodName().length() == 0 ? "null" : String.valueOf(this.request.getBillingMethodName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getAccountToken() != null) {
                queryStrings.add("accountToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getAccountToken())));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateBillingMethodTask
    extends Gs2RestSessionTask<UpdateBillingMethodResult> {
        private UpdateBillingMethodRequest request;

        public UpdateBillingMethodTask(UpdateBillingMethodRequest request, AsyncAction<AsyncResult<UpdateBillingMethodResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateBillingMethodResult parse(JsonNode data) {
            return UpdateBillingMethodResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account/me/billingMethod/{billingMethodName}";
            url = url.replace("{billingMethodName}", this.request.getBillingMethodName() == null || this.request.getBillingMethodName().length() == 0 ? "null" : String.valueOf(this.request.getBillingMethodName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("accountToken", UpdateBillingMethodTask.this.request.getAccountToken());
                    this.put("description", UpdateBillingMethodTask.this.request.getDescription());
                    this.put("contextStack", UpdateBillingMethodTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteBillingMethodTask
    extends Gs2RestSessionTask<DeleteBillingMethodResult> {
        private DeleteBillingMethodRequest request;

        public DeleteBillingMethodTask(DeleteBillingMethodRequest request, AsyncAction<AsyncResult<DeleteBillingMethodResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteBillingMethodResult parse(JsonNode data) {
            return DeleteBillingMethodResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account/me/billingMethod/{billingMethodName}";
            url = url.replace("{billingMethodName}", this.request.getBillingMethodName() == null || this.request.getBillingMethodName().length() == 0 ? "null" : String.valueOf(this.request.getBillingMethodName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getAccountToken() != null) {
                queryStrings.add("accountToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getAccountToken())));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeReceiptsTask
    extends Gs2RestSessionTask<DescribeReceiptsResult> {
        private DescribeReceiptsRequest request;

        public DescribeReceiptsTask(DescribeReceiptsRequest request, AsyncAction<AsyncResult<DescribeReceiptsResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeReceiptsResult parse(JsonNode data) {
            return DescribeReceiptsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account/me/receipt";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getAccountToken() != null) {
                queryStrings.add("accountToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getAccountToken())));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeBillingsTask
    extends Gs2RestSessionTask<DescribeBillingsResult> {
        private DescribeBillingsRequest request;

        public DescribeBillingsTask(DescribeBillingsRequest request, AsyncAction<AsyncResult<DescribeBillingsResult>> userCallback) {
            super((Gs2RestSession)Gs2ProjectRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeBillingsResult parse(JsonNode data) {
            return DescribeBillingsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "project").replace("{region}", Gs2ProjectRestClient.this.session.getRegion().getName()) + "/account/me/billing/{projectName}/{year}/{month}";
            url = url.replace("{projectName}", this.request.getProjectName() == null || this.request.getProjectName().length() == 0 ? "null" : String.valueOf(this.request.getProjectName()));
            url = url.replace("{year}", this.request.getYear() == null ? "null" : String.valueOf(this.request.getYear()));
            url = url.replace("{month}", this.request.getMonth() == null ? "null" : String.valueOf(this.request.getMonth()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getAccountToken() != null) {
                queryStrings.add("accountToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getAccountToken())));
            }
            if (this.request.getRegion() != null) {
                queryStrings.add("region=" + EncodingUtil.urlEncode(String.valueOf(this.request.getRegion())));
            }
            if (this.request.getService() != null) {
                queryStrings.add("service=" + EncodingUtil.urlEncode(String.valueOf(this.request.getService())));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

