/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.money;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.money.request.CheckCleanUserDataByUserIdRequest;
import io.gs2.money.request.CheckDumpUserDataByUserIdRequest;
import io.gs2.money.request.CheckImportUserDataByUserIdRequest;
import io.gs2.money.request.CleanUserDataByUserIdRequest;
import io.gs2.money.request.CreateNamespaceRequest;
import io.gs2.money.request.DeleteNamespaceRequest;
import io.gs2.money.request.DepositByStampSheetRequest;
import io.gs2.money.request.DepositByUserIdRequest;
import io.gs2.money.request.DescribeNamespacesRequest;
import io.gs2.money.request.DescribeReceiptsRequest;
import io.gs2.money.request.DescribeWalletsByUserIdRequest;
import io.gs2.money.request.DescribeWalletsRequest;
import io.gs2.money.request.DumpUserDataByUserIdRequest;
import io.gs2.money.request.GetByUserIdAndTransactionIdRequest;
import io.gs2.money.request.GetNamespaceRequest;
import io.gs2.money.request.GetNamespaceStatusRequest;
import io.gs2.money.request.GetWalletByUserIdRequest;
import io.gs2.money.request.GetWalletRequest;
import io.gs2.money.request.ImportUserDataByUserIdRequest;
import io.gs2.money.request.PrepareImportUserDataByUserIdRequest;
import io.gs2.money.request.RecordReceiptByStampTaskRequest;
import io.gs2.money.request.RecordReceiptRequest;
import io.gs2.money.request.RevertRecordReceiptByStampSheetRequest;
import io.gs2.money.request.RevertRecordReceiptRequest;
import io.gs2.money.request.UpdateNamespaceRequest;
import io.gs2.money.request.WithdrawByStampTaskRequest;
import io.gs2.money.request.WithdrawByUserIdRequest;
import io.gs2.money.request.WithdrawRequest;
import io.gs2.money.result.CheckCleanUserDataByUserIdResult;
import io.gs2.money.result.CheckDumpUserDataByUserIdResult;
import io.gs2.money.result.CheckImportUserDataByUserIdResult;
import io.gs2.money.result.CleanUserDataByUserIdResult;
import io.gs2.money.result.CreateNamespaceResult;
import io.gs2.money.result.DeleteNamespaceResult;
import io.gs2.money.result.DepositByStampSheetResult;
import io.gs2.money.result.DepositByUserIdResult;
import io.gs2.money.result.DescribeNamespacesResult;
import io.gs2.money.result.DescribeReceiptsResult;
import io.gs2.money.result.DescribeWalletsByUserIdResult;
import io.gs2.money.result.DescribeWalletsResult;
import io.gs2.money.result.DumpUserDataByUserIdResult;
import io.gs2.money.result.GetByUserIdAndTransactionIdResult;
import io.gs2.money.result.GetNamespaceResult;
import io.gs2.money.result.GetNamespaceStatusResult;
import io.gs2.money.result.GetWalletByUserIdResult;
import io.gs2.money.result.GetWalletResult;
import io.gs2.money.result.ImportUserDataByUserIdResult;
import io.gs2.money.result.PrepareImportUserDataByUserIdResult;
import io.gs2.money.result.RecordReceiptByStampTaskResult;
import io.gs2.money.result.RecordReceiptResult;
import io.gs2.money.result.RevertRecordReceiptByStampSheetResult;
import io.gs2.money.result.RevertRecordReceiptResult;
import io.gs2.money.result.UpdateNamespaceResult;
import io.gs2.money.result.WithdrawByStampTaskResult;
import io.gs2.money.result.WithdrawByUserIdResult;
import io.gs2.money.result.WithdrawResult;
import java.util.ArrayList;
import java.util.HashMap;

public class Gs2MoneyRestClient
extends AbstractGs2Client<Gs2MoneyRestClient> {
    public Gs2MoneyRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void dumpUserDataByUserIdAsync(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> callback) {
        DumpUserDataByUserIdTask task = new DumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DumpUserDataByUserIdResult dumpUserDataByUserId(DumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.dumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkDumpUserDataByUserIdAsync(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> callback) {
        CheckDumpUserDataByUserIdTask task = new CheckDumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckDumpUserDataByUserIdResult checkDumpUserDataByUserId(CheckDumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkDumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckDumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void cleanUserDataByUserIdAsync(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> callback) {
        CleanUserDataByUserIdTask task = new CleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CleanUserDataByUserIdResult cleanUserDataByUserId(CleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.cleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkCleanUserDataByUserIdAsync(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> callback) {
        CheckCleanUserDataByUserIdTask task = new CheckCleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckCleanUserDataByUserIdResult checkCleanUserDataByUserId(CheckCleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkCleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckCleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void prepareImportUserDataByUserIdAsync(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> callback) {
        PrepareImportUserDataByUserIdTask task = new PrepareImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PrepareImportUserDataByUserIdResult prepareImportUserDataByUserId(PrepareImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void importUserDataByUserIdAsync(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> callback) {
        ImportUserDataByUserIdTask task = new ImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ImportUserDataByUserIdResult importUserDataByUserId(ImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.importUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkImportUserDataByUserIdAsync(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> callback) {
        CheckImportUserDataByUserIdTask task = new CheckImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckImportUserDataByUserIdResult checkImportUserDataByUserId(CheckImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeWalletsAsync(DescribeWalletsRequest request, AsyncAction<AsyncResult<DescribeWalletsResult>> callback) {
        DescribeWalletsTask task = new DescribeWalletsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeWalletsResult describeWallets(DescribeWalletsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeWalletsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeWalletsResult)resultAsyncResult[0].getResult();
    }

    public void describeWalletsByUserIdAsync(DescribeWalletsByUserIdRequest request, AsyncAction<AsyncResult<DescribeWalletsByUserIdResult>> callback) {
        DescribeWalletsByUserIdTask task = new DescribeWalletsByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeWalletsByUserIdResult describeWalletsByUserId(DescribeWalletsByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeWalletsByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeWalletsByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getWalletAsync(GetWalletRequest request, AsyncAction<AsyncResult<GetWalletResult>> callback) {
        GetWalletTask task = new GetWalletTask(request, callback);
        this.session.execute(task);
    }

    public GetWalletResult getWallet(GetWalletRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getWalletAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetWalletResult)resultAsyncResult[0].getResult();
    }

    public void getWalletByUserIdAsync(GetWalletByUserIdRequest request, AsyncAction<AsyncResult<GetWalletByUserIdResult>> callback) {
        GetWalletByUserIdTask task = new GetWalletByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetWalletByUserIdResult getWalletByUserId(GetWalletByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getWalletByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetWalletByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void depositByUserIdAsync(DepositByUserIdRequest request, AsyncAction<AsyncResult<DepositByUserIdResult>> callback) {
        DepositByUserIdTask task = new DepositByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DepositByUserIdResult depositByUserId(DepositByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.depositByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DepositByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void withdrawAsync(WithdrawRequest request, AsyncAction<AsyncResult<WithdrawResult>> callback) {
        WithdrawTask task = new WithdrawTask(request, callback);
        this.session.execute(task);
    }

    public WithdrawResult withdraw(WithdrawRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.withdrawAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (WithdrawResult)resultAsyncResult[0].getResult();
    }

    public void withdrawByUserIdAsync(WithdrawByUserIdRequest request, AsyncAction<AsyncResult<WithdrawByUserIdResult>> callback) {
        WithdrawByUserIdTask task = new WithdrawByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public WithdrawByUserIdResult withdrawByUserId(WithdrawByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.withdrawByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (WithdrawByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void depositByStampSheetAsync(DepositByStampSheetRequest request, AsyncAction<AsyncResult<DepositByStampSheetResult>> callback) {
        DepositByStampSheetTask task = new DepositByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public DepositByStampSheetResult depositByStampSheet(DepositByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.depositByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DepositByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void withdrawByStampTaskAsync(WithdrawByStampTaskRequest request, AsyncAction<AsyncResult<WithdrawByStampTaskResult>> callback) {
        WithdrawByStampTaskTask task = new WithdrawByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public WithdrawByStampTaskResult withdrawByStampTask(WithdrawByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.withdrawByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (WithdrawByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void describeReceiptsAsync(DescribeReceiptsRequest request, AsyncAction<AsyncResult<DescribeReceiptsResult>> callback) {
        DescribeReceiptsTask task = new DescribeReceiptsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeReceiptsResult describeReceipts(DescribeReceiptsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeReceiptsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeReceiptsResult)resultAsyncResult[0].getResult();
    }

    public void getByUserIdAndTransactionIdAsync(GetByUserIdAndTransactionIdRequest request, AsyncAction<AsyncResult<GetByUserIdAndTransactionIdResult>> callback) {
        GetByUserIdAndTransactionIdTask task = new GetByUserIdAndTransactionIdTask(request, callback);
        this.session.execute(task);
    }

    public GetByUserIdAndTransactionIdResult getByUserIdAndTransactionId(GetByUserIdAndTransactionIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getByUserIdAndTransactionIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetByUserIdAndTransactionIdResult)resultAsyncResult[0].getResult();
    }

    public void recordReceiptAsync(RecordReceiptRequest request, AsyncAction<AsyncResult<RecordReceiptResult>> callback) {
        RecordReceiptTask task = new RecordReceiptTask(request, callback);
        this.session.execute(task);
    }

    public RecordReceiptResult recordReceipt(RecordReceiptRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.recordReceiptAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RecordReceiptResult)resultAsyncResult[0].getResult();
    }

    public void revertRecordReceiptAsync(RevertRecordReceiptRequest request, AsyncAction<AsyncResult<RevertRecordReceiptResult>> callback) {
        RevertRecordReceiptTask task = new RevertRecordReceiptTask(request, callback);
        this.session.execute(task);
    }

    public RevertRecordReceiptResult revertRecordReceipt(RevertRecordReceiptRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.revertRecordReceiptAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RevertRecordReceiptResult)resultAsyncResult[0].getResult();
    }

    public void recordReceiptByStampTaskAsync(RecordReceiptByStampTaskRequest request, AsyncAction<AsyncResult<RecordReceiptByStampTaskResult>> callback) {
        RecordReceiptByStampTaskTask task = new RecordReceiptByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public RecordReceiptByStampTaskResult recordReceiptByStampTask(RecordReceiptByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.recordReceiptByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RecordReceiptByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void revertRecordReceiptByStampSheetAsync(RevertRecordReceiptByStampSheetRequest request, AsyncAction<AsyncResult<RevertRecordReceiptByStampSheetResult>> callback) {
        RevertRecordReceiptByStampSheetTask task = new RevertRecordReceiptByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public RevertRecordReceiptByStampSheetResult revertRecordReceiptByStampSheet(RevertRecordReceiptByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.revertRecordReceiptByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RevertRecordReceiptByStampSheetResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("priority", CreateNamespaceTask.this.request.getPriority());
                    this.put("shareFree", CreateNamespaceTask.this.request.getShareFree());
                    this.put("currency", CreateNamespaceTask.this.request.getCurrency());
                    this.put("appleKey", CreateNamespaceTask.this.request.getAppleKey());
                    this.put("googleKey", CreateNamespaceTask.this.request.getGoogleKey());
                    this.put("enableFakeReceipt", CreateNamespaceTask.this.request.getEnableFakeReceipt());
                    this.put("createWalletScript", CreateNamespaceTask.this.request.getCreateWalletScript() != null ? CreateNamespaceTask.this.request.getCreateWalletScript().toJson() : null);
                    this.put("depositScript", CreateNamespaceTask.this.request.getDepositScript() != null ? CreateNamespaceTask.this.request.getDepositScript().toJson() : null);
                    this.put("withdrawScript", CreateNamespaceTask.this.request.getWithdrawScript() != null ? CreateNamespaceTask.this.request.getWithdrawScript().toJson() : null);
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("priority", UpdateNamespaceTask.this.request.getPriority());
                    this.put("appleKey", UpdateNamespaceTask.this.request.getAppleKey());
                    this.put("googleKey", UpdateNamespaceTask.this.request.getGoogleKey());
                    this.put("enableFakeReceipt", UpdateNamespaceTask.this.request.getEnableFakeReceipt());
                    this.put("createWalletScript", UpdateNamespaceTask.this.request.getCreateWalletScript() != null ? UpdateNamespaceTask.this.request.getCreateWalletScript().toJson() : null);
                    this.put("depositScript", UpdateNamespaceTask.this.request.getDepositScript() != null ? UpdateNamespaceTask.this.request.getDepositScript().toJson() : null);
                    this.put("withdrawScript", UpdateNamespaceTask.this.request.getWithdrawScript() != null ? UpdateNamespaceTask.this.request.getWithdrawScript().toJson() : null);
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DumpUserDataByUserIdTask
    extends Gs2RestSessionTask<DumpUserDataByUserIdResult> {
        private DumpUserDataByUserIdRequest request;

        public DumpUserDataByUserIdTask(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DumpUserDataByUserIdResult parse(JsonNode data) {
            return DumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", DumpUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckDumpUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckDumpUserDataByUserIdResult> {
        private CheckDumpUserDataByUserIdRequest request;

        public CheckDumpUserDataByUserIdTask(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckDumpUserDataByUserIdResult parse(JsonNode data) {
            return CheckDumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CleanUserDataByUserIdResult> {
        private CleanUserDataByUserIdRequest request;

        public CleanUserDataByUserIdTask(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CleanUserDataByUserIdResult parse(JsonNode data) {
            return CleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", CleanUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckCleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckCleanUserDataByUserIdResult> {
        private CheckCleanUserDataByUserIdRequest request;

        public CheckCleanUserDataByUserIdTask(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckCleanUserDataByUserIdResult parse(JsonNode data) {
            return CheckCleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareImportUserDataByUserIdTask
    extends Gs2RestSessionTask<PrepareImportUserDataByUserIdResult> {
        private PrepareImportUserDataByUserIdRequest request;

        public PrepareImportUserDataByUserIdTask(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareImportUserDataByUserIdResult parse(JsonNode data) {
            return PrepareImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/prepare";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", PrepareImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ImportUserDataByUserIdTask
    extends Gs2RestSessionTask<ImportUserDataByUserIdResult> {
        private ImportUserDataByUserIdRequest request;

        public ImportUserDataByUserIdTask(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ImportUserDataByUserIdResult parse(JsonNode data) {
            return ImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("uploadToken", ImportUserDataByUserIdTask.this.request.getUploadToken());
                    this.put("contextStack", ImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckImportUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckImportUserDataByUserIdResult> {
        private CheckImportUserDataByUserIdRequest request;

        public CheckImportUserDataByUserIdTask(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckImportUserDataByUserIdResult parse(JsonNode data) {
            return CheckImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/{uploadToken}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{uploadToken}", this.request.getUploadToken() == null || this.request.getUploadToken().length() == 0 ? "null" : String.valueOf(this.request.getUploadToken()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeWalletsTask
    extends Gs2RestSessionTask<DescribeWalletsResult> {
        private DescribeWalletsRequest request;

        public DescribeWalletsTask(DescribeWalletsRequest request, AsyncAction<AsyncResult<DescribeWalletsResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeWalletsResult parse(JsonNode data) {
            return DescribeWalletsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/wallet";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeWalletsByUserIdTask
    extends Gs2RestSessionTask<DescribeWalletsByUserIdResult> {
        private DescribeWalletsByUserIdRequest request;

        public DescribeWalletsByUserIdTask(DescribeWalletsByUserIdRequest request, AsyncAction<AsyncResult<DescribeWalletsByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeWalletsByUserIdResult parse(JsonNode data) {
            return DescribeWalletsByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/wallet";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetWalletTask
    extends Gs2RestSessionTask<GetWalletResult> {
        private GetWalletRequest request;

        public GetWalletTask(GetWalletRequest request, AsyncAction<AsyncResult<GetWalletResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetWalletResult parse(JsonNode data) {
            return GetWalletResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/wallet/{slot}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{slot}", this.request.getSlot() == null ? "null" : String.valueOf(this.request.getSlot()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetWalletByUserIdTask
    extends Gs2RestSessionTask<GetWalletByUserIdResult> {
        private GetWalletByUserIdRequest request;

        public GetWalletByUserIdTask(GetWalletByUserIdRequest request, AsyncAction<AsyncResult<GetWalletByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetWalletByUserIdResult parse(JsonNode data) {
            return GetWalletByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/wallet/{slot}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{slot}", this.request.getSlot() == null ? "null" : String.valueOf(this.request.getSlot()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DepositByUserIdTask
    extends Gs2RestSessionTask<DepositByUserIdResult> {
        private DepositByUserIdRequest request;

        public DepositByUserIdTask(DepositByUserIdRequest request, AsyncAction<AsyncResult<DepositByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DepositByUserIdResult parse(JsonNode data) {
            return DepositByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/wallet/{slot}/deposit";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{slot}", this.request.getSlot() == null ? "null" : String.valueOf(this.request.getSlot()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("price", DepositByUserIdTask.this.request.getPrice());
                    this.put("count", DepositByUserIdTask.this.request.getCount());
                    this.put("contextStack", DepositByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class WithdrawTask
    extends Gs2RestSessionTask<WithdrawResult> {
        private WithdrawRequest request;

        public WithdrawTask(WithdrawRequest request, AsyncAction<AsyncResult<WithdrawResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public WithdrawResult parse(JsonNode data) {
            return WithdrawResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/wallet/{slot}/withdraw";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{slot}", this.request.getSlot() == null ? "null" : String.valueOf(this.request.getSlot()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("count", WithdrawTask.this.request.getCount());
                    this.put("paidOnly", WithdrawTask.this.request.getPaidOnly());
                    this.put("contextStack", WithdrawTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class WithdrawByUserIdTask
    extends Gs2RestSessionTask<WithdrawByUserIdResult> {
        private WithdrawByUserIdRequest request;

        public WithdrawByUserIdTask(WithdrawByUserIdRequest request, AsyncAction<AsyncResult<WithdrawByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public WithdrawByUserIdResult parse(JsonNode data) {
            return WithdrawByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/wallet/{slot}/withdraw";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{slot}", this.request.getSlot() == null ? "null" : String.valueOf(this.request.getSlot()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("count", WithdrawByUserIdTask.this.request.getCount());
                    this.put("paidOnly", WithdrawByUserIdTask.this.request.getPaidOnly());
                    this.put("contextStack", WithdrawByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DepositByStampSheetTask
    extends Gs2RestSessionTask<DepositByStampSheetResult> {
        private DepositByStampSheetRequest request;

        public DepositByStampSheetTask(DepositByStampSheetRequest request, AsyncAction<AsyncResult<DepositByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DepositByStampSheetResult parse(JsonNode data) {
            return DepositByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/stamp/deposit";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", DepositByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", DepositByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", DepositByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class WithdrawByStampTaskTask
    extends Gs2RestSessionTask<WithdrawByStampTaskResult> {
        private WithdrawByStampTaskRequest request;

        public WithdrawByStampTaskTask(WithdrawByStampTaskRequest request, AsyncAction<AsyncResult<WithdrawByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public WithdrawByStampTaskResult parse(JsonNode data) {
            return WithdrawByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/stamp/withdraw";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", WithdrawByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", WithdrawByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", WithdrawByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeReceiptsTask
    extends Gs2RestSessionTask<DescribeReceiptsResult> {
        private DescribeReceiptsRequest request;

        public DescribeReceiptsTask(DescribeReceiptsRequest request, AsyncAction<AsyncResult<DescribeReceiptsResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeReceiptsResult parse(JsonNode data) {
            return DescribeReceiptsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/receipt";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getUserId() != null) {
                queryStrings.add("userId=" + EncodingUtil.urlEncode(String.valueOf(this.request.getUserId())));
            }
            if (this.request.getSlot() != null) {
                queryStrings.add("slot=" + String.valueOf(this.request.getSlot()));
            }
            if (this.request.getBegin() != null) {
                queryStrings.add("begin=" + String.valueOf(this.request.getBegin()));
            }
            if (this.request.getEnd() != null) {
                queryStrings.add("end=" + String.valueOf(this.request.getEnd()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetByUserIdAndTransactionIdTask
    extends Gs2RestSessionTask<GetByUserIdAndTransactionIdResult> {
        private GetByUserIdAndTransactionIdRequest request;

        public GetByUserIdAndTransactionIdTask(GetByUserIdAndTransactionIdRequest request, AsyncAction<AsyncResult<GetByUserIdAndTransactionIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetByUserIdAndTransactionIdResult parse(JsonNode data) {
            return GetByUserIdAndTransactionIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/receipt/{transactionId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{transactionId}", this.request.getTransactionId() == null || this.request.getTransactionId().length() == 0 ? "null" : String.valueOf(this.request.getTransactionId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class RecordReceiptTask
    extends Gs2RestSessionTask<RecordReceiptResult> {
        private RecordReceiptRequest request;

        public RecordReceiptTask(RecordReceiptRequest request, AsyncAction<AsyncResult<RecordReceiptResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RecordReceiptResult parse(JsonNode data) {
            return RecordReceiptResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/receipt";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contentsId", RecordReceiptTask.this.request.getContentsId());
                    this.put("receipt", RecordReceiptTask.this.request.getReceipt());
                    this.put("contextStack", RecordReceiptTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class RevertRecordReceiptTask
    extends Gs2RestSessionTask<RevertRecordReceiptResult> {
        private RevertRecordReceiptRequest request;

        public RevertRecordReceiptTask(RevertRecordReceiptRequest request, AsyncAction<AsyncResult<RevertRecordReceiptResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RevertRecordReceiptResult parse(JsonNode data) {
            return RevertRecordReceiptResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/receipt/revert";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("receipt", RevertRecordReceiptTask.this.request.getReceipt());
                    this.put("contextStack", RevertRecordReceiptTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class RecordReceiptByStampTaskTask
    extends Gs2RestSessionTask<RecordReceiptByStampTaskResult> {
        private RecordReceiptByStampTaskRequest request;

        public RecordReceiptByStampTaskTask(RecordReceiptByStampTaskRequest request, AsyncAction<AsyncResult<RecordReceiptByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RecordReceiptByStampTaskResult parse(JsonNode data) {
            return RecordReceiptByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/stamp/receipt/record";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", RecordReceiptByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", RecordReceiptByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", RecordReceiptByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class RevertRecordReceiptByStampSheetTask
    extends Gs2RestSessionTask<RevertRecordReceiptByStampSheetResult> {
        private RevertRecordReceiptByStampSheetRequest request;

        public RevertRecordReceiptByStampSheetTask(RevertRecordReceiptByStampSheetRequest request, AsyncAction<AsyncResult<RevertRecordReceiptByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2MoneyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RevertRecordReceiptByStampSheetResult parse(JsonNode data) {
            return RevertRecordReceiptByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "money").replace("{region}", Gs2MoneyRestClient.this.session.getRegion().getName()) + "/stamp/receipt/record/revert";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", RevertRecordReceiptByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", RevertRecordReceiptByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", RevertRecordReceiptByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

