/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.grade;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.grade.request.AddGradeByStampSheetRequest;
import io.gs2.grade.request.AddGradeByUserIdRequest;
import io.gs2.grade.request.ApplyRankCapByStampSheetRequest;
import io.gs2.grade.request.ApplyRankCapByUserIdRequest;
import io.gs2.grade.request.ApplyRankCapRequest;
import io.gs2.grade.request.CheckCleanUserDataByUserIdRequest;
import io.gs2.grade.request.CheckDumpUserDataByUserIdRequest;
import io.gs2.grade.request.CheckImportUserDataByUserIdRequest;
import io.gs2.grade.request.CleanUserDataByUserIdRequest;
import io.gs2.grade.request.CreateGradeModelMasterRequest;
import io.gs2.grade.request.CreateNamespaceRequest;
import io.gs2.grade.request.DeleteGradeModelMasterRequest;
import io.gs2.grade.request.DeleteNamespaceRequest;
import io.gs2.grade.request.DeleteStatusByUserIdRequest;
import io.gs2.grade.request.DescribeGradeModelMastersRequest;
import io.gs2.grade.request.DescribeGradeModelsRequest;
import io.gs2.grade.request.DescribeNamespacesRequest;
import io.gs2.grade.request.DescribeStatusesByUserIdRequest;
import io.gs2.grade.request.DescribeStatusesRequest;
import io.gs2.grade.request.DumpUserDataByUserIdRequest;
import io.gs2.grade.request.ExportMasterRequest;
import io.gs2.grade.request.GetCurrentGradeMasterRequest;
import io.gs2.grade.request.GetGradeModelMasterRequest;
import io.gs2.grade.request.GetGradeModelRequest;
import io.gs2.grade.request.GetNamespaceRequest;
import io.gs2.grade.request.GetNamespaceStatusRequest;
import io.gs2.grade.request.GetStatusByUserIdRequest;
import io.gs2.grade.request.GetStatusRequest;
import io.gs2.grade.request.ImportUserDataByUserIdRequest;
import io.gs2.grade.request.MultiplyAcquireActionsByStampSheetRequest;
import io.gs2.grade.request.MultiplyAcquireActionsByUserIdRequest;
import io.gs2.grade.request.PrepareImportUserDataByUserIdRequest;
import io.gs2.grade.request.SetGradeByUserIdRequest;
import io.gs2.grade.request.SubGradeByStampTaskRequest;
import io.gs2.grade.request.SubGradeByUserIdRequest;
import io.gs2.grade.request.UpdateCurrentGradeMasterFromGitHubRequest;
import io.gs2.grade.request.UpdateCurrentGradeMasterRequest;
import io.gs2.grade.request.UpdateGradeModelMasterRequest;
import io.gs2.grade.request.UpdateNamespaceRequest;
import io.gs2.grade.request.VerifyGradeByStampTaskRequest;
import io.gs2.grade.request.VerifyGradeByUserIdRequest;
import io.gs2.grade.request.VerifyGradeRequest;
import io.gs2.grade.request.VerifyGradeUpMaterialByStampTaskRequest;
import io.gs2.grade.request.VerifyGradeUpMaterialByUserIdRequest;
import io.gs2.grade.request.VerifyGradeUpMaterialRequest;
import io.gs2.grade.result.AddGradeByStampSheetResult;
import io.gs2.grade.result.AddGradeByUserIdResult;
import io.gs2.grade.result.ApplyRankCapByStampSheetResult;
import io.gs2.grade.result.ApplyRankCapByUserIdResult;
import io.gs2.grade.result.ApplyRankCapResult;
import io.gs2.grade.result.CheckCleanUserDataByUserIdResult;
import io.gs2.grade.result.CheckDumpUserDataByUserIdResult;
import io.gs2.grade.result.CheckImportUserDataByUserIdResult;
import io.gs2.grade.result.CleanUserDataByUserIdResult;
import io.gs2.grade.result.CreateGradeModelMasterResult;
import io.gs2.grade.result.CreateNamespaceResult;
import io.gs2.grade.result.DeleteGradeModelMasterResult;
import io.gs2.grade.result.DeleteNamespaceResult;
import io.gs2.grade.result.DeleteStatusByUserIdResult;
import io.gs2.grade.result.DescribeGradeModelMastersResult;
import io.gs2.grade.result.DescribeGradeModelsResult;
import io.gs2.grade.result.DescribeNamespacesResult;
import io.gs2.grade.result.DescribeStatusesByUserIdResult;
import io.gs2.grade.result.DescribeStatusesResult;
import io.gs2.grade.result.DumpUserDataByUserIdResult;
import io.gs2.grade.result.ExportMasterResult;
import io.gs2.grade.result.GetCurrentGradeMasterResult;
import io.gs2.grade.result.GetGradeModelMasterResult;
import io.gs2.grade.result.GetGradeModelResult;
import io.gs2.grade.result.GetNamespaceResult;
import io.gs2.grade.result.GetNamespaceStatusResult;
import io.gs2.grade.result.GetStatusByUserIdResult;
import io.gs2.grade.result.GetStatusResult;
import io.gs2.grade.result.ImportUserDataByUserIdResult;
import io.gs2.grade.result.MultiplyAcquireActionsByStampSheetResult;
import io.gs2.grade.result.MultiplyAcquireActionsByUserIdResult;
import io.gs2.grade.result.PrepareImportUserDataByUserIdResult;
import io.gs2.grade.result.SetGradeByUserIdResult;
import io.gs2.grade.result.SubGradeByStampTaskResult;
import io.gs2.grade.result.SubGradeByUserIdResult;
import io.gs2.grade.result.UpdateCurrentGradeMasterFromGitHubResult;
import io.gs2.grade.result.UpdateCurrentGradeMasterResult;
import io.gs2.grade.result.UpdateGradeModelMasterResult;
import io.gs2.grade.result.UpdateNamespaceResult;
import io.gs2.grade.result.VerifyGradeByStampTaskResult;
import io.gs2.grade.result.VerifyGradeByUserIdResult;
import io.gs2.grade.result.VerifyGradeResult;
import io.gs2.grade.result.VerifyGradeUpMaterialByStampTaskResult;
import io.gs2.grade.result.VerifyGradeUpMaterialByUserIdResult;
import io.gs2.grade.result.VerifyGradeUpMaterialResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Gs2GradeRestClient
extends AbstractGs2Client<Gs2GradeRestClient> {
    public Gs2GradeRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void dumpUserDataByUserIdAsync(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> callback) {
        DumpUserDataByUserIdTask task = new DumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DumpUserDataByUserIdResult dumpUserDataByUserId(DumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.dumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkDumpUserDataByUserIdAsync(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> callback) {
        CheckDumpUserDataByUserIdTask task = new CheckDumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckDumpUserDataByUserIdResult checkDumpUserDataByUserId(CheckDumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkDumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckDumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void cleanUserDataByUserIdAsync(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> callback) {
        CleanUserDataByUserIdTask task = new CleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CleanUserDataByUserIdResult cleanUserDataByUserId(CleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.cleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkCleanUserDataByUserIdAsync(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> callback) {
        CheckCleanUserDataByUserIdTask task = new CheckCleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckCleanUserDataByUserIdResult checkCleanUserDataByUserId(CheckCleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkCleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckCleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void prepareImportUserDataByUserIdAsync(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> callback) {
        PrepareImportUserDataByUserIdTask task = new PrepareImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PrepareImportUserDataByUserIdResult prepareImportUserDataByUserId(PrepareImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void importUserDataByUserIdAsync(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> callback) {
        ImportUserDataByUserIdTask task = new ImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ImportUserDataByUserIdResult importUserDataByUserId(ImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.importUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkImportUserDataByUserIdAsync(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> callback) {
        CheckImportUserDataByUserIdTask task = new CheckImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckImportUserDataByUserIdResult checkImportUserDataByUserId(CheckImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeGradeModelMastersAsync(DescribeGradeModelMastersRequest request, AsyncAction<AsyncResult<DescribeGradeModelMastersResult>> callback) {
        DescribeGradeModelMastersTask task = new DescribeGradeModelMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeGradeModelMastersResult describeGradeModelMasters(DescribeGradeModelMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeGradeModelMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeGradeModelMastersResult)resultAsyncResult[0].getResult();
    }

    public void createGradeModelMasterAsync(CreateGradeModelMasterRequest request, AsyncAction<AsyncResult<CreateGradeModelMasterResult>> callback) {
        CreateGradeModelMasterTask task = new CreateGradeModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateGradeModelMasterResult createGradeModelMaster(CreateGradeModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createGradeModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateGradeModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void getGradeModelMasterAsync(GetGradeModelMasterRequest request, AsyncAction<AsyncResult<GetGradeModelMasterResult>> callback) {
        GetGradeModelMasterTask task = new GetGradeModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetGradeModelMasterResult getGradeModelMaster(GetGradeModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getGradeModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetGradeModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateGradeModelMasterAsync(UpdateGradeModelMasterRequest request, AsyncAction<AsyncResult<UpdateGradeModelMasterResult>> callback) {
        UpdateGradeModelMasterTask task = new UpdateGradeModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateGradeModelMasterResult updateGradeModelMaster(UpdateGradeModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateGradeModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateGradeModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteGradeModelMasterAsync(DeleteGradeModelMasterRequest request, AsyncAction<AsyncResult<DeleteGradeModelMasterResult>> callback) {
        DeleteGradeModelMasterTask task = new DeleteGradeModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteGradeModelMasterResult deleteGradeModelMaster(DeleteGradeModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteGradeModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteGradeModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void describeGradeModelsAsync(DescribeGradeModelsRequest request, AsyncAction<AsyncResult<DescribeGradeModelsResult>> callback) {
        DescribeGradeModelsTask task = new DescribeGradeModelsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeGradeModelsResult describeGradeModels(DescribeGradeModelsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeGradeModelsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeGradeModelsResult)resultAsyncResult[0].getResult();
    }

    public void getGradeModelAsync(GetGradeModelRequest request, AsyncAction<AsyncResult<GetGradeModelResult>> callback) {
        GetGradeModelTask task = new GetGradeModelTask(request, callback);
        this.session.execute(task);
    }

    public GetGradeModelResult getGradeModel(GetGradeModelRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getGradeModelAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetGradeModelResult)resultAsyncResult[0].getResult();
    }

    public void describeStatusesAsync(DescribeStatusesRequest request, AsyncAction<AsyncResult<DescribeStatusesResult>> callback) {
        DescribeStatusesTask task = new DescribeStatusesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeStatusesResult describeStatuses(DescribeStatusesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeStatusesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeStatusesResult)resultAsyncResult[0].getResult();
    }

    public void describeStatusesByUserIdAsync(DescribeStatusesByUserIdRequest request, AsyncAction<AsyncResult<DescribeStatusesByUserIdResult>> callback) {
        DescribeStatusesByUserIdTask task = new DescribeStatusesByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeStatusesByUserIdResult describeStatusesByUserId(DescribeStatusesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeStatusesByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeStatusesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getStatusAsync(GetStatusRequest request, AsyncAction<AsyncResult<GetStatusResult>> callback) {
        GetStatusTask task = new GetStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetStatusResult getStatus(GetStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetStatusResult)resultAsyncResult[0].getResult();
    }

    public void getStatusByUserIdAsync(GetStatusByUserIdRequest request, AsyncAction<AsyncResult<GetStatusByUserIdResult>> callback) {
        GetStatusByUserIdTask task = new GetStatusByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetStatusByUserIdResult getStatusByUserId(GetStatusByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getStatusByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetStatusByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void addGradeByUserIdAsync(AddGradeByUserIdRequest request, AsyncAction<AsyncResult<AddGradeByUserIdResult>> callback) {
        AddGradeByUserIdTask task = new AddGradeByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public AddGradeByUserIdResult addGradeByUserId(AddGradeByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.addGradeByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (AddGradeByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void subGradeByUserIdAsync(SubGradeByUserIdRequest request, AsyncAction<AsyncResult<SubGradeByUserIdResult>> callback) {
        SubGradeByUserIdTask task = new SubGradeByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public SubGradeByUserIdResult subGradeByUserId(SubGradeByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.subGradeByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SubGradeByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void setGradeByUserIdAsync(SetGradeByUserIdRequest request, AsyncAction<AsyncResult<SetGradeByUserIdResult>> callback) {
        SetGradeByUserIdTask task = new SetGradeByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public SetGradeByUserIdResult setGradeByUserId(SetGradeByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.setGradeByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SetGradeByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void applyRankCapAsync(ApplyRankCapRequest request, AsyncAction<AsyncResult<ApplyRankCapResult>> callback) {
        ApplyRankCapTask task = new ApplyRankCapTask(request, callback);
        this.session.execute(task);
    }

    public ApplyRankCapResult applyRankCap(ApplyRankCapRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.applyRankCapAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ApplyRankCapResult)resultAsyncResult[0].getResult();
    }

    public void applyRankCapByUserIdAsync(ApplyRankCapByUserIdRequest request, AsyncAction<AsyncResult<ApplyRankCapByUserIdResult>> callback) {
        ApplyRankCapByUserIdTask task = new ApplyRankCapByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ApplyRankCapByUserIdResult applyRankCapByUserId(ApplyRankCapByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.applyRankCapByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ApplyRankCapByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteStatusByUserIdAsync(DeleteStatusByUserIdRequest request, AsyncAction<AsyncResult<DeleteStatusByUserIdResult>> callback) {
        DeleteStatusByUserIdTask task = new DeleteStatusByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteStatusByUserIdResult deleteStatusByUserId(DeleteStatusByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteStatusByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteStatusByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void verifyGradeAsync(VerifyGradeRequest request, AsyncAction<AsyncResult<VerifyGradeResult>> callback) {
        VerifyGradeTask task = new VerifyGradeTask(request, callback);
        this.session.execute(task);
    }

    public VerifyGradeResult verifyGrade(VerifyGradeRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.verifyGradeAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (VerifyGradeResult)resultAsyncResult[0].getResult();
    }

    public void verifyGradeByUserIdAsync(VerifyGradeByUserIdRequest request, AsyncAction<AsyncResult<VerifyGradeByUserIdResult>> callback) {
        VerifyGradeByUserIdTask task = new VerifyGradeByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public VerifyGradeByUserIdResult verifyGradeByUserId(VerifyGradeByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.verifyGradeByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (VerifyGradeByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void verifyGradeUpMaterialAsync(VerifyGradeUpMaterialRequest request, AsyncAction<AsyncResult<VerifyGradeUpMaterialResult>> callback) {
        VerifyGradeUpMaterialTask task = new VerifyGradeUpMaterialTask(request, callback);
        this.session.execute(task);
    }

    public VerifyGradeUpMaterialResult verifyGradeUpMaterial(VerifyGradeUpMaterialRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.verifyGradeUpMaterialAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (VerifyGradeUpMaterialResult)resultAsyncResult[0].getResult();
    }

    public void verifyGradeUpMaterialByUserIdAsync(VerifyGradeUpMaterialByUserIdRequest request, AsyncAction<AsyncResult<VerifyGradeUpMaterialByUserIdResult>> callback) {
        VerifyGradeUpMaterialByUserIdTask task = new VerifyGradeUpMaterialByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public VerifyGradeUpMaterialByUserIdResult verifyGradeUpMaterialByUserId(VerifyGradeUpMaterialByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.verifyGradeUpMaterialByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (VerifyGradeUpMaterialByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void addGradeByStampSheetAsync(AddGradeByStampSheetRequest request, AsyncAction<AsyncResult<AddGradeByStampSheetResult>> callback) {
        AddGradeByStampSheetTask task = new AddGradeByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public AddGradeByStampSheetResult addGradeByStampSheet(AddGradeByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.addGradeByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (AddGradeByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void applyRankCapByStampSheetAsync(ApplyRankCapByStampSheetRequest request, AsyncAction<AsyncResult<ApplyRankCapByStampSheetResult>> callback) {
        ApplyRankCapByStampSheetTask task = new ApplyRankCapByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public ApplyRankCapByStampSheetResult applyRankCapByStampSheet(ApplyRankCapByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.applyRankCapByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ApplyRankCapByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void subGradeByStampTaskAsync(SubGradeByStampTaskRequest request, AsyncAction<AsyncResult<SubGradeByStampTaskResult>> callback) {
        SubGradeByStampTaskTask task = new SubGradeByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public SubGradeByStampTaskResult subGradeByStampTask(SubGradeByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.subGradeByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SubGradeByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void multiplyAcquireActionsByUserIdAsync(MultiplyAcquireActionsByUserIdRequest request, AsyncAction<AsyncResult<MultiplyAcquireActionsByUserIdResult>> callback) {
        MultiplyAcquireActionsByUserIdTask task = new MultiplyAcquireActionsByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public MultiplyAcquireActionsByUserIdResult multiplyAcquireActionsByUserId(MultiplyAcquireActionsByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.multiplyAcquireActionsByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (MultiplyAcquireActionsByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void multiplyAcquireActionsByStampSheetAsync(MultiplyAcquireActionsByStampSheetRequest request, AsyncAction<AsyncResult<MultiplyAcquireActionsByStampSheetResult>> callback) {
        MultiplyAcquireActionsByStampSheetTask task = new MultiplyAcquireActionsByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public MultiplyAcquireActionsByStampSheetResult multiplyAcquireActionsByStampSheet(MultiplyAcquireActionsByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.multiplyAcquireActionsByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (MultiplyAcquireActionsByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void verifyGradeByStampTaskAsync(VerifyGradeByStampTaskRequest request, AsyncAction<AsyncResult<VerifyGradeByStampTaskResult>> callback) {
        VerifyGradeByStampTaskTask task = new VerifyGradeByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public VerifyGradeByStampTaskResult verifyGradeByStampTask(VerifyGradeByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.verifyGradeByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (VerifyGradeByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void verifyGradeUpMaterialByStampTaskAsync(VerifyGradeUpMaterialByStampTaskRequest request, AsyncAction<AsyncResult<VerifyGradeUpMaterialByStampTaskResult>> callback) {
        VerifyGradeUpMaterialByStampTaskTask task = new VerifyGradeUpMaterialByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public VerifyGradeUpMaterialByStampTaskResult verifyGradeUpMaterialByStampTask(VerifyGradeUpMaterialByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.verifyGradeUpMaterialByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (VerifyGradeUpMaterialByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentGradeMasterAsync(GetCurrentGradeMasterRequest request, AsyncAction<AsyncResult<GetCurrentGradeMasterResult>> callback) {
        GetCurrentGradeMasterTask task = new GetCurrentGradeMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentGradeMasterResult getCurrentGradeMaster(GetCurrentGradeMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentGradeMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentGradeMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentGradeMasterAsync(UpdateCurrentGradeMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentGradeMasterResult>> callback) {
        UpdateCurrentGradeMasterTask task = new UpdateCurrentGradeMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentGradeMasterResult updateCurrentGradeMaster(UpdateCurrentGradeMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentGradeMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentGradeMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentGradeMasterFromGitHubAsync(UpdateCurrentGradeMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentGradeMasterFromGitHubResult>> callback) {
        UpdateCurrentGradeMasterFromGitHubTask task = new UpdateCurrentGradeMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentGradeMasterFromGitHubResult updateCurrentGradeMasterFromGitHub(UpdateCurrentGradeMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentGradeMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentGradeMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("transactionSetting", CreateNamespaceTask.this.request.getTransactionSetting() != null ? CreateNamespaceTask.this.request.getTransactionSetting().toJson() : null);
                    this.put("changeGradeScript", CreateNamespaceTask.this.request.getChangeGradeScript() != null ? CreateNamespaceTask.this.request.getChangeGradeScript().toJson() : null);
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("transactionSetting", UpdateNamespaceTask.this.request.getTransactionSetting() != null ? UpdateNamespaceTask.this.request.getTransactionSetting().toJson() : null);
                    this.put("changeGradeScript", UpdateNamespaceTask.this.request.getChangeGradeScript() != null ? UpdateNamespaceTask.this.request.getChangeGradeScript().toJson() : null);
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DumpUserDataByUserIdTask
    extends Gs2RestSessionTask<DumpUserDataByUserIdResult> {
        private DumpUserDataByUserIdRequest request;

        public DumpUserDataByUserIdTask(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DumpUserDataByUserIdResult parse(JsonNode data) {
            return DumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", DumpUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckDumpUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckDumpUserDataByUserIdResult> {
        private CheckDumpUserDataByUserIdRequest request;

        public CheckDumpUserDataByUserIdTask(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckDumpUserDataByUserIdResult parse(JsonNode data) {
            return CheckDumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CleanUserDataByUserIdResult> {
        private CleanUserDataByUserIdRequest request;

        public CleanUserDataByUserIdTask(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CleanUserDataByUserIdResult parse(JsonNode data) {
            return CleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", CleanUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckCleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckCleanUserDataByUserIdResult> {
        private CheckCleanUserDataByUserIdRequest request;

        public CheckCleanUserDataByUserIdTask(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckCleanUserDataByUserIdResult parse(JsonNode data) {
            return CheckCleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareImportUserDataByUserIdTask
    extends Gs2RestSessionTask<PrepareImportUserDataByUserIdResult> {
        private PrepareImportUserDataByUserIdRequest request;

        public PrepareImportUserDataByUserIdTask(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareImportUserDataByUserIdResult parse(JsonNode data) {
            return PrepareImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/prepare";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", PrepareImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ImportUserDataByUserIdTask
    extends Gs2RestSessionTask<ImportUserDataByUserIdResult> {
        private ImportUserDataByUserIdRequest request;

        public ImportUserDataByUserIdTask(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ImportUserDataByUserIdResult parse(JsonNode data) {
            return ImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("uploadToken", ImportUserDataByUserIdTask.this.request.getUploadToken());
                    this.put("contextStack", ImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckImportUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckImportUserDataByUserIdResult> {
        private CheckImportUserDataByUserIdRequest request;

        public CheckImportUserDataByUserIdTask(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckImportUserDataByUserIdResult parse(JsonNode data) {
            return CheckImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/{uploadToken}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{uploadToken}", this.request.getUploadToken() == null || this.request.getUploadToken().length() == 0 ? "null" : String.valueOf(this.request.getUploadToken()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeGradeModelMastersTask
    extends Gs2RestSessionTask<DescribeGradeModelMastersResult> {
        private DescribeGradeModelMastersRequest request;

        public DescribeGradeModelMastersTask(DescribeGradeModelMastersRequest request, AsyncAction<AsyncResult<DescribeGradeModelMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeGradeModelMastersResult parse(JsonNode data) {
            return DescribeGradeModelMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateGradeModelMasterTask
    extends Gs2RestSessionTask<CreateGradeModelMasterResult> {
        private CreateGradeModelMasterRequest request;

        public CreateGradeModelMasterTask(CreateGradeModelMasterRequest request, AsyncAction<AsyncResult<CreateGradeModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateGradeModelMasterResult parse(JsonNode data) {
            return CreateGradeModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateGradeModelMasterTask.this.request.getName());
                    this.put("description", CreateGradeModelMasterTask.this.request.getDescription());
                    this.put("metadata", CreateGradeModelMasterTask.this.request.getMetadata());
                    this.put("defaultGrades", CreateGradeModelMasterTask.this.request.getDefaultGrades() == null ? new ArrayList() : CreateGradeModelMasterTask.this.request.getDefaultGrades().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("experienceModelId", CreateGradeModelMasterTask.this.request.getExperienceModelId());
                    this.put("gradeEntries", CreateGradeModelMasterTask.this.request.getGradeEntries() == null ? new ArrayList() : CreateGradeModelMasterTask.this.request.getGradeEntries().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("acquireActionRates", CreateGradeModelMasterTask.this.request.getAcquireActionRates() == null ? new ArrayList() : CreateGradeModelMasterTask.this.request.getAcquireActionRates().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", CreateGradeModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetGradeModelMasterTask
    extends Gs2RestSessionTask<GetGradeModelMasterResult> {
        private GetGradeModelMasterRequest request;

        public GetGradeModelMasterTask(GetGradeModelMasterRequest request, AsyncAction<AsyncResult<GetGradeModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetGradeModelMasterResult parse(JsonNode data) {
            return GetGradeModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model/{gradeName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{gradeName}", this.request.getGradeName() == null || this.request.getGradeName().length() == 0 ? "null" : String.valueOf(this.request.getGradeName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateGradeModelMasterTask
    extends Gs2RestSessionTask<UpdateGradeModelMasterResult> {
        private UpdateGradeModelMasterRequest request;

        public UpdateGradeModelMasterTask(UpdateGradeModelMasterRequest request, AsyncAction<AsyncResult<UpdateGradeModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateGradeModelMasterResult parse(JsonNode data) {
            return UpdateGradeModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model/{gradeName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{gradeName}", this.request.getGradeName() == null || this.request.getGradeName().length() == 0 ? "null" : String.valueOf(this.request.getGradeName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateGradeModelMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateGradeModelMasterTask.this.request.getMetadata());
                    this.put("defaultGrades", UpdateGradeModelMasterTask.this.request.getDefaultGrades() == null ? new ArrayList() : UpdateGradeModelMasterTask.this.request.getDefaultGrades().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("experienceModelId", UpdateGradeModelMasterTask.this.request.getExperienceModelId());
                    this.put("gradeEntries", UpdateGradeModelMasterTask.this.request.getGradeEntries() == null ? new ArrayList() : UpdateGradeModelMasterTask.this.request.getGradeEntries().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("acquireActionRates", UpdateGradeModelMasterTask.this.request.getAcquireActionRates() == null ? new ArrayList() : UpdateGradeModelMasterTask.this.request.getAcquireActionRates().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", UpdateGradeModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteGradeModelMasterTask
    extends Gs2RestSessionTask<DeleteGradeModelMasterResult> {
        private DeleteGradeModelMasterRequest request;

        public DeleteGradeModelMasterTask(DeleteGradeModelMasterRequest request, AsyncAction<AsyncResult<DeleteGradeModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteGradeModelMasterResult parse(JsonNode data) {
            return DeleteGradeModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model/{gradeName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{gradeName}", this.request.getGradeName() == null || this.request.getGradeName().length() == 0 ? "null" : String.valueOf(this.request.getGradeName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeGradeModelsTask
    extends Gs2RestSessionTask<DescribeGradeModelsResult> {
        private DescribeGradeModelsRequest request;

        public DescribeGradeModelsTask(DescribeGradeModelsRequest request, AsyncAction<AsyncResult<DescribeGradeModelsResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeGradeModelsResult parse(JsonNode data) {
            return DescribeGradeModelsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/model";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetGradeModelTask
    extends Gs2RestSessionTask<GetGradeModelResult> {
        private GetGradeModelRequest request;

        public GetGradeModelTask(GetGradeModelRequest request, AsyncAction<AsyncResult<GetGradeModelResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetGradeModelResult parse(JsonNode data) {
            return GetGradeModelResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/model/{gradeName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{gradeName}", this.request.getGradeName() == null || this.request.getGradeName().length() == 0 ? "null" : String.valueOf(this.request.getGradeName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeStatusesTask
    extends Gs2RestSessionTask<DescribeStatusesResult> {
        private DescribeStatusesRequest request;

        public DescribeStatusesTask(DescribeStatusesRequest request, AsyncAction<AsyncResult<DescribeStatusesResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeStatusesResult parse(JsonNode data) {
            return DescribeStatusesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getGradeName() != null) {
                queryStrings.add("gradeName=" + EncodingUtil.urlEncode(String.valueOf(this.request.getGradeName())));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeStatusesByUserIdTask
    extends Gs2RestSessionTask<DescribeStatusesByUserIdResult> {
        private DescribeStatusesByUserIdRequest request;

        public DescribeStatusesByUserIdTask(DescribeStatusesByUserIdRequest request, AsyncAction<AsyncResult<DescribeStatusesByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeStatusesByUserIdResult parse(JsonNode data) {
            return DescribeStatusesByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getGradeName() != null) {
                queryStrings.add("gradeName=" + EncodingUtil.urlEncode(String.valueOf(this.request.getGradeName())));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetStatusTask
    extends Gs2RestSessionTask<GetStatusResult> {
        private GetStatusRequest request;

        public GetStatusTask(GetStatusRequest request, AsyncAction<AsyncResult<GetStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetStatusResult parse(JsonNode data) {
            return GetStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/status/model/{gradeName}/property/{propertyId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{gradeName}", this.request.getGradeName() == null || this.request.getGradeName().length() == 0 ? "null" : String.valueOf(this.request.getGradeName()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetStatusByUserIdTask
    extends Gs2RestSessionTask<GetStatusByUserIdResult> {
        private GetStatusByUserIdRequest request;

        public GetStatusByUserIdTask(GetStatusByUserIdRequest request, AsyncAction<AsyncResult<GetStatusByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetStatusByUserIdResult parse(JsonNode data) {
            return GetStatusByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/model/{gradeName}/property/{propertyId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{gradeName}", this.request.getGradeName() == null || this.request.getGradeName().length() == 0 ? "null" : String.valueOf(this.request.getGradeName()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class AddGradeByUserIdTask
    extends Gs2RestSessionTask<AddGradeByUserIdResult> {
        private AddGradeByUserIdRequest request;

        public AddGradeByUserIdTask(AddGradeByUserIdRequest request, AsyncAction<AsyncResult<AddGradeByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public AddGradeByUserIdResult parse(JsonNode data) {
            return AddGradeByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/model/{gradeName}/property/{propertyId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{gradeName}", this.request.getGradeName() == null || this.request.getGradeName().length() == 0 ? "null" : String.valueOf(this.request.getGradeName()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("gradeValue", AddGradeByUserIdTask.this.request.getGradeValue());
                    this.put("contextStack", AddGradeByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class SubGradeByUserIdTask
    extends Gs2RestSessionTask<SubGradeByUserIdResult> {
        private SubGradeByUserIdRequest request;

        public SubGradeByUserIdTask(SubGradeByUserIdRequest request, AsyncAction<AsyncResult<SubGradeByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SubGradeByUserIdResult parse(JsonNode data) {
            return SubGradeByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/model/{gradeName}/property/{propertyId}/sub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{gradeName}", this.request.getGradeName() == null || this.request.getGradeName().length() == 0 ? "null" : String.valueOf(this.request.getGradeName()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("gradeValue", SubGradeByUserIdTask.this.request.getGradeValue());
                    this.put("contextStack", SubGradeByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class SetGradeByUserIdTask
    extends Gs2RestSessionTask<SetGradeByUserIdResult> {
        private SetGradeByUserIdRequest request;

        public SetGradeByUserIdTask(SetGradeByUserIdRequest request, AsyncAction<AsyncResult<SetGradeByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SetGradeByUserIdResult parse(JsonNode data) {
            return SetGradeByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/model/{gradeName}/property/{propertyId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{gradeName}", this.request.getGradeName() == null || this.request.getGradeName().length() == 0 ? "null" : String.valueOf(this.request.getGradeName()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("gradeValue", SetGradeByUserIdTask.this.request.getGradeValue());
                    this.put("contextStack", SetGradeByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ApplyRankCapTask
    extends Gs2RestSessionTask<ApplyRankCapResult> {
        private ApplyRankCapRequest request;

        public ApplyRankCapTask(ApplyRankCapRequest request, AsyncAction<AsyncResult<ApplyRankCapResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ApplyRankCapResult parse(JsonNode data) {
            return ApplyRankCapResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/status/model/{gradeName}/property/{propertyId}/apply/rank/cap";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{gradeName}", this.request.getGradeName() == null || this.request.getGradeName().length() == 0 ? "null" : String.valueOf(this.request.getGradeName()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", ApplyRankCapTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ApplyRankCapByUserIdTask
    extends Gs2RestSessionTask<ApplyRankCapByUserIdResult> {
        private ApplyRankCapByUserIdRequest request;

        public ApplyRankCapByUserIdTask(ApplyRankCapByUserIdRequest request, AsyncAction<AsyncResult<ApplyRankCapByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ApplyRankCapByUserIdResult parse(JsonNode data) {
            return ApplyRankCapByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/model/{gradeName}/property/{propertyId}/apply/rank/cap";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{gradeName}", this.request.getGradeName() == null || this.request.getGradeName().length() == 0 ? "null" : String.valueOf(this.request.getGradeName()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", ApplyRankCapByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteStatusByUserIdTask
    extends Gs2RestSessionTask<DeleteStatusByUserIdResult> {
        private DeleteStatusByUserIdRequest request;

        public DeleteStatusByUserIdTask(DeleteStatusByUserIdRequest request, AsyncAction<AsyncResult<DeleteStatusByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteStatusByUserIdResult parse(JsonNode data) {
            return DeleteStatusByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/model/{gradeName}/property/{propertyId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{gradeName}", this.request.getGradeName() == null || this.request.getGradeName().length() == 0 ? "null" : String.valueOf(this.request.getGradeName()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class VerifyGradeTask
    extends Gs2RestSessionTask<VerifyGradeResult> {
        private VerifyGradeRequest request;

        public VerifyGradeTask(VerifyGradeRequest request, AsyncAction<AsyncResult<VerifyGradeResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public VerifyGradeResult parse(JsonNode data) {
            return VerifyGradeResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/status/{gradeName}/verify/grade/{verifyType}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{gradeName}", this.request.getGradeName() == null || this.request.getGradeName().length() == 0 ? "null" : String.valueOf(this.request.getGradeName()));
            url = url.replace("{verifyType}", this.request.getVerifyType() == null || this.request.getVerifyType().length() == 0 ? "null" : String.valueOf(this.request.getVerifyType()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("propertyId", VerifyGradeTask.this.request.getPropertyId());
                    this.put("gradeValue", VerifyGradeTask.this.request.getGradeValue());
                    this.put("contextStack", VerifyGradeTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class VerifyGradeByUserIdTask
    extends Gs2RestSessionTask<VerifyGradeByUserIdResult> {
        private VerifyGradeByUserIdRequest request;

        public VerifyGradeByUserIdTask(VerifyGradeByUserIdRequest request, AsyncAction<AsyncResult<VerifyGradeByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public VerifyGradeByUserIdResult parse(JsonNode data) {
            return VerifyGradeByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/{gradeName}/verify/grade/{verifyType}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{gradeName}", this.request.getGradeName() == null || this.request.getGradeName().length() == 0 ? "null" : String.valueOf(this.request.getGradeName()));
            url = url.replace("{verifyType}", this.request.getVerifyType() == null || this.request.getVerifyType().length() == 0 ? "null" : String.valueOf(this.request.getVerifyType()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("propertyId", VerifyGradeByUserIdTask.this.request.getPropertyId());
                    this.put("gradeValue", VerifyGradeByUserIdTask.this.request.getGradeValue());
                    this.put("contextStack", VerifyGradeByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class VerifyGradeUpMaterialTask
    extends Gs2RestSessionTask<VerifyGradeUpMaterialResult> {
        private VerifyGradeUpMaterialRequest request;

        public VerifyGradeUpMaterialTask(VerifyGradeUpMaterialRequest request, AsyncAction<AsyncResult<VerifyGradeUpMaterialResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public VerifyGradeUpMaterialResult parse(JsonNode data) {
            return VerifyGradeUpMaterialResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/status/{gradeName}/verify/material/{verifyType}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{gradeName}", this.request.getGradeName() == null || this.request.getGradeName().length() == 0 ? "null" : String.valueOf(this.request.getGradeName()));
            url = url.replace("{verifyType}", this.request.getVerifyType() == null || this.request.getVerifyType().length() == 0 ? "null" : String.valueOf(this.request.getVerifyType()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("propertyId", VerifyGradeUpMaterialTask.this.request.getPropertyId());
                    this.put("materialPropertyId", VerifyGradeUpMaterialTask.this.request.getMaterialPropertyId());
                    this.put("contextStack", VerifyGradeUpMaterialTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class VerifyGradeUpMaterialByUserIdTask
    extends Gs2RestSessionTask<VerifyGradeUpMaterialByUserIdResult> {
        private VerifyGradeUpMaterialByUserIdRequest request;

        public VerifyGradeUpMaterialByUserIdTask(VerifyGradeUpMaterialByUserIdRequest request, AsyncAction<AsyncResult<VerifyGradeUpMaterialByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public VerifyGradeUpMaterialByUserIdResult parse(JsonNode data) {
            return VerifyGradeUpMaterialByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/{gradeName}/verify/material/{verifyType}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{gradeName}", this.request.getGradeName() == null || this.request.getGradeName().length() == 0 ? "null" : String.valueOf(this.request.getGradeName()));
            url = url.replace("{verifyType}", this.request.getVerifyType() == null || this.request.getVerifyType().length() == 0 ? "null" : String.valueOf(this.request.getVerifyType()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("propertyId", VerifyGradeUpMaterialByUserIdTask.this.request.getPropertyId());
                    this.put("materialPropertyId", VerifyGradeUpMaterialByUserIdTask.this.request.getMaterialPropertyId());
                    this.put("contextStack", VerifyGradeUpMaterialByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class AddGradeByStampSheetTask
    extends Gs2RestSessionTask<AddGradeByStampSheetResult> {
        private AddGradeByStampSheetRequest request;

        public AddGradeByStampSheetTask(AddGradeByStampSheetRequest request, AsyncAction<AsyncResult<AddGradeByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public AddGradeByStampSheetResult parse(JsonNode data) {
            return AddGradeByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/stamp/grade/add";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", AddGradeByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", AddGradeByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", AddGradeByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ApplyRankCapByStampSheetTask
    extends Gs2RestSessionTask<ApplyRankCapByStampSheetResult> {
        private ApplyRankCapByStampSheetRequest request;

        public ApplyRankCapByStampSheetTask(ApplyRankCapByStampSheetRequest request, AsyncAction<AsyncResult<ApplyRankCapByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ApplyRankCapByStampSheetResult parse(JsonNode data) {
            return ApplyRankCapByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/stamp/apply/rank/cap";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", ApplyRankCapByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", ApplyRankCapByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", ApplyRankCapByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class SubGradeByStampTaskTask
    extends Gs2RestSessionTask<SubGradeByStampTaskResult> {
        private SubGradeByStampTaskRequest request;

        public SubGradeByStampTaskTask(SubGradeByStampTaskRequest request, AsyncAction<AsyncResult<SubGradeByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SubGradeByStampTaskResult parse(JsonNode data) {
            return SubGradeByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/stamp/grade/sub";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", SubGradeByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", SubGradeByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", SubGradeByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class MultiplyAcquireActionsByUserIdTask
    extends Gs2RestSessionTask<MultiplyAcquireActionsByUserIdResult> {
        private MultiplyAcquireActionsByUserIdRequest request;

        public MultiplyAcquireActionsByUserIdTask(MultiplyAcquireActionsByUserIdRequest request, AsyncAction<AsyncResult<MultiplyAcquireActionsByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public MultiplyAcquireActionsByUserIdResult parse(JsonNode data) {
            return MultiplyAcquireActionsByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/model/{gradeName}/property/{propertyId}/acquire/rate/{rateName}/multiply";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{gradeName}", this.request.getGradeName() == null || this.request.getGradeName().length() == 0 ? "null" : String.valueOf(this.request.getGradeName()));
            url = url.replace("{propertyId}", this.request.getPropertyId() == null || this.request.getPropertyId().length() == 0 ? "null" : String.valueOf(this.request.getPropertyId()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("acquireActions", MultiplyAcquireActionsByUserIdTask.this.request.getAcquireActions() == null ? new ArrayList() : MultiplyAcquireActionsByUserIdTask.this.request.getAcquireActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", MultiplyAcquireActionsByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class MultiplyAcquireActionsByStampSheetTask
    extends Gs2RestSessionTask<MultiplyAcquireActionsByStampSheetResult> {
        private MultiplyAcquireActionsByStampSheetRequest request;

        public MultiplyAcquireActionsByStampSheetTask(MultiplyAcquireActionsByStampSheetRequest request, AsyncAction<AsyncResult<MultiplyAcquireActionsByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public MultiplyAcquireActionsByStampSheetResult parse(JsonNode data) {
            return MultiplyAcquireActionsByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/stamp/form/acquire";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", MultiplyAcquireActionsByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", MultiplyAcquireActionsByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", MultiplyAcquireActionsByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class VerifyGradeByStampTaskTask
    extends Gs2RestSessionTask<VerifyGradeByStampTaskResult> {
        private VerifyGradeByStampTaskRequest request;

        public VerifyGradeByStampTaskTask(VerifyGradeByStampTaskRequest request, AsyncAction<AsyncResult<VerifyGradeByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public VerifyGradeByStampTaskResult parse(JsonNode data) {
            return VerifyGradeByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/stamp/grade/verify";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", VerifyGradeByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", VerifyGradeByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", VerifyGradeByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class VerifyGradeUpMaterialByStampTaskTask
    extends Gs2RestSessionTask<VerifyGradeUpMaterialByStampTaskResult> {
        private VerifyGradeUpMaterialByStampTaskRequest request;

        public VerifyGradeUpMaterialByStampTaskTask(VerifyGradeUpMaterialByStampTaskRequest request, AsyncAction<AsyncResult<VerifyGradeUpMaterialByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public VerifyGradeUpMaterialByStampTaskResult parse(JsonNode data) {
            return VerifyGradeUpMaterialByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/stamp/material/verify";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", VerifyGradeUpMaterialByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", VerifyGradeUpMaterialByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", VerifyGradeUpMaterialByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentGradeMasterTask
    extends Gs2RestSessionTask<GetCurrentGradeMasterResult> {
        private GetCurrentGradeMasterRequest request;

        public GetCurrentGradeMasterTask(GetCurrentGradeMasterRequest request, AsyncAction<AsyncResult<GetCurrentGradeMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentGradeMasterResult parse(JsonNode data) {
            return GetCurrentGradeMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentGradeMasterTask
    extends Gs2RestSessionTask<UpdateCurrentGradeMasterResult> {
        private UpdateCurrentGradeMasterRequest request;

        public UpdateCurrentGradeMasterTask(UpdateCurrentGradeMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentGradeMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentGradeMasterResult parse(JsonNode data) {
            return UpdateCurrentGradeMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentGradeMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentGradeMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentGradeMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentGradeMasterFromGitHubResult> {
        private UpdateCurrentGradeMasterFromGitHubRequest request;

        public UpdateCurrentGradeMasterFromGitHubTask(UpdateCurrentGradeMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentGradeMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2GradeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentGradeMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentGradeMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "grade").replace("{region}", Gs2GradeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentGradeMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentGradeMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentGradeMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

