/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.core.net;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.exception.BadGatewayException;
import io.gs2.core.exception.BadRequestException;
import io.gs2.core.exception.ConflictException;
import io.gs2.core.exception.InternalServerErrorException;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.exception.QuotaLimitExceededException;
import io.gs2.core.exception.RequestTimeoutException;
import io.gs2.core.exception.ServiceUnavailableException;
import io.gs2.core.exception.UnauthorizedException;
import io.gs2.core.exception.UnknownException;
import io.gs2.core.model.GeneralError;
import io.gs2.core.net.Gs2Response;

public class Gs2RestResponse
extends Gs2Response {
    public Gs2RestResponse(String message, int statusCode) {
        super(message);
        String errorMessage;
        try {
            ObjectMapper mapper = new ObjectMapper();
            GeneralError error = (GeneralError)mapper.readValue(message, GeneralError.class);
            errorMessage = error.getMessage();
        }
        catch (Exception e) {
            errorMessage = message;
        }
        switch (statusCode) {
            case 200: {
                break;
            }
            case 400: {
                this.exception = new BadRequestException(errorMessage);
                break;
            }
            case 502: {
                this.exception = new BadGatewayException(errorMessage);
                break;
            }
            case 401: {
                this.exception = new UnauthorizedException(errorMessage);
                break;
            }
            case 409: {
                this.exception = new ConflictException(errorMessage);
                break;
            }
            case 500: {
                this.exception = new InternalServerErrorException(errorMessage);
                break;
            }
            case 404: {
                this.exception = new NotFoundException(errorMessage);
                break;
            }
            case 402: {
                this.exception = new QuotaLimitExceededException(errorMessage);
                break;
            }
            case 408: {
                this.exception = new RequestTimeoutException(errorMessage);
                break;
            }
            case 503: {
                this.exception = new ServiceUnavailableException(errorMessage);
                break;
            }
            default: {
                System.out.println(statusCode);
                this.exception = new UnknownException(errorMessage != null ? errorMessage : "");
            }
        }
    }
}

