/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.megaField;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.megaField.request.ActionByUserIdRequest;
import io.gs2.megaField.request.ActionRequest;
import io.gs2.megaField.request.CreateAreaModelMasterRequest;
import io.gs2.megaField.request.CreateLayerModelMasterRequest;
import io.gs2.megaField.request.CreateNamespaceRequest;
import io.gs2.megaField.request.DeleteAreaModelMasterRequest;
import io.gs2.megaField.request.DeleteLayerModelMasterRequest;
import io.gs2.megaField.request.DeleteNamespaceRequest;
import io.gs2.megaField.request.DescribeAreaModelMastersRequest;
import io.gs2.megaField.request.DescribeAreaModelsRequest;
import io.gs2.megaField.request.DescribeLayerModelMastersRequest;
import io.gs2.megaField.request.DescribeLayerModelsRequest;
import io.gs2.megaField.request.DescribeNamespacesRequest;
import io.gs2.megaField.request.ExportMasterRequest;
import io.gs2.megaField.request.FetchPositionFromSystemRequest;
import io.gs2.megaField.request.FetchPositionRequest;
import io.gs2.megaField.request.GetAreaModelMasterRequest;
import io.gs2.megaField.request.GetAreaModelRequest;
import io.gs2.megaField.request.GetCurrentFieldMasterRequest;
import io.gs2.megaField.request.GetLayerModelMasterRequest;
import io.gs2.megaField.request.GetLayerModelRequest;
import io.gs2.megaField.request.GetNamespaceRequest;
import io.gs2.megaField.request.GetNamespaceStatusRequest;
import io.gs2.megaField.request.NearUserIdsFromSystemRequest;
import io.gs2.megaField.request.NearUserIdsRequest;
import io.gs2.megaField.request.PutPositionByUserIdRequest;
import io.gs2.megaField.request.PutPositionRequest;
import io.gs2.megaField.request.UpdateAreaModelMasterRequest;
import io.gs2.megaField.request.UpdateCurrentFieldMasterFromGitHubRequest;
import io.gs2.megaField.request.UpdateCurrentFieldMasterRequest;
import io.gs2.megaField.request.UpdateLayerModelMasterRequest;
import io.gs2.megaField.request.UpdateNamespaceRequest;
import io.gs2.megaField.result.ActionByUserIdResult;
import io.gs2.megaField.result.ActionResult;
import io.gs2.megaField.result.CreateAreaModelMasterResult;
import io.gs2.megaField.result.CreateLayerModelMasterResult;
import io.gs2.megaField.result.CreateNamespaceResult;
import io.gs2.megaField.result.DeleteAreaModelMasterResult;
import io.gs2.megaField.result.DeleteLayerModelMasterResult;
import io.gs2.megaField.result.DeleteNamespaceResult;
import io.gs2.megaField.result.DescribeAreaModelMastersResult;
import io.gs2.megaField.result.DescribeAreaModelsResult;
import io.gs2.megaField.result.DescribeLayerModelMastersResult;
import io.gs2.megaField.result.DescribeLayerModelsResult;
import io.gs2.megaField.result.DescribeNamespacesResult;
import io.gs2.megaField.result.ExportMasterResult;
import io.gs2.megaField.result.FetchPositionFromSystemResult;
import io.gs2.megaField.result.FetchPositionResult;
import io.gs2.megaField.result.GetAreaModelMasterResult;
import io.gs2.megaField.result.GetAreaModelResult;
import io.gs2.megaField.result.GetCurrentFieldMasterResult;
import io.gs2.megaField.result.GetLayerModelMasterResult;
import io.gs2.megaField.result.GetLayerModelResult;
import io.gs2.megaField.result.GetNamespaceResult;
import io.gs2.megaField.result.GetNamespaceStatusResult;
import io.gs2.megaField.result.NearUserIdsFromSystemResult;
import io.gs2.megaField.result.NearUserIdsResult;
import io.gs2.megaField.result.PutPositionByUserIdResult;
import io.gs2.megaField.result.PutPositionResult;
import io.gs2.megaField.result.UpdateAreaModelMasterResult;
import io.gs2.megaField.result.UpdateCurrentFieldMasterFromGitHubResult;
import io.gs2.megaField.result.UpdateCurrentFieldMasterResult;
import io.gs2.megaField.result.UpdateLayerModelMasterResult;
import io.gs2.megaField.result.UpdateNamespaceResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Gs2MegaFieldRestClient
extends AbstractGs2Client<Gs2MegaFieldRestClient> {
    public Gs2MegaFieldRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void describeAreaModelsAsync(DescribeAreaModelsRequest request, AsyncAction<AsyncResult<DescribeAreaModelsResult>> callback) {
        DescribeAreaModelsTask task = new DescribeAreaModelsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeAreaModelsResult describeAreaModels(DescribeAreaModelsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeAreaModelsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeAreaModelsResult)resultAsyncResult[0].getResult();
    }

    public void getAreaModelAsync(GetAreaModelRequest request, AsyncAction<AsyncResult<GetAreaModelResult>> callback) {
        GetAreaModelTask task = new GetAreaModelTask(request, callback);
        this.session.execute(task);
    }

    public GetAreaModelResult getAreaModel(GetAreaModelRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getAreaModelAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetAreaModelResult)resultAsyncResult[0].getResult();
    }

    public void describeAreaModelMastersAsync(DescribeAreaModelMastersRequest request, AsyncAction<AsyncResult<DescribeAreaModelMastersResult>> callback) {
        DescribeAreaModelMastersTask task = new DescribeAreaModelMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeAreaModelMastersResult describeAreaModelMasters(DescribeAreaModelMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeAreaModelMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeAreaModelMastersResult)resultAsyncResult[0].getResult();
    }

    public void createAreaModelMasterAsync(CreateAreaModelMasterRequest request, AsyncAction<AsyncResult<CreateAreaModelMasterResult>> callback) {
        CreateAreaModelMasterTask task = new CreateAreaModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateAreaModelMasterResult createAreaModelMaster(CreateAreaModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createAreaModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateAreaModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void getAreaModelMasterAsync(GetAreaModelMasterRequest request, AsyncAction<AsyncResult<GetAreaModelMasterResult>> callback) {
        GetAreaModelMasterTask task = new GetAreaModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetAreaModelMasterResult getAreaModelMaster(GetAreaModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getAreaModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetAreaModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateAreaModelMasterAsync(UpdateAreaModelMasterRequest request, AsyncAction<AsyncResult<UpdateAreaModelMasterResult>> callback) {
        UpdateAreaModelMasterTask task = new UpdateAreaModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateAreaModelMasterResult updateAreaModelMaster(UpdateAreaModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateAreaModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateAreaModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteAreaModelMasterAsync(DeleteAreaModelMasterRequest request, AsyncAction<AsyncResult<DeleteAreaModelMasterResult>> callback) {
        DeleteAreaModelMasterTask task = new DeleteAreaModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteAreaModelMasterResult deleteAreaModelMaster(DeleteAreaModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteAreaModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteAreaModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void describeLayerModelsAsync(DescribeLayerModelsRequest request, AsyncAction<AsyncResult<DescribeLayerModelsResult>> callback) {
        DescribeLayerModelsTask task = new DescribeLayerModelsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeLayerModelsResult describeLayerModels(DescribeLayerModelsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeLayerModelsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeLayerModelsResult)resultAsyncResult[0].getResult();
    }

    public void getLayerModelAsync(GetLayerModelRequest request, AsyncAction<AsyncResult<GetLayerModelResult>> callback) {
        GetLayerModelTask task = new GetLayerModelTask(request, callback);
        this.session.execute(task);
    }

    public GetLayerModelResult getLayerModel(GetLayerModelRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getLayerModelAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetLayerModelResult)resultAsyncResult[0].getResult();
    }

    public void describeLayerModelMastersAsync(DescribeLayerModelMastersRequest request, AsyncAction<AsyncResult<DescribeLayerModelMastersResult>> callback) {
        DescribeLayerModelMastersTask task = new DescribeLayerModelMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeLayerModelMastersResult describeLayerModelMasters(DescribeLayerModelMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeLayerModelMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeLayerModelMastersResult)resultAsyncResult[0].getResult();
    }

    public void createLayerModelMasterAsync(CreateLayerModelMasterRequest request, AsyncAction<AsyncResult<CreateLayerModelMasterResult>> callback) {
        CreateLayerModelMasterTask task = new CreateLayerModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateLayerModelMasterResult createLayerModelMaster(CreateLayerModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createLayerModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateLayerModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void getLayerModelMasterAsync(GetLayerModelMasterRequest request, AsyncAction<AsyncResult<GetLayerModelMasterResult>> callback) {
        GetLayerModelMasterTask task = new GetLayerModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetLayerModelMasterResult getLayerModelMaster(GetLayerModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getLayerModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetLayerModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateLayerModelMasterAsync(UpdateLayerModelMasterRequest request, AsyncAction<AsyncResult<UpdateLayerModelMasterResult>> callback) {
        UpdateLayerModelMasterTask task = new UpdateLayerModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateLayerModelMasterResult updateLayerModelMaster(UpdateLayerModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateLayerModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateLayerModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteLayerModelMasterAsync(DeleteLayerModelMasterRequest request, AsyncAction<AsyncResult<DeleteLayerModelMasterResult>> callback) {
        DeleteLayerModelMasterTask task = new DeleteLayerModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteLayerModelMasterResult deleteLayerModelMaster(DeleteLayerModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteLayerModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteLayerModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentFieldMasterAsync(GetCurrentFieldMasterRequest request, AsyncAction<AsyncResult<GetCurrentFieldMasterResult>> callback) {
        GetCurrentFieldMasterTask task = new GetCurrentFieldMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentFieldMasterResult getCurrentFieldMaster(GetCurrentFieldMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentFieldMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentFieldMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentFieldMasterAsync(UpdateCurrentFieldMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentFieldMasterResult>> callback) {
        UpdateCurrentFieldMasterTask task = new UpdateCurrentFieldMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentFieldMasterResult updateCurrentFieldMaster(UpdateCurrentFieldMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentFieldMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentFieldMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentFieldMasterFromGitHubAsync(UpdateCurrentFieldMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentFieldMasterFromGitHubResult>> callback) {
        UpdateCurrentFieldMasterFromGitHubTask task = new UpdateCurrentFieldMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentFieldMasterFromGitHubResult updateCurrentFieldMasterFromGitHub(UpdateCurrentFieldMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentFieldMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentFieldMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    public void putPositionAsync(PutPositionRequest request, AsyncAction<AsyncResult<PutPositionResult>> callback) {
        PutPositionTask task = new PutPositionTask(request, callback);
        this.session.execute(task);
    }

    public PutPositionResult putPosition(PutPositionRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.putPositionAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PutPositionResult)resultAsyncResult[0].getResult();
    }

    public void putPositionByUserIdAsync(PutPositionByUserIdRequest request, AsyncAction<AsyncResult<PutPositionByUserIdResult>> callback) {
        PutPositionByUserIdTask task = new PutPositionByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PutPositionByUserIdResult putPositionByUserId(PutPositionByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.putPositionByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PutPositionByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void fetchPositionAsync(FetchPositionRequest request, AsyncAction<AsyncResult<FetchPositionResult>> callback) {
        FetchPositionTask task = new FetchPositionTask(request, callback);
        this.session.execute(task);
    }

    public FetchPositionResult fetchPosition(FetchPositionRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.fetchPositionAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (FetchPositionResult)resultAsyncResult[0].getResult();
    }

    public void fetchPositionFromSystemAsync(FetchPositionFromSystemRequest request, AsyncAction<AsyncResult<FetchPositionFromSystemResult>> callback) {
        FetchPositionFromSystemTask task = new FetchPositionFromSystemTask(request, callback);
        this.session.execute(task);
    }

    public FetchPositionFromSystemResult fetchPositionFromSystem(FetchPositionFromSystemRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.fetchPositionFromSystemAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (FetchPositionFromSystemResult)resultAsyncResult[0].getResult();
    }

    public void nearUserIdsAsync(NearUserIdsRequest request, AsyncAction<AsyncResult<NearUserIdsResult>> callback) {
        NearUserIdsTask task = new NearUserIdsTask(request, callback);
        this.session.execute(task);
    }

    public NearUserIdsResult nearUserIds(NearUserIdsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.nearUserIdsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (NearUserIdsResult)resultAsyncResult[0].getResult();
    }

    public void nearUserIdsFromSystemAsync(NearUserIdsFromSystemRequest request, AsyncAction<AsyncResult<NearUserIdsFromSystemResult>> callback) {
        NearUserIdsFromSystemTask task = new NearUserIdsFromSystemTask(request, callback);
        this.session.execute(task);
    }

    public NearUserIdsFromSystemResult nearUserIdsFromSystem(NearUserIdsFromSystemRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.nearUserIdsFromSystemAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (NearUserIdsFromSystemResult)resultAsyncResult[0].getResult();
    }

    public void actionAsync(ActionRequest request, AsyncAction<AsyncResult<ActionResult>> callback) {
        ActionTask task = new ActionTask(request, callback);
        this.session.execute(task);
    }

    public ActionResult action(ActionRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.actionAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ActionResult)resultAsyncResult[0].getResult();
    }

    public void actionByUserIdAsync(ActionByUserIdRequest request, AsyncAction<AsyncResult<ActionByUserIdResult>> callback) {
        ActionByUserIdTask task = new ActionByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ActionByUserIdResult actionByUserId(ActionByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.actionByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ActionByUserIdResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeAreaModelsTask
    extends Gs2RestSessionTask<DescribeAreaModelsResult> {
        private DescribeAreaModelsRequest request;

        public DescribeAreaModelsTask(DescribeAreaModelsRequest request, AsyncAction<AsyncResult<DescribeAreaModelsResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeAreaModelsResult parse(JsonNode data) {
            return DescribeAreaModelsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/area";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetAreaModelTask
    extends Gs2RestSessionTask<GetAreaModelResult> {
        private GetAreaModelRequest request;

        public GetAreaModelTask(GetAreaModelRequest request, AsyncAction<AsyncResult<GetAreaModelResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetAreaModelResult parse(JsonNode data) {
            return GetAreaModelResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/area/{areaModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeAreaModelMastersTask
    extends Gs2RestSessionTask<DescribeAreaModelMastersResult> {
        private DescribeAreaModelMastersRequest request;

        public DescribeAreaModelMastersTask(DescribeAreaModelMastersRequest request, AsyncAction<AsyncResult<DescribeAreaModelMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeAreaModelMastersResult parse(JsonNode data) {
            return DescribeAreaModelMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/area";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateAreaModelMasterTask
    extends Gs2RestSessionTask<CreateAreaModelMasterResult> {
        private CreateAreaModelMasterRequest request;

        public CreateAreaModelMasterTask(CreateAreaModelMasterRequest request, AsyncAction<AsyncResult<CreateAreaModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateAreaModelMasterResult parse(JsonNode data) {
            return CreateAreaModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/area";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateAreaModelMasterTask.this.request.getName());
                    this.put("description", CreateAreaModelMasterTask.this.request.getDescription());
                    this.put("metadata", CreateAreaModelMasterTask.this.request.getMetadata());
                    this.put("contextStack", CreateAreaModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetAreaModelMasterTask
    extends Gs2RestSessionTask<GetAreaModelMasterResult> {
        private GetAreaModelMasterRequest request;

        public GetAreaModelMasterTask(GetAreaModelMasterRequest request, AsyncAction<AsyncResult<GetAreaModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetAreaModelMasterResult parse(JsonNode data) {
            return GetAreaModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/area/{areaModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateAreaModelMasterTask
    extends Gs2RestSessionTask<UpdateAreaModelMasterResult> {
        private UpdateAreaModelMasterRequest request;

        public UpdateAreaModelMasterTask(UpdateAreaModelMasterRequest request, AsyncAction<AsyncResult<UpdateAreaModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateAreaModelMasterResult parse(JsonNode data) {
            return UpdateAreaModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/area/{areaModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateAreaModelMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateAreaModelMasterTask.this.request.getMetadata());
                    this.put("contextStack", UpdateAreaModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteAreaModelMasterTask
    extends Gs2RestSessionTask<DeleteAreaModelMasterResult> {
        private DeleteAreaModelMasterRequest request;

        public DeleteAreaModelMasterTask(DeleteAreaModelMasterRequest request, AsyncAction<AsyncResult<DeleteAreaModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteAreaModelMasterResult parse(JsonNode data) {
            return DeleteAreaModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/area/{areaModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeLayerModelsTask
    extends Gs2RestSessionTask<DescribeLayerModelsResult> {
        private DescribeLayerModelsRequest request;

        public DescribeLayerModelsTask(DescribeLayerModelsRequest request, AsyncAction<AsyncResult<DescribeLayerModelsResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeLayerModelsResult parse(JsonNode data) {
            return DescribeLayerModelsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/area/{areaModelName}/layer";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetLayerModelTask
    extends Gs2RestSessionTask<GetLayerModelResult> {
        private GetLayerModelRequest request;

        public GetLayerModelTask(GetLayerModelRequest request, AsyncAction<AsyncResult<GetLayerModelResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetLayerModelResult parse(JsonNode data) {
            return GetLayerModelResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/area/{areaModelName}/layer/{layerModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            url = url.replace("{layerModelName}", this.request.getLayerModelName() == null || this.request.getLayerModelName().length() == 0 ? "null" : String.valueOf(this.request.getLayerModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeLayerModelMastersTask
    extends Gs2RestSessionTask<DescribeLayerModelMastersResult> {
        private DescribeLayerModelMastersRequest request;

        public DescribeLayerModelMastersTask(DescribeLayerModelMastersRequest request, AsyncAction<AsyncResult<DescribeLayerModelMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeLayerModelMastersResult parse(JsonNode data) {
            return DescribeLayerModelMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/area/{areaModelName}/layer";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateLayerModelMasterTask
    extends Gs2RestSessionTask<CreateLayerModelMasterResult> {
        private CreateLayerModelMasterRequest request;

        public CreateLayerModelMasterTask(CreateLayerModelMasterRequest request, AsyncAction<AsyncResult<CreateLayerModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateLayerModelMasterResult parse(JsonNode data) {
            return CreateLayerModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/area/{areaModelName}/layer";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateLayerModelMasterTask.this.request.getName());
                    this.put("description", CreateLayerModelMasterTask.this.request.getDescription());
                    this.put("metadata", CreateLayerModelMasterTask.this.request.getMetadata());
                    this.put("contextStack", CreateLayerModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetLayerModelMasterTask
    extends Gs2RestSessionTask<GetLayerModelMasterResult> {
        private GetLayerModelMasterRequest request;

        public GetLayerModelMasterTask(GetLayerModelMasterRequest request, AsyncAction<AsyncResult<GetLayerModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetLayerModelMasterResult parse(JsonNode data) {
            return GetLayerModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/area/{areaModelName}/layer/{layerModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            url = url.replace("{layerModelName}", this.request.getLayerModelName() == null || this.request.getLayerModelName().length() == 0 ? "null" : String.valueOf(this.request.getLayerModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateLayerModelMasterTask
    extends Gs2RestSessionTask<UpdateLayerModelMasterResult> {
        private UpdateLayerModelMasterRequest request;

        public UpdateLayerModelMasterTask(UpdateLayerModelMasterRequest request, AsyncAction<AsyncResult<UpdateLayerModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateLayerModelMasterResult parse(JsonNode data) {
            return UpdateLayerModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/area/{areaModelName}/layer/{layerModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            url = url.replace("{layerModelName}", this.request.getLayerModelName() == null || this.request.getLayerModelName().length() == 0 ? "null" : String.valueOf(this.request.getLayerModelName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateLayerModelMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateLayerModelMasterTask.this.request.getMetadata());
                    this.put("contextStack", UpdateLayerModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteLayerModelMasterTask
    extends Gs2RestSessionTask<DeleteLayerModelMasterResult> {
        private DeleteLayerModelMasterRequest request;

        public DeleteLayerModelMasterTask(DeleteLayerModelMasterRequest request, AsyncAction<AsyncResult<DeleteLayerModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteLayerModelMasterResult parse(JsonNode data) {
            return DeleteLayerModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/area/{areaModelName}/layer/{layerModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            url = url.replace("{layerModelName}", this.request.getLayerModelName() == null || this.request.getLayerModelName().length() == 0 ? "null" : String.valueOf(this.request.getLayerModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentFieldMasterTask
    extends Gs2RestSessionTask<GetCurrentFieldMasterResult> {
        private GetCurrentFieldMasterRequest request;

        public GetCurrentFieldMasterTask(GetCurrentFieldMasterRequest request, AsyncAction<AsyncResult<GetCurrentFieldMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentFieldMasterResult parse(JsonNode data) {
            return GetCurrentFieldMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentFieldMasterTask
    extends Gs2RestSessionTask<UpdateCurrentFieldMasterResult> {
        private UpdateCurrentFieldMasterRequest request;

        public UpdateCurrentFieldMasterTask(UpdateCurrentFieldMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentFieldMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentFieldMasterResult parse(JsonNode data) {
            return UpdateCurrentFieldMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentFieldMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentFieldMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentFieldMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentFieldMasterFromGitHubResult> {
        private UpdateCurrentFieldMasterFromGitHubRequest request;

        public UpdateCurrentFieldMasterFromGitHubTask(UpdateCurrentFieldMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentFieldMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentFieldMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentFieldMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentFieldMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentFieldMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentFieldMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class PutPositionTask
    extends Gs2RestSessionTask<PutPositionResult> {
        private PutPositionRequest request;

        public PutPositionTask(PutPositionRequest request, AsyncAction<AsyncResult<PutPositionResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PutPositionResult parse(JsonNode data) {
            return PutPositionResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/spatial/{areaModelName}/{layerModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            url = url.replace("{layerModelName}", this.request.getLayerModelName() == null || this.request.getLayerModelName().length() == 0 ? "null" : String.valueOf(this.request.getLayerModelName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("position", PutPositionTask.this.request.getPosition() != null ? PutPositionTask.this.request.getPosition().toJson() : null);
                    this.put("vector", PutPositionTask.this.request.getVector() != null ? PutPositionTask.this.request.getVector().toJson() : null);
                    this.put("r", PutPositionTask.this.request.getR());
                    this.put("contextStack", PutPositionTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PutPositionByUserIdTask
    extends Gs2RestSessionTask<PutPositionByUserIdResult> {
        private PutPositionByUserIdRequest request;

        public PutPositionByUserIdTask(PutPositionByUserIdRequest request, AsyncAction<AsyncResult<PutPositionByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PutPositionByUserIdResult parse(JsonNode data) {
            return PutPositionByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/spatial/{areaModelName}/{layerModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            url = url.replace("{layerModelName}", this.request.getLayerModelName() == null || this.request.getLayerModelName().length() == 0 ? "null" : String.valueOf(this.request.getLayerModelName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("position", PutPositionByUserIdTask.this.request.getPosition() != null ? PutPositionByUserIdTask.this.request.getPosition().toJson() : null);
                    this.put("vector", PutPositionByUserIdTask.this.request.getVector() != null ? PutPositionByUserIdTask.this.request.getVector().toJson() : null);
                    this.put("r", PutPositionByUserIdTask.this.request.getR());
                    this.put("contextStack", PutPositionByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class FetchPositionTask
    extends Gs2RestSessionTask<FetchPositionResult> {
        private FetchPositionRequest request;

        public FetchPositionTask(FetchPositionRequest request, AsyncAction<AsyncResult<FetchPositionResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public FetchPositionResult parse(JsonNode data) {
            return FetchPositionResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/area/{areaModelName}/layer/{layerModelName}/spatial/fetch";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            url = url.replace("{layerModelName}", this.request.getLayerModelName() == null || this.request.getLayerModelName().length() == 0 ? "null" : String.valueOf(this.request.getLayerModelName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("userIds", FetchPositionTask.this.request.getUserIds() == null ? new ArrayList() : FetchPositionTask.this.request.getUserIds().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", FetchPositionTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class FetchPositionFromSystemTask
    extends Gs2RestSessionTask<FetchPositionFromSystemResult> {
        private FetchPositionFromSystemRequest request;

        public FetchPositionFromSystemTask(FetchPositionFromSystemRequest request, AsyncAction<AsyncResult<FetchPositionFromSystemResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public FetchPositionFromSystemResult parse(JsonNode data) {
            return FetchPositionFromSystemResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/system/area/{areaModelName}/layer/{layerModelName}/spatial/fetch";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            url = url.replace("{layerModelName}", this.request.getLayerModelName() == null || this.request.getLayerModelName().length() == 0 ? "null" : String.valueOf(this.request.getLayerModelName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("userIds", FetchPositionFromSystemTask.this.request.getUserIds() == null ? new ArrayList() : FetchPositionFromSystemTask.this.request.getUserIds().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", FetchPositionFromSystemTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class NearUserIdsTask
    extends Gs2RestSessionTask<NearUserIdsResult> {
        private NearUserIdsRequest request;

        public NearUserIdsTask(NearUserIdsRequest request, AsyncAction<AsyncResult<NearUserIdsResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public NearUserIdsResult parse(JsonNode data) {
            return NearUserIdsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/area/{areaModelName}/layer/{layerModelName}/spatial/near";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            url = url.replace("{layerModelName}", this.request.getLayerModelName() == null || this.request.getLayerModelName().length() == 0 ? "null" : String.valueOf(this.request.getLayerModelName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("point", NearUserIdsTask.this.request.getPoint() != null ? NearUserIdsTask.this.request.getPoint().toJson() : null);
                    this.put("r", NearUserIdsTask.this.request.getR());
                    this.put("limit", NearUserIdsTask.this.request.getLimit());
                    this.put("contextStack", NearUserIdsTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class NearUserIdsFromSystemTask
    extends Gs2RestSessionTask<NearUserIdsFromSystemResult> {
        private NearUserIdsFromSystemRequest request;

        public NearUserIdsFromSystemTask(NearUserIdsFromSystemRequest request, AsyncAction<AsyncResult<NearUserIdsFromSystemResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public NearUserIdsFromSystemResult parse(JsonNode data) {
            return NearUserIdsFromSystemResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/system/area/{areaModelName}/layer/{layerModelName}/spatial/near";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            url = url.replace("{layerModelName}", this.request.getLayerModelName() == null || this.request.getLayerModelName().length() == 0 ? "null" : String.valueOf(this.request.getLayerModelName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("point", NearUserIdsFromSystemTask.this.request.getPoint() != null ? NearUserIdsFromSystemTask.this.request.getPoint().toJson() : null);
                    this.put("r", NearUserIdsFromSystemTask.this.request.getR());
                    this.put("limit", NearUserIdsFromSystemTask.this.request.getLimit());
                    this.put("contextStack", NearUserIdsFromSystemTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ActionTask
    extends Gs2RestSessionTask<ActionResult> {
        private ActionRequest request;

        public ActionTask(ActionRequest request, AsyncAction<AsyncResult<ActionResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ActionResult parse(JsonNode data) {
            return ActionResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/spatial/{areaModelName}/{layerModelName}/action";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            url = url.replace("{layerModelName}", this.request.getLayerModelName() == null || this.request.getLayerModelName().length() == 0 ? "null" : String.valueOf(this.request.getLayerModelName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("position", ActionTask.this.request.getPosition() != null ? ActionTask.this.request.getPosition().toJson() : null);
                    this.put("scopes", ActionTask.this.request.getScopes() == null ? new ArrayList() : ActionTask.this.request.getScopes().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", ActionTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ActionByUserIdTask
    extends Gs2RestSessionTask<ActionByUserIdResult> {
        private ActionByUserIdRequest request;

        public ActionByUserIdTask(ActionByUserIdRequest request, AsyncAction<AsyncResult<ActionByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MegaFieldRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ActionByUserIdResult parse(JsonNode data) {
            return ActionByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "mega-field").replace("{region}", Gs2MegaFieldRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/spatial/{areaModelName}/{layerModelName}/action";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{areaModelName}", this.request.getAreaModelName() == null || this.request.getAreaModelName().length() == 0 ? "null" : String.valueOf(this.request.getAreaModelName()));
            url = url.replace("{layerModelName}", this.request.getLayerModelName() == null || this.request.getLayerModelName().length() == 0 ? "null" : String.valueOf(this.request.getLayerModelName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("position", ActionByUserIdTask.this.request.getPosition() != null ? ActionByUserIdTask.this.request.getPosition().toJson() : null);
                    this.put("scopes", ActionByUserIdTask.this.request.getScopes() == null ? new ArrayList() : ActionByUserIdTask.this.request.getScopes().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", ActionByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }
}

