/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.lottery.request.CheckCleanUserDataByUserIdRequest;
import io.gs2.lottery.request.CheckDumpUserDataByUserIdRequest;
import io.gs2.lottery.request.CheckImportUserDataByUserIdRequest;
import io.gs2.lottery.request.CleanUserDataByUserIdRequest;
import io.gs2.lottery.request.CreateLotteryModelMasterRequest;
import io.gs2.lottery.request.CreateNamespaceRequest;
import io.gs2.lottery.request.CreatePrizeTableMasterRequest;
import io.gs2.lottery.request.DeleteLotteryModelMasterRequest;
import io.gs2.lottery.request.DeleteNamespaceRequest;
import io.gs2.lottery.request.DeletePrizeTableMasterRequest;
import io.gs2.lottery.request.DescribeBoxesByUserIdRequest;
import io.gs2.lottery.request.DescribeBoxesRequest;
import io.gs2.lottery.request.DescribeLotteryModelMastersRequest;
import io.gs2.lottery.request.DescribeLotteryModelsRequest;
import io.gs2.lottery.request.DescribeNamespacesRequest;
import io.gs2.lottery.request.DescribePrizeLimitsRequest;
import io.gs2.lottery.request.DescribePrizeTableMastersRequest;
import io.gs2.lottery.request.DescribePrizeTablesRequest;
import io.gs2.lottery.request.DescribeProbabilitiesByUserIdRequest;
import io.gs2.lottery.request.DescribeProbabilitiesRequest;
import io.gs2.lottery.request.DrawByStampSheetRequest;
import io.gs2.lottery.request.DrawByUserIdRequest;
import io.gs2.lottery.request.DrawWithRandomSeedByUserIdRequest;
import io.gs2.lottery.request.DumpUserDataByUserIdRequest;
import io.gs2.lottery.request.ExportMasterRequest;
import io.gs2.lottery.request.GetBoxByUserIdRequest;
import io.gs2.lottery.request.GetBoxRequest;
import io.gs2.lottery.request.GetCurrentLotteryMasterRequest;
import io.gs2.lottery.request.GetLotteryModelMasterRequest;
import io.gs2.lottery.request.GetLotteryModelRequest;
import io.gs2.lottery.request.GetNamespaceRequest;
import io.gs2.lottery.request.GetNamespaceStatusRequest;
import io.gs2.lottery.request.GetPrizeLimitRequest;
import io.gs2.lottery.request.GetPrizeTableMasterRequest;
import io.gs2.lottery.request.GetPrizeTableRequest;
import io.gs2.lottery.request.ImportUserDataByUserIdRequest;
import io.gs2.lottery.request.PredictionByUserIdRequest;
import io.gs2.lottery.request.PredictionRequest;
import io.gs2.lottery.request.PrepareImportUserDataByUserIdRequest;
import io.gs2.lottery.request.ResetBoxByUserIdRequest;
import io.gs2.lottery.request.ResetBoxRequest;
import io.gs2.lottery.request.ResetPrizeLimitRequest;
import io.gs2.lottery.request.UpdateCurrentLotteryMasterFromGitHubRequest;
import io.gs2.lottery.request.UpdateCurrentLotteryMasterRequest;
import io.gs2.lottery.request.UpdateLotteryModelMasterRequest;
import io.gs2.lottery.request.UpdateNamespaceRequest;
import io.gs2.lottery.request.UpdatePrizeTableMasterRequest;
import io.gs2.lottery.result.CheckCleanUserDataByUserIdResult;
import io.gs2.lottery.result.CheckDumpUserDataByUserIdResult;
import io.gs2.lottery.result.CheckImportUserDataByUserIdResult;
import io.gs2.lottery.result.CleanUserDataByUserIdResult;
import io.gs2.lottery.result.CreateLotteryModelMasterResult;
import io.gs2.lottery.result.CreateNamespaceResult;
import io.gs2.lottery.result.CreatePrizeTableMasterResult;
import io.gs2.lottery.result.DeleteLotteryModelMasterResult;
import io.gs2.lottery.result.DeleteNamespaceResult;
import io.gs2.lottery.result.DeletePrizeTableMasterResult;
import io.gs2.lottery.result.DescribeBoxesByUserIdResult;
import io.gs2.lottery.result.DescribeBoxesResult;
import io.gs2.lottery.result.DescribeLotteryModelMastersResult;
import io.gs2.lottery.result.DescribeLotteryModelsResult;
import io.gs2.lottery.result.DescribeNamespacesResult;
import io.gs2.lottery.result.DescribePrizeLimitsResult;
import io.gs2.lottery.result.DescribePrizeTableMastersResult;
import io.gs2.lottery.result.DescribePrizeTablesResult;
import io.gs2.lottery.result.DescribeProbabilitiesByUserIdResult;
import io.gs2.lottery.result.DescribeProbabilitiesResult;
import io.gs2.lottery.result.DrawByStampSheetResult;
import io.gs2.lottery.result.DrawByUserIdResult;
import io.gs2.lottery.result.DrawWithRandomSeedByUserIdResult;
import io.gs2.lottery.result.DumpUserDataByUserIdResult;
import io.gs2.lottery.result.ExportMasterResult;
import io.gs2.lottery.result.GetBoxByUserIdResult;
import io.gs2.lottery.result.GetBoxResult;
import io.gs2.lottery.result.GetCurrentLotteryMasterResult;
import io.gs2.lottery.result.GetLotteryModelMasterResult;
import io.gs2.lottery.result.GetLotteryModelResult;
import io.gs2.lottery.result.GetNamespaceResult;
import io.gs2.lottery.result.GetNamespaceStatusResult;
import io.gs2.lottery.result.GetPrizeLimitResult;
import io.gs2.lottery.result.GetPrizeTableMasterResult;
import io.gs2.lottery.result.GetPrizeTableResult;
import io.gs2.lottery.result.ImportUserDataByUserIdResult;
import io.gs2.lottery.result.PredictionByUserIdResult;
import io.gs2.lottery.result.PredictionResult;
import io.gs2.lottery.result.PrepareImportUserDataByUserIdResult;
import io.gs2.lottery.result.ResetBoxByUserIdResult;
import io.gs2.lottery.result.ResetBoxResult;
import io.gs2.lottery.result.ResetPrizeLimitResult;
import io.gs2.lottery.result.UpdateCurrentLotteryMasterFromGitHubResult;
import io.gs2.lottery.result.UpdateCurrentLotteryMasterResult;
import io.gs2.lottery.result.UpdateLotteryModelMasterResult;
import io.gs2.lottery.result.UpdateNamespaceResult;
import io.gs2.lottery.result.UpdatePrizeTableMasterResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Gs2LotteryRestClient
extends AbstractGs2Client<Gs2LotteryRestClient> {
    public Gs2LotteryRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void dumpUserDataByUserIdAsync(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> callback) {
        DumpUserDataByUserIdTask task = new DumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DumpUserDataByUserIdResult dumpUserDataByUserId(DumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.dumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkDumpUserDataByUserIdAsync(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> callback) {
        CheckDumpUserDataByUserIdTask task = new CheckDumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckDumpUserDataByUserIdResult checkDumpUserDataByUserId(CheckDumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkDumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckDumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void cleanUserDataByUserIdAsync(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> callback) {
        CleanUserDataByUserIdTask task = new CleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CleanUserDataByUserIdResult cleanUserDataByUserId(CleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.cleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkCleanUserDataByUserIdAsync(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> callback) {
        CheckCleanUserDataByUserIdTask task = new CheckCleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckCleanUserDataByUserIdResult checkCleanUserDataByUserId(CheckCleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkCleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckCleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void prepareImportUserDataByUserIdAsync(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> callback) {
        PrepareImportUserDataByUserIdTask task = new PrepareImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PrepareImportUserDataByUserIdResult prepareImportUserDataByUserId(PrepareImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void importUserDataByUserIdAsync(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> callback) {
        ImportUserDataByUserIdTask task = new ImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ImportUserDataByUserIdResult importUserDataByUserId(ImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.importUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkImportUserDataByUserIdAsync(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> callback) {
        CheckImportUserDataByUserIdTask task = new CheckImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckImportUserDataByUserIdResult checkImportUserDataByUserId(CheckImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeLotteryModelMastersAsync(DescribeLotteryModelMastersRequest request, AsyncAction<AsyncResult<DescribeLotteryModelMastersResult>> callback) {
        DescribeLotteryModelMastersTask task = new DescribeLotteryModelMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeLotteryModelMastersResult describeLotteryModelMasters(DescribeLotteryModelMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeLotteryModelMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeLotteryModelMastersResult)resultAsyncResult[0].getResult();
    }

    public void createLotteryModelMasterAsync(CreateLotteryModelMasterRequest request, AsyncAction<AsyncResult<CreateLotteryModelMasterResult>> callback) {
        CreateLotteryModelMasterTask task = new CreateLotteryModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateLotteryModelMasterResult createLotteryModelMaster(CreateLotteryModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createLotteryModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateLotteryModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void getLotteryModelMasterAsync(GetLotteryModelMasterRequest request, AsyncAction<AsyncResult<GetLotteryModelMasterResult>> callback) {
        GetLotteryModelMasterTask task = new GetLotteryModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetLotteryModelMasterResult getLotteryModelMaster(GetLotteryModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getLotteryModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetLotteryModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateLotteryModelMasterAsync(UpdateLotteryModelMasterRequest request, AsyncAction<AsyncResult<UpdateLotteryModelMasterResult>> callback) {
        UpdateLotteryModelMasterTask task = new UpdateLotteryModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateLotteryModelMasterResult updateLotteryModelMaster(UpdateLotteryModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateLotteryModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateLotteryModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteLotteryModelMasterAsync(DeleteLotteryModelMasterRequest request, AsyncAction<AsyncResult<DeleteLotteryModelMasterResult>> callback) {
        DeleteLotteryModelMasterTask task = new DeleteLotteryModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteLotteryModelMasterResult deleteLotteryModelMaster(DeleteLotteryModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteLotteryModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteLotteryModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void describePrizeTableMastersAsync(DescribePrizeTableMastersRequest request, AsyncAction<AsyncResult<DescribePrizeTableMastersResult>> callback) {
        DescribePrizeTableMastersTask task = new DescribePrizeTableMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribePrizeTableMastersResult describePrizeTableMasters(DescribePrizeTableMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describePrizeTableMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribePrizeTableMastersResult)resultAsyncResult[0].getResult();
    }

    public void createPrizeTableMasterAsync(CreatePrizeTableMasterRequest request, AsyncAction<AsyncResult<CreatePrizeTableMasterResult>> callback) {
        CreatePrizeTableMasterTask task = new CreatePrizeTableMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreatePrizeTableMasterResult createPrizeTableMaster(CreatePrizeTableMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createPrizeTableMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreatePrizeTableMasterResult)resultAsyncResult[0].getResult();
    }

    public void getPrizeTableMasterAsync(GetPrizeTableMasterRequest request, AsyncAction<AsyncResult<GetPrizeTableMasterResult>> callback) {
        GetPrizeTableMasterTask task = new GetPrizeTableMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetPrizeTableMasterResult getPrizeTableMaster(GetPrizeTableMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getPrizeTableMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetPrizeTableMasterResult)resultAsyncResult[0].getResult();
    }

    public void updatePrizeTableMasterAsync(UpdatePrizeTableMasterRequest request, AsyncAction<AsyncResult<UpdatePrizeTableMasterResult>> callback) {
        UpdatePrizeTableMasterTask task = new UpdatePrizeTableMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdatePrizeTableMasterResult updatePrizeTableMaster(UpdatePrizeTableMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updatePrizeTableMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdatePrizeTableMasterResult)resultAsyncResult[0].getResult();
    }

    public void deletePrizeTableMasterAsync(DeletePrizeTableMasterRequest request, AsyncAction<AsyncResult<DeletePrizeTableMasterResult>> callback) {
        DeletePrizeTableMasterTask task = new DeletePrizeTableMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeletePrizeTableMasterResult deletePrizeTableMaster(DeletePrizeTableMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deletePrizeTableMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeletePrizeTableMasterResult)resultAsyncResult[0].getResult();
    }

    public void describeLotteryModelsAsync(DescribeLotteryModelsRequest request, AsyncAction<AsyncResult<DescribeLotteryModelsResult>> callback) {
        DescribeLotteryModelsTask task = new DescribeLotteryModelsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeLotteryModelsResult describeLotteryModels(DescribeLotteryModelsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeLotteryModelsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeLotteryModelsResult)resultAsyncResult[0].getResult();
    }

    public void getLotteryModelAsync(GetLotteryModelRequest request, AsyncAction<AsyncResult<GetLotteryModelResult>> callback) {
        GetLotteryModelTask task = new GetLotteryModelTask(request, callback);
        this.session.execute(task);
    }

    public GetLotteryModelResult getLotteryModel(GetLotteryModelRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getLotteryModelAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetLotteryModelResult)resultAsyncResult[0].getResult();
    }

    public void describePrizeTablesAsync(DescribePrizeTablesRequest request, AsyncAction<AsyncResult<DescribePrizeTablesResult>> callback) {
        DescribePrizeTablesTask task = new DescribePrizeTablesTask(request, callback);
        this.session.execute(task);
    }

    public DescribePrizeTablesResult describePrizeTables(DescribePrizeTablesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describePrizeTablesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribePrizeTablesResult)resultAsyncResult[0].getResult();
    }

    public void getPrizeTableAsync(GetPrizeTableRequest request, AsyncAction<AsyncResult<GetPrizeTableResult>> callback) {
        GetPrizeTableTask task = new GetPrizeTableTask(request, callback);
        this.session.execute(task);
    }

    public GetPrizeTableResult getPrizeTable(GetPrizeTableRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getPrizeTableAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetPrizeTableResult)resultAsyncResult[0].getResult();
    }

    public void drawByUserIdAsync(DrawByUserIdRequest request, AsyncAction<AsyncResult<DrawByUserIdResult>> callback) {
        DrawByUserIdTask task = new DrawByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DrawByUserIdResult drawByUserId(DrawByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.drawByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DrawByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void predictionAsync(PredictionRequest request, AsyncAction<AsyncResult<PredictionResult>> callback) {
        PredictionTask task = new PredictionTask(request, callback);
        this.session.execute(task);
    }

    public PredictionResult prediction(PredictionRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.predictionAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PredictionResult)resultAsyncResult[0].getResult();
    }

    public void predictionByUserIdAsync(PredictionByUserIdRequest request, AsyncAction<AsyncResult<PredictionByUserIdResult>> callback) {
        PredictionByUserIdTask task = new PredictionByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PredictionByUserIdResult predictionByUserId(PredictionByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.predictionByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PredictionByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void drawWithRandomSeedByUserIdAsync(DrawWithRandomSeedByUserIdRequest request, AsyncAction<AsyncResult<DrawWithRandomSeedByUserIdResult>> callback) {
        DrawWithRandomSeedByUserIdTask task = new DrawWithRandomSeedByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DrawWithRandomSeedByUserIdResult drawWithRandomSeedByUserId(DrawWithRandomSeedByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.drawWithRandomSeedByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DrawWithRandomSeedByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void drawByStampSheetAsync(DrawByStampSheetRequest request, AsyncAction<AsyncResult<DrawByStampSheetResult>> callback) {
        DrawByStampSheetTask task = new DrawByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public DrawByStampSheetResult drawByStampSheet(DrawByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.drawByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DrawByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void describeProbabilitiesAsync(DescribeProbabilitiesRequest request, AsyncAction<AsyncResult<DescribeProbabilitiesResult>> callback) {
        DescribeProbabilitiesTask task = new DescribeProbabilitiesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeProbabilitiesResult describeProbabilities(DescribeProbabilitiesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeProbabilitiesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeProbabilitiesResult)resultAsyncResult[0].getResult();
    }

    public void describeProbabilitiesByUserIdAsync(DescribeProbabilitiesByUserIdRequest request, AsyncAction<AsyncResult<DescribeProbabilitiesByUserIdResult>> callback) {
        DescribeProbabilitiesByUserIdTask task = new DescribeProbabilitiesByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeProbabilitiesByUserIdResult describeProbabilitiesByUserId(DescribeProbabilitiesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeProbabilitiesByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeProbabilitiesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentLotteryMasterAsync(GetCurrentLotteryMasterRequest request, AsyncAction<AsyncResult<GetCurrentLotteryMasterResult>> callback) {
        GetCurrentLotteryMasterTask task = new GetCurrentLotteryMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentLotteryMasterResult getCurrentLotteryMaster(GetCurrentLotteryMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentLotteryMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentLotteryMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentLotteryMasterAsync(UpdateCurrentLotteryMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentLotteryMasterResult>> callback) {
        UpdateCurrentLotteryMasterTask task = new UpdateCurrentLotteryMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentLotteryMasterResult updateCurrentLotteryMaster(UpdateCurrentLotteryMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentLotteryMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentLotteryMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentLotteryMasterFromGitHubAsync(UpdateCurrentLotteryMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentLotteryMasterFromGitHubResult>> callback) {
        UpdateCurrentLotteryMasterFromGitHubTask task = new UpdateCurrentLotteryMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentLotteryMasterFromGitHubResult updateCurrentLotteryMasterFromGitHub(UpdateCurrentLotteryMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentLotteryMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentLotteryMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    public void describePrizeLimitsAsync(DescribePrizeLimitsRequest request, AsyncAction<AsyncResult<DescribePrizeLimitsResult>> callback) {
        DescribePrizeLimitsTask task = new DescribePrizeLimitsTask(request, callback);
        this.session.execute(task);
    }

    public DescribePrizeLimitsResult describePrizeLimits(DescribePrizeLimitsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describePrizeLimitsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribePrizeLimitsResult)resultAsyncResult[0].getResult();
    }

    public void getPrizeLimitAsync(GetPrizeLimitRequest request, AsyncAction<AsyncResult<GetPrizeLimitResult>> callback) {
        GetPrizeLimitTask task = new GetPrizeLimitTask(request, callback);
        this.session.execute(task);
    }

    public GetPrizeLimitResult getPrizeLimit(GetPrizeLimitRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getPrizeLimitAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetPrizeLimitResult)resultAsyncResult[0].getResult();
    }

    public void resetPrizeLimitAsync(ResetPrizeLimitRequest request, AsyncAction<AsyncResult<ResetPrizeLimitResult>> callback) {
        ResetPrizeLimitTask task = new ResetPrizeLimitTask(request, callback);
        this.session.execute(task);
    }

    public ResetPrizeLimitResult resetPrizeLimit(ResetPrizeLimitRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.resetPrizeLimitAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ResetPrizeLimitResult)resultAsyncResult[0].getResult();
    }

    public void describeBoxesAsync(DescribeBoxesRequest request, AsyncAction<AsyncResult<DescribeBoxesResult>> callback) {
        DescribeBoxesTask task = new DescribeBoxesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeBoxesResult describeBoxes(DescribeBoxesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeBoxesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeBoxesResult)resultAsyncResult[0].getResult();
    }

    public void describeBoxesByUserIdAsync(DescribeBoxesByUserIdRequest request, AsyncAction<AsyncResult<DescribeBoxesByUserIdResult>> callback) {
        DescribeBoxesByUserIdTask task = new DescribeBoxesByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeBoxesByUserIdResult describeBoxesByUserId(DescribeBoxesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeBoxesByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeBoxesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getBoxAsync(GetBoxRequest request, AsyncAction<AsyncResult<GetBoxResult>> callback) {
        GetBoxTask task = new GetBoxTask(request, callback);
        this.session.execute(task);
    }

    public GetBoxResult getBox(GetBoxRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getBoxAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetBoxResult)resultAsyncResult[0].getResult();
    }

    public void getBoxByUserIdAsync(GetBoxByUserIdRequest request, AsyncAction<AsyncResult<GetBoxByUserIdResult>> callback) {
        GetBoxByUserIdTask task = new GetBoxByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetBoxByUserIdResult getBoxByUserId(GetBoxByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getBoxByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetBoxByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void resetBoxAsync(ResetBoxRequest request, AsyncAction<AsyncResult<ResetBoxResult>> callback) {
        ResetBoxTask task = new ResetBoxTask(request, callback);
        this.session.execute(task);
    }

    public ResetBoxResult resetBox(ResetBoxRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.resetBoxAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ResetBoxResult)resultAsyncResult[0].getResult();
    }

    public void resetBoxByUserIdAsync(ResetBoxByUserIdRequest request, AsyncAction<AsyncResult<ResetBoxByUserIdResult>> callback) {
        ResetBoxByUserIdTask task = new ResetBoxByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ResetBoxByUserIdResult resetBoxByUserId(ResetBoxByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.resetBoxByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ResetBoxByUserIdResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("transactionSetting", CreateNamespaceTask.this.request.getTransactionSetting() != null ? CreateNamespaceTask.this.request.getTransactionSetting().toJson() : null);
                    this.put("lotteryTriggerScriptId", CreateNamespaceTask.this.request.getLotteryTriggerScriptId());
                    this.put("choicePrizeTableScriptId", CreateNamespaceTask.this.request.getChoicePrizeTableScriptId());
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("queueNamespaceId", CreateNamespaceTask.this.request.getQueueNamespaceId());
                    this.put("keyId", CreateNamespaceTask.this.request.getKeyId());
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("transactionSetting", UpdateNamespaceTask.this.request.getTransactionSetting() != null ? UpdateNamespaceTask.this.request.getTransactionSetting().toJson() : null);
                    this.put("lotteryTriggerScriptId", UpdateNamespaceTask.this.request.getLotteryTriggerScriptId());
                    this.put("choicePrizeTableScriptId", UpdateNamespaceTask.this.request.getChoicePrizeTableScriptId());
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("queueNamespaceId", UpdateNamespaceTask.this.request.getQueueNamespaceId());
                    this.put("keyId", UpdateNamespaceTask.this.request.getKeyId());
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DumpUserDataByUserIdTask
    extends Gs2RestSessionTask<DumpUserDataByUserIdResult> {
        private DumpUserDataByUserIdRequest request;

        public DumpUserDataByUserIdTask(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DumpUserDataByUserIdResult parse(JsonNode data) {
            return DumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", DumpUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckDumpUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckDumpUserDataByUserIdResult> {
        private CheckDumpUserDataByUserIdRequest request;

        public CheckDumpUserDataByUserIdTask(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckDumpUserDataByUserIdResult parse(JsonNode data) {
            return CheckDumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CleanUserDataByUserIdResult> {
        private CleanUserDataByUserIdRequest request;

        public CleanUserDataByUserIdTask(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CleanUserDataByUserIdResult parse(JsonNode data) {
            return CleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", CleanUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckCleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckCleanUserDataByUserIdResult> {
        private CheckCleanUserDataByUserIdRequest request;

        public CheckCleanUserDataByUserIdTask(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckCleanUserDataByUserIdResult parse(JsonNode data) {
            return CheckCleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareImportUserDataByUserIdTask
    extends Gs2RestSessionTask<PrepareImportUserDataByUserIdResult> {
        private PrepareImportUserDataByUserIdRequest request;

        public PrepareImportUserDataByUserIdTask(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareImportUserDataByUserIdResult parse(JsonNode data) {
            return PrepareImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/prepare";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", PrepareImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ImportUserDataByUserIdTask
    extends Gs2RestSessionTask<ImportUserDataByUserIdResult> {
        private ImportUserDataByUserIdRequest request;

        public ImportUserDataByUserIdTask(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ImportUserDataByUserIdResult parse(JsonNode data) {
            return ImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("uploadToken", ImportUserDataByUserIdTask.this.request.getUploadToken());
                    this.put("contextStack", ImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckImportUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckImportUserDataByUserIdResult> {
        private CheckImportUserDataByUserIdRequest request;

        public CheckImportUserDataByUserIdTask(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckImportUserDataByUserIdResult parse(JsonNode data) {
            return CheckImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/{uploadToken}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{uploadToken}", this.request.getUploadToken() == null || this.request.getUploadToken().length() == 0 ? "null" : String.valueOf(this.request.getUploadToken()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeLotteryModelMastersTask
    extends Gs2RestSessionTask<DescribeLotteryModelMastersResult> {
        private DescribeLotteryModelMastersRequest request;

        public DescribeLotteryModelMastersTask(DescribeLotteryModelMastersRequest request, AsyncAction<AsyncResult<DescribeLotteryModelMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeLotteryModelMastersResult parse(JsonNode data) {
            return DescribeLotteryModelMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/lottery";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateLotteryModelMasterTask
    extends Gs2RestSessionTask<CreateLotteryModelMasterResult> {
        private CreateLotteryModelMasterRequest request;

        public CreateLotteryModelMasterTask(CreateLotteryModelMasterRequest request, AsyncAction<AsyncResult<CreateLotteryModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateLotteryModelMasterResult parse(JsonNode data) {
            return CreateLotteryModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/lottery";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateLotteryModelMasterTask.this.request.getName());
                    this.put("description", CreateLotteryModelMasterTask.this.request.getDescription());
                    this.put("metadata", CreateLotteryModelMasterTask.this.request.getMetadata());
                    this.put("mode", CreateLotteryModelMasterTask.this.request.getMode());
                    this.put("method", CreateLotteryModelMasterTask.this.request.getMethod());
                    this.put("prizeTableName", CreateLotteryModelMasterTask.this.request.getPrizeTableName());
                    this.put("choicePrizeTableScriptId", CreateLotteryModelMasterTask.this.request.getChoicePrizeTableScriptId());
                    this.put("contextStack", CreateLotteryModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetLotteryModelMasterTask
    extends Gs2RestSessionTask<GetLotteryModelMasterResult> {
        private GetLotteryModelMasterRequest request;

        public GetLotteryModelMasterTask(GetLotteryModelMasterRequest request, AsyncAction<AsyncResult<GetLotteryModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetLotteryModelMasterResult parse(JsonNode data) {
            return GetLotteryModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/lottery/{lotteryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{lotteryName}", this.request.getLotteryName() == null || this.request.getLotteryName().length() == 0 ? "null" : String.valueOf(this.request.getLotteryName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateLotteryModelMasterTask
    extends Gs2RestSessionTask<UpdateLotteryModelMasterResult> {
        private UpdateLotteryModelMasterRequest request;

        public UpdateLotteryModelMasterTask(UpdateLotteryModelMasterRequest request, AsyncAction<AsyncResult<UpdateLotteryModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateLotteryModelMasterResult parse(JsonNode data) {
            return UpdateLotteryModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/lottery/{lotteryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{lotteryName}", this.request.getLotteryName() == null || this.request.getLotteryName().length() == 0 ? "null" : String.valueOf(this.request.getLotteryName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateLotteryModelMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateLotteryModelMasterTask.this.request.getMetadata());
                    this.put("mode", UpdateLotteryModelMasterTask.this.request.getMode());
                    this.put("method", UpdateLotteryModelMasterTask.this.request.getMethod());
                    this.put("prizeTableName", UpdateLotteryModelMasterTask.this.request.getPrizeTableName());
                    this.put("choicePrizeTableScriptId", UpdateLotteryModelMasterTask.this.request.getChoicePrizeTableScriptId());
                    this.put("contextStack", UpdateLotteryModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteLotteryModelMasterTask
    extends Gs2RestSessionTask<DeleteLotteryModelMasterResult> {
        private DeleteLotteryModelMasterRequest request;

        public DeleteLotteryModelMasterTask(DeleteLotteryModelMasterRequest request, AsyncAction<AsyncResult<DeleteLotteryModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteLotteryModelMasterResult parse(JsonNode data) {
            return DeleteLotteryModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/lottery/{lotteryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{lotteryName}", this.request.getLotteryName() == null || this.request.getLotteryName().length() == 0 ? "null" : String.valueOf(this.request.getLotteryName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribePrizeTableMastersTask
    extends Gs2RestSessionTask<DescribePrizeTableMastersResult> {
        private DescribePrizeTableMastersRequest request;

        public DescribePrizeTableMastersTask(DescribePrizeTableMastersRequest request, AsyncAction<AsyncResult<DescribePrizeTableMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribePrizeTableMastersResult parse(JsonNode data) {
            return DescribePrizeTableMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/table";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreatePrizeTableMasterTask
    extends Gs2RestSessionTask<CreatePrizeTableMasterResult> {
        private CreatePrizeTableMasterRequest request;

        public CreatePrizeTableMasterTask(CreatePrizeTableMasterRequest request, AsyncAction<AsyncResult<CreatePrizeTableMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreatePrizeTableMasterResult parse(JsonNode data) {
            return CreatePrizeTableMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/table";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreatePrizeTableMasterTask.this.request.getName());
                    this.put("description", CreatePrizeTableMasterTask.this.request.getDescription());
                    this.put("metadata", CreatePrizeTableMasterTask.this.request.getMetadata());
                    this.put("prizes", CreatePrizeTableMasterTask.this.request.getPrizes() == null ? new ArrayList() : CreatePrizeTableMasterTask.this.request.getPrizes().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", CreatePrizeTableMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetPrizeTableMasterTask
    extends Gs2RestSessionTask<GetPrizeTableMasterResult> {
        private GetPrizeTableMasterRequest request;

        public GetPrizeTableMasterTask(GetPrizeTableMasterRequest request, AsyncAction<AsyncResult<GetPrizeTableMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetPrizeTableMasterResult parse(JsonNode data) {
            return GetPrizeTableMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/table/{prizeTableName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{prizeTableName}", this.request.getPrizeTableName() == null || this.request.getPrizeTableName().length() == 0 ? "null" : String.valueOf(this.request.getPrizeTableName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdatePrizeTableMasterTask
    extends Gs2RestSessionTask<UpdatePrizeTableMasterResult> {
        private UpdatePrizeTableMasterRequest request;

        public UpdatePrizeTableMasterTask(UpdatePrizeTableMasterRequest request, AsyncAction<AsyncResult<UpdatePrizeTableMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdatePrizeTableMasterResult parse(JsonNode data) {
            return UpdatePrizeTableMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/table/{prizeTableName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{prizeTableName}", this.request.getPrizeTableName() == null || this.request.getPrizeTableName().length() == 0 ? "null" : String.valueOf(this.request.getPrizeTableName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdatePrizeTableMasterTask.this.request.getDescription());
                    this.put("metadata", UpdatePrizeTableMasterTask.this.request.getMetadata());
                    this.put("prizes", UpdatePrizeTableMasterTask.this.request.getPrizes() == null ? new ArrayList() : UpdatePrizeTableMasterTask.this.request.getPrizes().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", UpdatePrizeTableMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeletePrizeTableMasterTask
    extends Gs2RestSessionTask<DeletePrizeTableMasterResult> {
        private DeletePrizeTableMasterRequest request;

        public DeletePrizeTableMasterTask(DeletePrizeTableMasterRequest request, AsyncAction<AsyncResult<DeletePrizeTableMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeletePrizeTableMasterResult parse(JsonNode data) {
            return DeletePrizeTableMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/table/{prizeTableName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{prizeTableName}", this.request.getPrizeTableName() == null || this.request.getPrizeTableName().length() == 0 ? "null" : String.valueOf(this.request.getPrizeTableName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeLotteryModelsTask
    extends Gs2RestSessionTask<DescribeLotteryModelsResult> {
        private DescribeLotteryModelsRequest request;

        public DescribeLotteryModelsTask(DescribeLotteryModelsRequest request, AsyncAction<AsyncResult<DescribeLotteryModelsResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeLotteryModelsResult parse(JsonNode data) {
            return DescribeLotteryModelsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/lottery";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetLotteryModelTask
    extends Gs2RestSessionTask<GetLotteryModelResult> {
        private GetLotteryModelRequest request;

        public GetLotteryModelTask(GetLotteryModelRequest request, AsyncAction<AsyncResult<GetLotteryModelResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetLotteryModelResult parse(JsonNode data) {
            return GetLotteryModelResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/lottery/{lotteryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{lotteryName}", this.request.getLotteryName() == null || this.request.getLotteryName().length() == 0 ? "null" : String.valueOf(this.request.getLotteryName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribePrizeTablesTask
    extends Gs2RestSessionTask<DescribePrizeTablesResult> {
        private DescribePrizeTablesRequest request;

        public DescribePrizeTablesTask(DescribePrizeTablesRequest request, AsyncAction<AsyncResult<DescribePrizeTablesResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribePrizeTablesResult parse(JsonNode data) {
            return DescribePrizeTablesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/table";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetPrizeTableTask
    extends Gs2RestSessionTask<GetPrizeTableResult> {
        private GetPrizeTableRequest request;

        public GetPrizeTableTask(GetPrizeTableRequest request, AsyncAction<AsyncResult<GetPrizeTableResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetPrizeTableResult parse(JsonNode data) {
            return GetPrizeTableResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/table/{prizeTableName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{prizeTableName}", this.request.getPrizeTableName() == null || this.request.getPrizeTableName().length() == 0 ? "null" : String.valueOf(this.request.getPrizeTableName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DrawByUserIdTask
    extends Gs2RestSessionTask<DrawByUserIdResult> {
        private DrawByUserIdRequest request;

        public DrawByUserIdTask(DrawByUserIdRequest request, AsyncAction<AsyncResult<DrawByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DrawByUserIdResult parse(JsonNode data) {
            return DrawByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/lottery/{lotteryName}/draw";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{lotteryName}", this.request.getLotteryName() == null || this.request.getLotteryName().length() == 0 ? "null" : String.valueOf(this.request.getLotteryName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("count", DrawByUserIdTask.this.request.getCount());
                    this.put("config", DrawByUserIdTask.this.request.getConfig() == null ? new ArrayList() : DrawByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", DrawByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PredictionTask
    extends Gs2RestSessionTask<PredictionResult> {
        private PredictionRequest request;

        public PredictionTask(PredictionRequest request, AsyncAction<AsyncResult<PredictionResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PredictionResult parse(JsonNode data) {
            return PredictionResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/lottery/{lotteryName}/prediction";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{lotteryName}", this.request.getLotteryName() == null || this.request.getLotteryName().length() == 0 ? "null" : String.valueOf(this.request.getLotteryName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("randomSeed", PredictionTask.this.request.getRandomSeed());
                    this.put("count", PredictionTask.this.request.getCount());
                    this.put("contextStack", PredictionTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PredictionByUserIdTask
    extends Gs2RestSessionTask<PredictionByUserIdResult> {
        private PredictionByUserIdRequest request;

        public PredictionByUserIdTask(PredictionByUserIdRequest request, AsyncAction<AsyncResult<PredictionByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PredictionByUserIdResult parse(JsonNode data) {
            return PredictionByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/lottery/{lotteryName}/prediction";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{lotteryName}", this.request.getLotteryName() == null || this.request.getLotteryName().length() == 0 ? "null" : String.valueOf(this.request.getLotteryName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("randomSeed", PredictionByUserIdTask.this.request.getRandomSeed());
                    this.put("count", PredictionByUserIdTask.this.request.getCount());
                    this.put("contextStack", PredictionByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DrawWithRandomSeedByUserIdTask
    extends Gs2RestSessionTask<DrawWithRandomSeedByUserIdResult> {
        private DrawWithRandomSeedByUserIdRequest request;

        public DrawWithRandomSeedByUserIdTask(DrawWithRandomSeedByUserIdRequest request, AsyncAction<AsyncResult<DrawWithRandomSeedByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DrawWithRandomSeedByUserIdResult parse(JsonNode data) {
            return DrawWithRandomSeedByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/lottery/{lotteryName}/draw/withSeed";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{lotteryName}", this.request.getLotteryName() == null || this.request.getLotteryName().length() == 0 ? "null" : String.valueOf(this.request.getLotteryName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("randomSeed", DrawWithRandomSeedByUserIdTask.this.request.getRandomSeed());
                    this.put("count", DrawWithRandomSeedByUserIdTask.this.request.getCount());
                    this.put("config", DrawWithRandomSeedByUserIdTask.this.request.getConfig() == null ? new ArrayList() : DrawWithRandomSeedByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", DrawWithRandomSeedByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DrawByStampSheetTask
    extends Gs2RestSessionTask<DrawByStampSheetResult> {
        private DrawByStampSheetRequest request;

        public DrawByStampSheetTask(DrawByStampSheetRequest request, AsyncAction<AsyncResult<DrawByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DrawByStampSheetResult parse(JsonNode data) {
            return DrawByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/stamp/draw";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", DrawByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", DrawByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", DrawByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeProbabilitiesTask
    extends Gs2RestSessionTask<DescribeProbabilitiesResult> {
        private DescribeProbabilitiesRequest request;

        public DescribeProbabilitiesTask(DescribeProbabilitiesRequest request, AsyncAction<AsyncResult<DescribeProbabilitiesResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeProbabilitiesResult parse(JsonNode data) {
            return DescribeProbabilitiesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/lottery/{lotteryName}/probability";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{lotteryName}", this.request.getLotteryName() == null || this.request.getLotteryName().length() == 0 ? "null" : String.valueOf(this.request.getLotteryName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeProbabilitiesByUserIdTask
    extends Gs2RestSessionTask<DescribeProbabilitiesByUserIdResult> {
        private DescribeProbabilitiesByUserIdRequest request;

        public DescribeProbabilitiesByUserIdTask(DescribeProbabilitiesByUserIdRequest request, AsyncAction<AsyncResult<DescribeProbabilitiesByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeProbabilitiesByUserIdResult parse(JsonNode data) {
            return DescribeProbabilitiesByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/lottery/{lotteryName}/probability";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{lotteryName}", this.request.getLotteryName() == null || this.request.getLotteryName().length() == 0 ? "null" : String.valueOf(this.request.getLotteryName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentLotteryMasterTask
    extends Gs2RestSessionTask<GetCurrentLotteryMasterResult> {
        private GetCurrentLotteryMasterRequest request;

        public GetCurrentLotteryMasterTask(GetCurrentLotteryMasterRequest request, AsyncAction<AsyncResult<GetCurrentLotteryMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentLotteryMasterResult parse(JsonNode data) {
            return GetCurrentLotteryMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentLotteryMasterTask
    extends Gs2RestSessionTask<UpdateCurrentLotteryMasterResult> {
        private UpdateCurrentLotteryMasterRequest request;

        public UpdateCurrentLotteryMasterTask(UpdateCurrentLotteryMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentLotteryMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentLotteryMasterResult parse(JsonNode data) {
            return UpdateCurrentLotteryMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentLotteryMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentLotteryMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentLotteryMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentLotteryMasterFromGitHubResult> {
        private UpdateCurrentLotteryMasterFromGitHubRequest request;

        public UpdateCurrentLotteryMasterFromGitHubTask(UpdateCurrentLotteryMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentLotteryMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentLotteryMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentLotteryMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentLotteryMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentLotteryMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentLotteryMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribePrizeLimitsTask
    extends Gs2RestSessionTask<DescribePrizeLimitsResult> {
        private DescribePrizeLimitsRequest request;

        public DescribePrizeLimitsTask(DescribePrizeLimitsRequest request, AsyncAction<AsyncResult<DescribePrizeLimitsResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribePrizeLimitsResult parse(JsonNode data) {
            return DescribePrizeLimitsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/prizeLimit/{prizeTableName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{prizeTableName}", this.request.getPrizeTableName() == null || this.request.getPrizeTableName().length() == 0 ? "null" : String.valueOf(this.request.getPrizeTableName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetPrizeLimitTask
    extends Gs2RestSessionTask<GetPrizeLimitResult> {
        private GetPrizeLimitRequest request;

        public GetPrizeLimitTask(GetPrizeLimitRequest request, AsyncAction<AsyncResult<GetPrizeLimitResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetPrizeLimitResult parse(JsonNode data) {
            return GetPrizeLimitResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/prizeLimit/{prizeTableName}/{prizeId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{prizeTableName}", this.request.getPrizeTableName() == null || this.request.getPrizeTableName().length() == 0 ? "null" : String.valueOf(this.request.getPrizeTableName()));
            url = url.replace("{prizeId}", this.request.getPrizeId() == null || this.request.getPrizeId().length() == 0 ? "null" : String.valueOf(this.request.getPrizeId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ResetPrizeLimitTask
    extends Gs2RestSessionTask<ResetPrizeLimitResult> {
        private ResetPrizeLimitRequest request;

        public ResetPrizeLimitTask(ResetPrizeLimitRequest request, AsyncAction<AsyncResult<ResetPrizeLimitResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ResetPrizeLimitResult parse(JsonNode data) {
            return ResetPrizeLimitResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/prizeLimit/{prizeTableName}/{prizeId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{prizeTableName}", this.request.getPrizeTableName() == null || this.request.getPrizeTableName().length() == 0 ? "null" : String.valueOf(this.request.getPrizeTableName()));
            url = url.replace("{prizeId}", this.request.getPrizeId() == null || this.request.getPrizeId().length() == 0 ? "null" : String.valueOf(this.request.getPrizeId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeBoxesTask
    extends Gs2RestSessionTask<DescribeBoxesResult> {
        private DescribeBoxesRequest request;

        public DescribeBoxesTask(DescribeBoxesRequest request, AsyncAction<AsyncResult<DescribeBoxesResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeBoxesResult parse(JsonNode data) {
            return DescribeBoxesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/box";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeBoxesByUserIdTask
    extends Gs2RestSessionTask<DescribeBoxesByUserIdResult> {
        private DescribeBoxesByUserIdRequest request;

        public DescribeBoxesByUserIdTask(DescribeBoxesByUserIdRequest request, AsyncAction<AsyncResult<DescribeBoxesByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeBoxesByUserIdResult parse(JsonNode data) {
            return DescribeBoxesByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/box";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetBoxTask
    extends Gs2RestSessionTask<GetBoxResult> {
        private GetBoxRequest request;

        public GetBoxTask(GetBoxRequest request, AsyncAction<AsyncResult<GetBoxResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetBoxResult parse(JsonNode data) {
            return GetBoxResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/box/{prizeTableName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{prizeTableName}", this.request.getPrizeTableName() == null || this.request.getPrizeTableName().length() == 0 ? "null" : String.valueOf(this.request.getPrizeTableName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetBoxByUserIdTask
    extends Gs2RestSessionTask<GetBoxByUserIdResult> {
        private GetBoxByUserIdRequest request;

        public GetBoxByUserIdTask(GetBoxByUserIdRequest request, AsyncAction<AsyncResult<GetBoxByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetBoxByUserIdResult parse(JsonNode data) {
            return GetBoxByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/box/{prizeTableName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{prizeTableName}", this.request.getPrizeTableName() == null || this.request.getPrizeTableName().length() == 0 ? "null" : String.valueOf(this.request.getPrizeTableName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ResetBoxTask
    extends Gs2RestSessionTask<ResetBoxResult> {
        private ResetBoxRequest request;

        public ResetBoxTask(ResetBoxRequest request, AsyncAction<AsyncResult<ResetBoxResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ResetBoxResult parse(JsonNode data) {
            return ResetBoxResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/box/{prizeTableName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{prizeTableName}", this.request.getPrizeTableName() == null || this.request.getPrizeTableName().length() == 0 ? "null" : String.valueOf(this.request.getPrizeTableName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ResetBoxByUserIdTask
    extends Gs2RestSessionTask<ResetBoxByUserIdResult> {
        private ResetBoxByUserIdRequest request;

        public ResetBoxByUserIdTask(ResetBoxByUserIdRequest request, AsyncAction<AsyncResult<ResetBoxByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LotteryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ResetBoxByUserIdResult parse(JsonNode data) {
            return ResetBoxByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "lottery").replace("{region}", Gs2LotteryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/box/{prizeTableName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{prizeTableName}", this.request.getPrizeTableName() == null || this.request.getPrizeTableName().length() == 0 ? "null" : String.valueOf(this.request.getPrizeTableName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }
}

