/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.enhance.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.model.IModel;
import io.gs2.enhance.model.BonusRate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RateModel
implements IModel,
Serializable,
Comparable<RateModel> {
    private String rateModelId;
    private String name;
    private String description;
    private String metadata;
    private String targetInventoryModelId;
    private String acquireExperienceSuffix;
    private String materialInventoryModelId;
    private List<String> acquireExperienceHierarchy;
    private String experienceModelId;
    private List<BonusRate> bonusRates;

    public String getRateModelId() {
        return this.rateModelId;
    }

    public void setRateModelId(String rateModelId) {
        this.rateModelId = rateModelId;
    }

    public RateModel withRateModelId(String rateModelId) {
        this.rateModelId = rateModelId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RateModel withName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RateModel withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public RateModel withMetadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public String getTargetInventoryModelId() {
        return this.targetInventoryModelId;
    }

    public void setTargetInventoryModelId(String targetInventoryModelId) {
        this.targetInventoryModelId = targetInventoryModelId;
    }

    public RateModel withTargetInventoryModelId(String targetInventoryModelId) {
        this.targetInventoryModelId = targetInventoryModelId;
        return this;
    }

    public String getAcquireExperienceSuffix() {
        return this.acquireExperienceSuffix;
    }

    public void setAcquireExperienceSuffix(String acquireExperienceSuffix) {
        this.acquireExperienceSuffix = acquireExperienceSuffix;
    }

    public RateModel withAcquireExperienceSuffix(String acquireExperienceSuffix) {
        this.acquireExperienceSuffix = acquireExperienceSuffix;
        return this;
    }

    public String getMaterialInventoryModelId() {
        return this.materialInventoryModelId;
    }

    public void setMaterialInventoryModelId(String materialInventoryModelId) {
        this.materialInventoryModelId = materialInventoryModelId;
    }

    public RateModel withMaterialInventoryModelId(String materialInventoryModelId) {
        this.materialInventoryModelId = materialInventoryModelId;
        return this;
    }

    public List<String> getAcquireExperienceHierarchy() {
        return this.acquireExperienceHierarchy;
    }

    public void setAcquireExperienceHierarchy(List<String> acquireExperienceHierarchy) {
        this.acquireExperienceHierarchy = acquireExperienceHierarchy;
    }

    public RateModel withAcquireExperienceHierarchy(List<String> acquireExperienceHierarchy) {
        this.acquireExperienceHierarchy = acquireExperienceHierarchy;
        return this;
    }

    public String getExperienceModelId() {
        return this.experienceModelId;
    }

    public void setExperienceModelId(String experienceModelId) {
        this.experienceModelId = experienceModelId;
    }

    public RateModel withExperienceModelId(String experienceModelId) {
        this.experienceModelId = experienceModelId;
        return this;
    }

    public List<BonusRate> getBonusRates() {
        return this.bonusRates;
    }

    public void setBonusRates(List<BonusRate> bonusRates) {
        this.bonusRates = bonusRates;
    }

    public RateModel withBonusRates(List<BonusRate> bonusRates) {
        this.bonusRates = bonusRates;
        return this;
    }

    public static RateModel fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new RateModel().withRateModelId(data.get("rateModelId") == null || data.get("rateModelId").isNull() ? null : data.get("rateModelId").asText()).withName(data.get("name") == null || data.get("name").isNull() ? null : data.get("name").asText()).withDescription(data.get("description") == null || data.get("description").isNull() ? null : data.get("description").asText()).withMetadata(data.get("metadata") == null || data.get("metadata").isNull() ? null : data.get("metadata").asText()).withTargetInventoryModelId(data.get("targetInventoryModelId") == null || data.get("targetInventoryModelId").isNull() ? null : data.get("targetInventoryModelId").asText()).withAcquireExperienceSuffix(data.get("acquireExperienceSuffix") == null || data.get("acquireExperienceSuffix").isNull() ? null : data.get("acquireExperienceSuffix").asText()).withMaterialInventoryModelId(data.get("materialInventoryModelId") == null || data.get("materialInventoryModelId").isNull() ? null : data.get("materialInventoryModelId").asText()).withAcquireExperienceHierarchy(data.get("acquireExperienceHierarchy") == null || data.get("acquireExperienceHierarchy").isNull() ? new ArrayList<String>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("acquireExperienceHierarchy").elements(), 256), false).map(item -> item.asText()).collect(Collectors.toList())).withExperienceModelId(data.get("experienceModelId") == null || data.get("experienceModelId").isNull() ? null : data.get("experienceModelId").asText()).withBonusRates(data.get("bonusRates") == null || data.get("bonusRates").isNull() ? new ArrayList<BonusRate>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("bonusRates").elements(), 256), false).map(item -> BonusRate.fromJson(item)).collect(Collectors.toList()));
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
            {
                this.put("rateModelId", RateModel.this.getRateModelId());
                this.put("name", RateModel.this.getName());
                this.put("description", RateModel.this.getDescription());
                this.put("metadata", RateModel.this.getMetadata());
                this.put("targetInventoryModelId", RateModel.this.getTargetInventoryModelId());
                this.put("acquireExperienceSuffix", RateModel.this.getAcquireExperienceSuffix());
                this.put("materialInventoryModelId", RateModel.this.getMaterialInventoryModelId());
                this.put("acquireExperienceHierarchy", RateModel.this.getAcquireExperienceHierarchy() == null ? new ArrayList() : RateModel.this.getAcquireExperienceHierarchy().stream().map(item -> item).collect(Collectors.toList()));
                this.put("experienceModelId", RateModel.this.getExperienceModelId());
                this.put("bonusRates", RateModel.this.getBonusRates() == null ? new ArrayList() : RateModel.this.getBonusRates().stream().map(item -> item.toJson()).collect(Collectors.toList()));
            }
        });
    }

    @Override
    public int compareTo(RateModel o) {
        return this.rateModelId.compareTo(o.rateModelId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rateModelId == null ? 0 : this.rateModelId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.targetInventoryModelId == null ? 0 : this.targetInventoryModelId.hashCode());
        result = 31 * result + (this.acquireExperienceSuffix == null ? 0 : this.acquireExperienceSuffix.hashCode());
        result = 31 * result + (this.materialInventoryModelId == null ? 0 : this.materialInventoryModelId.hashCode());
        result = 31 * result + (this.acquireExperienceHierarchy == null ? 0 : this.acquireExperienceHierarchy.hashCode());
        result = 31 * result + (this.experienceModelId == null ? 0 : this.experienceModelId.hashCode());
        result = 31 * result + (this.bonusRates == null ? 0 : this.bonusRates.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        RateModel other = (RateModel)o;
        if (this.rateModelId == null) {
            return other.rateModelId == null;
        }
        if (!this.rateModelId.equals(other.rateModelId)) {
            return false;
        }
        if (this.name == null) {
            return other.name == null;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.description == null) {
            return other.description == null;
        }
        if (!this.description.equals(other.description)) {
            return false;
        }
        if (this.metadata == null) {
            return other.metadata == null;
        }
        if (!this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.targetInventoryModelId == null) {
            return other.targetInventoryModelId == null;
        }
        if (!this.targetInventoryModelId.equals(other.targetInventoryModelId)) {
            return false;
        }
        if (this.acquireExperienceSuffix == null) {
            return other.acquireExperienceSuffix == null;
        }
        if (!this.acquireExperienceSuffix.equals(other.acquireExperienceSuffix)) {
            return false;
        }
        if (this.materialInventoryModelId == null) {
            return other.materialInventoryModelId == null;
        }
        if (!this.materialInventoryModelId.equals(other.materialInventoryModelId)) {
            return false;
        }
        if (this.acquireExperienceHierarchy == null) {
            return other.acquireExperienceHierarchy == null;
        }
        if (!this.acquireExperienceHierarchy.equals(other.acquireExperienceHierarchy)) {
            return false;
        }
        if (this.experienceModelId == null) {
            return other.experienceModelId == null;
        }
        if (!this.experienceModelId.equals(other.experienceModelId)) {
            return false;
        }
        if (this.bonusRates == null) {
            return other.bonusRates == null;
        }
        return this.bonusRates.equals(other.bonusRates);
    }
}

