/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.core.net;

import io.gs2.core.net.Gs2RestResponse;
import io.gs2.core.net.IResponseHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.client.HttpClientBuilder;

public class HttpTask {
    private static HttpClient client = HttpClientBuilder.create().build();
    protected HttpRequestBase httpRequest;
    private IResponseHandler handler;

    public HttpTask(Method method, String url, IResponseHandler handler) {
        switch (method) {
            case GET: {
                this.httpRequest = new HttpGet(url);
                break;
            }
            case POST: {
                this.httpRequest = new HttpPost(url);
                break;
            }
            case PUT: {
                this.httpRequest = new HttpPut(url);
                break;
            }
            case DELETE: {
                this.httpRequest = new HttpDelete(url);
            }
        }
        this.handler = handler;
    }

    public void send() {
        new Thread(() -> {
            try {
                HttpResponse response = client.execute((HttpUriRequest)this.httpRequest);
                this.callback(this.httpRequest, response, true);
            }
            catch (IOException e) {
                try {
                    this.callback(this.httpRequest, null, false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }).start();
    }

    public HttpRequestBase getHttpRequest() {
        return this.httpRequest;
    }

    void callback(HttpRequestBase pHttpRequest, HttpResponse pHttpResponse, boolean isSuccessful) throws IOException {
        if (pHttpResponse != null) {
            int responseLength = (int)pHttpResponse.getEntity().getContentLength();
            byte[] responseBody = new byte[responseLength];
            try (InputStream in = pHttpResponse.getEntity().getContent();){
                for (int readSize = 0; readSize < responseLength; readSize += in.read(responseBody, readSize, responseLength - readSize)) {
                }
            }
            Gs2RestResponse gs2RestResponse = new Gs2RestResponse(new String(responseBody), pHttpResponse.getStatusLine().getStatusCode());
            this.handler.callback(gs2RestResponse);
        } else {
            Gs2RestResponse gs2RestResponse = new Gs2RestResponse("", 400);
            this.handler.callback(gs2RestResponse);
        }
    }

    public void addHeaderEntry(String key, String value) {
        this.httpRequest.addHeader(key, value);
    }

    public void setBody(byte[] body) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            bout.write(body);
            BasicHttpEntity entity = new BasicHttpEntity();
            entity.setContent((InputStream)new ByteArrayInputStream(bout.toByteArray()));
            if (this.httpRequest instanceof HttpPost) {
                ((HttpPost)this.httpRequest).setEntity((HttpEntity)entity);
            }
            if (this.httpRequest instanceof HttpPut) {
                ((HttpPut)this.httpRequest).setEntity((HttpEntity)entity);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

