/*
 * Copyright 2016 Game Server Services, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package io.gs2.formation.request;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.JsonNode;
import io.gs2.core.control.Gs2BasicRequest;

@SuppressWarnings("serial")
@JsonIgnoreProperties(ignoreUnknown=true)
public class GetPropertyFormByUserIdRequest extends Gs2BasicRequest<GetPropertyFormByUserIdRequest> {
    private String namespaceName;
    private String userId;
    private String propertyFormModelName;
    private String propertyId;
	public String getNamespaceName() {
		return namespaceName;
	}
	public void setNamespaceName(String namespaceName) {
		this.namespaceName = namespaceName;
	}
	public GetPropertyFormByUserIdRequest withNamespaceName(String namespaceName) {
		this.namespaceName = namespaceName;
		return this;
	}
	public String getUserId() {
		return userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}
	public GetPropertyFormByUserIdRequest withUserId(String userId) {
		this.userId = userId;
		return this;
	}
	public String getPropertyFormModelName() {
		return propertyFormModelName;
	}
	public void setPropertyFormModelName(String propertyFormModelName) {
		this.propertyFormModelName = propertyFormModelName;
	}
	public GetPropertyFormByUserIdRequest withPropertyFormModelName(String propertyFormModelName) {
		this.propertyFormModelName = propertyFormModelName;
		return this;
	}
	public String getPropertyId() {
		return propertyId;
	}
	public void setPropertyId(String propertyId) {
		this.propertyId = propertyId;
	}
	public GetPropertyFormByUserIdRequest withPropertyId(String propertyId) {
		this.propertyId = propertyId;
		return this;
	}

    public static GetPropertyFormByUserIdRequest fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new GetPropertyFormByUserIdRequest()
            .withNamespaceName(data.get("namespaceName") == null || data.get("namespaceName").isNull() ? null : data.get("namespaceName").asText())
            .withUserId(data.get("userId") == null || data.get("userId").isNull() ? null : data.get("userId").asText())
            .withPropertyFormModelName(data.get("propertyFormModelName") == null || data.get("propertyFormModelName").isNull() ? null : data.get("propertyFormModelName").asText())
            .withPropertyId(data.get("propertyId") == null || data.get("propertyId").isNull() ? null : data.get("propertyId").asText());
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree(
            new HashMap<String, Object>() {{
                put("namespaceName", getNamespaceName());
                put("userId", getUserId());
                put("propertyFormModelName", getPropertyFormModelName());
                put("propertyId", getPropertyId());
            }}
        );
    }
}