/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.watch;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gs2.AbstractGs2Client;
import io.gs2.model.IGs2Credential;
import io.gs2.model.Region;
import io.gs2.watch.control.CreateAlarmRequest;
import io.gs2.watch.control.CreateAlarmResult;
import io.gs2.watch.control.DeleteAlarmRequest;
import io.gs2.watch.control.DescribeAlarmEventRequest;
import io.gs2.watch.control.DescribeAlarmEventResult;
import io.gs2.watch.control.DescribeAlarmRequest;
import io.gs2.watch.control.DescribeAlarmResult;
import io.gs2.watch.control.DescribeOperationRequest;
import io.gs2.watch.control.DescribeOperationResult;
import io.gs2.watch.control.DescribeServiceRequest;
import io.gs2.watch.control.DescribeServiceResult;
import io.gs2.watch.control.GetAlarmRequest;
import io.gs2.watch.control.GetAlarmResult;
import io.gs2.watch.control.GetMetricRequest;
import io.gs2.watch.control.GetMetricResult;
import io.gs2.watch.control.UpdateAlarmRequest;
import io.gs2.watch.control.UpdateAlarmResult;
import java.util.ArrayList;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class Gs2WatchClient
extends AbstractGs2Client<Gs2WatchClient> {
    public static String ENDPOINT = "watch";

    public Gs2WatchClient(IGs2Credential credential) {
        super(credential);
    }

    public Gs2WatchClient(IGs2Credential credential, Region region) {
        super(credential, region);
    }

    public Gs2WatchClient(IGs2Credential credential, String region) {
        super(credential, region);
    }

    public CreateAlarmResult createAlarm(CreateAlarmRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("name", request.getName()).put("service", request.getService()).put("operation", request.getOperation()).put("expression", request.getExpression()).put("threshold", request.getThreshold()).put("notificationId", request.getNotificationId());
        if (request.getDescription() != null) {
            body.put("description", request.getDescription());
        }
        if (request.getServiceId() != null) {
            body.put("serviceId", request.getServiceId());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/alarm", this.credential, ENDPOINT, "Gs2Watch", "CreateAlarm", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CreateAlarmResult)this.doRequest((HttpUriRequest)post, CreateAlarmResult.class);
    }

    public void deleteAlarm(DeleteAlarmRequest request) {
        String url = "https://{service}.{region}.gs2io.com/alarm/" + (request.getAlarmName() == null || request.getAlarmName().equals("") ? "null" : request.getAlarmName()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Watch", "DeleteAlarm");
        if (request.getRequestId() != null) {
            delete.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        this.doRequest((HttpUriRequest)delete, null);
    }

    public DescribeAlarmResult describeAlarm(DescribeAlarmRequest request) {
        String url = "https://{service}.{region}.gs2io.com/alarm";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Watch", "DescribeAlarm");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeAlarmResult)this.doRequest((HttpUriRequest)get, DescribeAlarmResult.class);
    }

    public DescribeAlarmEventResult describeAlarmEvent(DescribeAlarmEventRequest request) {
        String url = "https://{service}.{region}.gs2io.com/alarm/" + (request.getAlarmName() == null || request.getAlarmName().equals("") ? "null" : request.getAlarmName()) + "/event";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Watch", "DescribeAlarmEvent");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeAlarmEventResult)this.doRequest((HttpUriRequest)get, DescribeAlarmEventResult.class);
    }

    public GetAlarmResult getAlarm(GetAlarmRequest request) {
        String url = "https://{service}.{region}.gs2io.com/alarm/" + (request.getAlarmName() == null || request.getAlarmName().equals("") ? "null" : request.getAlarmName()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Watch", "GetAlarm");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetAlarmResult)this.doRequest((HttpUriRequest)get, GetAlarmResult.class);
    }

    public UpdateAlarmResult updateAlarm(UpdateAlarmRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("expression", request.getExpression()).put("threshold", request.getThreshold()).put("notificationId", request.getNotificationId());
        if (request.getDescription() != null) {
            body.put("description", request.getDescription());
        }
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2io.com/alarm/" + (request.getAlarmName() == null || request.getAlarmName().equals("") ? "null" : request.getAlarmName()) + "", this.credential, ENDPOINT, "Gs2Watch", "UpdateAlarm", body.toString());
        if (request.getRequestId() != null) {
            put.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (UpdateAlarmResult)this.doRequest((HttpUriRequest)put, UpdateAlarmResult.class);
    }

    public DescribeOperationResult describeOperation(DescribeOperationRequest request) {
        String url = "https://{service}.{region}.gs2io.com/service/" + (request.getService() == null || request.getService().equals("") ? "null" : request.getService()) + "/operation";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Watch", "DescribeOperation");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeOperationResult)this.doRequest((HttpUriRequest)get, DescribeOperationResult.class);
    }

    public DescribeServiceResult describeService(DescribeServiceRequest request) {
        String url = "https://{service}.{region}.gs2io.com/service";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Watch", "DescribeService");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeServiceResult)this.doRequest((HttpUriRequest)get, DescribeServiceResult.class);
    }

    public GetMetricResult getMetric(GetMetricRequest request) {
        String url = "https://{service}.{region}.gs2io.com/metric/" + (request.getServiceId() == null || request.getServiceId().equals("") ? "null" : request.getServiceId()) + "/" + (request.getOperation() == null || request.getOperation().equals("") ? "null" : request.getOperation()) + "";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getBegin() != null) {
            queryString.add(new BasicNameValuePair("begin", String.valueOf(request.getBegin())));
        }
        if (request.getEnd() != null) {
            queryString.add(new BasicNameValuePair("end", String.valueOf(request.getEnd())));
        }
        if (request.getAllowLongTerm() != null) {
            queryString.add(new BasicNameValuePair("allowLongTerm", String.valueOf(request.getAllowLongTerm())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Watch", "GetMetric");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetMetricResult)this.doRequest((HttpUriRequest)get, GetMetricResult.class);
    }
}

