/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.showcase;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.gs2.AbstractGs2Client;
import io.gs2.model.IGs2Credential;
import io.gs2.model.Region;
import io.gs2.showcase.control.BuyItemRequest;
import io.gs2.showcase.control.BuyItemResult;
import io.gs2.showcase.control.CreateItemGroupMasterRequest;
import io.gs2.showcase.control.CreateItemGroupMasterResult;
import io.gs2.showcase.control.CreateItemMasterRequest;
import io.gs2.showcase.control.CreateItemMasterResult;
import io.gs2.showcase.control.CreateShowcaseItemMasterRequest;
import io.gs2.showcase.control.CreateShowcaseItemMasterResult;
import io.gs2.showcase.control.CreateShowcaseRequest;
import io.gs2.showcase.control.CreateShowcaseResult;
import io.gs2.showcase.control.DeleteItemGroupMasterRequest;
import io.gs2.showcase.control.DeleteItemMasterRequest;
import io.gs2.showcase.control.DeleteShowcaseItemMasterRequest;
import io.gs2.showcase.control.DeleteShowcaseRequest;
import io.gs2.showcase.control.DescribeItemGroupMasterRequest;
import io.gs2.showcase.control.DescribeItemGroupMasterResult;
import io.gs2.showcase.control.DescribeItemMasterRequest;
import io.gs2.showcase.control.DescribeItemMasterResult;
import io.gs2.showcase.control.DescribeItemRequest;
import io.gs2.showcase.control.DescribeItemResult;
import io.gs2.showcase.control.DescribeShowcaseItemMasterRequest;
import io.gs2.showcase.control.DescribeShowcaseItemMasterResult;
import io.gs2.showcase.control.DescribeShowcaseRequest;
import io.gs2.showcase.control.DescribeShowcaseResult;
import io.gs2.showcase.control.ExportMasterRequest;
import io.gs2.showcase.control.ExportMasterResult;
import io.gs2.showcase.control.GetCurrentShowcaseMasterRequest;
import io.gs2.showcase.control.GetCurrentShowcaseMasterResult;
import io.gs2.showcase.control.GetItemGroupMasterRequest;
import io.gs2.showcase.control.GetItemGroupMasterResult;
import io.gs2.showcase.control.GetItemMasterRequest;
import io.gs2.showcase.control.GetItemMasterResult;
import io.gs2.showcase.control.GetItemRequest;
import io.gs2.showcase.control.GetItemResult;
import io.gs2.showcase.control.GetShowcaseItemMasterRequest;
import io.gs2.showcase.control.GetShowcaseItemMasterResult;
import io.gs2.showcase.control.GetShowcaseRequest;
import io.gs2.showcase.control.GetShowcaseResult;
import io.gs2.showcase.control.GetShowcaseStatusRequest;
import io.gs2.showcase.control.GetShowcaseStatusResult;
import io.gs2.showcase.control.UpdateCurrentShowcaseMasterRequest;
import io.gs2.showcase.control.UpdateCurrentShowcaseMasterResult;
import io.gs2.showcase.control.UpdateItemGroupMasterRequest;
import io.gs2.showcase.control.UpdateItemGroupMasterResult;
import io.gs2.showcase.control.UpdateItemMasterRequest;
import io.gs2.showcase.control.UpdateItemMasterResult;
import io.gs2.showcase.control.UpdateShowcaseItemMasterRequest;
import io.gs2.showcase.control.UpdateShowcaseItemMasterResult;
import io.gs2.showcase.control.UpdateShowcaseRequest;
import io.gs2.showcase.control.UpdateShowcaseResult;
import java.util.ArrayList;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class Gs2ShowcaseClient
extends AbstractGs2Client<Gs2ShowcaseClient> {
    public static String ENDPOINT = "showcase";

    public Gs2ShowcaseClient(IGs2Credential credential) {
        super(credential);
    }

    public Gs2ShowcaseClient(IGs2Credential credential, Region region) {
        super(credential, region);
    }

    public Gs2ShowcaseClient(IGs2Credential credential, String region) {
        super(credential, region);
    }

    public GetCurrentShowcaseMasterResult getCurrentShowcaseMaster(GetCurrentShowcaseMasterRequest request) {
        String url = "https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/item/master";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Showcase", "GetCurrentShowcaseMaster");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetCurrentShowcaseMasterResult)this.doRequest((HttpUriRequest)get, GetCurrentShowcaseMasterResult.class);
    }

    public UpdateCurrentShowcaseMasterResult updateCurrentShowcaseMaster(UpdateCurrentShowcaseMasterRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("settings", request.getSettings());
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/item/master", this.credential, ENDPOINT, "Gs2Showcase", "UpdateCurrentShowcaseMaster", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (UpdateCurrentShowcaseMasterResult)this.doRequest((HttpUriRequest)post, UpdateCurrentShowcaseMasterResult.class);
    }

    public CreateItemGroupMasterResult createItemGroupMaster(CreateItemGroupMasterRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("name", request.getName());
        if (request.getItemNames() != null) {
            ArrayList<TextNode> node = new ArrayList<TextNode>();
            for (String item : request.getItemNames()) {
                node.add(JsonNodeFactory.instance.textNode(item));
            }
            body.set("itemNames", (JsonNode)JsonNodeFactory.instance.arrayNode().addAll(node));
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/master/itemGroup", this.credential, ENDPOINT, "Gs2Showcase", "CreateItemGroupMaster", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CreateItemGroupMasterResult)this.doRequest((HttpUriRequest)post, CreateItemGroupMasterResult.class);
    }

    public void deleteItemGroupMaster(DeleteItemGroupMasterRequest request) {
        String url = "https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/master/itemGroup/" + (request.getItemGroupName() == null || request.getItemGroupName().equals("") ? "null" : request.getItemGroupName()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Showcase", "DeleteItemGroupMaster");
        if (request.getRequestId() != null) {
            delete.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        this.doRequest((HttpUriRequest)delete, null);
    }

    public DescribeItemGroupMasterResult describeItemGroupMaster(DescribeItemGroupMasterRequest request) {
        String url = "https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/master/itemGroup";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Showcase", "DescribeItemGroupMaster");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeItemGroupMasterResult)this.doRequest((HttpUriRequest)get, DescribeItemGroupMasterResult.class);
    }

    public GetItemGroupMasterResult getItemGroupMaster(GetItemGroupMasterRequest request) {
        String url = "https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/master/itemGroup/" + (request.getItemGroupName() == null || request.getItemGroupName().equals("") ? "null" : request.getItemGroupName()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Showcase", "GetItemGroupMaster");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetItemGroupMasterResult)this.doRequest((HttpUriRequest)get, GetItemGroupMasterResult.class);
    }

    public UpdateItemGroupMasterResult updateItemGroupMaster(UpdateItemGroupMasterRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode();
        if (request.getItemNames() != null) {
            ArrayList<TextNode> node = new ArrayList<TextNode>();
            for (String item : request.getItemNames()) {
                node.add(JsonNodeFactory.instance.textNode(item));
            }
            body.set("itemNames", (JsonNode)JsonNodeFactory.instance.arrayNode().addAll(node));
        }
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/master/itemGroup/" + (request.getItemGroupName() == null || request.getItemGroupName().equals("") ? "null" : request.getItemGroupName()) + "", this.credential, ENDPOINT, "Gs2Showcase", "UpdateItemGroupMaster", body.toString());
        if (request.getRequestId() != null) {
            put.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (UpdateItemGroupMasterResult)this.doRequest((HttpUriRequest)put, UpdateItemGroupMasterResult.class);
    }

    public CreateItemMasterResult createItemMaster(CreateItemMasterRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("name", request.getName()).put("currencyType", request.getCurrencyType()).put("price", request.getPrice()).put("itemType", request.getItemType()).put("itemAmount", request.getItemAmount());
        if (request.getMeta() != null) {
            body.put("meta", request.getMeta());
        }
        if (request.getCurrencyMoneyName() != null) {
            body.put("currencyMoneyName", request.getCurrencyMoneyName());
        }
        if (request.getCurrencyGoldName() != null) {
            body.put("currencyGoldName", request.getCurrencyGoldName());
        }
        if (request.getCurrencyConsumableItemItemPoolName() != null) {
            body.put("currencyConsumableItemItemPoolName", request.getCurrencyConsumableItemItemPoolName());
        }
        if (request.getCurrencyConsumableItemItemName() != null) {
            body.put("currencyConsumableItemItemName", request.getCurrencyConsumableItemItemName());
        }
        if (request.getCurrencyOption() != null) {
            body.put("currencyOption", request.getCurrencyOption());
        }
        if (request.getItemMoneyName() != null) {
            body.put("itemMoneyName", request.getItemMoneyName());
        }
        if (request.getItemGoldName() != null) {
            body.put("itemGoldName", request.getItemGoldName());
        }
        if (request.getItemStaminaStaminaPoolName() != null) {
            body.put("itemStaminaStaminaPoolName", request.getItemStaminaStaminaPoolName());
        }
        if (request.getItemConsumableItemItemPoolName() != null) {
            body.put("itemConsumableItemItemPoolName", request.getItemConsumableItemItemPoolName());
        }
        if (request.getItemConsumableItemItemName() != null) {
            body.put("itemConsumableItemItemName", request.getItemConsumableItemItemName());
        }
        if (request.getItemGachaGachaPoolName() != null) {
            body.put("itemGachaGachaPoolName", request.getItemGachaGachaPoolName());
        }
        if (request.getItemGachaGachaName() != null) {
            body.put("itemGachaGachaName", request.getItemGachaGachaName());
        }
        if (request.getItemOption() != null) {
            body.put("itemOption", request.getItemOption());
        }
        if (request.getOpenConditionType() != null) {
            body.put("openConditionType", request.getOpenConditionType());
        }
        if (request.getOpenConditionLimitName() != null) {
            body.put("openConditionLimitName", request.getOpenConditionLimitName());
        }
        if (request.getOpenConditionLimitCounterName() != null) {
            body.put("openConditionLimitCounterName", request.getOpenConditionLimitCounterName());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/master/item", this.credential, ENDPOINT, "Gs2Showcase", "CreateItemMaster", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CreateItemMasterResult)this.doRequest((HttpUriRequest)post, CreateItemMasterResult.class);
    }

    public void deleteItemMaster(DeleteItemMasterRequest request) {
        String url = "https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/master/item/" + (request.getItemName() == null || request.getItemName().equals("") ? "null" : request.getItemName()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Showcase", "DeleteItemMaster");
        if (request.getRequestId() != null) {
            delete.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        this.doRequest((HttpUriRequest)delete, null);
    }

    public DescribeItemMasterResult describeItemMaster(DescribeItemMasterRequest request) {
        String url = "https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/master/item";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Showcase", "DescribeItemMaster");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeItemMasterResult)this.doRequest((HttpUriRequest)get, DescribeItemMasterResult.class);
    }

    public GetItemMasterResult getItemMaster(GetItemMasterRequest request) {
        String url = "https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/master/item/" + (request.getItemName() == null || request.getItemName().equals("") ? "null" : request.getItemName()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Showcase", "GetItemMaster");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetItemMasterResult)this.doRequest((HttpUriRequest)get, GetItemMasterResult.class);
    }

    public UpdateItemMasterResult updateItemMaster(UpdateItemMasterRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("currencyType", request.getCurrencyType()).put("price", request.getPrice()).put("itemType", request.getItemType()).put("itemAmount", request.getItemAmount());
        if (request.getMeta() != null) {
            body.put("meta", request.getMeta());
        }
        if (request.getCurrencyMoneyName() != null) {
            body.put("currencyMoneyName", request.getCurrencyMoneyName());
        }
        if (request.getCurrencyGoldName() != null) {
            body.put("currencyGoldName", request.getCurrencyGoldName());
        }
        if (request.getCurrencyConsumableItemItemPoolName() != null) {
            body.put("currencyConsumableItemItemPoolName", request.getCurrencyConsumableItemItemPoolName());
        }
        if (request.getCurrencyConsumableItemItemName() != null) {
            body.put("currencyConsumableItemItemName", request.getCurrencyConsumableItemItemName());
        }
        if (request.getCurrencyOption() != null) {
            body.put("currencyOption", request.getCurrencyOption());
        }
        if (request.getItemMoneyName() != null) {
            body.put("itemMoneyName", request.getItemMoneyName());
        }
        if (request.getItemGoldName() != null) {
            body.put("itemGoldName", request.getItemGoldName());
        }
        if (request.getItemStaminaStaminaPoolName() != null) {
            body.put("itemStaminaStaminaPoolName", request.getItemStaminaStaminaPoolName());
        }
        if (request.getItemConsumableItemItemPoolName() != null) {
            body.put("itemConsumableItemItemPoolName", request.getItemConsumableItemItemPoolName());
        }
        if (request.getItemConsumableItemItemName() != null) {
            body.put("itemConsumableItemItemName", request.getItemConsumableItemItemName());
        }
        if (request.getItemGachaGachaPoolName() != null) {
            body.put("itemGachaGachaPoolName", request.getItemGachaGachaPoolName());
        }
        if (request.getItemGachaGachaName() != null) {
            body.put("itemGachaGachaName", request.getItemGachaGachaName());
        }
        if (request.getItemOption() != null) {
            body.put("itemOption", request.getItemOption());
        }
        if (request.getOpenConditionType() != null) {
            body.put("openConditionType", request.getOpenConditionType());
        }
        if (request.getOpenConditionLimitName() != null) {
            body.put("openConditionLimitName", request.getOpenConditionLimitName());
        }
        if (request.getOpenConditionLimitCounterName() != null) {
            body.put("openConditionLimitCounterName", request.getOpenConditionLimitCounterName());
        }
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/master/item/" + (request.getItemName() == null || request.getItemName().equals("") ? "null" : request.getItemName()) + "", this.credential, ENDPOINT, "Gs2Showcase", "UpdateItemMaster", body.toString());
        if (request.getRequestId() != null) {
            put.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (UpdateItemMasterResult)this.doRequest((HttpUriRequest)put, UpdateItemMasterResult.class);
    }

    public BuyItemResult buyItem(BuyItemRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("keyName", request.getKeyName());
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/item/" + (request.getShowcaseItemId() == null || request.getShowcaseItemId().equals("") ? "null" : request.getShowcaseItemId()) + "", this.credential, ENDPOINT, "Gs2Showcase", "BuyItem", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        post.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (BuyItemResult)this.doRequest((HttpUriRequest)post, BuyItemResult.class);
    }

    public DescribeItemResult describeItem(DescribeItemRequest request) {
        String url = "https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/item";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Showcase", "DescribeItem");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        get.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (DescribeItemResult)this.doRequest((HttpUriRequest)get, DescribeItemResult.class);
    }

    public GetItemResult getItem(GetItemRequest request) {
        String url = "https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/item/" + (request.getShowcaseItemId() == null || request.getShowcaseItemId().equals("") ? "null" : request.getShowcaseItemId()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Showcase", "GetItem");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        get.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (GetItemResult)this.doRequest((HttpUriRequest)get, GetItemResult.class);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        String url = "https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/master";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Showcase", "ExportMaster");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (ExportMasterResult)this.doRequest((HttpUriRequest)get, ExportMasterResult.class);
    }

    public CreateShowcaseItemMasterResult createShowcaseItemMaster(CreateShowcaseItemMasterRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("category", request.getCategory()).put("priority", request.getPriority());
        if (request.getItemName() != null) {
            body.put("itemName", request.getItemName());
        }
        if (request.getItemGroupName() != null) {
            body.put("itemGroupName", request.getItemGroupName());
        }
        if (request.getReleaseConditionType() != null) {
            body.put("releaseConditionType", request.getReleaseConditionType());
        }
        if (request.getReleaseConditionScheduleName() != null) {
            body.put("releaseConditionScheduleName", request.getReleaseConditionScheduleName());
        }
        if (request.getReleaseConditionScheduleEventName() != null) {
            body.put("releaseConditionScheduleEventName", request.getReleaseConditionScheduleEventName());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/master/showcaseItem", this.credential, ENDPOINT, "Gs2Showcase", "CreateShowcaseItemMaster", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CreateShowcaseItemMasterResult)this.doRequest((HttpUriRequest)post, CreateShowcaseItemMasterResult.class);
    }

    public void deleteShowcaseItemMaster(DeleteShowcaseItemMasterRequest request) {
        String url = "https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/master/showcaseItem/" + (request.getCategory() == null || request.getCategory().equals("") ? "null" : request.getCategory()) + "/" + (request.getResourceId() == null || request.getResourceId().equals("") ? "null" : request.getResourceId()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Showcase", "DeleteShowcaseItemMaster");
        if (request.getRequestId() != null) {
            delete.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        this.doRequest((HttpUriRequest)delete, null);
    }

    public DescribeShowcaseItemMasterResult describeShowcaseItemMaster(DescribeShowcaseItemMasterRequest request) {
        String url = "https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/master/showcaseItem";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Showcase", "DescribeShowcaseItemMaster");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeShowcaseItemMasterResult)this.doRequest((HttpUriRequest)get, DescribeShowcaseItemMasterResult.class);
    }

    public GetShowcaseItemMasterResult getShowcaseItemMaster(GetShowcaseItemMasterRequest request) {
        String url = "https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/master/showcaseItem/" + (request.getCategory() == null || request.getCategory().equals("") ? "null" : request.getCategory()) + "/" + (request.getResourceId() == null || request.getResourceId().equals("") ? "null" : request.getResourceId()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Showcase", "GetShowcaseItemMaster");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetShowcaseItemMasterResult)this.doRequest((HttpUriRequest)get, GetShowcaseItemMasterResult.class);
    }

    public UpdateShowcaseItemMasterResult updateShowcaseItemMaster(UpdateShowcaseItemMasterRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("releaseConditionType", request.getReleaseConditionType()).put("priority", request.getPriority());
        if (request.getReleaseConditionScheduleName() != null) {
            body.put("releaseConditionScheduleName", request.getReleaseConditionScheduleName());
        }
        if (request.getReleaseConditionScheduleEventName() != null) {
            body.put("releaseConditionScheduleEventName", request.getReleaseConditionScheduleEventName());
        }
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/master/showcaseItem/" + (request.getCategory() == null || request.getCategory().equals("") ? "null" : request.getCategory()) + "/" + (request.getResourceId() == null || request.getResourceId().equals("") ? "null" : request.getResourceId()) + "", this.credential, ENDPOINT, "Gs2Showcase", "UpdateShowcaseItemMaster", body.toString());
        if (request.getRequestId() != null) {
            put.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (UpdateShowcaseItemMasterResult)this.doRequest((HttpUriRequest)put, UpdateShowcaseItemMasterResult.class);
    }

    public CreateShowcaseResult createShowcase(CreateShowcaseRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("name", request.getName());
        if (request.getDescription() != null) {
            body.put("description", request.getDescription());
        }
        if (request.getReleaseConditionTriggerScript() != null) {
            body.put("releaseConditionTriggerScript", request.getReleaseConditionTriggerScript());
        }
        if (request.getBuyTriggerScript() != null) {
            body.put("buyTriggerScript", request.getBuyTriggerScript());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/showcase", this.credential, ENDPOINT, "Gs2Showcase", "CreateShowcase", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CreateShowcaseResult)this.doRequest((HttpUriRequest)post, CreateShowcaseResult.class);
    }

    public void deleteShowcase(DeleteShowcaseRequest request) {
        String url = "https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Showcase", "DeleteShowcase");
        if (request.getRequestId() != null) {
            delete.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        this.doRequest((HttpUriRequest)delete, null);
    }

    public DescribeShowcaseResult describeShowcase(DescribeShowcaseRequest request) {
        String url = "https://{service}.{region}.gs2io.com/showcase";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Showcase", "DescribeShowcase");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeShowcaseResult)this.doRequest((HttpUriRequest)get, DescribeShowcaseResult.class);
    }

    public GetShowcaseResult getShowcase(GetShowcaseRequest request) {
        String url = "https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Showcase", "GetShowcase");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetShowcaseResult)this.doRequest((HttpUriRequest)get, GetShowcaseResult.class);
    }

    public GetShowcaseStatusResult getShowcaseStatus(GetShowcaseStatusRequest request) {
        String url = "https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "/status";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Showcase", "GetShowcaseStatus");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetShowcaseStatusResult)this.doRequest((HttpUriRequest)get, GetShowcaseStatusResult.class);
    }

    public UpdateShowcaseResult updateShowcase(UpdateShowcaseRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode();
        if (request.getDescription() != null) {
            body.put("description", request.getDescription());
        }
        if (request.getReleaseConditionTriggerScript() != null) {
            body.put("releaseConditionTriggerScript", request.getReleaseConditionTriggerScript());
        }
        if (request.getBuyTriggerScript() != null) {
            body.put("buyTriggerScript", request.getBuyTriggerScript());
        }
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2io.com/showcase/" + (request.getShowcaseName() == null || request.getShowcaseName().equals("") ? "null" : request.getShowcaseName()) + "", this.credential, ENDPOINT, "Gs2Showcase", "UpdateShowcase", body.toString());
        if (request.getRequestId() != null) {
            put.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (UpdateShowcaseResult)this.doRequest((HttpUriRequest)put, UpdateShowcaseResult.class);
    }
}

