/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.mission;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gs2.AbstractGs2Client;
import io.gs2.mission.model.AcquireAction;
import io.gs2.mission.model.Config;
import io.gs2.mission.model.CounterScopeModel;
import io.gs2.mission.model.NotificationSetting;
import io.gs2.mission.request.CompleteByUserIdRequest;
import io.gs2.mission.request.CompleteRequest;
import io.gs2.mission.request.CreateCounterModelMasterRequest;
import io.gs2.mission.request.CreateMissionGroupModelMasterRequest;
import io.gs2.mission.request.CreateMissionTaskModelMasterRequest;
import io.gs2.mission.request.CreateNamespaceRequest;
import io.gs2.mission.request.DeleteCompleteByUserIdRequest;
import io.gs2.mission.request.DeleteCounterByUserIdRequest;
import io.gs2.mission.request.DeleteCounterModelMasterRequest;
import io.gs2.mission.request.DeleteMissionGroupModelMasterRequest;
import io.gs2.mission.request.DeleteMissionTaskModelMasterRequest;
import io.gs2.mission.request.DeleteNamespaceRequest;
import io.gs2.mission.request.DescribeCompletesByUserIdRequest;
import io.gs2.mission.request.DescribeCompletesRequest;
import io.gs2.mission.request.DescribeCounterModelMastersRequest;
import io.gs2.mission.request.DescribeCounterModelsRequest;
import io.gs2.mission.request.DescribeCountersByUserIdRequest;
import io.gs2.mission.request.DescribeCountersRequest;
import io.gs2.mission.request.DescribeMissionGroupModelMastersRequest;
import io.gs2.mission.request.DescribeMissionGroupModelsRequest;
import io.gs2.mission.request.DescribeMissionTaskModelMastersRequest;
import io.gs2.mission.request.DescribeMissionTaskModelsRequest;
import io.gs2.mission.request.DescribeNamespacesRequest;
import io.gs2.mission.request.ExportMasterRequest;
import io.gs2.mission.request.GetCompleteByUserIdRequest;
import io.gs2.mission.request.GetCompleteRequest;
import io.gs2.mission.request.GetCounterByUserIdRequest;
import io.gs2.mission.request.GetCounterModelMasterRequest;
import io.gs2.mission.request.GetCounterModelRequest;
import io.gs2.mission.request.GetCounterRequest;
import io.gs2.mission.request.GetCurrentMissionMasterRequest;
import io.gs2.mission.request.GetMissionGroupModelMasterRequest;
import io.gs2.mission.request.GetMissionGroupModelRequest;
import io.gs2.mission.request.GetMissionTaskModelMasterRequest;
import io.gs2.mission.request.GetMissionTaskModelRequest;
import io.gs2.mission.request.GetNamespaceRequest;
import io.gs2.mission.request.GetNamespaceStatusRequest;
import io.gs2.mission.request.IncreaseByStampSheetRequest;
import io.gs2.mission.request.IncreaseCounterByUserIdRequest;
import io.gs2.mission.request.ReceiveByStampTaskRequest;
import io.gs2.mission.request.ReceiveByUserIdRequest;
import io.gs2.mission.request.UpdateCounterModelMasterRequest;
import io.gs2.mission.request.UpdateCurrentMissionMasterRequest;
import io.gs2.mission.request.UpdateMissionGroupModelMasterRequest;
import io.gs2.mission.request.UpdateMissionTaskModelMasterRequest;
import io.gs2.mission.request.UpdateNamespaceRequest;
import io.gs2.mission.result.CompleteByUserIdResult;
import io.gs2.mission.result.CompleteResult;
import io.gs2.mission.result.CreateCounterModelMasterResult;
import io.gs2.mission.result.CreateMissionGroupModelMasterResult;
import io.gs2.mission.result.CreateMissionTaskModelMasterResult;
import io.gs2.mission.result.CreateNamespaceResult;
import io.gs2.mission.result.DeleteCompleteByUserIdResult;
import io.gs2.mission.result.DeleteCounterByUserIdResult;
import io.gs2.mission.result.DeleteCounterModelMasterResult;
import io.gs2.mission.result.DeleteMissionGroupModelMasterResult;
import io.gs2.mission.result.DeleteMissionTaskModelMasterResult;
import io.gs2.mission.result.DeleteNamespaceResult;
import io.gs2.mission.result.DescribeCompletesByUserIdResult;
import io.gs2.mission.result.DescribeCompletesResult;
import io.gs2.mission.result.DescribeCounterModelMastersResult;
import io.gs2.mission.result.DescribeCounterModelsResult;
import io.gs2.mission.result.DescribeCountersByUserIdResult;
import io.gs2.mission.result.DescribeCountersResult;
import io.gs2.mission.result.DescribeMissionGroupModelMastersResult;
import io.gs2.mission.result.DescribeMissionGroupModelsResult;
import io.gs2.mission.result.DescribeMissionTaskModelMastersResult;
import io.gs2.mission.result.DescribeMissionTaskModelsResult;
import io.gs2.mission.result.DescribeNamespacesResult;
import io.gs2.mission.result.ExportMasterResult;
import io.gs2.mission.result.GetCompleteByUserIdResult;
import io.gs2.mission.result.GetCompleteResult;
import io.gs2.mission.result.GetCounterByUserIdResult;
import io.gs2.mission.result.GetCounterModelMasterResult;
import io.gs2.mission.result.GetCounterModelResult;
import io.gs2.mission.result.GetCounterResult;
import io.gs2.mission.result.GetCurrentMissionMasterResult;
import io.gs2.mission.result.GetMissionGroupModelMasterResult;
import io.gs2.mission.result.GetMissionGroupModelResult;
import io.gs2.mission.result.GetMissionTaskModelMasterResult;
import io.gs2.mission.result.GetMissionTaskModelResult;
import io.gs2.mission.result.GetNamespaceResult;
import io.gs2.mission.result.GetNamespaceStatusResult;
import io.gs2.mission.result.IncreaseByStampSheetResult;
import io.gs2.mission.result.IncreaseCounterByUserIdResult;
import io.gs2.mission.result.ReceiveByStampTaskResult;
import io.gs2.mission.result.ReceiveByUserIdResult;
import io.gs2.mission.result.UpdateCounterModelMasterResult;
import io.gs2.mission.result.UpdateCurrentMissionMasterResult;
import io.gs2.mission.result.UpdateMissionGroupModelMasterResult;
import io.gs2.mission.result.UpdateMissionTaskModelMasterResult;
import io.gs2.mission.result.UpdateNamespaceResult;
import io.gs2.model.IGs2Credential;
import io.gs2.model.Region;
import java.util.ArrayList;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class Gs2MissionRestClient
extends AbstractGs2Client<Gs2MissionRestClient> {
    public static String ENDPOINT = "mission";

    public Gs2MissionRestClient(IGs2Credential credential) {
        super(credential);
    }

    public Gs2MissionRestClient(IGs2Credential credential, Region region) {
        super(credential, region);
    }

    public Gs2MissionRestClient(IGs2Credential credential, String region) {
        super(credential, region);
    }

    public DescribeMissionGroupModelsResult describeMissionGroupModels(DescribeMissionGroupModelsRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FMissionGroupModelFunctionHandler.describeMissionGroupModels";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeMissionGroupModelsResult)this.doRequest((HttpUriRequest)http, DescribeMissionGroupModelsResult.class);
    }

    public GetMissionGroupModelResult getMissionGroupModel(GetMissionGroupModelRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FMissionGroupModelFunctionHandler.getMissionGroupModel";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String missionGroupName = null;
        if (request.getMissionGroupName() != null) {
            missionGroupName = request.getMissionGroupName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (missionGroupName != null) {
            _queryString.add(new BasicNameValuePair("missionGroupName", String.valueOf(missionGroupName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetMissionGroupModelResult)this.doRequest((HttpUriRequest)http, GetMissionGroupModelResult.class);
    }

    public DescribeMissionGroupModelMastersResult describeMissionGroupModelMasters(DescribeMissionGroupModelMastersRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FMissionGroupModelMasterFunctionHandler.describeMissionGroupModelMasters";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String pageToken = String.valueOf(request.getPageToken());
        String limit = String.valueOf(request.getLimit());
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (pageToken != null) {
            _queryString.add(new BasicNameValuePair("pageToken", String.valueOf(pageToken)));
        }
        if (limit != null) {
            _queryString.add(new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeMissionGroupModelMastersResult)this.doRequest((HttpUriRequest)http, DescribeMissionGroupModelMastersResult.class);
    }

    public CreateMissionGroupModelMasterResult createMissionGroupModelMaster(CreateMissionGroupModelMasterRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FMissionGroupModelMasterFunctionHandler.createMissionGroupModelMaster";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String name = null;
        if (request.getName() != null) {
            name = request.getName();
        }
        String metadata = null;
        if (request.getMetadata() != null) {
            metadata = request.getMetadata();
        }
        String description = null;
        if (request.getDescription() != null) {
            description = request.getDescription();
        }
        String completeNotificationNamespaceId = null;
        if (request.getCompleteNotificationNamespaceId() != null) {
            completeNotificationNamespaceId = request.getCompleteNotificationNamespaceId();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (name != null) {
            _body.put("name", name);
        }
        if (metadata != null) {
            _body.put("metadata", metadata);
        }
        if (description != null) {
            _body.put("description", description);
        }
        if (completeNotificationNamespaceId != null) {
            _body.put("completeNotificationNamespaceId", completeNotificationNamespaceId);
        }
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CreateMissionGroupModelMasterResult)this.doRequest((HttpUriRequest)http, CreateMissionGroupModelMasterResult.class);
    }

    public GetMissionGroupModelMasterResult getMissionGroupModelMaster(GetMissionGroupModelMasterRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FMissionGroupModelMasterFunctionHandler.getMissionGroupModelMaster";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String missionGroupName = null;
        if (request.getMissionGroupName() != null) {
            missionGroupName = request.getMissionGroupName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (missionGroupName != null) {
            _queryString.add(new BasicNameValuePair("missionGroupName", String.valueOf(missionGroupName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetMissionGroupModelMasterResult)this.doRequest((HttpUriRequest)http, GetMissionGroupModelMasterResult.class);
    }

    public UpdateMissionGroupModelMasterResult updateMissionGroupModelMaster(UpdateMissionGroupModelMasterRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FMissionGroupModelMasterFunctionHandler.updateMissionGroupModelMaster";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String missionGroupName = null;
        if (request.getMissionGroupName() != null) {
            missionGroupName = request.getMissionGroupName();
        }
        String metadata = null;
        if (request.getMetadata() != null) {
            metadata = request.getMetadata();
        }
        String description = null;
        if (request.getDescription() != null) {
            description = request.getDescription();
        }
        String completeNotificationNamespaceId = null;
        if (request.getCompleteNotificationNamespaceId() != null) {
            completeNotificationNamespaceId = request.getCompleteNotificationNamespaceId();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (missionGroupName != null) {
            _queryString.add(new BasicNameValuePair("missionGroupName", String.valueOf(missionGroupName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (metadata != null) {
            _body.put("metadata", metadata);
        }
        if (description != null) {
            _body.put("description", description);
        }
        if (completeNotificationNamespaceId != null) {
            _body.put("completeNotificationNamespaceId", completeNotificationNamespaceId);
        }
        HttpPut http = this.createHttpPut(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (UpdateMissionGroupModelMasterResult)this.doRequest((HttpUriRequest)http, UpdateMissionGroupModelMasterResult.class);
    }

    public DeleteMissionGroupModelMasterResult deleteMissionGroupModelMaster(DeleteMissionGroupModelMasterRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FMissionGroupModelMasterFunctionHandler.deleteMissionGroupModelMaster";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String missionGroupName = null;
        if (request.getMissionGroupName() != null) {
            missionGroupName = request.getMissionGroupName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (missionGroupName != null) {
            _queryString.add(new BasicNameValuePair("missionGroupName", String.valueOf(missionGroupName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpDelete http = this.createHttpDelete(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DeleteMissionGroupModelMasterResult)this.doRequest((HttpUriRequest)http, DeleteMissionGroupModelMasterResult.class);
    }

    public DescribeCounterModelsResult describeCounterModels(DescribeCounterModelsRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCounterModelFunctionHandler.describeCounterModels";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeCounterModelsResult)this.doRequest((HttpUriRequest)http, DescribeCounterModelsResult.class);
    }

    public GetCounterModelResult getCounterModel(GetCounterModelRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCounterModelFunctionHandler.getCounterModel";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String counterName = null;
        if (request.getCounterName() != null) {
            counterName = request.getCounterName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (counterName != null) {
            _queryString.add(new BasicNameValuePair("counterName", String.valueOf(counterName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetCounterModelResult)this.doRequest((HttpUriRequest)http, GetCounterModelResult.class);
    }

    public DescribeMissionTaskModelsResult describeMissionTaskModels(DescribeMissionTaskModelsRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FMissionTaskModelFunctionHandler.describeMissionTaskModels";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String missionGroupName = null;
        if (request.getMissionGroupName() != null) {
            missionGroupName = request.getMissionGroupName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (missionGroupName != null) {
            _queryString.add(new BasicNameValuePair("missionGroupName", String.valueOf(missionGroupName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeMissionTaskModelsResult)this.doRequest((HttpUriRequest)http, DescribeMissionTaskModelsResult.class);
    }

    public GetMissionTaskModelResult getMissionTaskModel(GetMissionTaskModelRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FMissionTaskModelFunctionHandler.getMissionTaskModel";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String missionGroupName = null;
        if (request.getMissionGroupName() != null) {
            missionGroupName = request.getMissionGroupName();
        }
        String missionTaskName = null;
        if (request.getMissionTaskName() != null) {
            missionTaskName = request.getMissionTaskName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (missionGroupName != null) {
            _queryString.add(new BasicNameValuePair("missionGroupName", String.valueOf(missionGroupName)));
        }
        if (missionTaskName != null) {
            _queryString.add(new BasicNameValuePair("missionTaskName", String.valueOf(missionTaskName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetMissionTaskModelResult)this.doRequest((HttpUriRequest)http, GetMissionTaskModelResult.class);
    }

    public DescribeCountersResult describeCounters(DescribeCountersRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCounterFunctionHandler.describeCounters";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String pageToken = String.valueOf(request.getPageToken());
        String limit = String.valueOf(request.getLimit());
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (pageToken != null) {
            _queryString.add(new BasicNameValuePair("pageToken", String.valueOf(pageToken)));
        }
        if (limit != null) {
            _queryString.add(new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        http.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (DescribeCountersResult)this.doRequest((HttpUriRequest)http, DescribeCountersResult.class);
    }

    public DescribeCountersByUserIdResult describeCountersByUserId(DescribeCountersByUserIdRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCounterFunctionHandler.describeCountersByUserId";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String userId = null;
        if (request.getUserId() != null) {
            userId = request.getUserId();
        }
        String pageToken = String.valueOf(request.getPageToken());
        String limit = String.valueOf(request.getLimit());
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (userId != null) {
            _queryString.add(new BasicNameValuePair("userId", String.valueOf(userId)));
        }
        if (pageToken != null) {
            _queryString.add(new BasicNameValuePair("pageToken", String.valueOf(pageToken)));
        }
        if (limit != null) {
            _queryString.add(new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (DescribeCountersByUserIdResult)this.doRequest((HttpUriRequest)http, DescribeCountersByUserIdResult.class);
    }

    public IncreaseCounterByUserIdResult increaseCounterByUserId(IncreaseCounterByUserIdRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCounterFunctionHandler.increaseCounterByUserId";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String counterName = null;
        if (request.getCounterName() != null) {
            counterName = request.getCounterName();
        }
        String userId = null;
        if (request.getUserId() != null) {
            userId = request.getUserId();
        }
        Long value = null;
        if (request.getValue() != null) {
            value = request.getValue();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (counterName != null) {
            _queryString.add(new BasicNameValuePair("counterName", String.valueOf(counterName)));
        }
        if (userId != null) {
            _queryString.add(new BasicNameValuePair("userId", String.valueOf(userId)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (value != null) {
            _body.put("value", value);
        }
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (IncreaseCounterByUserIdResult)this.doRequest((HttpUriRequest)http, IncreaseCounterByUserIdResult.class);
    }

    public GetCounterResult getCounter(GetCounterRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCounterFunctionHandler.getCounter";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String counterName = null;
        if (request.getCounterName() != null) {
            counterName = request.getCounterName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (counterName != null) {
            _queryString.add(new BasicNameValuePair("counterName", String.valueOf(counterName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        http.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (GetCounterResult)this.doRequest((HttpUriRequest)http, GetCounterResult.class);
    }

    public GetCounterByUserIdResult getCounterByUserId(GetCounterByUserIdRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCounterFunctionHandler.getCounterByUserId";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String counterName = null;
        if (request.getCounterName() != null) {
            counterName = request.getCounterName();
        }
        String userId = null;
        if (request.getUserId() != null) {
            userId = request.getUserId();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (counterName != null) {
            _queryString.add(new BasicNameValuePair("counterName", String.valueOf(counterName)));
        }
        if (userId != null) {
            _queryString.add(new BasicNameValuePair("userId", String.valueOf(userId)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (GetCounterByUserIdResult)this.doRequest((HttpUriRequest)http, GetCounterByUserIdResult.class);
    }

    public DeleteCounterByUserIdResult deleteCounterByUserId(DeleteCounterByUserIdRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCounterFunctionHandler.deleteCounterByUserId";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String userId = null;
        if (request.getUserId() != null) {
            userId = request.getUserId();
        }
        String counterName = null;
        if (request.getCounterName() != null) {
            counterName = request.getCounterName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (userId != null) {
            _queryString.add(new BasicNameValuePair("userId", String.valueOf(userId)));
        }
        if (counterName != null) {
            _queryString.add(new BasicNameValuePair("counterName", String.valueOf(counterName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpDelete http = this.createHttpDelete(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (DeleteCounterByUserIdResult)this.doRequest((HttpUriRequest)http, DeleteCounterByUserIdResult.class);
    }

    public IncreaseByStampSheetResult increaseByStampSheet(IncreaseByStampSheetRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCounterFunctionHandler.increaseByStampSheet";
        String stampSheet = null;
        if (request.getStampSheet() != null) {
            stampSheet = request.getStampSheet();
        }
        String keyId = null;
        if (request.getKeyId() != null) {
            keyId = request.getKeyId();
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (stampSheet != null) {
            _body.put("stampSheet", stampSheet);
        }
        if (keyId != null) {
            _body.put("keyId", keyId);
        }
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (IncreaseByStampSheetResult)this.doRequest((HttpUriRequest)http, IncreaseByStampSheetResult.class);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCurrentMissionMasterFunctionHandler.exportMaster";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (ExportMasterResult)this.doRequest((HttpUriRequest)http, ExportMasterResult.class);
    }

    public GetCurrentMissionMasterResult getCurrentMissionMaster(GetCurrentMissionMasterRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCurrentMissionMasterFunctionHandler.getCurrentMissionMaster";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetCurrentMissionMasterResult)this.doRequest((HttpUriRequest)http, GetCurrentMissionMasterResult.class);
    }

    public UpdateCurrentMissionMasterResult updateCurrentMissionMaster(UpdateCurrentMissionMasterRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCurrentMissionMasterFunctionHandler.updateCurrentMissionMaster";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String settings = null;
        if (request.getSettings() != null) {
            settings = request.getSettings();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (settings != null) {
            _body.put("settings", settings);
        }
        HttpPut http = this.createHttpPut(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (UpdateCurrentMissionMasterResult)this.doRequest((HttpUriRequest)http, UpdateCurrentMissionMasterResult.class);
    }

    public DescribeMissionTaskModelMastersResult describeMissionTaskModelMasters(DescribeMissionTaskModelMastersRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FMissionTaskModelMasterFunctionHandler.describeMissionTaskModelMasters";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String missionGroupName = null;
        if (request.getMissionGroupName() != null) {
            missionGroupName = request.getMissionGroupName();
        }
        String pageToken = String.valueOf(request.getPageToken());
        String limit = String.valueOf(request.getLimit());
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (missionGroupName != null) {
            _queryString.add(new BasicNameValuePair("missionGroupName", String.valueOf(missionGroupName)));
        }
        if (pageToken != null) {
            _queryString.add(new BasicNameValuePair("pageToken", String.valueOf(pageToken)));
        }
        if (limit != null) {
            _queryString.add(new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeMissionTaskModelMastersResult)this.doRequest((HttpUriRequest)http, DescribeMissionTaskModelMastersResult.class);
    }

    public CreateMissionTaskModelMasterResult createMissionTaskModelMaster(CreateMissionTaskModelMasterRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FMissionTaskModelMasterFunctionHandler.createMissionTaskModelMaster";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String missionGroupName = null;
        if (request.getMissionGroupName() != null) {
            missionGroupName = request.getMissionGroupName();
        }
        String name = null;
        if (request.getName() != null) {
            name = request.getName();
        }
        String metadata = null;
        if (request.getMetadata() != null) {
            metadata = request.getMetadata();
        }
        String description = null;
        if (request.getDescription() != null) {
            description = request.getDescription();
        }
        String counterName = null;
        if (request.getCounterName() != null) {
            counterName = request.getCounterName();
        }
        String resetType = null;
        if (request.getResetType() != null) {
            resetType = request.getResetType();
        }
        Long targetValue = null;
        if (request.getTargetValue() != null) {
            targetValue = request.getTargetValue();
        }
        ArrayNode completeAcquireActions = null;
        if (request.getCompleteAcquireActions() != null) {
            ArrayList<ObjectNode> node = new ArrayList<ObjectNode>();
            for (AcquireAction item : request.getCompleteAcquireActions()) {
                node.add(item.toJson());
            }
            completeAcquireActions = JsonNodeFactory.instance.arrayNode().addAll(node);
        }
        String challengePeriodEventId = null;
        if (request.getChallengePeriodEventId() != null) {
            challengePeriodEventId = request.getChallengePeriodEventId();
        }
        String premiseMissionTaskName = null;
        if (request.getPremiseMissionTaskName() != null) {
            premiseMissionTaskName = request.getPremiseMissionTaskName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (missionGroupName != null) {
            _queryString.add(new BasicNameValuePair("missionGroupName", String.valueOf(missionGroupName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (name != null) {
            _body.put("name", name);
        }
        if (metadata != null) {
            _body.put("metadata", metadata);
        }
        if (description != null) {
            _body.put("description", description);
        }
        if (counterName != null) {
            _body.put("counterName", counterName);
        }
        if (resetType != null) {
            _body.put("resetType", resetType);
        }
        if (targetValue != null) {
            _body.put("targetValue", targetValue);
        }
        if (completeAcquireActions != null) {
            _body.put("completeAcquireActions", (JsonNode)completeAcquireActions);
        }
        if (challengePeriodEventId != null) {
            _body.put("challengePeriodEventId", challengePeriodEventId);
        }
        if (premiseMissionTaskName != null) {
            _body.put("premiseMissionTaskName", premiseMissionTaskName);
        }
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CreateMissionTaskModelMasterResult)this.doRequest((HttpUriRequest)http, CreateMissionTaskModelMasterResult.class);
    }

    public GetMissionTaskModelMasterResult getMissionTaskModelMaster(GetMissionTaskModelMasterRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FMissionTaskModelMasterFunctionHandler.getMissionTaskModelMaster";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String missionGroupName = null;
        if (request.getMissionGroupName() != null) {
            missionGroupName = request.getMissionGroupName();
        }
        String missionTaskName = null;
        if (request.getMissionTaskName() != null) {
            missionTaskName = request.getMissionTaskName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (missionGroupName != null) {
            _queryString.add(new BasicNameValuePair("missionGroupName", String.valueOf(missionGroupName)));
        }
        if (missionTaskName != null) {
            _queryString.add(new BasicNameValuePair("missionTaskName", String.valueOf(missionTaskName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetMissionTaskModelMasterResult)this.doRequest((HttpUriRequest)http, GetMissionTaskModelMasterResult.class);
    }

    public UpdateMissionTaskModelMasterResult updateMissionTaskModelMaster(UpdateMissionTaskModelMasterRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FMissionTaskModelMasterFunctionHandler.updateMissionTaskModelMaster";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String missionGroupName = null;
        if (request.getMissionGroupName() != null) {
            missionGroupName = request.getMissionGroupName();
        }
        String missionTaskName = null;
        if (request.getMissionTaskName() != null) {
            missionTaskName = request.getMissionTaskName();
        }
        String metadata = null;
        if (request.getMetadata() != null) {
            metadata = request.getMetadata();
        }
        String description = null;
        if (request.getDescription() != null) {
            description = request.getDescription();
        }
        String counterName = null;
        if (request.getCounterName() != null) {
            counterName = request.getCounterName();
        }
        String resetType = null;
        if (request.getResetType() != null) {
            resetType = request.getResetType();
        }
        Long targetValue = null;
        if (request.getTargetValue() != null) {
            targetValue = request.getTargetValue();
        }
        ArrayNode completeAcquireActions = null;
        if (request.getCompleteAcquireActions() != null) {
            ArrayList<ObjectNode> node = new ArrayList<ObjectNode>();
            for (AcquireAction item : request.getCompleteAcquireActions()) {
                node.add(item.toJson());
            }
            completeAcquireActions = JsonNodeFactory.instance.arrayNode().addAll(node);
        }
        String challengePeriodEventId = null;
        if (request.getChallengePeriodEventId() != null) {
            challengePeriodEventId = request.getChallengePeriodEventId();
        }
        String premiseMissionTaskName = null;
        if (request.getPremiseMissionTaskName() != null) {
            premiseMissionTaskName = request.getPremiseMissionTaskName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (missionGroupName != null) {
            _queryString.add(new BasicNameValuePair("missionGroupName", String.valueOf(missionGroupName)));
        }
        if (missionTaskName != null) {
            _queryString.add(new BasicNameValuePair("missionTaskName", String.valueOf(missionTaskName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (metadata != null) {
            _body.put("metadata", metadata);
        }
        if (description != null) {
            _body.put("description", description);
        }
        if (counterName != null) {
            _body.put("counterName", counterName);
        }
        if (resetType != null) {
            _body.put("resetType", resetType);
        }
        if (targetValue != null) {
            _body.put("targetValue", targetValue);
        }
        if (completeAcquireActions != null) {
            _body.put("completeAcquireActions", (JsonNode)completeAcquireActions);
        }
        if (challengePeriodEventId != null) {
            _body.put("challengePeriodEventId", challengePeriodEventId);
        }
        if (premiseMissionTaskName != null) {
            _body.put("premiseMissionTaskName", premiseMissionTaskName);
        }
        HttpPut http = this.createHttpPut(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (UpdateMissionTaskModelMasterResult)this.doRequest((HttpUriRequest)http, UpdateMissionTaskModelMasterResult.class);
    }

    public DeleteMissionTaskModelMasterResult deleteMissionTaskModelMaster(DeleteMissionTaskModelMasterRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FMissionTaskModelMasterFunctionHandler.deleteMissionTaskModelMaster";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String missionGroupName = null;
        if (request.getMissionGroupName() != null) {
            missionGroupName = request.getMissionGroupName();
        }
        String missionTaskName = null;
        if (request.getMissionTaskName() != null) {
            missionTaskName = request.getMissionTaskName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (missionGroupName != null) {
            _queryString.add(new BasicNameValuePair("missionGroupName", String.valueOf(missionGroupName)));
        }
        if (missionTaskName != null) {
            _queryString.add(new BasicNameValuePair("missionTaskName", String.valueOf(missionTaskName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpDelete http = this.createHttpDelete(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DeleteMissionTaskModelMasterResult)this.doRequest((HttpUriRequest)http, DeleteMissionTaskModelMasterResult.class);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FNamespaceFunctionHandler.describeNamespaces";
        String pageToken = String.valueOf(request.getPageToken());
        String limit = String.valueOf(request.getLimit());
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (pageToken != null) {
            _queryString.add(new BasicNameValuePair("pageToken", String.valueOf(pageToken)));
        }
        if (limit != null) {
            _queryString.add(new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeNamespacesResult)this.doRequest((HttpUriRequest)http, DescribeNamespacesResult.class);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FNamespaceFunctionHandler.createNamespace";
        String name = null;
        if (request.getName() != null) {
            name = request.getName();
        }
        String description = null;
        if (request.getDescription() != null) {
            description = request.getDescription();
        }
        String missionCompleteTriggerScriptId = null;
        if (request.getMissionCompleteTriggerScriptId() != null) {
            missionCompleteTriggerScriptId = request.getMissionCompleteTriggerScriptId();
        }
        String missionCompleteDoneTriggerScriptId = null;
        if (request.getMissionCompleteDoneTriggerScriptId() != null) {
            missionCompleteDoneTriggerScriptId = request.getMissionCompleteDoneTriggerScriptId();
        }
        String missionCompleteDoneTriggerQueueNamespaceId = null;
        if (request.getMissionCompleteDoneTriggerQueueNamespaceId() != null) {
            missionCompleteDoneTriggerQueueNamespaceId = request.getMissionCompleteDoneTriggerQueueNamespaceId();
        }
        String counterIncrementTriggerScriptId = null;
        if (request.getCounterIncrementTriggerScriptId() != null) {
            counterIncrementTriggerScriptId = request.getCounterIncrementTriggerScriptId();
        }
        String counterIncrementDoneTriggerScriptId = null;
        if (request.getCounterIncrementDoneTriggerScriptId() != null) {
            counterIncrementDoneTriggerScriptId = request.getCounterIncrementDoneTriggerScriptId();
        }
        String counterIncrementDoneTriggerQueueNamespaceId = null;
        if (request.getCounterIncrementDoneTriggerQueueNamespaceId() != null) {
            counterIncrementDoneTriggerQueueNamespaceId = request.getCounterIncrementDoneTriggerQueueNamespaceId();
        }
        String receiveRewardsTriggerScriptId = null;
        if (request.getReceiveRewardsTriggerScriptId() != null) {
            receiveRewardsTriggerScriptId = request.getReceiveRewardsTriggerScriptId();
        }
        String receiveRewardsDoneTriggerScriptId = null;
        if (request.getReceiveRewardsDoneTriggerScriptId() != null) {
            receiveRewardsDoneTriggerScriptId = request.getReceiveRewardsDoneTriggerScriptId();
        }
        String receiveRewardsDoneTriggerQueueNamespaceId = null;
        if (request.getReceiveRewardsDoneTriggerQueueNamespaceId() != null) {
            receiveRewardsDoneTriggerQueueNamespaceId = request.getReceiveRewardsDoneTriggerQueueNamespaceId();
        }
        String queueNamespaceId = null;
        if (request.getQueueNamespaceId() != null) {
            queueNamespaceId = request.getQueueNamespaceId();
        }
        String keyId = null;
        if (request.getKeyId() != null) {
            keyId = request.getKeyId();
        }
        NotificationSetting completeNotification = null;
        if (request.getCompleteNotification() != null) {
            completeNotification = request.getCompleteNotification();
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (name != null) {
            _body.put("name", name);
        }
        if (description != null) {
            _body.put("description", description);
        }
        if (missionCompleteTriggerScriptId != null) {
            _body.put("missionCompleteTriggerScriptId", missionCompleteTriggerScriptId);
        }
        if (missionCompleteDoneTriggerScriptId != null) {
            _body.put("missionCompleteDoneTriggerScriptId", missionCompleteDoneTriggerScriptId);
        }
        if (missionCompleteDoneTriggerQueueNamespaceId != null) {
            _body.put("missionCompleteDoneTriggerQueueNamespaceId", missionCompleteDoneTriggerQueueNamespaceId);
        }
        if (counterIncrementTriggerScriptId != null) {
            _body.put("counterIncrementTriggerScriptId", counterIncrementTriggerScriptId);
        }
        if (counterIncrementDoneTriggerScriptId != null) {
            _body.put("counterIncrementDoneTriggerScriptId", counterIncrementDoneTriggerScriptId);
        }
        if (counterIncrementDoneTriggerQueueNamespaceId != null) {
            _body.put("counterIncrementDoneTriggerQueueNamespaceId", counterIncrementDoneTriggerQueueNamespaceId);
        }
        if (receiveRewardsTriggerScriptId != null) {
            _body.put("receiveRewardsTriggerScriptId", receiveRewardsTriggerScriptId);
        }
        if (receiveRewardsDoneTriggerScriptId != null) {
            _body.put("receiveRewardsDoneTriggerScriptId", receiveRewardsDoneTriggerScriptId);
        }
        if (receiveRewardsDoneTriggerQueueNamespaceId != null) {
            _body.put("receiveRewardsDoneTriggerQueueNamespaceId", receiveRewardsDoneTriggerQueueNamespaceId);
        }
        if (queueNamespaceId != null) {
            _body.put("queueNamespaceId", queueNamespaceId);
        }
        if (keyId != null) {
            _body.put("keyId", keyId);
        }
        if (completeNotification != null) {
            _body.put("completeNotification", (JsonNode)completeNotification.toJson());
        }
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CreateNamespaceResult)this.doRequest((HttpUriRequest)http, CreateNamespaceResult.class);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FNamespaceFunctionHandler.getNamespaceStatus";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetNamespaceStatusResult)this.doRequest((HttpUriRequest)http, GetNamespaceStatusResult.class);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FNamespaceFunctionHandler.getNamespace";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetNamespaceResult)this.doRequest((HttpUriRequest)http, GetNamespaceResult.class);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FNamespaceFunctionHandler.updateNamespace";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String description = null;
        if (request.getDescription() != null) {
            description = request.getDescription();
        }
        String missionCompleteTriggerScriptId = null;
        if (request.getMissionCompleteTriggerScriptId() != null) {
            missionCompleteTriggerScriptId = request.getMissionCompleteTriggerScriptId();
        }
        String missionCompleteDoneTriggerScriptId = null;
        if (request.getMissionCompleteDoneTriggerScriptId() != null) {
            missionCompleteDoneTriggerScriptId = request.getMissionCompleteDoneTriggerScriptId();
        }
        String missionCompleteDoneTriggerQueueNamespaceId = null;
        if (request.getMissionCompleteDoneTriggerQueueNamespaceId() != null) {
            missionCompleteDoneTriggerQueueNamespaceId = request.getMissionCompleteDoneTriggerQueueNamespaceId();
        }
        String counterIncrementTriggerScriptId = null;
        if (request.getCounterIncrementTriggerScriptId() != null) {
            counterIncrementTriggerScriptId = request.getCounterIncrementTriggerScriptId();
        }
        String counterIncrementDoneTriggerScriptId = null;
        if (request.getCounterIncrementDoneTriggerScriptId() != null) {
            counterIncrementDoneTriggerScriptId = request.getCounterIncrementDoneTriggerScriptId();
        }
        String counterIncrementDoneTriggerQueueNamespaceId = null;
        if (request.getCounterIncrementDoneTriggerQueueNamespaceId() != null) {
            counterIncrementDoneTriggerQueueNamespaceId = request.getCounterIncrementDoneTriggerQueueNamespaceId();
        }
        String receiveRewardsTriggerScriptId = null;
        if (request.getReceiveRewardsTriggerScriptId() != null) {
            receiveRewardsTriggerScriptId = request.getReceiveRewardsTriggerScriptId();
        }
        String receiveRewardsDoneTriggerScriptId = null;
        if (request.getReceiveRewardsDoneTriggerScriptId() != null) {
            receiveRewardsDoneTriggerScriptId = request.getReceiveRewardsDoneTriggerScriptId();
        }
        String receiveRewardsDoneTriggerQueueNamespaceId = null;
        if (request.getReceiveRewardsDoneTriggerQueueNamespaceId() != null) {
            receiveRewardsDoneTriggerQueueNamespaceId = request.getReceiveRewardsDoneTriggerQueueNamespaceId();
        }
        String queueNamespaceId = null;
        if (request.getQueueNamespaceId() != null) {
            queueNamespaceId = request.getQueueNamespaceId();
        }
        String keyId = null;
        if (request.getKeyId() != null) {
            keyId = request.getKeyId();
        }
        NotificationSetting completeNotification = null;
        if (request.getCompleteNotification() != null) {
            completeNotification = request.getCompleteNotification();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (description != null) {
            _body.put("description", description);
        }
        if (missionCompleteTriggerScriptId != null) {
            _body.put("missionCompleteTriggerScriptId", missionCompleteTriggerScriptId);
        }
        if (missionCompleteDoneTriggerScriptId != null) {
            _body.put("missionCompleteDoneTriggerScriptId", missionCompleteDoneTriggerScriptId);
        }
        if (missionCompleteDoneTriggerQueueNamespaceId != null) {
            _body.put("missionCompleteDoneTriggerQueueNamespaceId", missionCompleteDoneTriggerQueueNamespaceId);
        }
        if (counterIncrementTriggerScriptId != null) {
            _body.put("counterIncrementTriggerScriptId", counterIncrementTriggerScriptId);
        }
        if (counterIncrementDoneTriggerScriptId != null) {
            _body.put("counterIncrementDoneTriggerScriptId", counterIncrementDoneTriggerScriptId);
        }
        if (counterIncrementDoneTriggerQueueNamespaceId != null) {
            _body.put("counterIncrementDoneTriggerQueueNamespaceId", counterIncrementDoneTriggerQueueNamespaceId);
        }
        if (receiveRewardsTriggerScriptId != null) {
            _body.put("receiveRewardsTriggerScriptId", receiveRewardsTriggerScriptId);
        }
        if (receiveRewardsDoneTriggerScriptId != null) {
            _body.put("receiveRewardsDoneTriggerScriptId", receiveRewardsDoneTriggerScriptId);
        }
        if (receiveRewardsDoneTriggerQueueNamespaceId != null) {
            _body.put("receiveRewardsDoneTriggerQueueNamespaceId", receiveRewardsDoneTriggerQueueNamespaceId);
        }
        if (queueNamespaceId != null) {
            _body.put("queueNamespaceId", queueNamespaceId);
        }
        if (keyId != null) {
            _body.put("keyId", keyId);
        }
        if (completeNotification != null) {
            _body.put("completeNotification", (JsonNode)completeNotification.toJson());
        }
        HttpPut http = this.createHttpPut(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (UpdateNamespaceResult)this.doRequest((HttpUriRequest)http, UpdateNamespaceResult.class);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FNamespaceFunctionHandler.deleteNamespace";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpDelete http = this.createHttpDelete(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DeleteNamespaceResult)this.doRequest((HttpUriRequest)http, DeleteNamespaceResult.class);
    }

    public DescribeCounterModelMastersResult describeCounterModelMasters(DescribeCounterModelMastersRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCounterModelMasterFunctionHandler.describeCounterModelMasters";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String pageToken = String.valueOf(request.getPageToken());
        String limit = String.valueOf(request.getLimit());
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (pageToken != null) {
            _queryString.add(new BasicNameValuePair("pageToken", String.valueOf(pageToken)));
        }
        if (limit != null) {
            _queryString.add(new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeCounterModelMastersResult)this.doRequest((HttpUriRequest)http, DescribeCounterModelMastersResult.class);
    }

    public CreateCounterModelMasterResult createCounterModelMaster(CreateCounterModelMasterRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCounterModelMasterFunctionHandler.createCounterModelMaster";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String name = null;
        if (request.getName() != null) {
            name = request.getName();
        }
        String metadata = null;
        if (request.getMetadata() != null) {
            metadata = request.getMetadata();
        }
        String description = null;
        if (request.getDescription() != null) {
            description = request.getDescription();
        }
        ArrayNode scopes = null;
        if (request.getScopes() != null) {
            ArrayList<ObjectNode> node = new ArrayList<ObjectNode>();
            for (CounterScopeModel item : request.getScopes()) {
                node.add(item.toJson());
            }
            scopes = JsonNodeFactory.instance.arrayNode().addAll(node);
        }
        String challengePeriodEventId = null;
        if (request.getChallengePeriodEventId() != null) {
            challengePeriodEventId = request.getChallengePeriodEventId();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (name != null) {
            _body.put("name", name);
        }
        if (metadata != null) {
            _body.put("metadata", metadata);
        }
        if (description != null) {
            _body.put("description", description);
        }
        if (scopes != null) {
            _body.put("scopes", (JsonNode)scopes);
        }
        if (challengePeriodEventId != null) {
            _body.put("challengePeriodEventId", challengePeriodEventId);
        }
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CreateCounterModelMasterResult)this.doRequest((HttpUriRequest)http, CreateCounterModelMasterResult.class);
    }

    public GetCounterModelMasterResult getCounterModelMaster(GetCounterModelMasterRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCounterModelMasterFunctionHandler.getCounterModelMaster";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String counterName = null;
        if (request.getCounterName() != null) {
            counterName = request.getCounterName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (counterName != null) {
            _queryString.add(new BasicNameValuePair("counterName", String.valueOf(counterName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetCounterModelMasterResult)this.doRequest((HttpUriRequest)http, GetCounterModelMasterResult.class);
    }

    public UpdateCounterModelMasterResult updateCounterModelMaster(UpdateCounterModelMasterRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCounterModelMasterFunctionHandler.updateCounterModelMaster";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String counterName = null;
        if (request.getCounterName() != null) {
            counterName = request.getCounterName();
        }
        String metadata = null;
        if (request.getMetadata() != null) {
            metadata = request.getMetadata();
        }
        String description = null;
        if (request.getDescription() != null) {
            description = request.getDescription();
        }
        ArrayNode scopes = null;
        if (request.getScopes() != null) {
            ArrayList<ObjectNode> node = new ArrayList<ObjectNode>();
            for (CounterScopeModel item : request.getScopes()) {
                node.add(item.toJson());
            }
            scopes = JsonNodeFactory.instance.arrayNode().addAll(node);
        }
        String challengePeriodEventId = null;
        if (request.getChallengePeriodEventId() != null) {
            challengePeriodEventId = request.getChallengePeriodEventId();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (counterName != null) {
            _queryString.add(new BasicNameValuePair("counterName", String.valueOf(counterName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (metadata != null) {
            _body.put("metadata", metadata);
        }
        if (description != null) {
            _body.put("description", description);
        }
        if (scopes != null) {
            _body.put("scopes", (JsonNode)scopes);
        }
        if (challengePeriodEventId != null) {
            _body.put("challengePeriodEventId", challengePeriodEventId);
        }
        HttpPut http = this.createHttpPut(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (UpdateCounterModelMasterResult)this.doRequest((HttpUriRequest)http, UpdateCounterModelMasterResult.class);
    }

    public DeleteCounterModelMasterResult deleteCounterModelMaster(DeleteCounterModelMasterRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCounterModelMasterFunctionHandler.deleteCounterModelMaster";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String counterName = null;
        if (request.getCounterName() != null) {
            counterName = request.getCounterName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (counterName != null) {
            _queryString.add(new BasicNameValuePair("counterName", String.valueOf(counterName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpDelete http = this.createHttpDelete(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DeleteCounterModelMasterResult)this.doRequest((HttpUriRequest)http, DeleteCounterModelMasterResult.class);
    }

    public DescribeCompletesResult describeCompletes(DescribeCompletesRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCompleteFunctionHandler.describeCompletes";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String pageToken = String.valueOf(request.getPageToken());
        String limit = String.valueOf(request.getLimit());
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (pageToken != null) {
            _queryString.add(new BasicNameValuePair("pageToken", String.valueOf(pageToken)));
        }
        if (limit != null) {
            _queryString.add(new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        http.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (DescribeCompletesResult)this.doRequest((HttpUriRequest)http, DescribeCompletesResult.class);
    }

    public DescribeCompletesByUserIdResult describeCompletesByUserId(DescribeCompletesByUserIdRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCompleteFunctionHandler.describeCompletesByUserId";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String userId = null;
        if (request.getUserId() != null) {
            userId = request.getUserId();
        }
        String pageToken = String.valueOf(request.getPageToken());
        String limit = String.valueOf(request.getLimit());
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (userId != null) {
            _queryString.add(new BasicNameValuePair("userId", String.valueOf(userId)));
        }
        if (pageToken != null) {
            _queryString.add(new BasicNameValuePair("pageToken", String.valueOf(pageToken)));
        }
        if (limit != null) {
            _queryString.add(new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (DescribeCompletesByUserIdResult)this.doRequest((HttpUriRequest)http, DescribeCompletesByUserIdResult.class);
    }

    public CompleteResult complete(CompleteRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCompleteFunctionHandler.complete";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String missionGroupName = null;
        if (request.getMissionGroupName() != null) {
            missionGroupName = request.getMissionGroupName();
        }
        String missionTaskName = null;
        if (request.getMissionTaskName() != null) {
            missionTaskName = request.getMissionTaskName();
        }
        ArrayNode config = null;
        if (request.getConfig() != null) {
            ArrayList<ObjectNode> node = new ArrayList<ObjectNode>();
            for (Config item : request.getConfig()) {
                node.add(item.toJson());
            }
            config = JsonNodeFactory.instance.arrayNode().addAll(node);
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (missionGroupName != null) {
            _queryString.add(new BasicNameValuePair("missionGroupName", String.valueOf(missionGroupName)));
        }
        if (missionTaskName != null) {
            _queryString.add(new BasicNameValuePair("missionTaskName", String.valueOf(missionTaskName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (config != null) {
            _body.put("config", (JsonNode)config);
        }
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        http.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (CompleteResult)this.doRequest((HttpUriRequest)http, CompleteResult.class);
    }

    public CompleteByUserIdResult completeByUserId(CompleteByUserIdRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCompleteFunctionHandler.completeByUserId";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String missionGroupName = null;
        if (request.getMissionGroupName() != null) {
            missionGroupName = request.getMissionGroupName();
        }
        String missionTaskName = null;
        if (request.getMissionTaskName() != null) {
            missionTaskName = request.getMissionTaskName();
        }
        String userId = null;
        if (request.getUserId() != null) {
            userId = request.getUserId();
        }
        ArrayNode config = null;
        if (request.getConfig() != null) {
            ArrayList<ObjectNode> node = new ArrayList<ObjectNode>();
            for (Config item : request.getConfig()) {
                node.add(item.toJson());
            }
            config = JsonNodeFactory.instance.arrayNode().addAll(node);
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (missionGroupName != null) {
            _queryString.add(new BasicNameValuePair("missionGroupName", String.valueOf(missionGroupName)));
        }
        if (missionTaskName != null) {
            _queryString.add(new BasicNameValuePair("missionTaskName", String.valueOf(missionTaskName)));
        }
        if (userId != null) {
            _queryString.add(new BasicNameValuePair("userId", String.valueOf(userId)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (config != null) {
            _body.put("config", (JsonNode)config);
        }
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (CompleteByUserIdResult)this.doRequest((HttpUriRequest)http, CompleteByUserIdResult.class);
    }

    public ReceiveByUserIdResult receiveByUserId(ReceiveByUserIdRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCompleteFunctionHandler.receiveByUserId";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String missionGroupName = null;
        if (request.getMissionGroupName() != null) {
            missionGroupName = request.getMissionGroupName();
        }
        String missionTaskName = null;
        if (request.getMissionTaskName() != null) {
            missionTaskName = request.getMissionTaskName();
        }
        String userId = null;
        if (request.getUserId() != null) {
            userId = request.getUserId();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (missionGroupName != null) {
            _queryString.add(new BasicNameValuePair("missionGroupName", String.valueOf(missionGroupName)));
        }
        if (missionTaskName != null) {
            _queryString.add(new BasicNameValuePair("missionTaskName", String.valueOf(missionTaskName)));
        }
        if (userId != null) {
            _queryString.add(new BasicNameValuePair("userId", String.valueOf(userId)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (ReceiveByUserIdResult)this.doRequest((HttpUriRequest)http, ReceiveByUserIdResult.class);
    }

    public GetCompleteResult getComplete(GetCompleteRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCompleteFunctionHandler.getComplete";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String missionGroupName = null;
        if (request.getMissionGroupName() != null) {
            missionGroupName = request.getMissionGroupName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (missionGroupName != null) {
            _queryString.add(new BasicNameValuePair("missionGroupName", String.valueOf(missionGroupName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        http.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (GetCompleteResult)this.doRequest((HttpUriRequest)http, GetCompleteResult.class);
    }

    public GetCompleteByUserIdResult getCompleteByUserId(GetCompleteByUserIdRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCompleteFunctionHandler.getCompleteByUserId";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String missionGroupName = null;
        if (request.getMissionGroupName() != null) {
            missionGroupName = request.getMissionGroupName();
        }
        String userId = null;
        if (request.getUserId() != null) {
            userId = request.getUserId();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (missionGroupName != null) {
            _queryString.add(new BasicNameValuePair("missionGroupName", String.valueOf(missionGroupName)));
        }
        if (userId != null) {
            _queryString.add(new BasicNameValuePair("userId", String.valueOf(userId)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (GetCompleteByUserIdResult)this.doRequest((HttpUriRequest)http, GetCompleteByUserIdResult.class);
    }

    public DeleteCompleteByUserIdResult deleteCompleteByUserId(DeleteCompleteByUserIdRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCompleteFunctionHandler.deleteCompleteByUserId";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String userId = null;
        if (request.getUserId() != null) {
            userId = request.getUserId();
        }
        String missionGroupName = null;
        if (request.getMissionGroupName() != null) {
            missionGroupName = request.getMissionGroupName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (userId != null) {
            _queryString.add(new BasicNameValuePair("userId", String.valueOf(userId)));
        }
        if (missionGroupName != null) {
            _queryString.add(new BasicNameValuePair("missionGroupName", String.valueOf(missionGroupName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpDelete http = this.createHttpDelete(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (DeleteCompleteByUserIdResult)this.doRequest((HttpUriRequest)http, DeleteCompleteByUserIdResult.class);
    }

    public ReceiveByStampTaskResult receiveByStampTask(ReceiveByStampTaskRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/mission-handler?handler=gs2_mission%2Fhandler%2FCompleteFunctionHandler.receiveByStampTask";
        String stampTask = null;
        if (request.getStampTask() != null) {
            stampTask = request.getStampTask();
        }
        String keyId = null;
        if (request.getKeyId() != null) {
            keyId = request.getKeyId();
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (stampTask != null) {
            _body.put("stampTask", stampTask);
        }
        if (keyId != null) {
            _body.put("keyId", keyId);
        }
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (ReceiveByStampTaskResult)this.doRequest((HttpUriRequest)http, ReceiveByStampTaskResult.class);
    }
}

