/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.chat;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gs2.AbstractGs2Client;
import io.gs2.chat.control.CheckEstimateScanByteByAllRoomRequest;
import io.gs2.chat.control.CheckEstimateScanByteByAllRoomResult;
import io.gs2.chat.control.CheckEstimateScanByteByRoomRequest;
import io.gs2.chat.control.CheckEstimateScanByteByRoomResult;
import io.gs2.chat.control.CreateLobbyRequest;
import io.gs2.chat.control.CreateLobbyResult;
import io.gs2.chat.control.CreateMySubscribeRequest;
import io.gs2.chat.control.CreateMySubscribeResult;
import io.gs2.chat.control.CreateRoomRequest;
import io.gs2.chat.control.CreateRoomResult;
import io.gs2.chat.control.CreateSubscribeRequest;
import io.gs2.chat.control.CreateSubscribeResult;
import io.gs2.chat.control.DeleteLobbyRequest;
import io.gs2.chat.control.DeleteMySubscribeRequest;
import io.gs2.chat.control.DeleteRoomRequest;
import io.gs2.chat.control.DeleteSubscribeRequest;
import io.gs2.chat.control.DescribeLobbyRequest;
import io.gs2.chat.control.DescribeLobbyResult;
import io.gs2.chat.control.DescribeMessageNoAuthRequest;
import io.gs2.chat.control.DescribeMessageNoAuthResult;
import io.gs2.chat.control.DescribeMessageRequest;
import io.gs2.chat.control.DescribeMessageResult;
import io.gs2.chat.control.DescribeMySubscribeRequest;
import io.gs2.chat.control.DescribeMySubscribeResult;
import io.gs2.chat.control.DescribeRoomRequest;
import io.gs2.chat.control.DescribeRoomResult;
import io.gs2.chat.control.DescribeServiceClassRequest;
import io.gs2.chat.control.DescribeServiceClassResult;
import io.gs2.chat.control.DescribeSubscribeByRoomIdRequest;
import io.gs2.chat.control.DescribeSubscribeByRoomIdResult;
import io.gs2.chat.control.DescribeSubscribeByUserIdRequest;
import io.gs2.chat.control.DescribeSubscribeByUserIdResult;
import io.gs2.chat.control.GetLobbyRequest;
import io.gs2.chat.control.GetLobbyResult;
import io.gs2.chat.control.GetLobbyStatusRequest;
import io.gs2.chat.control.GetLobbyStatusResult;
import io.gs2.chat.control.GetMySubscribeRequest;
import io.gs2.chat.control.GetMySubscribeResult;
import io.gs2.chat.control.GetRoomRequest;
import io.gs2.chat.control.GetRoomResult;
import io.gs2.chat.control.GetSubscribeRequest;
import io.gs2.chat.control.GetSubscribeResult;
import io.gs2.chat.control.SearchLogByAllRoomRequest;
import io.gs2.chat.control.SearchLogByAllRoomResult;
import io.gs2.chat.control.SearchLogByRoomRequest;
import io.gs2.chat.control.SearchLogByRoomResult;
import io.gs2.chat.control.SendMessageNoAuthRequest;
import io.gs2.chat.control.SendMessageNoAuthResult;
import io.gs2.chat.control.SendMessageRequest;
import io.gs2.chat.control.SendMessageResult;
import io.gs2.chat.control.UpdateLobbyRequest;
import io.gs2.chat.control.UpdateLobbyResult;
import io.gs2.model.IGs2Credential;
import io.gs2.model.Region;
import java.util.ArrayList;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class Gs2ChatClient
extends AbstractGs2Client<Gs2ChatClient> {
    public static String ENDPOINT = "chat";

    public Gs2ChatClient(IGs2Credential credential) {
        super(credential);
    }

    public Gs2ChatClient(IGs2Credential credential, Region region) {
        super(credential, region);
    }

    public Gs2ChatClient(IGs2Credential credential, String region) {
        super(credential, region);
    }

    public CreateLobbyResult createLobby(CreateLobbyRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("name", request.getName()).put("serviceClass", request.getServiceClass()).put("notificationType", request.getNotificationType());
        if (request.getDescription() != null) {
            body.put("description", request.getDescription());
        }
        if (request.getNotificationUrl() != null) {
            body.put("notificationUrl", request.getNotificationUrl());
        }
        if (request.getNotificationGameName() != null) {
            body.put("notificationGameName", request.getNotificationGameName());
        }
        if (request.getLogging() != null) {
            body.put("logging", request.getLogging());
        }
        if (request.getLoggingDate() != null) {
            body.put("loggingDate", request.getLoggingDate());
        }
        if (request.getCreateRoomTriggerScript() != null) {
            body.put("createRoomTriggerScript", request.getCreateRoomTriggerScript());
        }
        if (request.getCreateRoomDoneTriggerScript() != null) {
            body.put("createRoomDoneTriggerScript", request.getCreateRoomDoneTriggerScript());
        }
        if (request.getDeleteRoomTriggerScript() != null) {
            body.put("deleteRoomTriggerScript", request.getDeleteRoomTriggerScript());
        }
        if (request.getDeleteRoomDoneTriggerScript() != null) {
            body.put("deleteRoomDoneTriggerScript", request.getDeleteRoomDoneTriggerScript());
        }
        if (request.getCreateSubscribeTriggerScript() != null) {
            body.put("createSubscribeTriggerScript", request.getCreateSubscribeTriggerScript());
        }
        if (request.getCreateSubscribeDoneTriggerScript() != null) {
            body.put("createSubscribeDoneTriggerScript", request.getCreateSubscribeDoneTriggerScript());
        }
        if (request.getDeleteSubscribeTriggerScript() != null) {
            body.put("deleteSubscribeTriggerScript", request.getDeleteSubscribeTriggerScript());
        }
        if (request.getDeleteSubscribeDoneTriggerScript() != null) {
            body.put("deleteSubscribeDoneTriggerScript", request.getDeleteSubscribeDoneTriggerScript());
        }
        if (request.getSendMessageTriggerScript() != null) {
            body.put("sendMessageTriggerScript", request.getSendMessageTriggerScript());
        }
        if (request.getSendMessageDoneTriggerScript() != null) {
            body.put("sendMessageDoneTriggerScript", request.getSendMessageDoneTriggerScript());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/lobby", this.credential, ENDPOINT, "Gs2Chat", "CreateLobby", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CreateLobbyResult)this.doRequest((HttpUriRequest)post, CreateLobbyResult.class);
    }

    public void deleteLobby(DeleteLobbyRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Chat", "DeleteLobby");
        if (request.getRequestId() != null) {
            delete.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        this.doRequest((HttpUriRequest)delete, null);
    }

    public DescribeLobbyResult describeLobby(DescribeLobbyRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "DescribeLobby");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeLobbyResult)this.doRequest((HttpUriRequest)get, DescribeLobbyResult.class);
    }

    public DescribeServiceClassResult describeServiceClass(DescribeServiceClassRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/serviceClass";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "DescribeServiceClass");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeServiceClassResult)this.doRequest((HttpUriRequest)get, DescribeServiceClassResult.class);
    }

    public GetLobbyResult getLobby(GetLobbyRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "GetLobby");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetLobbyResult)this.doRequest((HttpUriRequest)get, GetLobbyResult.class);
    }

    public GetLobbyStatusResult getLobbyStatus(GetLobbyStatusRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/status";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "GetLobbyStatus");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetLobbyStatusResult)this.doRequest((HttpUriRequest)get, GetLobbyStatusResult.class);
    }

    public UpdateLobbyResult updateLobby(UpdateLobbyRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("serviceClass", request.getServiceClass()).put("notificationType", request.getNotificationType()).put("logging", request.getLogging());
        if (request.getDescription() != null) {
            body.put("description", request.getDescription());
        }
        if (request.getNotificationUrl() != null) {
            body.put("notificationUrl", request.getNotificationUrl());
        }
        if (request.getNotificationGameName() != null) {
            body.put("notificationGameName", request.getNotificationGameName());
        }
        if (request.getLoggingDate() != null) {
            body.put("loggingDate", request.getLoggingDate());
        }
        if (request.getCreateRoomTriggerScript() != null) {
            body.put("createRoomTriggerScript", request.getCreateRoomTriggerScript());
        }
        if (request.getCreateRoomDoneTriggerScript() != null) {
            body.put("createRoomDoneTriggerScript", request.getCreateRoomDoneTriggerScript());
        }
        if (request.getDeleteRoomTriggerScript() != null) {
            body.put("deleteRoomTriggerScript", request.getDeleteRoomTriggerScript());
        }
        if (request.getDeleteRoomDoneTriggerScript() != null) {
            body.put("deleteRoomDoneTriggerScript", request.getDeleteRoomDoneTriggerScript());
        }
        if (request.getCreateSubscribeTriggerScript() != null) {
            body.put("createSubscribeTriggerScript", request.getCreateSubscribeTriggerScript());
        }
        if (request.getCreateSubscribeDoneTriggerScript() != null) {
            body.put("createSubscribeDoneTriggerScript", request.getCreateSubscribeDoneTriggerScript());
        }
        if (request.getDeleteSubscribeTriggerScript() != null) {
            body.put("deleteSubscribeTriggerScript", request.getDeleteSubscribeTriggerScript());
        }
        if (request.getDeleteSubscribeDoneTriggerScript() != null) {
            body.put("deleteSubscribeDoneTriggerScript", request.getDeleteSubscribeDoneTriggerScript());
        }
        if (request.getSendMessageTriggerScript() != null) {
            body.put("sendMessageTriggerScript", request.getSendMessageTriggerScript());
        }
        if (request.getSendMessageDoneTriggerScript() != null) {
            body.put("sendMessageDoneTriggerScript", request.getSendMessageDoneTriggerScript());
        }
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "", this.credential, ENDPOINT, "Gs2Chat", "UpdateLobby", body.toString());
        if (request.getRequestId() != null) {
            put.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (UpdateLobbyResult)this.doRequest((HttpUriRequest)put, UpdateLobbyResult.class);
    }

    public CheckEstimateScanByteByAllRoomResult checkEstimateScanByteByAllRoom(CheckEstimateScanByteByAllRoomRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/log/estimate";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getUserId() != null) {
            queryString.add(new BasicNameValuePair("userId", String.valueOf(request.getUserId())));
        }
        if (request.getMessage() != null) {
            queryString.add(new BasicNameValuePair("message", String.valueOf(request.getMessage())));
        }
        if (request.getMeta() != null) {
            queryString.add(new BasicNameValuePair("meta", String.valueOf(request.getMeta())));
        }
        if (request.getBegin() != null) {
            queryString.add(new BasicNameValuePair("begin", String.valueOf(request.getBegin())));
        }
        if (request.getEnd() != null) {
            queryString.add(new BasicNameValuePair("end", String.valueOf(request.getEnd())));
        }
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "CheckEstimateScanByteByAllRoom");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CheckEstimateScanByteByAllRoomResult)this.doRequest((HttpUriRequest)get, CheckEstimateScanByteByAllRoomResult.class);
    }

    public CheckEstimateScanByteByRoomResult checkEstimateScanByteByRoom(CheckEstimateScanByteByRoomRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null || request.getRoomId().equals("") ? "null" : request.getRoomId()) + "/log/estimate";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getUserId() != null) {
            queryString.add(new BasicNameValuePair("userId", String.valueOf(request.getUserId())));
        }
        if (request.getMessage() != null) {
            queryString.add(new BasicNameValuePair("message", String.valueOf(request.getMessage())));
        }
        if (request.getMeta() != null) {
            queryString.add(new BasicNameValuePair("meta", String.valueOf(request.getMeta())));
        }
        if (request.getBegin() != null) {
            queryString.add(new BasicNameValuePair("begin", String.valueOf(request.getBegin())));
        }
        if (request.getEnd() != null) {
            queryString.add(new BasicNameValuePair("end", String.valueOf(request.getEnd())));
        }
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "CheckEstimateScanByteByRoom");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CheckEstimateScanByteByRoomResult)this.doRequest((HttpUriRequest)get, CheckEstimateScanByteByRoomResult.class);
    }

    public SearchLogByAllRoomResult searchLogByAllRoom(SearchLogByAllRoomRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/log";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getUserId() != null) {
            queryString.add(new BasicNameValuePair("userId", String.valueOf(request.getUserId())));
        }
        if (request.getMessage() != null) {
            queryString.add(new BasicNameValuePair("message", String.valueOf(request.getMessage())));
        }
        if (request.getMeta() != null) {
            queryString.add(new BasicNameValuePair("meta", String.valueOf(request.getMeta())));
        }
        if (request.getBegin() != null) {
            queryString.add(new BasicNameValuePair("begin", String.valueOf(request.getBegin())));
        }
        if (request.getEnd() != null) {
            queryString.add(new BasicNameValuePair("end", String.valueOf(request.getEnd())));
        }
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (request.getUseCache() != null) {
            queryString.add(new BasicNameValuePair("useCache", String.valueOf(request.getUseCache())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "SearchLogByAllRoom");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (SearchLogByAllRoomResult)this.doRequest((HttpUriRequest)get, SearchLogByAllRoomResult.class);
    }

    public SearchLogByRoomResult searchLogByRoom(SearchLogByRoomRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null || request.getRoomId().equals("") ? "null" : request.getRoomId()) + "/log";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getUserId() != null) {
            queryString.add(new BasicNameValuePair("userId", String.valueOf(request.getUserId())));
        }
        if (request.getMessage() != null) {
            queryString.add(new BasicNameValuePair("message", String.valueOf(request.getMessage())));
        }
        if (request.getMeta() != null) {
            queryString.add(new BasicNameValuePair("meta", String.valueOf(request.getMeta())));
        }
        if (request.getBegin() != null) {
            queryString.add(new BasicNameValuePair("begin", String.valueOf(request.getBegin())));
        }
        if (request.getEnd() != null) {
            queryString.add(new BasicNameValuePair("end", String.valueOf(request.getEnd())));
        }
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (request.getUseCache() != null) {
            queryString.add(new BasicNameValuePair("useCache", String.valueOf(request.getUseCache())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "SearchLogByRoom");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (SearchLogByRoomResult)this.doRequest((HttpUriRequest)get, SearchLogByRoomResult.class);
    }

    public DescribeMessageResult describeMessage(DescribeMessageRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null || request.getRoomId().equals("") ? "null" : request.getRoomId()) + "/message";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPassword() != null) {
            queryString.add(new BasicNameValuePair("password", String.valueOf(request.getPassword())));
        }
        if (request.getStartAt() != null) {
            queryString.add(new BasicNameValuePair("startAt", String.valueOf(request.getStartAt())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "DescribeMessage");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        get.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (DescribeMessageResult)this.doRequest((HttpUriRequest)get, DescribeMessageResult.class);
    }

    public DescribeMessageNoAuthResult describeMessageNoAuth(DescribeMessageNoAuthRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null || request.getRoomId().equals("") ? "null" : request.getRoomId()) + "/message/force";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getStartAt() != null) {
            queryString.add(new BasicNameValuePair("startAt", String.valueOf(request.getStartAt())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "DescribeMessageNoAuth");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeMessageNoAuthResult)this.doRequest((HttpUriRequest)get, DescribeMessageNoAuthResult.class);
    }

    public SendMessageResult sendMessage(SendMessageRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("message", request.getMessage());
        if (request.getMeta() != null) {
            body.put("meta", request.getMeta());
        }
        if (request.getPassword() != null) {
            body.put("password", request.getPassword());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null || request.getRoomId().equals("") ? "null" : request.getRoomId()) + "/message", this.credential, ENDPOINT, "Gs2Chat", "SendMessage", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        post.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (SendMessageResult)this.doRequest((HttpUriRequest)post, SendMessageResult.class);
    }

    public SendMessageNoAuthResult sendMessageNoAuth(SendMessageNoAuthRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("userId", request.getUserId()).put("message", request.getMessage());
        if (request.getMeta() != null) {
            body.put("meta", request.getMeta());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null || request.getRoomId().equals("") ? "null" : request.getRoomId()) + "/message/force", this.credential, ENDPOINT, "Gs2Chat", "SendMessageNoAuth", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (SendMessageNoAuthResult)this.doRequest((HttpUriRequest)post, SendMessageNoAuthResult.class);
    }

    public CreateRoomResult createRoom(CreateRoomRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode();
        if (request.getRoomId() != null) {
            body.put("roomId", request.getRoomId());
        }
        if (request.getAllowUserIds() != null) {
            body.put("allowUserIds", request.getAllowUserIds());
        }
        if (request.getPassword() != null) {
            body.put("password", request.getPassword());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/room", this.credential, ENDPOINT, "Gs2Chat", "CreateRoom", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CreateRoomResult)this.doRequest((HttpUriRequest)post, CreateRoomResult.class);
    }

    public void deleteRoom(DeleteRoomRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null || request.getRoomId().equals("") ? "null" : request.getRoomId()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Chat", "DeleteRoom");
        if (request.getRequestId() != null) {
            delete.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        this.doRequest((HttpUriRequest)delete, null);
    }

    public DescribeRoomResult describeRoom(DescribeRoomRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/room";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "DescribeRoom");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeRoomResult)this.doRequest((HttpUriRequest)get, DescribeRoomResult.class);
    }

    public GetRoomResult getRoom(GetRoomRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null || request.getRoomId().equals("") ? "null" : request.getRoomId()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "GetRoom");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetRoomResult)this.doRequest((HttpUriRequest)get, GetRoomResult.class);
    }

    public CreateMySubscribeResult createMySubscribe(CreateMySubscribeRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode();
        if (request.getEnableOfflineTransfer() != null) {
            body.put("enableOfflineTransfer", request.getEnableOfflineTransfer());
        }
        if (request.getOfflineTransferSound() != null) {
            body.put("offlineTransferSound", request.getOfflineTransferSound());
        }
        if (request.getPassword() != null) {
            body.put("password", request.getPassword());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null || request.getRoomId().equals("") ? "null" : request.getRoomId()) + "/subscribe", this.credential, ENDPOINT, "Gs2Chat", "CreateMySubscribe", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        post.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (CreateMySubscribeResult)this.doRequest((HttpUriRequest)post, CreateMySubscribeResult.class);
    }

    public CreateSubscribeResult createSubscribe(CreateSubscribeRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode();
        if (request.getEnableOfflineTransfer() != null) {
            body.put("enableOfflineTransfer", request.getEnableOfflineTransfer());
        }
        if (request.getOfflineTransferSound() != null) {
            body.put("offlineTransferSound", request.getOfflineTransferSound());
        }
        if (request.getPassword() != null) {
            body.put("password", request.getPassword());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null || request.getRoomId().equals("") ? "null" : request.getRoomId()) + "/user/" + (request.getUserId() == null || request.getUserId().equals("") ? "null" : request.getUserId()) + "/subscribe", this.credential, ENDPOINT, "Gs2Chat", "CreateSubscribe", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CreateSubscribeResult)this.doRequest((HttpUriRequest)post, CreateSubscribeResult.class);
    }

    public void deleteMySubscribe(DeleteMySubscribeRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null || request.getRoomId().equals("") ? "null" : request.getRoomId()) + "/user/self/subscribe";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Chat", "DeleteMySubscribe");
        if (request.getRequestId() != null) {
            delete.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        delete.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        this.doRequest((HttpUriRequest)delete, null);
    }

    public void deleteSubscribe(DeleteSubscribeRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null || request.getRoomId().equals("") ? "null" : request.getRoomId()) + "/user/" + (request.getUserId() == null || request.getUserId().equals("") ? "null" : request.getUserId()) + "/subscribe";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Chat", "DeleteSubscribe");
        if (request.getRequestId() != null) {
            delete.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        this.doRequest((HttpUriRequest)delete, null);
    }

    public DescribeMySubscribeResult describeMySubscribe(DescribeMySubscribeRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/user/subscribe";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "DescribeMySubscribe");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        get.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (DescribeMySubscribeResult)this.doRequest((HttpUriRequest)get, DescribeMySubscribeResult.class);
    }

    public DescribeSubscribeByRoomIdResult describeSubscribeByRoomId(DescribeSubscribeByRoomIdRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null || request.getRoomId().equals("") ? "null" : request.getRoomId()) + "/subscribe";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "DescribeSubscribeByRoomId");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeSubscribeByRoomIdResult)this.doRequest((HttpUriRequest)get, DescribeSubscribeByRoomIdResult.class);
    }

    public DescribeSubscribeByUserIdResult describeSubscribeByUserId(DescribeSubscribeByUserIdRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/user/" + (request.getUserId() == null || request.getUserId().equals("") ? "null" : request.getUserId()) + "/subscribe";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "DescribeSubscribeByUserId");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeSubscribeByUserIdResult)this.doRequest((HttpUriRequest)get, DescribeSubscribeByUserIdResult.class);
    }

    public GetMySubscribeResult getMySubscribe(GetMySubscribeRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null || request.getRoomId().equals("") ? "null" : request.getRoomId()) + "/user/self/subscribe";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "GetMySubscribe");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        get.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (GetMySubscribeResult)this.doRequest((HttpUriRequest)get, GetMySubscribeResult.class);
    }

    public GetSubscribeResult getSubscribe(GetSubscribeRequest request) {
        String url = "https://{service}.{region}.gs2io.com/lobby/" + (request.getLobbyName() == null || request.getLobbyName().equals("") ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null || request.getRoomId().equals("") ? "null" : request.getRoomId()) + "/user/" + (request.getUserId() == null || request.getUserId().equals("") ? "null" : request.getUserId()) + "/subscribe";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "GetSubscribe");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetSubscribeResult)this.doRequest((HttpUriRequest)get, GetSubscribeResult.class);
    }
}

