/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.stateMachine.model;

import io.gs2.cdk.stateMachine.model.ChangeStateEvent;
import io.gs2.cdk.stateMachine.model.EmitEvent;
import io.gs2.cdk.stateMachine.model.enums.EventEventType;
import io.gs2.cdk.stateMachine.model.options.EventEventTypeIsChangeStateOptions;
import io.gs2.cdk.stateMachine.model.options.EventEventTypeIsEmitOptions;
import io.gs2.cdk.stateMachine.model.options.EventOptions;
import java.util.HashMap;
import java.util.Map;

public class Event {
    private EventEventType eventType;
    private ChangeStateEvent changeStateEvent = null;
    private EmitEvent emitEvent = null;

    public Event(EventEventType eventType, EventOptions options) {
        this.eventType = eventType;
        this.changeStateEvent = options.changeStateEvent;
        this.emitEvent = options.emitEvent;
    }

    public Event(EventEventType eventType) {
        this.eventType = eventType;
    }

    public static Event eventTypeIsChangeState(ChangeStateEvent changeStateEvent, EventEventTypeIsChangeStateOptions options) {
        return new Event(EventEventType.CHANGE_STATE, new EventOptions().withChangeStateEvent(changeStateEvent));
    }

    public static Event eventTypeIsChangeState(ChangeStateEvent changeStateEvent) {
        return new Event(EventEventType.CHANGE_STATE);
    }

    public static Event eventTypeIsEmit(EmitEvent emitEvent, EventEventTypeIsEmitOptions options) {
        return new Event(EventEventType.EMIT, new EventOptions().withEmitEvent(emitEvent));
    }

    public static Event eventTypeIsEmit(EmitEvent emitEvent) {
        return new Event(EventEventType.EMIT);
    }

    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.eventType != null) {
            properties.put("eventType", this.eventType.toString());
        }
        if (this.changeStateEvent != null) {
            properties.put("changeStateEvent", this.changeStateEvent.properties());
        }
        if (this.emitEvent != null) {
            properties.put("emitEvent", this.emitEvent.properties());
        }
        return properties;
    }
}

