/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.skillTree.model;

import io.gs2.cdk.core.model.AcquireAction;
import io.gs2.cdk.core.model.ConsumeAction;
import io.gs2.cdk.skillTree.model.options.NodeModelOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class NodeModel {
    private String name;
    private List<ConsumeAction> releaseConsumeActions;
    private Float restrainReturnRate;
    private String metadata = null;
    private List<AcquireAction> returnAcquireActions = null;
    private List<String> premiseNodeNames = null;

    public NodeModel(String name, List<ConsumeAction> releaseConsumeActions, Float restrainReturnRate, NodeModelOptions options) {
        this.name = name;
        this.releaseConsumeActions = releaseConsumeActions;
        this.restrainReturnRate = restrainReturnRate;
        this.metadata = options.metadata;
        this.returnAcquireActions = options.returnAcquireActions;
        this.premiseNodeNames = options.premiseNodeNames;
    }

    public NodeModel(String name, List<ConsumeAction> releaseConsumeActions, Float restrainReturnRate) {
        this.name = name;
        this.releaseConsumeActions = releaseConsumeActions;
        this.restrainReturnRate = restrainReturnRate;
    }

    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("name", this.name);
        }
        if (this.metadata != null) {
            properties.put("metadata", this.metadata);
        }
        if (this.releaseConsumeActions != null) {
            properties.put("releaseConsumeActions", this.releaseConsumeActions.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.restrainReturnRate != null) {
            properties.put("restrainReturnRate", this.restrainReturnRate);
        }
        if (this.premiseNodeNames != null) {
            properties.put("premiseNodeNames", this.premiseNodeNames);
        }
        return properties;
    }
}

