/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.realtime.model;

import io.gs2.cdk.core.func.GetAttr;
import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.LogSetting;
import io.gs2.cdk.core.model.NotificationSetting;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.realtime.model.enums.NamespaceServerSpec;
import io.gs2.cdk.realtime.model.enums.NamespaceServerType;
import io.gs2.cdk.realtime.model.options.NamespaceOptions;
import io.gs2.cdk.realtime.ref.NamespaceRef;
import java.util.HashMap;
import java.util.Map;

public class Namespace
extends CdkResource {
    private Stack stack;
    private String name;
    private NamespaceServerType serverType;
    private NamespaceServerSpec serverSpec;
    private String description = null;
    private NotificationSetting createNotification = null;
    private LogSetting logSetting = null;

    public Namespace(Stack stack, String name, NamespaceServerType serverType, NamespaceServerSpec serverSpec, NamespaceOptions options) {
        super("Realtime_Namespace_" + name);
        this.stack = stack;
        this.name = name;
        this.serverType = serverType;
        this.serverSpec = serverSpec;
        this.description = options.description;
        this.createNotification = options.createNotification;
        this.logSetting = options.logSetting;
        stack.addResource(this);
    }

    public Namespace(Stack stack, String name, NamespaceServerType serverType, NamespaceServerSpec serverSpec) {
        super("Realtime_Namespace_" + name);
        this.stack = stack;
        this.name = name;
        this.serverType = serverType;
        this.serverSpec = serverSpec;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return "name";
    }

    @Override
    public String resourceType() {
        return "GS2::Realtime::Namespace";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("Name", this.name);
        }
        if (this.description != null) {
            properties.put("Description", this.description);
        }
        if (this.serverType != null) {
            properties.put("ServerType", (Object)this.serverType);
        }
        if (this.serverSpec != null) {
            properties.put("ServerSpec", (Object)this.serverSpec);
        }
        if (this.createNotification != null) {
            properties.put("CreateNotification", this.createNotification.properties());
        }
        if (this.logSetting != null) {
            properties.put("LogSetting", this.logSetting.properties());
        }
        return properties;
    }

    public NamespaceRef ref() {
        return new NamespaceRef(this.name);
    }

    public GetAttr getAttrNamespaceId() {
        return new GetAttr(this, "Item.NamespaceId", null);
    }
}

