/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.limit.model;

import io.gs2.cdk.limit.model.enums.LimitModelResetDayOfWeek;
import io.gs2.cdk.limit.model.enums.LimitModelResetType;
import io.gs2.cdk.limit.model.options.LimitModelOptions;
import io.gs2.cdk.limit.model.options.LimitModelResetTypeIsDailyOptions;
import io.gs2.cdk.limit.model.options.LimitModelResetTypeIsMonthlyOptions;
import io.gs2.cdk.limit.model.options.LimitModelResetTypeIsNotResetOptions;
import io.gs2.cdk.limit.model.options.LimitModelResetTypeIsWeeklyOptions;
import java.util.HashMap;
import java.util.Map;

public class LimitModel {
    private String name;
    private LimitModelResetType resetType;
    private String metadata = null;
    private Integer resetDayOfMonth = null;
    private LimitModelResetDayOfWeek resetDayOfWeek = null;
    private Integer resetHour = null;

    public LimitModel(String name, LimitModelResetType resetType, LimitModelOptions options) {
        this.name = name;
        this.resetType = resetType;
        this.metadata = options.metadata;
        this.resetDayOfMonth = options.resetDayOfMonth;
        this.resetDayOfWeek = options.resetDayOfWeek;
        this.resetHour = options.resetHour;
    }

    public LimitModel(String name, LimitModelResetType resetType) {
        this.name = name;
        this.resetType = resetType;
    }

    public static LimitModel resetTypeIsNotReset(String name, LimitModelResetTypeIsNotResetOptions options) {
        return new LimitModel(name, LimitModelResetType.NOT_RESET, new LimitModelOptions().withMetadata(options.metadata));
    }

    public static LimitModel resetTypeIsNotReset(String name) {
        return new LimitModel(name, LimitModelResetType.NOT_RESET);
    }

    public static LimitModel resetTypeIsDaily(String name, Integer resetHour, LimitModelResetTypeIsDailyOptions options) {
        return new LimitModel(name, LimitModelResetType.DAILY, new LimitModelOptions().withResetHour(resetHour).withMetadata(options.metadata));
    }

    public static LimitModel resetTypeIsDaily(String name, Integer resetHour) {
        return new LimitModel(name, LimitModelResetType.DAILY);
    }

    public static LimitModel resetTypeIsWeekly(String name, LimitModelResetDayOfWeek resetDayOfWeek, Integer resetHour, LimitModelResetTypeIsWeeklyOptions options) {
        return new LimitModel(name, LimitModelResetType.WEEKLY, new LimitModelOptions().withResetDayOfWeek(resetDayOfWeek).withResetHour(resetHour).withMetadata(options.metadata));
    }

    public static LimitModel resetTypeIsWeekly(String name, LimitModelResetDayOfWeek resetDayOfWeek, Integer resetHour) {
        return new LimitModel(name, LimitModelResetType.WEEKLY);
    }

    public static LimitModel resetTypeIsMonthly(String name, Integer resetDayOfMonth, Integer resetHour, LimitModelResetTypeIsMonthlyOptions options) {
        return new LimitModel(name, LimitModelResetType.MONTHLY, new LimitModelOptions().withResetDayOfMonth(resetDayOfMonth).withResetHour(resetHour).withMetadata(options.metadata));
    }

    public static LimitModel resetTypeIsMonthly(String name, Integer resetDayOfMonth, Integer resetHour) {
        return new LimitModel(name, LimitModelResetType.MONTHLY);
    }

    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("name", this.name);
        }
        if (this.metadata != null) {
            properties.put("metadata", this.metadata);
        }
        if (this.resetType != null) {
            properties.put("resetType", this.resetType.toString());
        }
        if (this.resetDayOfMonth != null) {
            properties.put("resetDayOfMonth", this.resetDayOfMonth);
        }
        if (this.resetDayOfWeek != null) {
            properties.put("resetDayOfWeek", this.resetDayOfWeek.toString());
        }
        if (this.resetHour != null) {
            properties.put("resetHour", this.resetHour);
        }
        return properties;
    }
}

