/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.inbox.ref;

import io.gs2.cdk.core.func.GetAttr;
import io.gs2.cdk.core.func.Join;
import io.gs2.cdk.core.model.AcquireAction;
import io.gs2.cdk.inbox.model.TimeSpan;
import io.gs2.cdk.inbox.ref.GlobalMessageRef;
import io.gs2.cdk.inbox.stampSheet.DeleteMessageByUserId;
import io.gs2.cdk.inbox.stampSheet.OpenMessageByUserId;
import io.gs2.cdk.inbox.stampSheet.SendMessageByUserId;
import java.util.Arrays;
import java.util.List;

public class NamespaceRef {
    private String namespaceName;

    public NamespaceRef(String namespaceName) {
        this.namespaceName = namespaceName;
    }

    public GlobalMessageRef globalMessage(String globalMessageName) {
        return new GlobalMessageRef(this.namespaceName, globalMessageName);
    }

    public SendMessageByUserId sendMessage(String metadata, List<AcquireAction> readAcquireActions, Long expiresAt, TimeSpan expiresTimeSpan, String userId) {
        return new SendMessageByUserId(this.namespaceName, metadata, readAcquireActions, expiresAt, expiresTimeSpan, userId);
    }

    public SendMessageByUserId sendMessage(String metadata, List<AcquireAction> readAcquireActions, Long expiresAt, TimeSpan expiresTimeSpan) {
        return new SendMessageByUserId(this.namespaceName, metadata, readAcquireActions, expiresAt, expiresTimeSpan, "#{userId}");
    }

    public OpenMessageByUserId openMessage(String messageName, String userId) {
        return new OpenMessageByUserId(this.namespaceName, messageName, userId);
    }

    public OpenMessageByUserId openMessage(String messageName) {
        return new OpenMessageByUserId(this.namespaceName, messageName, "#{userId}");
    }

    public DeleteMessageByUserId deleteMessage(String messageName, String userId) {
        return new DeleteMessageByUserId(this.namespaceName, messageName, userId);
    }

    public DeleteMessageByUserId deleteMessage(String messageName) {
        return new DeleteMessageByUserId(this.namespaceName, messageName, "#{userId}");
    }

    public String grn() {
        return new Join(":", Arrays.asList("grn", "gs2", GetAttr.region().str(), GetAttr.ownerId().str(), "inbox", this.namespaceName)).str();
    }
}

