/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.inbox.model;

import io.gs2.cdk.core.model.AcquireAction;
import io.gs2.cdk.inbox.model.TimeSpan;
import io.gs2.cdk.inbox.model.options.GlobalMessageOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GlobalMessage {
    private String name;
    private String metadata;
    private List<AcquireAction> readAcquireActions = null;
    private TimeSpan expiresTimeSpan = null;
    private Long expiresAt = null;
    private String messageReceptionPeriodEventId = null;

    public GlobalMessage(String name, String metadata, GlobalMessageOptions options) {
        this.name = name;
        this.metadata = metadata;
        this.readAcquireActions = options.readAcquireActions;
        this.expiresTimeSpan = options.expiresTimeSpan;
        this.expiresAt = options.expiresAt;
        this.messageReceptionPeriodEventId = options.messageReceptionPeriodEventId;
    }

    public GlobalMessage(String name, String metadata) {
        this.name = name;
        this.metadata = metadata;
    }

    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("name", this.name);
        }
        if (this.metadata != null) {
            properties.put("metadata", this.metadata);
        }
        if (this.readAcquireActions != null) {
            properties.put("readAcquireActions", this.readAcquireActions.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.expiresTimeSpan != null) {
            properties.put("expiresTimeSpan", this.expiresTimeSpan.properties());
        }
        if (this.expiresAt != null) {
            properties.put("expiresAt", this.expiresAt);
        }
        if (this.messageReceptionPeriodEventId != null) {
            properties.put("messageReceptionPeriodEventId", this.messageReceptionPeriodEventId);
        }
        return properties;
    }
}

