/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.guild.model;

import io.gs2.cdk.core.func.GetAttr;
import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.LogSetting;
import io.gs2.cdk.core.model.NotificationSetting;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.guild.model.CurrentMasterData;
import io.gs2.cdk.guild.model.GuildModel;
import io.gs2.cdk.guild.model.options.NamespaceOptions;
import io.gs2.cdk.guild.ref.NamespaceRef;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Namespace
extends CdkResource {
    private Stack stack;
    private String name;
    private String description = null;
    private NotificationSetting joinNotification = null;
    private NotificationSetting leaveNotification = null;
    private NotificationSetting changeMemberNotification = null;
    private NotificationSetting receiveRequestNotification = null;
    private NotificationSetting removeRequestNotification = null;
    private LogSetting logSetting = null;

    public Namespace(Stack stack, String name, NamespaceOptions options) {
        super("Guild_Namespace_" + name);
        this.stack = stack;
        this.name = name;
        this.description = options.description;
        this.joinNotification = options.joinNotification;
        this.leaveNotification = options.leaveNotification;
        this.changeMemberNotification = options.changeMemberNotification;
        this.receiveRequestNotification = options.receiveRequestNotification;
        this.removeRequestNotification = options.removeRequestNotification;
        this.logSetting = options.logSetting;
        stack.addResource(this);
    }

    public Namespace(Stack stack, String name) {
        super("Guild_Namespace_" + name);
        this.stack = stack;
        this.name = name;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return "name";
    }

    @Override
    public String resourceType() {
        return "GS2::Guild::Namespace";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("Name", this.name);
        }
        if (this.description != null) {
            properties.put("Description", this.description);
        }
        if (this.joinNotification != null) {
            properties.put("JoinNotification", this.joinNotification.properties());
        }
        if (this.leaveNotification != null) {
            properties.put("LeaveNotification", this.leaveNotification.properties());
        }
        if (this.changeMemberNotification != null) {
            properties.put("ChangeMemberNotification", this.changeMemberNotification.properties());
        }
        if (this.receiveRequestNotification != null) {
            properties.put("ReceiveRequestNotification", this.receiveRequestNotification.properties());
        }
        if (this.removeRequestNotification != null) {
            properties.put("RemoveRequestNotification", this.removeRequestNotification.properties());
        }
        if (this.logSetting != null) {
            properties.put("LogSetting", this.logSetting.properties());
        }
        return properties;
    }

    public NamespaceRef ref() {
        return new NamespaceRef(this.name);
    }

    public GetAttr getAttrNamespaceId() {
        return new GetAttr(this, "Item.NamespaceId", null);
    }

    public Namespace masterData(List<GuildModel> guildModels) {
        new CurrentMasterData(this.stack, this.name, guildModels).addDependsOn(this);
        return this;
    }
}

