/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.formation.model;

import io.gs2.cdk.core.func.GetAttr;
import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.LogSetting;
import io.gs2.cdk.core.model.ScriptSetting;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.core.model.TransactionSetting;
import io.gs2.cdk.formation.model.CurrentMasterData;
import io.gs2.cdk.formation.model.MoldModel;
import io.gs2.cdk.formation.model.PropertyFormModel;
import io.gs2.cdk.formation.model.options.NamespaceOptions;
import io.gs2.cdk.formation.ref.NamespaceRef;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Namespace
extends CdkResource {
    private Stack stack;
    private String name;
    private String description = null;
    private TransactionSetting transactionSetting = null;
    private ScriptSetting updateMoldScript = null;
    private ScriptSetting updateFormScript = null;
    private ScriptSetting updatePropertyFormScript = null;
    private LogSetting logSetting = null;

    public Namespace(Stack stack, String name, NamespaceOptions options) {
        super("Formation_Namespace_" + name);
        this.stack = stack;
        this.name = name;
        this.description = options.description;
        this.transactionSetting = options.transactionSetting;
        this.updateMoldScript = options.updateMoldScript;
        this.updateFormScript = options.updateFormScript;
        this.updatePropertyFormScript = options.updatePropertyFormScript;
        this.logSetting = options.logSetting;
        stack.addResource(this);
    }

    public Namespace(Stack stack, String name) {
        super("Formation_Namespace_" + name);
        this.stack = stack;
        this.name = name;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return "name";
    }

    @Override
    public String resourceType() {
        return "GS2::Formation::Namespace";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("Name", this.name);
        }
        if (this.description != null) {
            properties.put("Description", this.description);
        }
        if (this.transactionSetting != null) {
            properties.put("TransactionSetting", this.transactionSetting.properties());
        }
        if (this.updateMoldScript != null) {
            properties.put("UpdateMoldScript", this.updateMoldScript.properties());
        }
        if (this.updateFormScript != null) {
            properties.put("UpdateFormScript", this.updateFormScript.properties());
        }
        if (this.updatePropertyFormScript != null) {
            properties.put("UpdatePropertyFormScript", this.updatePropertyFormScript.properties());
        }
        if (this.logSetting != null) {
            properties.put("LogSetting", this.logSetting.properties());
        }
        return properties;
    }

    public NamespaceRef ref() {
        return new NamespaceRef(this.name);
    }

    public GetAttr getAttrNamespaceId() {
        return new GetAttr(this, "Item.NamespaceId", null);
    }

    public Namespace masterData(List<MoldModel> moldModels, List<PropertyFormModel> propertyFormModels) {
        new CurrentMasterData(this.stack, this.name, moldModels, propertyFormModels).addDependsOn(this);
        return this;
    }
}

