/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.exchange.model;

import io.gs2.cdk.core.model.AcquireAction;
import io.gs2.cdk.core.model.ConsumeAction;
import io.gs2.cdk.exchange.model.enums.RateModelTimingType;
import io.gs2.cdk.exchange.model.options.RateModelOptions;
import io.gs2.cdk.exchange.model.options.RateModelTimingTypeIsAwaitOptions;
import io.gs2.cdk.exchange.model.options.RateModelTimingTypeIsImmediateOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RateModel {
    private String name;
    private RateModelTimingType timingType;
    private String metadata = null;
    private List<ConsumeAction> consumeActions = null;
    private Integer lockTime = null;
    private List<AcquireAction> acquireActions = null;

    public RateModel(String name, RateModelTimingType timingType, RateModelOptions options) {
        this.name = name;
        this.timingType = timingType;
        this.metadata = options.metadata;
        this.consumeActions = options.consumeActions;
        this.lockTime = options.lockTime;
        this.acquireActions = options.acquireActions;
    }

    public RateModel(String name, RateModelTimingType timingType) {
        this.name = name;
        this.timingType = timingType;
    }

    public static RateModel timingTypeIsImmediate(String name, RateModelTimingTypeIsImmediateOptions options) {
        return new RateModel(name, RateModelTimingType.IMMEDIATE, new RateModelOptions().withMetadata(options.metadata).withConsumeActions(options.consumeActions).withAcquireActions(options.acquireActions));
    }

    public static RateModel timingTypeIsImmediate(String name) {
        return new RateModel(name, RateModelTimingType.IMMEDIATE);
    }

    public static RateModel timingTypeIsAwait(String name, Integer lockTime, RateModelTimingTypeIsAwaitOptions options) {
        return new RateModel(name, RateModelTimingType.AWAIT, new RateModelOptions().withLockTime(lockTime).withMetadata(options.metadata).withConsumeActions(options.consumeActions).withAcquireActions(options.acquireActions));
    }

    public static RateModel timingTypeIsAwait(String name, Integer lockTime) {
        return new RateModel(name, RateModelTimingType.AWAIT);
    }

    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("name", this.name);
        }
        if (this.metadata != null) {
            properties.put("metadata", this.metadata);
        }
        if (this.consumeActions != null) {
            properties.put("consumeActions", this.consumeActions.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.timingType != null) {
            properties.put("timingType", this.timingType.toString());
        }
        if (this.lockTime != null) {
            properties.put("lockTime", this.lockTime);
        }
        if (this.acquireActions != null) {
            properties.put("acquireActions", this.acquireActions.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        return properties;
    }
}

