/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.core.model;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.gs2.cdk.core.model.CdkResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Stack {
    List<CdkResource> resources = new ArrayList<CdkResource>();
    Map<String, String> outputs = new HashMap<String, String>();

    public void addResource(CdkResource resource) {
        this.resources.add(resource);
    }

    public void output(String name, String path) {
        this.outputs.put(name, path);
    }

    public Map<String, Object> template() {
        final HashMap<String, Map<String, Object>> templateResources = new HashMap<String, Map<String, Object>>();
        for (CdkResource resource : this.resources) {
            templateResources.put(resource.resourceName, resource.template());
        }
        return new HashMap<String, Object>(){
            {
                this.put("GS2TemplateFormatVersion", "2019-05-01");
                this.put("Resources", templateResources);
                this.put("Outputs", Stack.this.outputs);
            }
        };
    }

    public String yaml() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER));
        return mapper.writeValueAsString(this.template()).replaceAll("\"!(.*) (.*)\"", "!$1 $2");
    }
}

