/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.stateMachine.integration;

import io.gs2.cdk.stateMachine.integration.Event;
import io.gs2.cdk.stateMachine.integration.ITask;
import io.gs2.cdk.stateMachine.integration.IVariable;
import io.gs2.cdk.stateMachine.integration.Result;
import io.gs2.cdk.stateMachine.integration.Script;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Task
implements ITask {
    String name;
    IVariable[] arguments;
    String script;
    List<Event> events;
    List<Result> results;

    public Task(String name, IVariable[] arguments, String script) {
        this.name = name;
        this.arguments = arguments;
        this.script = script;
        this.events = new ArrayList<Event>();
        this.results = new ArrayList<Result>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ITask transition(Event event) {
        event.fromTaskName = this.name;
        this.events.add(event);
        return this;
    }

    @Override
    public Event[] getEvents() {
        return this.events.toArray(new Event[0]);
    }

    public Task result(String name, Map<IVariable, String> emitEventArgumentVariableNames, String nextTaskName) {
        this.results.add(new Result(name, name, emitEventArgumentVariableNames));
        this.transition(new Event(name, emitEventArgumentVariableNames.keySet().toArray(new IVariable[0]), nextTaskName));
        return this;
    }

    public Script scriptPayload() {
        Object output = this.script;
        output = (String)output + "\n\n";
        for (Result result : this.results) {
            output = (String)output + String.format("if result == '%s' then\n", result.name);
            output = (String)output + String.format("result = {\nevent='%s',\nparams={%s},\nupdatedVariables=args.variables\n", result.emitEventName, result.emitEventArgumentVariableNames.entrySet().stream().map(v -> String.format("%s=%s", ((IVariable)v.getKey()).getName(), v.getValue())).collect(Collectors.joining(", "))).indent(2);
            output = (String)output + "end\n";
        }
        return new Script(this.name, (String)output);
    }

    @Override
    public String gsl() {
        Object output = String.format("Task %s(%s) {\n", this.name, Arrays.stream(this.arguments).map(IVariable::gsl).collect(Collectors.joining(", ")));
        for (Event event : this.events) {
            output = (String)output + String.format("Event %s(%s);\n", event.name, Arrays.stream(event.arguments).map(IVariable::gsl).collect(Collectors.joining(", "))).indent(2);
        }
        output = (String)output + String.format("Script grn:gs2:{region}:{ownerId}:script:{scriptNamespaceName}:script:{stateMachineName}_%s", this.name).indent(2);
        output = (String)output + "}\n\n";
        return output;
    }

    @Override
    public String mermaid() {
        Object output = "";
        for (Event event : this.events) {
            if (event.nextTaskName.equals("Error")) continue;
            output = (String)output + String.format("{stateMachineName}_%s[[%s]] -->|%s| {stateMachineName}_%s\n", event.fromTaskName, event.fromTaskName, event.name, event.nextTaskName);
        }
        return output;
    }
}

