/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.stateMachine.integration;

import io.gs2.cdk.stateMachine.integration.Event;
import io.gs2.cdk.stateMachine.integration.ITask;
import io.gs2.cdk.stateMachine.integration.InParam;
import io.gs2.cdk.stateMachine.integration.OutParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SubStateMachineTask
implements ITask {
    String name;
    String subStateMachineName;
    InParam[] inParams;
    OutParam[] outParams;
    List<Event> events = new ArrayList<Event>();

    public SubStateMachineTask(String name, String subStateMachineName, InParam[] inParams, OutParam[] outParams) {
        this.name = name;
        this.subStateMachineName = subStateMachineName;
        this.inParams = inParams;
        this.outParams = outParams;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ITask transition(Event event) {
        event.fromTaskName = this.name;
        this.events.add(event);
        return this;
    }

    @Override
    public Event[] getEvents() {
        return this.events.toArray(new Event[0]);
    }

    @Override
    public String gsl() {
        StringBuilder output = new StringBuilder();
        output.append(String.format("SubStateMachineTask %s {%n", this.name));
        output.append(String.format("using %s;%n", this.name).indent(2));
        String inParamPart = Arrays.stream(this.inParams).map(inParam -> String.format("%s <- %s", inParam.subStateMachineVariable.getName(), inParam.currentStateMachineVariable.getName())).collect(Collectors.joining(", "));
        output.append(("in (" + inParamPart + ");\n").indent(2));
        String outParamPart = Arrays.stream(this.outParams).map(outParam -> String.format("%s -> %s", outParam.subStateMachineVariable.getName(), outParam.currentStateMachineVariable.getName())).collect(Collectors.joining(", "));
        output.append(("out (" + outParamPart + ");\n").indent(2));
        output.append("}\n\n");
        return output.toString();
    }

    @Override
    public String mermaid() {
        return String.format("%s_{name}[/{name}/]\n", this.name).replace("{name}", this.name);
    }
}

