/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.showcase.model;

import io.gs2.cdk.showcase.model.SalesItem;
import io.gs2.cdk.showcase.model.SalesItemGroup;
import io.gs2.cdk.showcase.model.enums.DisplayItemType;
import io.gs2.cdk.showcase.model.options.DisplayItemOptions;
import io.gs2.cdk.showcase.model.options.DisplayItemTypeIsSalesItemGroupOptions;
import io.gs2.cdk.showcase.model.options.DisplayItemTypeIsSalesItemOptions;
import java.util.HashMap;
import java.util.Map;

public class DisplayItem {
    private String displayItemId;
    private DisplayItemType type;
    private SalesItem salesItem = null;
    private SalesItemGroup salesItemGroup = null;
    private String salesPeriodEventId = null;

    public DisplayItem(String displayItemId, DisplayItemType type, DisplayItemOptions options) {
        this.displayItemId = displayItemId;
        this.type = type;
        this.salesItem = options.salesItem;
        this.salesItemGroup = options.salesItemGroup;
        this.salesPeriodEventId = options.salesPeriodEventId;
    }

    public DisplayItem(String displayItemId, DisplayItemType type) {
        this.displayItemId = displayItemId;
        this.type = type;
    }

    public static DisplayItem typeIsSalesItem(String displayItemId, SalesItem salesItem, DisplayItemTypeIsSalesItemOptions options) {
        return new DisplayItem(displayItemId, DisplayItemType.SALES_ITEM, new DisplayItemOptions().withSalesItem(salesItem).withSalesPeriodEventId(options.salesPeriodEventId));
    }

    public static DisplayItem typeIsSalesItem(String displayItemId, SalesItem salesItem) {
        return new DisplayItem(displayItemId, DisplayItemType.SALES_ITEM);
    }

    public static DisplayItem typeIsSalesItemGroup(String displayItemId, SalesItemGroup salesItemGroup, DisplayItemTypeIsSalesItemGroupOptions options) {
        return new DisplayItem(displayItemId, DisplayItemType.SALES_ITEM_GROUP, new DisplayItemOptions().withSalesItemGroup(salesItemGroup).withSalesPeriodEventId(options.salesPeriodEventId));
    }

    public static DisplayItem typeIsSalesItemGroup(String displayItemId, SalesItemGroup salesItemGroup) {
        return new DisplayItem(displayItemId, DisplayItemType.SALES_ITEM_GROUP);
    }

    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.displayItemId != null) {
            properties.put("displayItemId", this.displayItemId);
        }
        if (this.type != null) {
            properties.put("type", this.type.toString());
        }
        if (this.salesItem != null) {
            properties.put("salesItem", this.salesItem.properties());
        }
        if (this.salesItemGroup != null) {
            properties.put("salesItemGroup", this.salesItemGroup.properties());
        }
        if (this.salesPeriodEventId != null) {
            properties.put("salesPeriodEventId", this.salesPeriodEventId);
        }
        return properties;
    }
}

