/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.lottery.model;

import io.gs2.cdk.core.model.AcquireAction;
import io.gs2.cdk.lottery.model.enums.PrizeType;
import io.gs2.cdk.lottery.model.options.PrizeOptions;
import io.gs2.cdk.lottery.model.options.PrizeTypeIsActionOptions;
import io.gs2.cdk.lottery.model.options.PrizeTypeIsPrizeTableOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Prize {
    private String prizeId;
    private PrizeType type;
    private Integer weight;
    private List<AcquireAction> acquireActions = null;
    private Integer drawnLimit = null;
    private String limitFailOverPrizeId = null;
    private String prizeTableName = null;

    public Prize(String prizeId, PrizeType type, Integer weight, PrizeOptions options) {
        this.prizeId = prizeId;
        this.type = type;
        this.weight = weight;
        this.acquireActions = options.acquireActions;
        this.drawnLimit = options.drawnLimit;
        this.limitFailOverPrizeId = options.limitFailOverPrizeId;
        this.prizeTableName = options.prizeTableName;
    }

    public Prize(String prizeId, PrizeType type, Integer weight) {
        this.prizeId = prizeId;
        this.type = type;
        this.weight = weight;
    }

    public static Prize typeIsAction(String prizeId, Integer weight, List<AcquireAction> acquireActions, PrizeTypeIsActionOptions options) {
        return new Prize(prizeId, PrizeType.ACTION, weight, new PrizeOptions().withAcquireActions(acquireActions).withDrawnLimit(options.drawnLimit));
    }

    public static Prize typeIsAction(String prizeId, Integer weight, List<AcquireAction> acquireActions) {
        return new Prize(prizeId, PrizeType.ACTION, weight);
    }

    public static Prize typeIsPrizeTable(String prizeId, Integer weight, String prizeTableName, PrizeTypeIsPrizeTableOptions options) {
        return new Prize(prizeId, PrizeType.PRIZE_TABLE, weight, new PrizeOptions().withPrizeTableName(prizeTableName).withDrawnLimit(options.drawnLimit));
    }

    public static Prize typeIsPrizeTable(String prizeId, Integer weight, String prizeTableName) {
        return new Prize(prizeId, PrizeType.PRIZE_TABLE, weight);
    }

    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.prizeId != null) {
            properties.put("prizeId", this.prizeId);
        }
        if (this.type != null) {
            properties.put("type", this.type.toString());
        }
        if (this.acquireActions != null) {
            properties.put("acquireActions", this.acquireActions.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.drawnLimit != null) {
            properties.put("drawnLimit", this.drawnLimit);
        }
        if (this.limitFailOverPrizeId != null) {
            properties.put("limitFailOverPrizeId", this.limitFailOverPrizeId);
        }
        if (this.prizeTableName != null) {
            properties.put("prizeTableName", this.prizeTableName);
        }
        if (this.weight != null) {
            properties.put("weight", this.weight);
        }
        return properties;
    }
}

