/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.inventory.model;

import io.gs2.cdk.core.func.GetAttr;
import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.LogSetting;
import io.gs2.cdk.core.model.ScriptSetting;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.inventory.model.BigInventoryModel;
import io.gs2.cdk.inventory.model.CurrentMasterData;
import io.gs2.cdk.inventory.model.InventoryModel;
import io.gs2.cdk.inventory.model.SimpleInventoryModel;
import io.gs2.cdk.inventory.model.options.NamespaceOptions;
import io.gs2.cdk.inventory.ref.NamespaceRef;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Namespace
extends CdkResource {
    private Stack stack;
    private String name;
    private String description = null;
    private ScriptSetting acquireScript = null;
    private ScriptSetting overflowScript = null;
    private ScriptSetting consumeScript = null;
    private ScriptSetting simpleItemAcquireScript = null;
    private ScriptSetting simpleItemConsumeScript = null;
    private LogSetting logSetting = null;

    public Namespace(Stack stack, String name, NamespaceOptions options) {
        super("Inventory_Namespace_" + name);
        this.stack = stack;
        this.name = name;
        this.description = options.description;
        this.acquireScript = options.acquireScript;
        this.overflowScript = options.overflowScript;
        this.consumeScript = options.consumeScript;
        this.simpleItemAcquireScript = options.simpleItemAcquireScript;
        this.simpleItemConsumeScript = options.simpleItemConsumeScript;
        this.logSetting = options.logSetting;
        stack.addResource(this);
    }

    public Namespace(Stack stack, String name) {
        super("Inventory_Namespace_" + name);
        this.stack = stack;
        this.name = name;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return "name";
    }

    @Override
    public String resourceType() {
        return "GS2::Inventory::Namespace";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("Name", this.name);
        }
        if (this.description != null) {
            properties.put("Description", this.description);
        }
        if (this.acquireScript != null) {
            properties.put("AcquireScript", this.acquireScript.properties());
        }
        if (this.overflowScript != null) {
            properties.put("OverflowScript", this.overflowScript.properties());
        }
        if (this.consumeScript != null) {
            properties.put("ConsumeScript", this.consumeScript.properties());
        }
        if (this.simpleItemAcquireScript != null) {
            properties.put("SimpleItemAcquireScript", this.simpleItemAcquireScript.properties());
        }
        if (this.simpleItemConsumeScript != null) {
            properties.put("SimpleItemConsumeScript", this.simpleItemConsumeScript.properties());
        }
        if (this.logSetting != null) {
            properties.put("LogSetting", this.logSetting.properties());
        }
        return properties;
    }

    public NamespaceRef ref() {
        return new NamespaceRef(this.name);
    }

    public GetAttr getAttrNamespaceId() {
        return new GetAttr(this, "Item.NamespaceId", null);
    }

    public Namespace masterData(List<InventoryModel> inventoryModels, List<SimpleInventoryModel> simpleInventoryModels, List<BigInventoryModel> bigInventoryModels) {
        new CurrentMasterData(this.stack, this.name, inventoryModels, simpleInventoryModels, bigInventoryModels).addDependsOn(this);
        return this;
    }
}

